/*
 * Decompiled with CFR 0.152.
 */
package jmapps.registry;

import com.sun.media.util.DynamicPlugIn;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.Codec;
import javax.media.Demultiplexer;
import javax.media.Effect;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.PlugInManager;
import javax.media.Renderer;
import jmapps.registry.VectorEditor;
import jmapps.registry.VectorPanel;
import jmapps.ui.JMPanel;

public class PerTypePanel
extends JMPanel
implements VectorEditor {
    VectorPanel panelPlugIns;
    Vector pluginVector;
    Vector pluginArray;
    TextArea textArea;
    int type;
    private static boolean jdkInit = false;
    private static Method forName3ArgsM;
    private static Method getSystemClassLoaderM;
    private static ClassLoader systemClassLoader;
    private static Method getContextClassLoaderM;
    static final String[] pluginTypes;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Thread;

    public PerTypePanel(int n2) {
        this.type = n2;
        this.setLayout(new GridLayout(1, 2, 6, 6));
        this.panelPlugIns = new VectorPanel(pluginTypes[n2], this, n2);
        this.add(this.panelPlugIns);
        Panel panel = new Panel(new BorderLayout());
        this.add(panel);
        Label label = new Label(JMFI18N.getResource("jmfregistry.plugin.details.label"));
        panel.add((Component)label, "North");
        this.textArea = new TextArea();
        this.textArea.setEditable(false);
        panel.add((Component)this.textArea, "Center");
    }

    private static boolean checkIfJDK12() {
        if (jdkInit) {
            return forName3ArgsM != null;
        }
        jdkInit = true;
        try {
            forName3ArgsM = (class$java$lang$Class == null ? (class$java$lang$Class = PerTypePanel.class$("java.lang.Class")) : class$java$lang$Class).getMethod("forName", class$java$lang$String == null ? (class$java$lang$String = PerTypePanel.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = PerTypePanel.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            getSystemClassLoaderM = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = PerTypePanel.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getMethod("getSystemClassLoader", null);
            systemClassLoader = (ClassLoader)getSystemClassLoaderM.invoke((Object)(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = PerTypePanel.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader), null);
            getContextClassLoaderM = (class$java$lang$Thread == null ? (class$java$lang$Thread = PerTypePanel.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
        }
        catch (Throwable throwable) {
            forName3ArgsM = null;
            return false;
        }
        return true;
    }

    static Class getClassForName(String string) throws ClassNotFoundException {
        block9: {
            try {
                return Class.forName(string);
            }
            catch (Exception exception) {
                if (!PerTypePanel.checkIfJDK12()) {
                    throw new ClassNotFoundException(exception.getMessage());
                }
            }
            catch (Error error) {
                if (PerTypePanel.checkIfJDK12()) break block9;
                throw error;
            }
        }
        try {
            return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class == null ? (class$java$lang$Class = PerTypePanel.class$("java.lang.Class")) : class$java$lang$Class), string, new Boolean(true), systemClassLoader);
        }
        catch (Throwable throwable) {
            try {
                ClassLoader classLoader = (ClassLoader)getContextClassLoaderM.invoke((Object)Thread.currentThread(), null);
                return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class == null ? (class$java$lang$Class = PerTypePanel.class$("java.lang.Class")) : class$java$lang$Class), string, new Boolean(true), classLoader);
            }
            catch (Exception exception) {
                throw new ClassNotFoundException(exception.getMessage());
            }
            catch (Error error) {
                throw error;
            }
        }
    }

    public Vector stringArrayToVector(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                vector.addElement(stringArray[n2]);
                ++n2;
            }
        }
        return vector;
    }

    public String[] vectorToStringArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        Enumeration enumeration = vector.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n2++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public Vector getList(int n2) {
        this.pluginVector = PlugInManager.getPlugInList(null, null, this.type);
        if (this.pluginVector == null) {
            this.pluginVector = new Vector(1);
        }
        return this.pluginVector;
    }

    public void setList(int n2, Vector vector) {
        this.pluginVector = vector;
    }

    public void commit(int n2) {
        PlugInManager.setPlugInList(this.pluginVector, this.type);
        try {
            PlugInManager.commit();
        }
        catch (IOException iOException) {
            System.err.println("PlugInManager.commit() - " + iOException);
        }
    }

    public boolean addToList(int n2, String string) {
        try {
            int n3;
            String string2 = string;
            Class clazz = PerTypePanel.getClassForName(string2);
            Object t = clazz.newInstance();
            Format[] formatArray = null;
            Format[] formatArray2 = null;
            if (t instanceof Demultiplexer) {
                n3 = 1;
                formatArray = ((Demultiplexer)t).getSupportedInputContentDescriptors();
                formatArray2 = new Format[]{};
            } else if (t instanceof Renderer) {
                n3 = 4;
                formatArray = ((Renderer)t).getSupportedInputFormats();
                formatArray2 = new Format[]{};
            } else if (t instanceof Multiplexer) {
                n3 = 5;
                formatArray = new Format[]{};
                formatArray2 = ((Multiplexer)t).getSupportedOutputContentDescriptors(null);
            } else if (t instanceof Effect) {
                n3 = 3;
                formatArray = ((Effect)t).getSupportedInputFormats();
                formatArray2 = ((Effect)t).getSupportedOutputFormats(null);
            } else if (t instanceof Codec) {
                n3 = 2;
                formatArray = ((Codec)t).getSupportedInputFormats();
                formatArray2 = ((Codec)t).getSupportedOutputFormats(null);
            } else {
                n3 = 0;
            }
            if (t instanceof DynamicPlugIn) {
                formatArray = ((DynamicPlugIn)t).getBaseInputFormats();
                formatArray2 = ((DynamicPlugIn)t).getBaseOutputFormats();
            }
            if (n3 != 0 && PlugInManager.addPlugIn(string2, formatArray, formatArray2, n3)) {
                return true;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return false;
    }

    public void selectedIndex(int n2, int n3) {
        String string = null;
        String string2 = "";
        Format[] formatArray = null;
        Format[] formatArray2 = null;
        if (n3 >= 0) {
            string = (String)this.pluginVector.elementAt(n3);
        }
        if (string != null) {
            formatArray = PlugInManager.getSupportedInputFormats(string, this.type);
        }
        if (formatArray != null) {
            string2 = string2 + JMFI18N.getResource("jmfregistry.details.informats") + "---->\n\n" + this.printFormats(formatArray) + "\n\n";
        }
        if (string != null) {
            formatArray2 = PlugInManager.getSupportedOutputFormats(string, this.type);
        }
        if (formatArray2 != null) {
            string2 = string2 + JMFI18N.getResource("jmfregistry.details.outformats") + "--->\n\n" + this.printFormats(formatArray2) + "\n\n";
        }
        this.textArea.setText(string2);
    }

    private String printFormats(Object object) {
        if (!(object instanceof Format[])) {
            return "null";
        }
        Format[] formatArray = (Format[])object;
        String string = "";
        int n2 = 0;
        while (n2 < formatArray.length) {
            string = string + n2 + ". " + formatArray[n2].getClass().getName() + "\n  " + formatArray[n2] + "\n";
            ++n2;
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        pluginTypes = new String[]{JMFI18N.getResource("jmfregistry.plugin"), JMFI18N.getResource("jmfregistry.plugin.demultiplexer"), JMFI18N.getResource("jmfregistry.plugin.codec"), JMFI18N.getResource("jmfregistry.plugin.effect"), JMFI18N.getResource("jmfregistry.plugin.renderer"), JMFI18N.getResource("jmfregistry.plugin.multiplexer")};
    }
}

