/*
 * Decompiled with CFR 0.152.
 */
import java.net.URL;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import net.jxta.codat.CodatID;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeID;

public final class IDTest
extends TestCase {
    public IDTest(String name) {
        super(name);
    }

    public void testID() {
        try {
            ID first = ID.nullID;
            ID second = ID.nullID;
            Assert.assertTrue((String)"comparison of two IDs failed", (boolean)first.equals(second));
            ID third = (ID)first.clone();
            Assert.assertTrue((String)"comparison of cloned ID failed", (boolean)first.equals(third));
            Assert.assertTrue((String)"zero hashcodereturned", (0 != first.hashCode() ? 1 : 0) != 0);
            URL asURL = first.getURL();
            String asString = first.toString();
            Assert.assertTrue((String)"comparison of ID string and string of URL was not the same", (boolean)asString.equals(asURL.toString()));
            third = IDFactory.fromURL(asURL);
            Assert.assertTrue((String)"result of conversion to URL and back to ID was not equal to original", (boolean)first.equals(third));
        }
        catch (Exception everything) {
            everything.printStackTrace();
            Assert.fail((String)("caught an unexpected exception - " + everything.toString()));
        }
    }

    public void testCodatID() {
        try {
            CodatID first = IDFactory.newCodatID(IDFactory.newPeerGroupID());
            CodatID second = IDFactory.newCodatID(IDFactory.newPeerGroupID());
            PeerID interloper = IDFactory.newPeerID(IDFactory.newPeerGroupID());
            Assert.assertTrue((String)"comparison of a CodatID against itself failed", (boolean)first.equals(first));
            Assert.assertTrue((String)"comparison of two different CodatIDs should have failed", (!first.equals(second) ? 1 : 0) != 0);
            CodatID third = (CodatID)first.clone();
            Assert.assertTrue((String)"comparison of cloned ID failed", (boolean)first.equals(third));
            Assert.assertTrue((String)"comparison of different types should have failed", (!first.equals(interloper) ? 1 : 0) != 0);
            Assert.assertTrue((String)"comparison of different types should have failed", (!interloper.equals(first) ? 1 : 0) != 0);
            Assert.assertTrue((String)"zero hashcodereturned", (0 != first.hashCode() ? 1 : 0) != 0);
            URL asURL = first.getURL();
            String asString = first.toString();
            Assert.assertTrue((String)"comparison of ID string and string of URL was not the same", (boolean)asString.equals(asURL.toString()));
            third = (CodatID)IDFactory.fromURL(asURL);
            Assert.assertTrue((String)"result of conversion to URL and back to ID was not equal to original", (boolean)first.equals(third));
            ID myPeerGroup = first.getPeerGroupID();
            Assert.assertTrue((String)"clone of ID is not of same peergroup.", (boolean)first.getPeerGroupID().equals(third.getPeerGroupID()));
            Assert.assertTrue((String)"dynamic CodatID did not test as such.", (!first.isStatic() ? 1 : 0) != 0);
        }
        catch (Exception everything) {
            everything.printStackTrace();
            Assert.fail((String)("caught an unexpected exception - " + everything.toString()));
        }
    }

    public void testPeerGroupID() {
        try {
            PeerGroupID first = IDFactory.newPeerGroupID();
            PeerGroupID second = IDFactory.newPeerGroupID();
            PeerID interloper = IDFactory.newPeerID(IDFactory.newPeerGroupID());
            Assert.assertTrue((String)"comparison of a PeerGroupID against itself failed", (boolean)first.equals(first));
            Assert.assertTrue((String)"comparison against worldPeerGroup should have failed", (!first.equals(PeerGroupID.worldPeerGroupID) ? 1 : 0) != 0);
            Assert.assertTrue((String)"comparison of two different PeerGroupIDs should have failed", (!first.equals(second) ? 1 : 0) != 0);
            PeerGroupID third = (PeerGroupID)first.clone();
            Assert.assertTrue((String)"comparison of cloned ID failed", (boolean)first.equals(third));
            Assert.assertTrue((String)"comparison of different types should have failed", (!first.equals(interloper) ? 1 : 0) != 0);
            Assert.assertTrue((String)"comparison of different types should have failed", (!interloper.equals(first) ? 1 : 0) != 0);
            Assert.assertTrue((String)"zero hashcodereturned", (0 != first.hashCode() ? 1 : 0) != 0);
            Assert.assertTrue((String)"hashcode for world group should not have matched.", (PeerGroupID.worldPeerGroupID.hashCode() != first.hashCode() ? 1 : 0) != 0);
            URL asURL = first.getURL();
            String asString = first.toString();
            Assert.assertTrue((String)"comparison of ID string and string of URL was not the same", (boolean)asString.equals(asURL.toString()));
            third = (PeerGroupID)IDFactory.fromURL(asURL);
            Assert.assertTrue((String)"result of conversion to URL and back to ID was not equal to original", (boolean)first.equals(third));
            Object fromFirst = first.getUniqueValue();
            Object fromSecond = second.getUniqueValue();
            Assert.assertTrue((String)"comparison of UUIDs from an ID and a clone failed", (boolean)fromFirst.equals(third.getUniqueValue()));
            Assert.assertTrue((String)"comparison of UUIDs from an ID and a different ID should have failed.", (!fromFirst.equals(second.getUniqueValue()) ? 1 : 0) != 0);
        }
        catch (Exception everything) {
            everything.printStackTrace();
            Assert.fail((String)("caught an unexpected exception - " + everything.toString()));
        }
    }

    public void testPeerID() {
        try {
            PeerID first = IDFactory.newPeerID(IDFactory.newPeerGroupID());
            PeerID second = IDFactory.newPeerID(IDFactory.newPeerGroupID());
            PeerGroupID interloper = IDFactory.newPeerGroupID();
            Assert.assertTrue((String)"comparison of a PeerID against itself failed", (boolean)first.equals(first));
            Assert.assertTrue((String)"comparison of two different PeerIDs should have failed", (!first.equals(second) ? 1 : 0) != 0);
            PeerID third = (PeerID)first.clone();
            Assert.assertTrue((String)"comparison of cloned ID failed", (boolean)first.equals(third));
            Assert.assertTrue((String)"comparison of different types should have failed", (!first.equals(interloper) ? 1 : 0) != 0);
            Assert.assertTrue((String)"comparison of different types should have failed", (!interloper.equals(first) ? 1 : 0) != 0);
            Assert.assertTrue((String)"zero hashcodereturned", (0 != first.hashCode() ? 1 : 0) != 0);
            URL asURL = first.getURL();
            String asString = first.toString();
            Assert.assertTrue((String)"comparison of ID string and string of URL was not the same", (boolean)asString.equals(asURL.toString()));
            third = (PeerID)IDFactory.fromURL(asURL);
            Assert.assertTrue((String)"result of conversion to URL and back to ID was not equal to original", (boolean)first.equals(third));
            Assert.assertTrue((String)"clone of ID is not of same peergroup.", (boolean)first.getPeerGroupID().equals(third.getPeerGroupID()));
        }
        catch (Exception everything) {
            everything.printStackTrace();
            Assert.fail((String)("caught an unexpected exception - " + everything.toString()));
        }
    }

    public void testPipeID() {
        try {
            PipeID first = IDFactory.newPipeID(IDFactory.newPeerGroupID());
            PipeID second = IDFactory.newPipeID(IDFactory.newPeerGroupID());
            PeerGroupID interloper = IDFactory.newPeerGroupID();
            Assert.assertTrue((String)"comparison of a PipeID against itself failed", (boolean)first.equals(first));
            Assert.assertTrue((String)"comparison of two different PipeIDs should have failed", (!first.equals(second) ? 1 : 0) != 0);
            PipeID third = (PipeID)first.clone();
            Assert.assertTrue((String)"comparison of cloned ID failed", (boolean)first.equals(third));
            Assert.assertTrue((String)"comparison of different types should have failed", (!first.equals(interloper) ? 1 : 0) != 0);
            Assert.assertTrue((String)"comparison of different types should have failed", (!interloper.equals(first) ? 1 : 0) != 0);
            Assert.assertTrue((String)"zero hashcode returned", (0 != first.hashCode() ? 1 : 0) != 0);
            URL asURL = first.getURL();
            String asString = first.toString();
            Assert.assertTrue((String)"comparison of ID string and string of URL was not the same", (boolean)asString.equals(asURL.toString()));
            third = (PipeID)IDFactory.fromURL(asURL);
            Assert.assertTrue((String)"result of conversion to URL and back to ID was not equal to original", (boolean)first.equals(third));
            Assert.assertTrue((String)"clone of ID is not of same peergroup.", (boolean)first.getPeerGroupID().equals(third.getPeerGroupID()));
        }
        catch (Exception everything) {
            everything.printStackTrace();
            Assert.fail((String)("caught an unexpected exception - " + everything.toString()));
        }
    }

    public void testIDFactory() {
        try {
            URL urla = new URL("urn:jxta:idform-1234567890");
            URL urlb = new URL("URN:jxta:idform-1234567890");
            URL urlc = new URL("urn:JXTA:idform-1234567890");
            URL urld = new URL("urn:JXTA:idform-123456789%30");
            URL urle = new URL("urn:JXTA:IDForm-1234567890");
            URL urlf = new URL("urn:jxta:idform2-ABCDEFG");
            URL urlg = new URL("urn:jxta:idform3-31:08:66:42:67:::91:24::73");
            ID ida = IDFactory.fromURL(urla);
            ID idb = IDFactory.fromURL(urlb);
            ID idc = IDFactory.fromURL(urlc);
            ID idd = IDFactory.fromURL(urld);
            ID ide = IDFactory.fromURL(urle);
            ID idf = IDFactory.fromURL(urlf);
            ID idg = IDFactory.fromURL(urlg);
            Assert.assertEquals((Object)ida, (Object)idb);
            Assert.assertEquals((Object)idb, (Object)idc);
            Assert.assertEquals((Object)ida, (Object)idc);
            Assert.assertEquals((Object)ida, (Object)idd);
            Assert.assertTrue((!ida.equals(ide) ? 1 : 0) != 0);
            Assert.assertTrue((!ida.equals(idf) ? 1 : 0) != 0);
            Assert.assertTrue((!ida.equals(idg) ? 1 : 0) != 0);
        }
        catch (Exception everything) {
            everything.printStackTrace();
            Assert.fail((String)("caught an unexpected exception - " + everything.toString()));
        }
    }

    public static void main(String[] args) {
        new TestRunner();
        TestRunner.main((String[])new String[]{"IDTest"});
    }
}

