/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.credential;

import net.jxta.credential.Credential;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.id.ID;
import net.jxta.membership.MembershipService;
import net.jxta.peergroup.PeerGroup;

public final class AuthenticationCredential
implements Credential {
    private String authenticationMethod = null;
    private Element identityInfo = null;
    private PeerGroup peergroup = null;

    public AuthenticationCredential(PeerGroup peergroup, String method, Element indentityInfo) {
        this.peergroup = peergroup;
        this.authenticationMethod = method;
        if (null != indentityInfo) {
            this.identityInfo = indentityInfo;
        }
    }

    public MembershipService getSourceService() {
        return null;
    }

    public ID getPeerGroupID() {
        return this.peergroup.getPeerGroupID();
    }

    public ID getPeerID() {
        return this.peergroup.getPeerID();
    }

    public String getMethod() {
        return this.authenticationMethod;
    }

    public Element getIdentityInfo() {
        return this.identityInfo;
    }

    public StructuredDocument getDocument(MimeMediaType as) throws Exception {
        StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(as, "AuthenticationCredential");
        Element e = doc.createElement("Method", this.getMethod());
        doc.appendChild(e);
        e = doc.createElement("PeerGroupID", this.getPeerGroupID().toString());
        doc.appendChild(e);
        e = doc.createElement("PeerID", this.getPeerID().toString());
        doc.appendChild(e);
        if (null != this.identityInfo) {
            e = doc.createElement("IdentityInfo");
            doc.appendChild(e);
            StructuredDocumentUtils.copyElements(doc, e, this.identityInfo);
        }
        return doc;
    }
}

