/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import org.apache.log4j.Category;

public class CmCache
implements Runnable {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$cm$CmCache == null ? (class$net$jxta$impl$cm$CmCache = CmCache.class$("net.jxta.impl.cm.CmCache")) : class$net$jxta$impl$cm$CmCache).getName());
    private Hashtable caches = new Hashtable();
    private File directory;
    private String[] keys;
    static /* synthetic */ Class class$net$jxta$impl$cm$CmCache;

    public CmCache(String[] keys, File dir) {
        int i = 0;
        while (i < keys.length) {
            Hashtable cache = new Hashtable();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(" Created Table [" + keys[i] + "]"));
            }
            this.caches.put(keys[i], cache);
            ++i;
        }
        this.directory = dir;
        this.keys = keys;
    }

    public synchronized void add(String attribute, String value, String path) {
        Hashtable tbl = (Hashtable)this.caches.get(attribute);
        if (!tbl.containsKey(value = value.toUpperCase())) {
            Vector<String> vec = new Vector<String>();
            vec.add(path);
            tbl.put(value, vec);
        } else {
            Vector vec = (Vector)tbl.get(value);
            if (!vec.contains(path)) {
                vec.add(path);
            }
        }
    }

    public boolean containsKey(String key) {
        return this.caches.containsKey(key);
    }

    public synchronized void remove(String path) {
        Enumeration caTbl = this.caches.elements();
        while (caTbl.hasMoreElements()) {
            Hashtable tbl = (Hashtable)caTbl.nextElement();
            Iterator values = tbl.values().iterator();
            while (values.hasNext()) {
                Vector vec = (Vector)values.next();
                int i = 0;
                while (i < vec.size()) {
                    if (((String)vec.elementAt(i)).equals(path)) {
                        vec.remove(i);
                        --i;
                    }
                    ++i;
                }
            }
        }
    }

    public synchronized Enumeration query(String attribute, String value) {
        boolean endswith = false;
        boolean startswith = false;
        boolean allvalues = false;
        if (attribute == null || attribute.length() == 0) {
            throw new IllegalArgumentException("Attribute is mandatory");
        }
        if (value == null || value.length() == 0) {
            allvalues = true;
        } else {
            if (value.charAt(0) == '*') {
                endswith = true;
                value = value.substring(1, value.length());
            }
            if (value.length() == 0) {
                allvalues = true;
            } else if (value.charAt(value.length() - 1) == '*') {
                startswith = true;
                value = value.substring(0, value.indexOf("*"));
            }
        }
        Hashtable tbl = (Hashtable)this.caches.get(attribute);
        if (allvalues) {
            return tbl.keys();
        }
        if (!endswith && !startswith) {
            Vector res = (Vector)tbl.get(value.toUpperCase());
            if (res != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(attribute + " Found " + res.size()));
                }
                return res.elements();
            }
        } else {
            Vector result = new Vector();
            Enumeration keys = tbl.keys();
            while (keys.hasMoreElements()) {
                String val = (String)keys.nextElement();
                String uVal = val.toUpperCase();
                String uValue = value.toUpperCase();
                if (startswith && !endswith) {
                    if (!uVal.startsWith(uValue)) continue;
                    this.addTo(result, (Vector)tbl.get(val));
                    continue;
                }
                if (endswith && !startswith) {
                    if (!uVal.endsWith(uValue)) continue;
                    this.addTo(result, (Vector)tbl.get(val));
                    continue;
                }
                if (!startswith || !endswith || uVal.indexOf(uValue) < 0) continue;
                this.addTo(result, (Vector)tbl.get(val));
            }
            return result.elements();
        }
        return new Vector().elements();
    }

    private void addTo(Vector to, Vector from) {
        Enumeration enumeration = from.elements();
        while (enumeration.hasMoreElements()) {
            to.add(enumeration.nextElement());
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StructuredDocument restoreFile(File file) {
        FileInputStream ip = null;
        StructuredDocument doc = null;
        ip = new FileInputStream(file);
        doc = StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), ip);
        Object var7_4 = null;
        if (ip == null) return doc;
        try {
            ((InputStream)ip).close();
            return doc;
        }
        catch (IOException e2) {
            if (!LOG.isDebugEnabled()) return doc;
            LOG.debug((Object)"error closing file", (Throwable)e2);
        }
        return doc;
        {
            catch (IOException e) {
                Object var7_5 = null;
                if (ip == null) return doc;
                try {
                    ((InputStream)ip).close();
                    return doc;
                }
                catch (IOException e2) {
                    if (!LOG.isDebugEnabled()) return doc;
                    LOG.debug((Object)"error closing file", (Throwable)e2);
                }
                return doc;
            }
            catch (RuntimeException re) {
                Object var7_6 = null;
                if (ip == null) return doc;
                try {
                    ((InputStream)ip).close();
                    return doc;
                }
                catch (IOException e2) {
                    if (!LOG.isDebugEnabled()) return doc;
                    LOG.debug((Object)"error closing file", (Throwable)e2);
                }
                return doc;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (ip == null) throw throwable;
            try {
                ((InputStream)ip).close();
                throw throwable;
            }
            catch (IOException e2) {
                if (!LOG.isDebugEnabled()) throw throwable;
                LOG.debug((Object)"error closing file", (Throwable)e2);
            }
            throw throwable;
        }
    }

    public synchronized void add(String path, StructuredDocument doc) {
        int i = 0;
        while (i < this.keys.length) {
            Enumeration enumeration = doc.getChildren(this.keys[i]);
            while (enumeration.hasMoreElements()) {
                this.add(this.keys[i], (String)((Element)enumeration.nextElement()).getValue(), path);
            }
            ++i;
        }
    }

    public synchronized void add(String path) {
        File adv = new File(this.directory, path);
        StructuredDocument doc = this.restoreFile(adv);
        this.add(path, doc);
    }

    public void run() {
        String[] files;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Caching thread started");
        }
        if ((files = this.directory.list()) != null) {
            int i = 0;
            while (i < files.length) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Indexing  " + files[i]));
                }
                File adv = new File(this.directory, files[i]);
                long startTime = System.currentTimeMillis();
                StructuredDocument doc = this.restoreFile(adv);
                if (doc != null) {
                    this.add(files[i], doc);
                }
                if (LOG.isDebugEnabled()) {
                    long endTime = System.currentTimeMillis();
                    long totalTime = endTime - startTime;
                    LOG.debug((Object)("Total time to parse and index  " + totalTime));
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

