/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.impl.cm.SchedulerService;
import net.jxta.impl.util.TimeUtils;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

class FileExpirationService {
    static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$cm$FileExpirationService == null ? (class$net$jxta$impl$cm$FileExpirationService = FileExpirationService.class$("net.jxta.impl.cm.FileExpirationService")) : class$net$jxta$impl$cm$FileExpirationService).getName());
    static final String SCHED_DB_FILENAME = "scheduler.db";
    static final String TEMP_SCHED_DB_FILENAME = ".tmp.scheduler.db";
    static final int SCHEDULE = 1;
    static final int CANCEL = 2;
    static final long COMPRESS_INTERVAL = 1800000L;
    static final int MOD_THRESHOLD = 128;
    File dir;
    File db;
    File tmpDb;
    DataOutputStream out;
    FileDescriptor outFD;
    Hashtable hash;
    int mods;
    SchedulerService ss;
    SchedulerService.PendingAction pendingCompressAction;
    ExpirationListener listener;
    static /* synthetic */ Class class$net$jxta$impl$cm$FileExpirationService;

    FileExpirationService(SchedulerService ss, File dir, ExpirationListener listener) throws IOException {
        this.ss = ss;
        this.dir = dir;
        this.listener = listener;
        this.hash = new Hashtable();
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IOException("Could not create target directory");
            }
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException("dir exists and is not a directory");
            }
        }
        this.db = new File(dir, SCHED_DB_FILENAME);
        this.mods = 0;
        this.tmpDb = new File(dir, TEMP_SCHED_DB_FILENAME);
        if (this.tmpDb.exists()) {
            this.tmpDb.delete();
        }
        if (this.tmpDb.exists() && LOG.isEnabledFor(Priority.WARN)) {
            LOG.warn((Object)"Could not delete temp file. This will be a problem...");
        }
        try {
            if (this.db.exists()) {
                this.compress(true);
            } else {
                this.openlog(this.db, false);
            }
        }
        catch (IOException problems) {
            if (LOG.isEnabledFor(Priority.ERROR)) {
                LOG.error((Object)"Could not open existing db or make a new one.", (Throwable)problems);
            }
            throw problems;
        }
        this.pendingCompressAction = ss.scheduleAction(new CleanupAction(), 1800000L);
    }

    void stop() {
        block6: {
            this.ss.cancelAction(this.pendingCompressAction);
            try {
                this.compress(true);
                this.out.flush();
                this.outFD.sync();
                this.out.close();
                this.out = null;
                this.outFD = null;
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor(Priority.ERROR)) break block6;
                LOG.error((Object)"Compression of log stream failed on stop()", (Throwable)e);
            }
        }
        Enumeration eachEntry = this.hash.elements();
        while (eachEntry.hasMoreElements()) {
            Entry anEntry;
            Entry entry = anEntry = (Entry)eachEntry.nextElement();
            synchronized (entry) {
                this.ss.cancelAction(anEntry.expiryAction);
                anEntry.expiryAction = null;
                anEntry.file = null;
            }
        }
        this.hash.clear();
    }

    private void openlog(File file, boolean forAppend) throws IOException {
        FileOutputStream fos = new FileOutputStream(file.getCanonicalPath(), forAppend);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        this.out = new DataOutputStream(bos);
        this.outFD = fos.getFD();
    }

    public long getPublicationLifetime(File f) {
        Entry entry = null;
        try {
            entry = (Entry)this.hash.get(f.getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (entry == null) {
            return -1L;
        }
        return entry.expiresAt;
    }

    public long getCacheLifetime(File f) {
        Entry entry = null;
        try {
            entry = (Entry)this.hash.get(f.getCanonicalPath());
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (null == entry) {
            return -1L;
        }
        long tillExpires = TimeUtils.toRelativeTimeMillis(entry.expiresAt);
        if (tillExpires <= 0L) {
            return -1L;
        }
        return Math.min(tillExpires, entry.cacheLifetime);
    }

    public boolean scheduleFileExpiration(File file, long pubLifetime, long cacheLifetime) throws IOException {
        return this.scheduleFileExpiration(file, pubLifetime, cacheLifetime, false);
    }

    boolean scheduleFileExpiration(File file, long pubLifetime, long cacheLifetime, boolean forceUpdate) throws IOException {
        String filePath = file.getCanonicalPath();
        if (pubLifetime < 0L) {
            throw new IllegalArgumentException("file cannot have negative local expiry");
        }
        if (cacheLifetime < 0L) {
            throw new IllegalArgumentException("file cannot have negative remote expiry");
        }
        if (cacheLifetime > pubLifetime) {
            cacheLifetime = pubLifetime;
        }
        while (true) {
            long expiresAt;
            if ((expiresAt = TimeUtils.toAbsoluteTimeMillis(pubLifetime)) < pubLifetime) {
                expiresAt = Long.MAX_VALUE;
            }
            Entry entry = null;
            FileExpirationService fileExpirationService = this;
            synchronized (fileExpirationService) {
                entry = (Entry)this.hash.get(filePath);
                if (entry == null) {
                    entry = new Entry(file, expiresAt, cacheLifetime);
                    ExpireAction action1 = new ExpireAction(entry);
                    this.log(1, file, expiresAt, cacheLifetime);
                    Entry entry2 = entry;
                    synchronized (entry2) {
                        entry.expiryAction = this.ss.scheduleAction(action1, pubLifetime);
                        this.hash.put(filePath, entry);
                    }
                    boolean bl = true;
                    return bl;
                }
                if (!forceUpdate) {
                    if (entry.expiresAt > expiresAt) {
                        boolean bl = false;
                        return bl;
                    }
                    if (entry.expiresAt == expiresAt && entry.cacheLifetime == cacheLifetime) {
                        boolean bl = false;
                        return bl;
                    }
                }
                this.hash.remove(filePath);
            }
            this.ss.cancelAction(entry.expiryAction);
            entry.expiryAction = null;
        }
    }

    public void cancelFileExpiration(File file) {
        Entry e = null;
        FileExpirationService fileExpirationService = this;
        synchronized (fileExpirationService) {
            try {
                e = (Entry)this.hash.remove(file.getCanonicalPath());
            }
            catch (IOException ignored) {
                // empty catch block
            }
            if (e == null) {
                return;
            }
            this.log(2, file, 0L, 0L);
        }
        this.ss.cancelAction(e.expiryAction);
        e.file = null;
        e.expiryAction = null;
    }

    void log(int action, File file, long expiresAt, long cacheLifetime) {
        block4: {
            try {
                this.logWrite(action, file, expiresAt, cacheLifetime);
            }
            catch (IOException e) {
                try {
                    this.compress(true);
                    this.logWrite(action, file, expiresAt, cacheLifetime);
                }
                catch (IOException e2) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block4;
                    LOG.warn((Object)("Cannot write to " + this.db + ", keeping expiration tables in memory."));
                }
            }
        }
    }

    private void logWrite(int action, File file, long expiresAt, long cacheLifetime) throws IOException {
        switch (action) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                if (!LOG.isEnabledFor(Priority.INFO)) break;
                LOG.warn((Object)"Unexpected Action in log write. Writing anyway.");
            }
        }
        if (null == this.out) {
            throw new IOException("out file is unavailable");
        }
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.writeInt(action);
            this.out.writeUTF(file.getCanonicalPath());
            this.out.writeLong(expiresAt);
            this.out.writeLong(cacheLifetime);
            this.outFD.sync();
            ++this.mods;
        }
    }

    /*
     * Loose catch block
     */
    private void compress(boolean removeunknowns) throws IOException {
        int oldmod;
        long start;
        block38: {
            IOException e22;
            FilterInputStream in;
            block36: {
                in = null;
                start = TimeUtils.timeNow();
                if (this.out != null) {
                    this.out.flush();
                    this.outFD.sync();
                    this.out.close();
                    this.out = null;
                    this.outFD = null;
                }
                oldmod = this.mods;
                this.mods = 0;
                if (this.tmpDb.exists()) {
                    this.tmpDb.delete();
                }
                if (this.tmpDb.exists()) {
                    throw new IOException("Could not remove existing temporary db.");
                }
                in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.db)));
                this.openlog(this.tmpDb, false);
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"Expiration log compression begins.");
                }
                this.compressStreams((DataInputStream)in);
                Object var8_5 = null;
                if (in == null) break block36;
                try {
                    in.close();
                    in = null;
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            if (this.out != null) {
                try {
                    this.out.flush();
                    this.outFD.sync();
                    this.out.close();
                    this.out = null;
                    this.outFD = null;
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            if (this.tmpDb.exists() && this.db.exists()) {
                if (!this.db.delete() && LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"could not delete old db. this will be a problem.");
                }
            } else if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"Either db or tmpdb was missing!");
            }
            if (this.tmpDb.exists() && !this.db.exists()) {
                if (!this.tmpDb.renameTo(this.db) && LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Could not rename temporary db to db file");
                }
            } else if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"Could not rename temporary log to log file, files missing or in the way.");
            }
            break block38;
            {
                catch (IOException compressFailed) {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)"Expiration log compression failed.", (Throwable)compressFailed);
                    }
                    throw compressFailed;
                }
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var8_6 = null;
                if (in != null) {
                    try {
                        in.close();
                        in = null;
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (this.out != null) {
                    try {
                        this.out.flush();
                        this.outFD.sync();
                        this.out.close();
                        this.out = null;
                        this.outFD = null;
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (this.tmpDb.exists() && this.db.exists()) {
                    if (!this.db.delete() && LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)"could not delete old db. this will be a problem.");
                    }
                } else if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Either db or tmpdb was missing!");
                }
                if (this.tmpDb.exists() && !this.db.exists()) {
                    if (!this.tmpDb.renameTo(this.db) && LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)"Could not rename temporary db to db file");
                    }
                } else if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Could not rename temporary log to log file, files missing or in the way.");
                }
                this.openlog(this.db, true);
                throw throwable;
            }
        }
        this.openlog(this.db, true);
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("Compressed " + this.db + " of " + this.hash.size() + " records." + "\n\t Compressed " + oldmod + " log entries to " + this.mods + " log entries." + "\n\t Compressed in " + TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), start) + " ms."));
        }
        if (removeunknowns) {
            this.removeUnknownFiles(this.dir);
        }
    }

    /*
     * Unable to fully structure code
     */
    void compressStreams(DataInputStream in) throws IOException {
        start = TimeUtils.timeNow();
        reduced = new Hashtable<String, Entry>(this.hash.size());
        shouldBeDeleted = new Vector<String>(this.hash.size());
        i = 0;
        try {
            while (true) {
                block21: {
                    block20: {
                        action = in.readInt();
                        file = new File(in.readUTF());
                        expiresAt = in.readLong();
                        cacheLifetime = in.readLong();
                        if (!file.exists()) break block20;
                        filepath = file.getCanonicalPath();
                        switch (action) {
                            case 1: {
                                if (expiresAt > start) {
                                    entry = (Entry)reduced.get(filepath);
                                    if (null == entry) {
                                        entry = new Entry(file, expiresAt, cacheLifetime);
                                    } else if (entry.expiresAt < expiresAt) {
                                        entry.expiresAt = expiresAt;
                                        entry.cacheLifetime = cacheLifetime;
                                    }
                                    reduced.put(filepath, entry);
                                    shouldBeDeleted.removeElement(filepath);
                                    break;
                                }
                                if (!shouldBeDeleted.contains(filepath)) {
                                    shouldBeDeleted.addElement(filepath);
                                    break;
                                }
                                break block21;
                            }
                            case 2: {
                                reduced.remove(file.getCanonicalPath());
                                this.cancelFileExpiration(file);
                                shouldBeDeleted.addElement(filepath);
                                break;
                            }
                            default: {
                                if (FileExpirationService.LOG.isEnabledFor(Priority.INFO)) {
                                    FileExpirationService.LOG.warn((Object)"Unexpected Action in log read.");
                                    break;
                                }
                                break block21;
                            }
                        }
                        break block21;
                    }
                    if (FileExpirationService.LOG.isEnabledFor(Priority.DEBUG)) {
                        FileExpirationService.LOG.debug((Object)("Forcing cancellation of deleted file : " + file.getPath()));
                    }
                    this.cancelFileExpiration(file);
                }
                ++i;
            }
        }
        catch (EOFException e) {
            if (FileExpirationService.LOG.isEnabledFor(Priority.INFO)) {
                FileExpirationService.LOG.info((Object)("Caught EOF Exception after processing " + i + " records from log"));
            }
            entries = reduced.elements();
            ** while (entries.hasMoreElements())
        }
lbl-1000:
        // 1 sources

        {
            anEntry = (Entry)entries.nextElement();
            if (this.scheduleFileExpiration(anEntry.file, TimeUtils.toRelativeTimeMillis(anEntry.expiresAt, start), anEntry.cacheLifetime)) continue;
            this.logWrite(1, anEntry.file, anEntry.expiresAt, anEntry.cacheLifetime);
            continue;
        }
lbl60:
        // 1 sources

        entries = shouldBeDeleted.elements();
        while (entries.hasMoreElements()) {
            file = new File((String)entries.nextElement());
            try {
                needsDelete = true;
                if (this.listener != null) {
                    needsDelete = this.listener.expired(file);
                }
                if (!needsDelete) continue;
                file.delete();
            }
            catch (Throwable t) {
                if (!FileExpirationService.LOG.isEnabledFor(Priority.DEBUG)) continue;
                FileExpirationService.LOG.debug((Object)"Throwable caught while dispatching expiration listener.", t);
            }
        }
    }

    private void removeUnknownFiles(File aDir) {
        String[] list = aDir.list();
        int i = 0;
        while (list != null && i < list.length) {
            block11: {
                try {
                    File f = new File(aDir, list[i]);
                    if (f.isDirectory()) {
                        this.removeUnknownFiles(f);
                        break block11;
                    }
                    if (f.getName().equals(SCHED_DB_FILENAME)) {
                        if (!this.dir.equals(f.getParentFile()) && LOG.isEnabledFor(Priority.WARN)) {
                            LOG.warn((Object)("Found a scheduler DB (" + f.getCanonicalPath() + ") inside the dirs we are monitoring. bad mojo."));
                        }
                        break block11;
                    }
                    if (null != this.hash.get(f.getCanonicalPath())) break block11;
                    try {
                        boolean needsDelete = true;
                        if (this.listener != null) {
                            needsDelete = this.listener.expired(f);
                        }
                        if (needsDelete) {
                            f.delete();
                        }
                    }
                    catch (Throwable t) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"Throwable caught while dispatching expiration listener.", t);
                        }
                    }
                }
                catch (Exception badFile) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block11;
                    LOG.debug((Object)("problem working with file : " + list[i]), (Throwable)badFile);
                }
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Entry {
        File file;
        long expiresAt;
        long cacheLifetime;
        SchedulerService.PendingAction expiryAction;

        Entry(File file, long expiresAt, long cacheLifetime) {
            this.file = file;
            this.expiresAt = expiresAt;
            this.cacheLifetime = cacheLifetime;
        }
    }

    class ExpireAction
    implements SchedulerService.Action {
        Entry entry;

        ExpireAction(Entry entry) {
            this.entry = entry;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void perform(SchedulerService ss) throws IOException {
            try {
                block14: {
                    try {
                        boolean needsDelete = true;
                        if (FileExpirationService.this.listener != null) {
                            needsDelete = FileExpirationService.this.listener.expired(this.entry.file);
                        }
                        if (!needsDelete) break block14;
                        this.entry.file.delete();
                    }
                    catch (Throwable t) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"Throwable caught while dispatching expiration listener.", t);
                        }
                        Object var4_5 = null;
                        FileExpirationService fileExpirationService3 = FileExpirationService.this;
                        synchronized (fileExpirationService3) {
                            FileExpirationService.this.hash.remove(this.entry.file.getCanonicalPath());
                        }
                        Entry entry = this.entry;
                        synchronized (entry) {
                            this.entry.file = null;
                            this.entry.expiryAction = null;
                            return;
                        }
                    }
                }
                Object var4_4 = null;
                FileExpirationService fileExpirationService = FileExpirationService.this;
                synchronized (fileExpirationService) {
                    FileExpirationService.this.hash.remove(this.entry.file.getCanonicalPath());
                }
                Entry entry = this.entry;
                synchronized (entry) {
                    this.entry.file = null;
                    this.entry.expiryAction = null;
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                FileExpirationService fileExpirationService2 = FileExpirationService.this;
                synchronized (fileExpirationService2) {
                    FileExpirationService.this.hash.remove(this.entry.file.getCanonicalPath());
                }
                Entry entry = this.entry;
                synchronized (entry) {
                    this.entry.file = null;
                    this.entry.expiryAction = null;
                    throw throwable;
                }
            }
        }
    }

    static class TimewarpAction
    implements SchedulerService.Action {
        private long warpby;
        private long warpinterval;

        public TimewarpAction(long warpinterval, long warpby) {
            this.warpinterval = warpinterval;
            this.warpby = warpby;
        }

        public void perform(SchedulerService ss) {
            ss.scheduleAction(this, this.warpinterval + this.warpby);
            SchedulerService schedulerService = ss;
            synchronized (schedulerService) {
                TimeUtils.timeWarp(this.warpby);
                ss.notifyAll();
            }
        }
    }

    class CleanupAction
    implements SchedulerService.Action {
        CleanupAction() {
        }

        public void perform(SchedulerService ss) {
            block8: {
                try {
                    FileExpirationService fileExpirationService = FileExpirationService.this;
                    synchronized (fileExpirationService) {
                        if (FileExpirationService.this.db.exists()) {
                            FileExpirationService.this.compress(true);
                        } else if (LOG.isEnabledFor(Priority.WARN)) {
                            LOG.warn((Object)"Expiry log not present!");
                        }
                    }
                }
                catch (IOException e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block8;
                    LOG.debug((Object)"Compression of log stream failed.", (Throwable)e);
                }
            }
            FileExpirationService.this.pendingCompressAction = ss.scheduleAction(this, 1800000L);
        }
    }

    static interface ExpirationListener {
        public boolean expired(File var1);
    }
}

