/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.MessageElement;

public class MessageElementImpl
extends MessageElement {
    private String name;
    private MimeMediaType type;
    private byte[] bytes;
    private int offset;
    private int len;

    public MessageElementImpl(String name, MimeMediaType type, byte[] b, int offset, int len) {
        this.name = name;
        this.type = null != type ? type : new MimeMediaType("application/octet-stream");
        this.bytes = b;
        this.offset = offset;
        this.len = len;
    }

    public MessageElementImpl(String name, MimeMediaType type, InputStream in, int len) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(len < 0 ? 1024 : len);
        byte[] buff = new byte[1024];
        this.name = name;
        this.type = null != type ? type : new MimeMediaType("application/octet-stream");
        int tcnt = 0;
        while (len < 0 || tcnt < len) {
            int needed = len - tcnt;
            int thistime = len < 0 || needed > 1024 ? 1024 : needed;
            int cnt = in.read(buff, 0, thistime);
            if (cnt <= 0) break;
            baos.write(buff, 0, cnt);
            tcnt += cnt;
        }
        this.offset = 0;
        this.len = tcnt;
        this.bytes = baos.toByteArray();
        if (len < 0) {
            in.close();
        }
    }

    public MessageElementImpl(String name, MimeMediaType type, InputStream in) throws IOException {
        this(name, type, in, -1);
        in.close();
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.len;
    }

    public byte[] getBytesOffset() {
        return this.bytes;
    }

    public InputStream getStream() {
        return new ByteArrayInputStream(this.bytes, this.offset, this.len);
    }

    public String getName() {
        return this.name;
    }

    public MimeMediaType getType() {
        return this.type;
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object target) {
        if (!(target instanceof MessageElement)) {
            return false;
        }
        MessageElement other = (MessageElement)target;
        boolean bl = this.name == null ? other.getName() != null : !this.name.equals(other.getName());
        if (bl) {
            return false;
        }
        boolean bl2 = this.type == null ? other.getType() != null : !this.type.equals(other.getType());
        if (bl2) {
            return false;
        }
        if (this.len != other.getLength()) {
            return false;
        }
        byte[] otherBytes = other.getBytesOffset();
        int otherI = other.getOffset();
        int i = 0;
        while (i < this.len) {
            if (this.bytes[this.offset + i] != otherBytes[otherI++]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

