/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import net.jxta.document.Attribute;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageElementEnumeration;
import net.jxta.impl.document.LiteXMLDocument;
import net.jxta.impl.document.LiteXMLElement;
import net.jxta.impl.endpoint.MessageImpl;
import net.jxta.impl.endpoint.MessageWireFormat;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.impl.util.Base64;

public class MessageWireFormatXML
extends MessageWireFormat {
    protected static final String MESSAGE_VERSION = "0";
    protected static final MimeMediaType outputMimeType = new MimeMediaType("text/xml");
    MimeMediaType type;

    public static MimeMediaType getOutputMimeType() {
        return (MimeMediaType)outputMimeType.clone();
    }

    public MessageWireFormatXML(MimeMediaType type) {
        this.type = type;
    }

    public void writeMessage(OutputStream os, Message m) throws IOException {
        LiteXMLDocument doc = new LiteXMLDocument(new MimeMediaType("text/xml"), "Message");
        doc.addAttribute("version", MESSAGE_VERSION);
        MessageElementEnumeration els = ((MessageImpl)m).getElementsInFifoOrder();
        while (els.hasMoreElements()) {
            MessageElement el = (MessageElement)els.nextElement();
            this.writeMessageElement(doc, el);
        }
        doc.sendToStream(os);
    }

    public void readMessage(InputStream is, Message msg) throws IOException {
        LiteXMLDocument doc = new LiteXMLDocument(new MimeMediaType("text/xml"), is);
        if (!"Message".equals(doc.getName())) {
            throw new IOException("Document element is not named Message.");
        }
        Attribute a = doc.getAttribute("version");
        if (a == null) {
            throw new IOException("Missing Message version");
        }
        String version = a.getValue();
        if (!version.equals(MESSAGE_VERSION)) {
            throw new IOException("Can not handle message version " + version + ", expected " + MESSAGE_VERSION);
        }
        Enumeration en = doc.getChildren();
        while (en.hasMoreElements()) {
            LiteXMLElement el = (LiteXMLElement)en.nextElement();
            this.readMessageElement(msg, el);
        }
    }

    private void readMessageElement(Message m, LiteXMLElement el) throws IOException {
        Attribute a = el.getAttribute("name");
        if (a == null) {
            throw new IOException("Missing name attribute in message element");
        }
        String name = a.getValue();
        a = el.getAttribute("mime_type");
        if (a == null) {
            throw new IOException("Missing mime_type for " + name);
        }
        String type = a.getValue();
        a = el.getAttribute("encoding");
        String encoding = a == null ? null : a.getValue();
        String value = el.getTextValue();
        byte[] bytes = encoding != null && encoding.equals("base64") ? Base64.decodeBase64(value) : value.getBytes();
        MessageElement mel = m.newMessageElement(name, new MimeMediaType(type), bytes, 0, bytes.length);
        m.addElement(mel);
    }

    private void writeMessageElement(LiteXMLDocument doc, MessageElement el) {
        String text;
        String encoding = null;
        byte[] bytes = el.getBytesOffset();
        int off = el.getOffset();
        int len = el.getLength();
        MimeMediaType type = el.getType();
        if (type == null) {
            type = new MimeMediaType("application/octet-stream");
        }
        if (type.getType().equals("text")) {
            text = new String(bytes, off, len);
        } else {
            text = Base64.encodeBase64(bytes);
            encoding = "base64";
        }
        LiteXMLElement xmlel = (LiteXMLElement)doc.createElement("Element", text);
        doc.appendChild(xmlel);
        xmlel.addAttribute("name", el.getName());
        if (encoding != null) {
            xmlel.addAttribute("encoding", encoding);
        }
        xmlel.addAttribute("mime_type", type.getMimeMediaType());
    }

    public static class Instantiator
    implements MessageWireFormatFactory.Instantiator {
        public MimeMediaType getOutputMimeType() {
            return MessageWireFormatXML.getOutputMimeType();
        }

        public MessageWireFormat newInstance(MimeMediaType type) {
            return new MessageWireFormatXML(type);
        }
    }
}

