/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.http;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import net.jxta.impl.endpoint.http.HttpTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

class HttpClient
extends Thread {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$http$HttpClient == null ? (class$net$jxta$impl$endpoint$http$HttpClient = HttpClient.class$("net.jxta.impl.endpoint.http.HttpClient")) : class$net$jxta$impl$endpoint$http$HttpClient).getName());
    private static final long MaxMsgPoll = 10L;
    private static final int PollingDelay = 20000;
    private boolean polling = false;
    private boolean quit = false;
    HttpTransport tpt = null;
    private Vector pollingHttps = new Vector();
    static /* synthetic */ Class class$net$jxta$impl$endpoint$http$HttpClient;

    public HttpClient(ThreadGroup inGroup, HttpTransport tpt) {
        super(inGroup, null, "Client Polling");
        this.tpt = tpt;
        this.setPolling(true);
    }

    boolean isPolling() {
        return this.polling && this.pollingHttps.size() > 0;
    }

    synchronized boolean setPolling(boolean enable) {
        boolean current = this.polling;
        this.polling = enable;
        this.notifyAll();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("polling is now " + (this.polling ? "enabled" : "disabled")));
        }
        return current;
    }

    synchronized void endPolling() {
        this.setPolling(false);
        this.quit = true;
        this.interrupt();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"polling is now termiating");
        }
    }

    public boolean isPollingHttp(String url) {
        return this.pollingHttps.contains(url);
    }

    public synchronized void addPollingHttp(String url) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("addPollingHttp: " + url));
        }
        boolean found = false;
        int i = 0;
        while (i < this.pollingHttps.size()) {
            try {
                if (((String)this.pollingHttps.elementAt(i)).equals(url)) {
                    found = true;
                }
            }
            catch (Exception e) {}
            break;
            ++i;
        }
        if (found) {
            return;
        }
        this.pollingHttps.addElement(url);
        this.setPolling(true);
    }

    public synchronized void removePollingHttp(String url) {
        block7: {
            boolean found = false;
            int i = 0;
            i = 0;
            while (i < this.pollingHttps.size()) {
                try {
                    if (((String)this.pollingHttps.elementAt(i)).equals(url)) {
                        found = true;
                    }
                }
                catch (Exception e) {}
                break;
                ++i;
            }
            if (!found) {
                return;
            }
            try {
                this.pollingHttps.removeElementAt(i);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block7;
                LOG.warn((Object)"cannot remove polling HTTP server");
            }
        }
    }

    public void run() {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"Begining client polling loop");
        }
        block13: while (true) {
            try {
                while (!this.quit) {
                    if (this.isPolling()) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"polling begins");
                        }
                        int i = 0;
                        while (i < this.pollingHttps.size()) {
                            block23: {
                                String addr = null;
                                try {
                                    addr = (String)this.pollingHttps.elementAt(i);
                                }
                                catch (Exception e) {
                                    break block23;
                                }
                                URL fullAddr = null;
                                try {
                                    String host = addr;
                                    int port = 80;
                                    int sepAt = addr.lastIndexOf(58);
                                    if (-1 != sepAt) {
                                        host = addr.substring(0, sepAt);
                                        port = Integer.parseInt(addr.substring(sepAt + 1));
                                    }
                                    fullAddr = new URL("http", host, port, "/rec/" + this.tpt.localClientId + "/");
                                }
                                catch (MalformedURLException badurl) {
                                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block23;
                                    LOG.debug((Object)"bad URL for either serverer or client");
                                    break block23;
                                }
                                int cnt = 0;
                                while ((long)cnt++ < 10L) {
                                    if (!this.tpt.pollRemote(fullAddr, 1)) break;
                                }
                            }
                            ++i;
                        }
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"snoozing for 20 secs");
                        }
                        try {
                            Thread.sleep(20000L);
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                        }
                        continue;
                    }
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"waiting for 20 secs");
                    }
                    HttpClient i = this;
                    synchronized (i) {
                        try {
                            this.wait(20000L);
                        }
                        catch (InterruptedException woken) {
                            Thread.interrupted();
                        }
                        continue block13;
                    }
                }
                break;
            }
            catch (Throwable all) {
                if (!LOG.isEnabledFor(Priority.FATAL)) break;
                LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                break;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

