/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.impl.endpoint.http.HttpTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class HttpNonBlockingMessenger
implements EndpointMessenger {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$http$HttpNonBlockingMessenger == null ? (class$net$jxta$impl$endpoint$http$HttpNonBlockingMessenger = HttpNonBlockingMessenger.class$("net.jxta.impl.endpoint.http.HttpNonBlockingMessenger")) : class$net$jxta$impl$endpoint$http$HttpNonBlockingMessenger).getName());
    private EndpointAddress srcAddress = null;
    private EndpointAddress dstAddress = null;
    private HttpTransport proto = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$http$HttpNonBlockingMessenger;

    public HttpNonBlockingMessenger(EndpointAddress destAddr, HttpTransport p) throws IOException {
        if (destAddr == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"destination address is null");
            }
            throw new IllegalArgumentException("destination address is null");
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("   opening a messenger for " + destAddr.toString()));
        }
        this.proto = p;
        this.dstAddress = (EndpointAddress)destAddr.clone();
        this.srcAddress = this.proto.getPublicAddress();
    }

    public void sendMessage(Message message) throws IOException {
        byte[] nextBuffer;
        int readLength;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"sendMessage starts");
        }
        message.setDestinationAddress(this.dstAddress);
        message.setSourceAddress(this.srcAddress);
        ByteArrayInputStream inputStream = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("text/xml")).writeMessage(baos, message);
            baos.close();
            byte[] bytes = baos.toByteArray();
            inputStream = new ByteArrayInputStream(bytes);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"HTTP - send - cannot read outgoing message", (Throwable)e);
            }
            throw new IOException("HTTP - send - cannot read outgoing message");
        }
        Vector<byte[]> msgBuffers = new Vector<byte[]>();
        int msgSize = 0;
        int bufferSize = 4096;
        while (-1 != (readLength = inputStream.read(nextBuffer = new byte[4096]))) {
            if (0 == readLength) continue;
            if (readLength < 4096) {
                byte[] anotherBuffer = new byte[readLength];
                System.arraycopy(nextBuffer, 0, anotherBuffer, 0, readLength);
                nextBuffer = anotherBuffer;
            }
            msgSize += nextBuffer.length;
            msgBuffers.addElement(nextBuffer);
        }
        try {
            String authority;
            String host = authority = this.dstAddress.getProtocolAddress();
            int port = 80;
            int sepAt = authority.lastIndexOf(58);
            if (-1 != sepAt) {
                host = authority.substring(0, sepAt);
                port = Integer.parseInt(authority.substring(sepAt + 1));
            }
            URL url = new URL("http", host, port, "/snd/");
            this.proto.sendHttpPUT(url, msgBuffers.elements(), msgSize);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"HttpNonBlockingMessenger: cannot send data ", (Throwable)e);
            }
            throw new IOException("HttpNonBlockingMessenger: cannot send data ");
        }
    }

    public void close() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

