/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointProtocol;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.servlethttp.HttpClientMessageSender;
import net.jxta.impl.endpoint.servlethttp.HttpRelayClientMessageReceiver;
import net.jxta.impl.endpoint.servlethttp.HttpServerMessageReceiver;
import net.jxta.impl.endpoint.servlethttp.JettyHttpServer;
import net.jxta.impl.protocol.HTTPAdv;
import net.jxta.impl.relay.RelayClientMessageSender;
import net.jxta.impl.relay.RelayServer;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.TransportAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class ServletHttpTransport
implements EndpointProtocol,
Module {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$servlethttp$ServletHttpTransport == null ? (class$net$jxta$impl$endpoint$servlethttp$ServletHttpTransport = ServletHttpTransport.class$("net.jxta.impl.endpoint.servlethttp.ServletHttpTransport")) : class$net$jxta$impl$endpoint$servlethttp$ServletHttpTransport).getName());
    private HttpClientMessageSender httpClientSender = null;
    private RelayClientMessageSender relayClientSender = null;
    private EndpointAddress localAddress = null;
    private static String protocolName = "http";
    protected static final String MAGIC_WORD = "JxtaHttpClient";
    private static final String MSG_RECEIVER_RELATIVE_URI = "/";
    private static final String RELAY_RELATIVE_URI = "/relay";
    private static int minThreads = 10;
    private static int maxThreads = 100;
    private static int maxThreadIdleTime = 120000;
    private static int maxReqReadTime = 60000;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$ServletHttpTransport;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$HttpMessageReceiverServlet;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$HttpRelayServlet;

    public boolean allowOverLoad() {
        return false;
    }

    public int startApp(String[] args) {
        return 0;
    }

    public void stopApp() {
    }

    public void init(PeerGroup peerGroup, ID assignedID, Advertisement impl) throws PeerGroupException {
        try {
            Enumeration httpChilds;
            Enumeration list;
            Properties prop = this.getJxtaProperties();
            this.initFromProperties(prop);
            ModuleImplAdvertisement implAdv = (ModuleImplAdvertisement)impl;
            PeerAdvertisement peerAdv = (PeerAdvertisement)peerGroup.getConfigAdvertisement();
            Element param = implAdv.getParam();
            if (param != null && (list = param.getChildren("Proto")).hasMoreElements()) {
                TextElement pname = (TextElement)list.nextElement();
                protocolName = pname.getTextValue();
            }
            if ((httpChilds = (param = peerAdv.getServiceParam(assignedID)).getChildren(TransportAdvertisement.getAdvertisementType())).hasMoreElements()) {
                param = (Element)httpChilds.nextElement();
            } else {
                httpChilds = param.getChildren(HTTPAdv.getAdvertisementType());
                if (httpChilds.hasMoreElements()) {
                    param = (Element)httpChilds.nextElement();
                }
            }
            HTTPAdv httpAdv = (HTTPAdv)AdvertisementFactory.newAdvertisement((TextElement)param);
            EndpointService endpoint = peerGroup.getEndpointService();
            InetAddress usingInterface = this.computeInterface(httpAdv);
            this.localAddress = this.computeEndpointAddress(endpoint, httpAdv, peerGroup.getPeerID().getUniqueValue().toString());
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Local address = " + this.localAddress));
            }
            this.configureProxyServer(httpAdv);
            this.configureHttpClientSender(this.localAddress, httpAdv);
            if (httpAdv.getRouterEnabled()) {
                this.configureRelayClients(peerGroup, endpoint, httpAdv);
            }
            if (httpAdv.getServerEnabled()) {
                this.configureServer(httpAdv, peerGroup, usingInterface, endpoint, prop);
            }
            endpoint.addEndpointProtocol(this);
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"ServletHttpTransport inited.");
            }
        }
        catch (Throwable e) {
            if (LOG.isEnabledFor(Priority.ERROR)) {
                LOG.error((Object)"Not initialized: ", e);
            }
            throw new PeerGroupException(e.getMessage());
        }
    }

    public EndpointMessenger getMessenger(EndpointAddress dest) throws IOException {
        if (this.isRelayClientAddress(dest)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Returned relay client messenger");
            }
            return this.relayClientSender.getMessenger(dest);
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"Returning normal http client messenger");
        }
        return this.httpClientSender.getMessenger(dest);
    }

    public void propagate(Message msg, String serviceName, String serviceParams, String prunePeer) throws IOException {
    }

    public void close() {
    }

    public String getProtocolName() {
        return ServletHttpTransport.getSupportedProtocolName();
    }

    public static String getSupportedProtocolName() {
        return protocolName;
    }

    public EndpointAddress getPublicAddress() {
        return this.localAddress;
    }

    public boolean allowRouting() {
        return true;
    }

    public boolean isConnectionOriented() {
        return true;
    }

    public boolean ping(EndpointAddress addr) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Trying to ping " + addr));
        }
        if (this.isRelayClientAddress(addr)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("  Using relay client sender to ping " + addr));
            }
            return this.relayClientSender.ping(addr);
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("  Using http client sender to ping " + addr));
        }
        return this.httpClientSender.ping(addr);
    }

    private EndpointAddress computeEndpointAddress(EndpointService endpoint, HTTPAdv httpAdv, String peerID) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"computeEndpointAddress()");
        }
        if (httpAdv.getServerEnabled()) {
            return endpoint.newEndpointAddress(protocolName + "://" + httpAdv.getServer());
        }
        String localClientId = peerID;
        return endpoint.newEndpointAddress(protocolName + "://" + MAGIC_WORD + localClientId);
    }

    private void configureHttpClientSender(EndpointAddress localAddress, HTTPAdv httpAdv) {
        String proxyName = null;
        if (httpAdv.getProxyEnabled()) {
            proxyName = httpAdv.getProxy();
        }
        this.httpClientSender = new HttpClientMessageSender(localAddress);
    }

    private void configureRelayClients(PeerGroup group, EndpointService endpoint, HTTPAdv httpAdv) {
        Vector routers = httpAdv.getRouters();
        if (routers != null) {
            Enumeration e = routers.elements();
            while (e.hasMoreElements()) {
                String urlStr = (String)e.nextElement();
                try {
                    URL url = new URL("http://" + urlStr + RELAY_RELATIVE_URI);
                    HttpRelayClientMessageReceiver receiver = new HttpRelayClientMessageReceiver(url);
                    receiver.init(group, endpoint, httpAdv);
                    receiver.start();
                }
                catch (MalformedURLException ex) {
                    if (!LOG.isEnabledFor(Priority.ERROR)) continue;
                    LOG.error((Object)("Invalid relay server specified: " + urlStr));
                }
                catch (IOException ex) {
                    if (!LOG.isEnabledFor(Priority.ERROR)) continue;
                    LOG.error((Object)("Problem starting relay client: " + urlStr + " Exception = " + ex));
                }
            }
        }
    }

    private InetAddress computeInterface(HTTPAdv httpAdv) throws UnknownHostException {
        String interfaceAddressStr = httpAdv.getInterfaceAddress();
        if (interfaceAddressStr == null) {
            interfaceAddressStr = InetAddress.getLocalHost().getHostAddress();
        }
        InetAddress usingInterface = InetAddress.getByName(interfaceAddressStr);
        return usingInterface;
    }

    private void configureServer(HTTPAdv httpAdv, PeerGroup peerGroup, InetAddress iface, EndpointService endpoint, Properties prop) {
        block4: {
            try {
                String serverName = httpAdv.getServer();
                int port = Integer.parseInt(httpAdv.getPort());
                JettyHttpServer server = new JettyHttpServer();
                server.init(iface, port, endpoint, minThreads, maxThreads, maxThreadIdleTime, maxReqReadTime);
                server.addServlet(MSG_RECEIVER_RELATIVE_URI, (class$net$jxta$impl$endpoint$servlethttp$HttpMessageReceiverServlet == null ? (class$net$jxta$impl$endpoint$servlethttp$HttpMessageReceiverServlet = ServletHttpTransport.class$("net.jxta.impl.endpoint.servlethttp.HttpMessageReceiverServlet")) : class$net$jxta$impl$endpoint$servlethttp$HttpMessageReceiverServlet).getName());
                HttpServerMessageReceiver receiver = new HttpServerMessageReceiver(server);
                receiver.init(peerGroup, endpoint, httpAdv);
                receiver.start();
                RelayServer relayServer = new RelayServer(endpoint, prop);
                server.setContextAttribute("relayServer", relayServer);
                server.addServlet(RELAY_RELATIVE_URI, (class$net$jxta$impl$endpoint$servlethttp$HttpRelayServlet == null ? (class$net$jxta$impl$endpoint$servlethttp$HttpRelayServlet = ServletHttpTransport.class$("net.jxta.impl.endpoint.servlethttp.HttpRelayServlet")) : class$net$jxta$impl$endpoint$servlethttp$HttpRelayServlet).getName());
                this.relayClientSender = new RelayClientMessageSender(relayServer, this.localAddress);
                server.start();
            }
            catch (IOException e) {
                if (LOG.isEnabledFor(Priority.ERROR)) {
                    LOG.error((Object)"Error starting HTTP server: ", (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.ERROR)) break block4;
                LOG.error((Object)"Error starting HTTP server: ", (Throwable)e);
            }
        }
    }

    private void configureProxyServer(HTTPAdv httpAdv) {
        if (httpAdv.getProxyEnabled()) {
            String proxyName = httpAdv.getProxy();
            if (proxyName != null) {
                String host = proxyName;
                String port = "8080";
                int sepAt = proxyName.lastIndexOf(58);
                if (-1 != sepAt) {
                    host = proxyName.substring(0, sepAt);
                    port = proxyName.substring(sepAt + 1);
                }
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"Configuring HTTP proxy server");
                }
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("  host: " + host));
                }
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("  port: " + port));
                }
                Properties prop = System.getProperties();
                ((Hashtable)prop).put("http.proxyHost", host);
                ((Hashtable)prop).put("http.proxyPort", port);
            } else if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"Configuration error: proxy server turned on, but no proxy server specified");
            }
        }
    }

    private boolean isRelayClientAddress(EndpointAddress addr) {
        return addr.getProtocolAddress().indexOf(MAGIC_WORD) != -1;
    }

    private Properties getJxtaProperties() {
        InputStream in;
        Properties prop;
        block9: {
            prop = null;
            in = null;
            try {
                in = new FileInputStream("jxta.properties");
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"Read jxta.properties from present working directory");
                }
            }
            catch (FileNotFoundException e) {
                ClassLoader loader = ClassLoader.getSystemClassLoader();
                in = loader.getResourceAsStream("jxta.properties");
                if (in == null || !LOG.isEnabledFor(Priority.INFO)) break block9;
                LOG.info((Object)"Read jxta.properties from classpath");
            }
        }
        if (in != null) {
            try {
                prop = new Properties();
                prop.load(in);
            }
            catch (IOException e) {
                if (LOG.isEnabledFor(Priority.ERROR)) {
                    LOG.error((Object)"Error reading jxta.properties");
                }
                prop = null;
            }
        } else if (LOG.isEnabledFor(Priority.WARN)) {
            LOG.warn((Object)"jxta.properties cannot be found");
        }
        return prop;
    }

    private void initFromProperties(Properties prop) {
        block23: {
            if (prop != null) {
                String maxThreadIdleTimeStr;
                block22: {
                    String maxReqReadTimeStr;
                    block21: {
                        String maxThreadsStr;
                        block20: {
                            if (LOG.isEnabledFor(Priority.INFO)) {
                                LOG.info((Object)"Using jxta.properties to configure HTTP server");
                            }
                            String minThreadsStr = prop.getProperty("HttpServer.MinThreads");
                            maxThreadsStr = prop.getProperty("HttpServer.MaxThreads");
                            maxReqReadTimeStr = prop.getProperty("HttpServer.MaxRequestReadTime");
                            maxThreadIdleTimeStr = prop.getProperty("HttpServer.MaxThreadIdleTime");
                            try {
                                if (minThreadsStr != null) {
                                    minThreads = Integer.parseInt(minThreadsStr);
                                }
                            }
                            catch (NumberFormatException e) {
                                if (!LOG.isEnabledFor(Priority.INFO)) break block20;
                                LOG.info((Object)"Invalid HttpServer.MinThreads value; using default");
                            }
                        }
                        try {
                            if (maxThreadsStr != null) {
                                maxThreads = Integer.parseInt(maxThreadsStr);
                            }
                        }
                        catch (NumberFormatException e) {
                            if (!LOG.isEnabledFor(Priority.INFO)) break block21;
                            LOG.info((Object)"Invalid HttpServer.MaxThreads value; using default");
                        }
                    }
                    try {
                        if (maxReqReadTimeStr != null) {
                            maxReqReadTime = Integer.parseInt(maxReqReadTimeStr);
                        }
                    }
                    catch (NumberFormatException e) {
                        if (!LOG.isEnabledFor(Priority.INFO)) break block22;
                        LOG.info((Object)"Invalid HttpServer.MaxReqReadTime value; using default");
                    }
                }
                try {
                    if (maxThreadIdleTimeStr != null) {
                        maxThreadIdleTime = Integer.parseInt(maxThreadIdleTimeStr);
                    }
                    break block23;
                }
                catch (NumberFormatException e) {
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)"Invalid HttpServer.MaxThreadIdleTime value; using default");
                    }
                    break block23;
                }
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"jxta.properties not found: using default values");
            }
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("minThreads = " + minThreads));
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("maxThreads = " + maxThreads));
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("maxReqReadTime = " + maxReqReadTime));
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("maxThreadIdleTime = " + maxThreadIdleTime));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

