/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tcp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointProtocol;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import net.jxta.impl.endpoint.tcp.Header;
import net.jxta.impl.endpoint.tcp.TcpConnection;
import net.jxta.impl.endpoint.tcp.TcpConnectionManager;
import net.jxta.impl.endpoint.tcp.TcpNonBlockingMessenger;
import net.jxta.impl.protocol.TCPAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.EndpointAdvertisement;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.TransportAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class TcpTransport
implements EndpointProtocol,
Runnable,
Module {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tcp$TcpTransport == null ? (class$net$jxta$impl$endpoint$tcp$TcpTransport = TcpTransport.class$("net.jxta.impl.endpoint.tcp.TcpTransport")) : class$net$jxta$impl$endpoint$tcp$TcpTransport).getName());
    public ServerSocket unicastSocket;
    public InetAddress usingInterface;
    private InetAddress propagateInetAddress;
    private int propagatePort;
    private int propagateSize;
    public int serverSocketPort;
    private Thread multicastThread = null;
    private Thread unicastThread = null;
    private MulticastSocket multicastSocket = null;
    private PeerGroup group = null;
    public EndpointService endpoint = null;
    private EndpointAddress publicAddress = null;
    private EndpointAdvertisement epadv = null;
    private EndpointAddress mAddress = null;
    private String localSubnet = null;
    private String protocolName = "tcp";
    private boolean allowMulticast = true;
    private TcpConnectionManager connManager = null;
    public static int unicastPortNb = 9701;
    public static String multicastAddress = "224.0.1.85";
    public static int multicastPortNb = 1234;
    public static int multicastPacketSize = 16384;
    public static String serverName = null;
    public static String interfaceAddress = null;
    private IncomingUnicastThreads unicastThreads = null;
    public static final int DefaultNbOfUnicastThreads = 1;
    public static final int MaxNbOfUnicastThreads = 50;
    public static final int MaxNbOfUnicastKeepAliveThreads = 40;
    public static final int MaxKeepAliveDelay = 900000;
    private IncomingMulticastThreads multicastThreads = null;
    public static final int DefaultNbOfMulticastThreads = 0;
    public static final int MaxNbOfMulticastThreads = 20;
    public static final int MaxNbOfPendingSockets = 100;
    public static final int MaxCnxBacklog = 50;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tcp$TcpTransport;

    public int getPort() {
        return this.serverSocketPort;
    }

    public InetAddress getMcastAddr() {
        return this.propagateInetAddress;
    }

    public int getMcastPort() {
        return this.propagatePort;
    }

    public int getMcastSize() {
        return this.propagateSize;
    }

    public boolean allowOverLoad() {
        return false;
    }

    public int startApp(String[] arg) {
        return 0;
    }

    public void stopApp() {
        this.endpoint.removeEndpointProtocol(this);
        if (LOG.isEnabledFor(Priority.WARN)) {
            LOG.warn((Object)"There may be more things to be done here");
        }
    }

    public void init(PeerGroup g, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.connManager = new TcpConnectionManager(this);
        try {
            Enumeration tcpChilds;
            Enumeration list;
            ModuleImplAdvertisement implAdv = (ModuleImplAdvertisement)impl;
            PeerAdvertisement configAdv = (PeerAdvertisement)g.getConfigAdvertisement();
            Element param = implAdv.getParam();
            if (param != null && (list = param.getChildren("Proto")).hasMoreElements()) {
                TextElement pname = (TextElement)list.nextElement();
                this.protocolName = pname.getTextValue();
            }
            if ((tcpChilds = (param = configAdv.getServiceParam(assignedID)).getChildren(TransportAdvertisement.getAdvertisementType())).hasMoreElements()) {
                param = (Element)tcpChilds.nextElement();
            } else {
                tcpChilds = param.getChildren(TCPAdv.getAdvertisementType());
                if (tcpChilds.hasMoreElements()) {
                    param = (Element)tcpChilds.nextElement();
                }
            }
            TCPAdv adv = (TCPAdv)AdvertisementFactory.newAdvertisement((TextElement)param);
            unicastPortNb = new Integer(adv.getPort());
            this.allowMulticast = adv.getMulticastState();
            if (this.allowMulticast) {
                multicastAddress = adv.getMulticastAddr();
                multicastPortNb = new Integer(adv.getMulticastPort());
                multicastPacketSize = new Integer(adv.getMulticastSize());
            }
            interfaceAddress = adv.getInterfaceAddress();
            serverName = adv.getServer();
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Configuring TCP Transport\nUnicastPort:" + unicastPortNb + "\nMulticastState:" + this.allowMulticast + "\nMulticastAddr:" + multicastAddress + "\n MulticastPort:" + multicastPortNb + "\n MulticastPacketSize:" + multicastPacketSize + "\n Interface address:" + (interfaceAddress == null ? "(unspecified)" : interfaceAddress) + "\n Public address:" + (serverName == null ? "(unspecified)" : serverName)));
            }
            this.unicastThreads = new IncomingUnicastThreads(this, 1);
            if (this.allowMulticast) {
                this.multicastThreads = new IncomingMulticastThreads(this, 0);
            }
            if (interfaceAddress == null) {
                interfaceAddress = InetAddress.getLocalHost().getHostAddress();
            }
            this.usingInterface = InetAddress.getByName(interfaceAddress);
            this.unicastSocket = new ServerSocket(unicastPortNb, 50, this.usingInterface);
            this.serverSocketPort = unicastPortNb;
            if (serverName == null) {
                serverName = this.usingInterface.getHostAddress() + ":" + unicastPortNb;
            }
            this.endpoint = g.getEndpointService();
            this.publicAddress = this.endpoint.newEndpointAddress(this.protocolName + "://" + serverName);
            this.mAddress = this.endpoint.newEndpointAddress(this.protocolName + "://" + multicastAddress);
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Binding to : " + this.usingInterface.getHostAddress() + "\nPublishing Address : " + this.publicAddress.toString()));
            }
            this.unicastThread = new Thread((Runnable)this, "TcpTransport:unicast server thread");
            this.unicastThread.start();
            if (this.allowMulticast) {
                this.propagatePort = multicastPortNb;
                this.propagateSize = multicastPacketSize;
                this.propagateInetAddress = InetAddress.getByName(multicastAddress);
                this.multicastSocket = new MulticastSocket(this.propagatePort);
                this.multicastSocket.setInterface(this.usingInterface);
                this.multicastSocket.joinGroup(this.propagateInetAddress);
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("Multicast : " + this.propagateInetAddress.getHostAddress() + ":" + this.propagatePort + " on interface " + this.multicastSocket.getInterface().getHostAddress()));
                }
                this.multicastThread = new Thread((Runnable)this, "TcpTransport:multicast server thread");
                this.multicastThread.start();
            }
            this.endpoint.addEndpointProtocol(this);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("Not initialized: " + e.toString()));
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Initialization exception", (Throwable)e);
            }
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"FIXME: there may be threads that need killing.");
            }
            throw new PeerGroupException(e.getMessage());
        }
    }

    public void run() {
        block4: {
            try {
                Thread current = Thread.currentThread();
                if (current.equals(this.unicastThread)) {
                    this.runUnicastServer();
                }
                if (current.equals(this.multicastThread)) {
                    this.runMulticastServer();
                }
            }
            catch (Throwable all) {
                if (!LOG.isEnabledFor(Priority.FATAL)) break block4;
                LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
            }
        }
    }

    public void runUnicastServer() {
        Socket socket = null;
        while (true) {
            try {
                socket = this.unicastSocket.accept();
                socket.setSoTimeout(900000);
                socket.setKeepAlive(true);
            }
            catch (IOException e1) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                LOG.debug((Object)("ServerSocket.accept() on port " + this.serverSocketPort + " has failed with: " + e1.toString()));
                continue;
            }
            catch (SecurityException e2) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                LOG.debug((Object)("ServerSocket.accept() on port " + this.serverSocketPort + " has failed : " + e2.toString()));
                continue;
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("runUnicastServer: received a connection from " + socket.getInetAddress().getHostAddress()));
            }
            this.processReceivingSocket(socket);
            socket = null;
        }
    }

    public void runMulticastServer() {
        if (!this.allowMulticast) {
            return;
        }
        while (true) {
            byte[] buffer = new byte[this.propagateSize];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            try {
                this.multicastSocket.receive(packet);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.ERROR)) break;
                LOG.error((Object)"failure in runMulticastServer ", (Throwable)e);
                break;
            }
            this.processReceivingBuffer(buffer);
        }
    }

    public void processMulticast(byte[] buffer) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"processMulticast starts");
        }
        if (buffer == null || buffer.length < Header.length) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   buffer null or truncated.");
            }
            return;
        }
        try {
            Header header = new Header();
            if (!header.initFromNetwork(buffer, 0)) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"header is corrupted. Msg ignored.");
                }
                throw new IOException("header is corrupted. Msg ignored.");
            }
            if (header.size > buffer.length) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"size from header is larger than buffer. Msg was truncated.");
                }
                throw new IOException("size from header is larger than buffer. Msg was truncated.");
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer, Header.length, header.size);
            Message msg = this.endpoint.newMessage();
            MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("application/x-jxta-msg")).readMessage(bais, msg);
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"  handing message to EndpointService");
            }
            if (!this.allowMulticast) {
                return;
            }
            EndpointAddress destAddr = msg.getSourceAddress();
            if (destAddr != null) {
                this.checkConnection(destAddr);
            }
            this.endpoint.demux(msg);
            Thread.yield();
        }
        catch (IOException e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("   discard message - exception " + e));
            }
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public void runReceive(Socket socket, boolean keep) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public EndpointMessenger getMessenger(EndpointAddress dst) throws IOException {
        String addr = dst.getProtocolAddress();
        if (addr.indexOf("127.0.0.1") >= 0) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"getMessenger is trying to get 127.0.0.1 - discard");
            }
            return null;
        }
        return new TcpNonBlockingMessenger(dst, this, this.connManager);
    }

    public synchronized void propagate(Message message, String pName, String pParams, String prunePeer) throws IOException {
        block16: {
            DatagramPacket packet;
            block15: {
                int res;
                if (!this.allowMulticast) {
                    return;
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"propagate");
                    LOG.debug((Object)("prunepeer = " + prunePeer));
                }
                this.mAddress.setServiceName(pName);
                this.mAddress.setServiceParameter(pParams);
                message.setDestinationAddress(this.mAddress);
                message.setSourceAddress(this.publicAddress);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("application/x-jxta-msg")).writeMessage(baos, message);
                baos.close();
                byte[] bytes = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                byte[] buffer = new byte[multicastPacketSize];
                int msgSize = Header.length;
                while (-1 != (res = bais.read(buffer, msgSize, multicastPacketSize - msgSize))) {
                    if ((msgSize += res) < multicastPacketSize) continue;
                    try {
                        bais.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Message discarded : larger than multicast packet size (" + multicastPacketSize + ")"));
                    }
                    throw new IOException("Message discarded : larger than multicast packet size (" + multicastPacketSize + ")");
                }
                try {
                    bais.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                if (Header.length == msgSize) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"Message discarded : could not read whole message from stream");
                    }
                    throw new IOException("Message discarded : could not read whole message from stream");
                }
                Header header = new Header();
                header.cmd = 1;
                header.srcAddr = this.usingInterface.getAddress();
                header.srcPort = this.serverSocketPort;
                header.size = msgSize - Header.length;
                header.buildForNetwork(buffer, 0);
                packet = new DatagramPacket(buffer, msgSize, this.propagateInetAddress, this.propagatePort);
                if (this.multicastSocket == null) {
                    try {
                        this.multicastSocket = new MulticastSocket(this.propagatePort);
                        this.multicastSocket.setInterface(this.usingInterface);
                        this.multicastSocket.joinGroup(this.propagateInetAddress);
                    }
                    catch (Exception e) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) break block15;
                        LOG.debug((Object)e);
                    }
                }
            }
            try {
                this.multicastSocket.send(packet);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block16;
                LOG.debug((Object)e);
            }
        }
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public EndpointAddress getPublicAddress() {
        return this.publicAddress;
    }

    public boolean isConnectionOriented() {
        return true;
    }

    public boolean allowRouting() {
        return true;
    }

    public boolean ping(EndpointAddress addr) {
        block11: {
            try {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("ping to " + addr.toString()));
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block11;
                LOG.debug((Object)"ping cannot print address because: ", (Throwable)e);
            }
        }
        try {
            String tmpAddr = addr.getProtocolAddress();
            if (tmpAddr.indexOf("127.0.0.1") >= 0) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"   pinging localhost - discard");
                }
                return false;
            }
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"  failed ", (Throwable)e);
            }
            return false;
        }
        TcpConnection conn = this.connManager.getTcpConnection(addr);
        if (conn == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"  no connection return false ");
            }
            return false;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("  return " + conn.isConnected()));
        }
        return conn.isConnected();
    }

    private void checkConnection(EndpointAddress addr) {
        TcpConnection conn = this.connManager.getTcpConnection(addr);
        if (conn == null) {
            return;
        }
        conn.notifyActivity();
    }

    void processReceivingSocket(Socket socket) {
        this.unicastThreads.newSocket(socket);
    }

    void processReceivingBuffer(byte[] buffer) {
        this.multicastThreads.newBuffer(buffer);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class IncomingMulticastThreads
    implements Runnable {
        protected Vector buffers = null;
        protected TcpTransport tp = null;
        private volatile int waitingThreads = 0;
        private int nbOfThreads = 0;

        public IncomingMulticastThreads(TcpTransport tp, int initialNumber) {
            this.tp = tp;
            this.buffers = new Vector();
            int i = 0;
            while (i < initialNumber) {
                ++this.nbOfThreads;
                Thread t = new Thread((Runnable)this, "TCP Incoming Multicast:" + this.nbOfThreads);
                t.start();
                ++i;
            }
        }

        public void run() {
            try {
                byte[] buffer = null;
                while (true) {
                    if ((buffer = this.waitForBuffer()) == null) {
                        this.decThreads();
                        return;
                    }
                    this.tp.processMulticast(buffer);
                }
            }
            catch (Throwable all) {
                if (LOG.isEnabledFor(Priority.FATAL)) {
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
                return;
            }
        }

        private synchronized void decThreads() {
            --this.nbOfThreads;
        }

        protected synchronized byte[] waitForBuffer() {
            byte[] buffer = null;
            while (true) {
                if (this.buffers.size() > 0) {
                    block12: {
                        try {
                            buffer = (byte[])this.buffers.elementAt(0);
                        }
                        catch (Exception e) {
                            if (!LOG.isEnabledFor(Priority.DEBUG)) break block12;
                            LOG.debug((Object)("waitForBuffer error: " + e));
                        }
                    }
                    if (buffer != null) {
                        block13: {
                            try {
                                this.buffers.removeElementAt(0);
                            }
                            catch (Exception e) {
                                if (!LOG.isEnabledFor(Priority.DEBUG)) break block13;
                                LOG.debug((Object)("waitForBuffer error: " + e));
                            }
                        }
                        return buffer;
                    }
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"waitForBuffer cannot get incoming buffer");
                    }
                }
                if (this.mustDie()) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("waitForBuffer: killing thread " + Thread.currentThread().getName()));
                    }
                    return null;
                }
                try {
                    ++this.waitingThreads;
                    this.wait();
                    --this.waitingThreads;
                }
                catch (Exception exception) {
                }
            }
        }

        private synchronized boolean mustDie() {
            return this.nbOfThreads > 20 || this.waitingThreads > 0;
        }

        protected synchronized void newBuffer(byte[] buffer) {
            this.buffers.addElement(buffer);
            if (this.waitingThreads == 0) {
                ++this.nbOfThreads;
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"newBuffer: create a new Multicast receive Thread");
                }
                Thread t = new Thread((Runnable)this, "TCP Incoming Multicast:" + this.nbOfThreads);
                t.start();
            }
            try {
                this.notify();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class IncomingUnicastThreads
    implements Runnable {
        protected Vector sockets = null;
        protected TcpTransport tp = null;
        private volatile int waitingThreads = 0;
        private int nbOfThreads = 0;
        private int nbOfKeepAlive = 0;

        public IncomingUnicastThreads(TcpTransport tp, int initialNumber) {
            this.tp = tp;
            this.sockets = new Vector();
            int i = 0;
            while (i < initialNumber) {
                ++this.nbOfThreads;
                Thread t = new Thread((Runnable)this, "TCP Incoming Unicast:" + this.nbOfThreads);
                t.start();
                ++i;
            }
        }

        public void run() {
            try {
                Socket socket = null;
                while (true) {
                    if ((socket = this.waitForSocket()) == null) {
                        this.decThreads();
                        return;
                    }
                    boolean keep = this.doesKeepAlive();
                    this.tp.runReceive(socket, keep);
                    if (!keep) continue;
                    this.stopKeepAlive();
                }
            }
            catch (Throwable all) {
                if (LOG.isEnabledFor(Priority.FATAL)) {
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
                return;
            }
        }

        private synchronized void decThreads() {
            --this.nbOfThreads;
        }

        protected synchronized Socket waitForSocket() {
            Socket socket = null;
            while (true) {
                if (this.sockets.size() > 0) {
                    block12: {
                        try {
                            socket = (Socket)this.sockets.elementAt(0);
                        }
                        catch (Exception e) {
                            if (!LOG.isEnabledFor(Priority.DEBUG)) break block12;
                            LOG.debug((Object)("waitForSocket error: " + e));
                        }
                    }
                    if (socket != null) {
                        block13: {
                            try {
                                this.sockets.removeElementAt(0);
                            }
                            catch (Exception e) {
                                if (!LOG.isEnabledFor(Priority.DEBUG)) break block13;
                                LOG.debug((Object)("waitForSocket error: " + e));
                            }
                        }
                        return socket;
                    }
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"waitForSocket cannot get incoming socket");
                    }
                }
                if (this.mustDie()) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"waitForSocket: killing thread");
                    }
                    return null;
                }
                try {
                    ++this.waitingThreads;
                    this.wait();
                    --this.waitingThreads;
                }
                catch (Exception exception) {
                }
            }
        }

        private synchronized boolean mustDie() {
            return this.nbOfThreads > 50 || this.waitingThreads > 1;
        }

        private synchronized boolean doesKeepAlive() {
            if (this.nbOfKeepAlive >= 40) {
                return false;
            }
            ++this.nbOfKeepAlive;
            return true;
        }

        private synchronized void stopKeepAlive() {
            --this.nbOfKeepAlive;
        }

        protected synchronized void newSocket(Socket socket) {
            if (this.sockets.size() > 100) {
                block8: {
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) break block8;
                        LOG.debug((Object)("newSocket socket.close failed with " + e));
                    }
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"newSocket: too many incoming request, dropped incoming message");
                }
                return;
            }
            this.sockets.addElement(socket);
            if (this.waitingThreads == 0) {
                ++this.nbOfThreads;
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"newSocket: create a new Thread");
                }
                Thread t = new Thread((Runnable)this, "TCP Incoming Unicast:" + this.nbOfThreads);
                t.start();
            }
            try {
                this.notify();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

