/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.exception.JxtaError;
import net.jxta.impl.endpoint.tls.TlsConfig;
import net.jxta.impl.peergroup.BorderPanelGBL;
import net.jxta.impl.peergroup.PagesPanel;
import net.jxta.impl.peergroup.PanelGBL;
import net.jxta.impl.protocol.HTTPAdv;
import net.jxta.impl.protocol.TCPAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.TransportAdvertisement;

public class ConfigDialog
extends Frame
implements ItemListener,
MouseListener {
    Frame mainFrame = this;
    PeerAdvertisement configAdv;
    HTTPAdv httpAdv;
    TCPAdv tcpAdv;
    GridBagConstraints stdConstr;
    GridBagConstraints centerConstr;
    GridBagConstraints centerLastConstr;
    GridBagConstraints fillConstr;
    GridBagConstraints leftLineConstr;
    GridBagConstraints midLineConstr;
    GridBagConstraints midLineEastConstr;
    GridBagConstraints rightLineConstr;
    GridBagConstraints leftPanelConstr;
    GridBagConstraints rightPanelConstr;
    Label helpLabel;
    IdPanel idPanel;
    HttpPanel httpPanel;
    TcpPanel tcpPanel;
    RdvPanel rdvPanel;
    RouterPanel routerPanel;
    DebugPanel debugPanel;
    SecPanel secPanel;
    Button ok;
    Button cancel;
    PagesPanel pages = new PagesPanel();
    boolean done = false;
    boolean canceled = false;

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        this.helpLabel.setForeground(Color.black);
        this.helpLabel.setText("See \"http://shell.jxta.org/index.html\" for config help");
    }

    public void itemStateChanged(ItemEvent e) {
        boolean routerPossible = this.tcpPanel.getState() && this.httpPanel.getState();
        this.routerPanel.remote.setEnabled(this.httpPanel.getState());
        this.rdvPanel.http.setEnabled(this.httpPanel.getState());
        this.rdvPanel.tcp.setEnabled(this.tcpPanel.getState());
        this.routerPanel.publicAddr.setEnabled(routerPossible);
        if (this.httpPanel.getState()) {
            this.idPanel.proxyPanel.setEnabled(this.routerPanel.remote.getState());
        }
    }

    public ConfigDialog(PeerAdvertisement cadv) {
        super("JXTA Configurator");
        Enumeration e;
        int index;
        Element param;
        this.stdConstr = new GridBagConstraints();
        this.stdConstr.gridwidth = 0;
        this.stdConstr.gridheight = 1;
        this.stdConstr.gridx = 0;
        this.stdConstr.gridy = -1;
        this.stdConstr.fill = 0;
        this.stdConstr.weightx = 1.0;
        this.stdConstr.anchor = 18;
        this.stdConstr.insets = new Insets(0, 0, 0, 0);
        this.fillConstr = (GridBagConstraints)this.stdConstr.clone();
        this.fillConstr.fill = 2;
        this.centerConstr = (GridBagConstraints)this.stdConstr.clone();
        this.centerConstr.anchor = 11;
        this.centerLastConstr = (GridBagConstraints)this.centerConstr.clone();
        this.centerLastConstr.weighty = 1.0;
        this.midLineConstr = new GridBagConstraints();
        this.midLineConstr.gridwidth = 1;
        this.midLineConstr.gridheight = 1;
        this.midLineConstr.fill = 0;
        this.midLineConstr.anchor = 13;
        this.midLineConstr.weightx = 0.0;
        this.midLineEastConstr = (GridBagConstraints)this.midLineConstr.clone();
        this.midLineEastConstr.anchor = 13;
        this.midLineEastConstr.weightx = 1.0;
        this.rightLineConstr = (GridBagConstraints)this.midLineConstr.clone();
        this.rightLineConstr.gridwidth = 0;
        this.rightLineConstr.weightx = 1.0;
        this.rightLineConstr.anchor = 17;
        this.leftLineConstr = (GridBagConstraints)this.midLineConstr.clone();
        this.leftLineConstr.gridx = 0;
        this.leftLineConstr.weightx = 0.0;
        this.leftLineConstr.anchor = 17;
        this.leftLineConstr.insets = new Insets(0, 20, 0, 20);
        GridBagConstraints fillInsetConstr = (GridBagConstraints)this.fillConstr.clone();
        fillInsetConstr.insets = new Insets(5, 5, 5, 5);
        this.leftPanelConstr = (GridBagConstraints)this.fillConstr.clone();
        this.leftPanelConstr.gridwidth = 1;
        this.rightPanelConstr = (GridBagConstraints)this.fillConstr.clone();
        this.rightPanelConstr.gridwidth = 0;
        this.rightPanelConstr.gridx = -1;
        this.configAdv = cadv;
        String dftDebugLevel = this.configAdv.getDebugLevel();
        boolean isRendezvous = false;
        Vector<String> rdvs = new Vector<String>();
        try {
            TextElement param2 = (TextElement)((Object)this.configAdv.getServiceParam(PeerGroup.rendezvousClassID));
            if (param2 != null) {
                Enumeration rdvEnum = param2.getChildren("Addr");
                while (rdvEnum.hasMoreElements()) {
                    rdvs.addElement(((TextElement)rdvEnum.nextElement()).getTextValue());
                }
                Enumeration rdv = param2.getChildren("Rdv");
                isRendezvous = rdv.hasMoreElements() && "true".equals(((TextElement)rdv.nextElement()).getTextValue());
            }
        }
        catch (Exception nobigdeal) {
            nobigdeal.printStackTrace();
        }
        boolean isJxtaProxy = true;
        try {
            StructuredDocument param3 = this.configAdv.getServiceParam(PeerGroup.proxyClassID);
            if (param3 == null || param3.getChildren("isOff").hasMoreElements()) {
                isJxtaProxy = false;
            }
        }
        catch (Exception nobigdeal) {
            nobigdeal.printStackTrace();
        }
        boolean tcpDefault = true;
        boolean httpDefault = true;
        try {
            Enumeration httpChilds;
            param = this.configAdv.getServiceParam(PeerGroup.httpProtoClassID);
            if (param.getChildren("isOff").hasMoreElements()) {
                httpDefault = false;
            }
            if ((httpChilds = param.getChildren(TransportAdvertisement.getAdvertisementType())).hasMoreElements()) {
                param = (Element)httpChilds.nextElement();
            } else {
                httpChilds = param.getChildren(HTTPAdv.getAdvertisementType());
                if (httpChilds.hasMoreElements()) {
                    param = (Element)httpChilds.nextElement();
                }
            }
            this.httpAdv = (HTTPAdv)AdvertisementFactory.newAdvertisement((TextElement)param);
        }
        catch (Exception thatsbad) {
            thatsbad.printStackTrace();
            throw new RuntimeException("Broken PeerAdvertisement. Cannot proceed.");
        }
        try {
            Enumeration tcpChilds;
            param = this.configAdv.getServiceParam(PeerGroup.tcpProtoClassID);
            if (param.getChildren("isOff").hasMoreElements()) {
                tcpDefault = false;
            }
            if ((tcpChilds = param.getChildren(TransportAdvertisement.getAdvertisementType())).hasMoreElements()) {
                param = (Element)tcpChilds.nextElement();
            } else {
                tcpChilds = param.getChildren(TCPAdv.getAdvertisementType());
                if (tcpChilds.hasMoreElements()) {
                    param = (Element)tcpChilds.nextElement();
                }
            }
            this.tcpAdv = (TCPAdv)AdvertisementFactory.newAdvertisement((TextElement)param);
        }
        catch (Exception thatsbad2) {
            thatsbad2.printStackTrace();
            throw new RuntimeException("Broken PeerAdvertisement. Cannot proceed.");
        }
        boolean serverDefault = this.httpAdv.getServerEnabled();
        boolean proxyDefault = this.httpAdv.getProxyEnabled();
        boolean routerDefault = this.httpAdv.getRouterEnabled();
        String defaultServerNameH = this.httpAdv.getServer();
        String defaultProxyName = this.httpAdv.getProxy();
        Vector defaultRouters = this.httpAdv.getRouters();
        String defaultInterfaceAddressH = this.httpAdv.getInterfaceAddress();
        String configModeH = this.httpAdv.getConfigMode();
        String defaultServerNameT = this.tcpAdv.getServer();
        String defaultInterfaceAddressT = this.tcpAdv.getInterfaceAddress();
        String configModeT = this.tcpAdv.getConfigMode();
        boolean prefAlwaysManualH = true;
        boolean prefAlwaysManualT = true;
        if (configModeH != null && configModeH.equals("manual")) {
            prefAlwaysManualH = false;
        }
        if (configModeT != null && configModeT.equals("manual")) {
            prefAlwaysManualT = false;
        }
        String defaultProxyPort = "8080";
        String defaultServerPortH = "9700";
        String defaultPortH = this.httpAdv.getPort();
        String defaultServerPortT = "9701";
        String defaultPortT = this.tcpAdv.getPort();
        if (defaultProxyName != null) {
            index = defaultProxyName.indexOf(":");
            defaultProxyPort = defaultProxyName.substring(index + 1);
            defaultProxyName = defaultProxyName.substring(0, index);
        }
        if (defaultServerNameH != null && (index = defaultServerNameH.indexOf(":")) != -1) {
            defaultServerPortH = defaultServerNameH.substring(index + 1);
            defaultServerNameH = defaultServerNameH.substring(0, index);
        } else {
            defaultServerNameH = "";
            defaultServerPortH = "9700";
        }
        if (defaultServerNameT != null && (index = defaultServerNameT.indexOf(":")) != -1) {
            defaultServerPortT = defaultServerNameT.substring(index + 1);
            defaultServerNameT = defaultServerNameT.substring(0, index);
        } else {
            defaultServerNameT = "";
            defaultServerPortT = "9701";
        }
        if (defaultPortT == null || defaultPortT.equals("")) {
            defaultPortT = "9701";
        }
        if (defaultPortH == null || defaultPortH.equals("")) {
            defaultPortH = "9700";
        }
        String pn = this.configAdv.getName();
        this.helpLabel = new Label("See \"http://shell.jxta.org/index.html\" for config help", 1);
        this.helpLabel.setBackground(new Color(220, 220, 220));
        this.helpLabel.setForeground(Color.black);
        this.idPanel = new IdPanel(pn, defaultProxyName, defaultProxyPort, proxyDefault);
        this.debugPanel = new DebugPanel(dftDebugLevel);
        this.tcpPanel = new TcpPanel(this, defaultInterfaceAddressT, defaultPortT, defaultServerNameT, defaultServerPortT, tcpDefault, prefAlwaysManualT);
        this.httpPanel = new HttpPanel(this, defaultInterfaceAddressH, defaultPortH, httpDefault, prefAlwaysManualH);
        this.routerPanel = new RouterPanel(this, "HTTP Relay Settings", defaultServerNameH, defaultServerPortH, serverDefault, routerDefault);
        this.secPanel = TlsConfig.willConfigureTls() ? new SecPanel(true) : new SecPanel(false);
        if (defaultRouters != null) {
            e = defaultRouters.elements();
            while (e.hasMoreElements()) {
                this.routerPanel.remote.addItem((String)e.nextElement());
            }
        }
        this.rdvPanel = new RdvPanel("Rendezvous Settings", isRendezvous, isJxtaProxy);
        if (rdvs != null) {
            e = rdvs.elements();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if (s.startsWith("tcp://")) {
                    this.rdvPanel.tcp.addItem(s.substring(6));
                    continue;
                }
                if (!s.startsWith("http://")) continue;
                this.rdvPanel.http.addItem(s.substring(7));
            }
        }
        this.ok = new Button("  OK  ");
        this.cancel = new Button("Cancel");
        this.routerPanel.remote.setEnabled(this.httpPanel.getState());
        this.routerPanel.publicAddr.setEnabled(this.tcpPanel.getState() && this.httpPanel.getState());
        this.rdvPanel.http.setEnabled(this.httpPanel.getState());
        this.rdvPanel.tcp.setEnabled(this.tcpPanel.getState());
        Panel okPanel = new Panel();
        okPanel.add(this.ok);
        okPanel.add(this.cancel);
        PanelGBL basicsPanel = this.pages.addPage("basic", "Basic settings");
        PanelGBL advancedPanel = this.pages.addPage("advanced", "Experienced Users Only");
        PanelGBL rdvrouterPanel = this.pages.addPage("Rendezvous/Relays", "Experienced Users Only");
        PanelGBL securityPanel = this.pages.addPage("Security", "Security Settings");
        advancedPanel.add((Component)this.debugPanel, fillInsetConstr);
        advancedPanel.add((Component)this.tcpPanel, fillInsetConstr);
        advancedPanel.add((Component)this.httpPanel, fillInsetConstr);
        rdvrouterPanel.add((Component)this.rdvPanel, fillInsetConstr);
        rdvrouterPanel.add((Component)this.routerPanel, fillInsetConstr);
        Button loadButton = new Button("Download relay and rendezvous lists");
        rdvrouterPanel.add((Component)loadButton, fillInsetConstr);
        GridBagConstraints centerWConstr = (GridBagConstraints)this.centerConstr.clone();
        centerWConstr.weighty = 1.0;
        basicsPanel.add((Component)this.idPanel, centerWConstr);
        securityPanel.add((Component)this.secPanel, centerWConstr);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.add((Component)this.helpLabel, this.fillConstr);
        this.add((Component)this.pages, fillInsetConstr);
        this.add((Component)okPanel, this.centerLastConstr);
        loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AutoLoader autoLoader = new AutoLoader(ConfigDialog.this.mainFrame, ConfigDialog.this.rdvPanel.tcp, ConfigDialog.this.rdvPanel.http, ConfigDialog.this.routerPanel.remote, "", "http://rdv.jxtahosts.net/cgi-bin/httpRdvsProd.cgi", "http://rdv.jxtahosts.net/cgi-bin/routersProd.cgi", false);
            }
        });
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigDialog.this.saveValues();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigDialog.this.beCanceled();
            }
        });
        this.helpLabel.addMouseListener(this);
        this.pack();
        this.show();
    }

    public synchronized boolean untilDone() {
        try {
            while (!this.done) {
                this.wait();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.canceled) {
            throw new JxtaError("Canceled during configuration");
        }
        return this.done;
    }

    private synchronized void beDone() {
        this.done = true;
        this.notify();
        this.dispose();
    }

    private synchronized void beCanceled() {
        this.canceled = true;
        this.done = true;
        this.notify();
        this.dispose();
    }

    private boolean verifyPort(String portName, String ports) {
        int p1;
        try {
            p1 = Integer.parseInt(ports);
        }
        catch (Exception ex) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText(portName + " port number must be an integer: " + ports);
            return false;
        }
        if (p1 > 65535 || p1 < 0) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText(portName + " port number must be an integer between 0 and " + "65535 found " + p1);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean loadBootStrapping(String urlString, HostListPanel list) {
        if (urlString.equals("")) {
            return true;
        }
        this.helpLabel.setForeground(Color.black);
        this.helpLabel.setText("Trying " + urlString + "...");
        InputStream inp = null;
        try {
            String s;
            inp = new URL(urlString).openStream();
            BufferedReader l = new BufferedReader(new InputStreamReader(inp));
            int valid = 0;
            while ((s = l.readLine()) != null) {
                void var5_8;
                if (!list.addItem((String)var5_8)) continue;
                ++valid;
            }
            if (valid == 0) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText(urlString + ": not a valid list.");
                return false;
            }
        }
        catch (MalformedURLException e) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText(urlString + ": malformed URL.");
            return false;
        }
        catch (IOException e) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText(urlString + ": not accessible. " + (this.idPanel.proxyPanel.getState() ? "" : "You might need a proxy."));
            return false;
        }
        try {
            inp.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.helpLabel.setForeground(Color.black);
        this.helpLabel.setText("Done loading Boostrapping info");
        return true;
    }

    private boolean verifyInput() {
        int j;
        if (this.idPanel.getName().equals("")) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText("A peer name is required.");
            return false;
        }
        if (!this.secPanel.getAlreadyInitialized()) {
            String principal = this.secPanel.getPrincipal();
            String passwd = this.secPanel.getPasswd();
            String vpasswd = this.secPanel.getVerifyPasswd();
            if (principal.length() == 0) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Please configure your secure username via the Security panel");
                this.secPanel.clearPrincipal();
                this.pages.showPage("Security");
                return false;
            }
            if (passwd.length() < 8) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Password requires at least 8 letters");
                this.secPanel.clearPasswds();
                this.pages.showPage("Security");
                return false;
            }
            if (passwd.compareTo(vpasswd) != 0) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Password does not match Verify Password");
                this.secPanel.clearPasswds();
                this.pages.showPage("Security");
                return false;
            }
        }
        if (!this.httpPanel.getState() && !this.tcpPanel.getState()) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText("At least one of TCP or HTTP must be enabled.");
            return false;
        }
        if (!(this.verifyPort("HTTP proxy", this.idPanel.proxyPanel.getPort()) && this.verifyPort("public router", this.routerPanel.publicAddr.getPort()) && this.verifyPort("TCP public", this.tcpPanel.getPublicPort()) && this.verifyPort("TCP local", this.tcpPanel.getLocalPort()) && this.verifyPort("HTTP local", this.httpPanel.getLocalPort()))) {
            return false;
        }
        if (!this.httpPanel.getState() || !this.routerPanel.remote.getState()) {
            return true;
        }
        String[] routers = this.routerPanel.remote.getItems();
        String[] httpRdvs = this.rdvPanel.http.getItems();
        int i = httpRdvs.length;
        while (i-- > 0) {
            j = routers.length;
            while (j-- > 0) {
                String s2;
                String s1 = httpRdvs[i].substring(0, httpRdvs[i].indexOf(":"));
                if (!s1.equals(s2 = routers[j].substring(0, routers[j].indexOf(":")))) continue;
                return true;
            }
        }
        try {
            if (this.idPanel.proxyPanel.getState()) {
                System.setProperty("http.proxyHost", this.idPanel.proxyPanel.getHost());
                System.setProperty("http.proxyPort", this.idPanel.proxyPanel.getPort());
            }
        }
        catch (Exception ee) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText("Cannot turn-on proxying w/ JDK 1.1. you must edit your system properties.");
            return false;
        }
        if (!this.loadBootStrapping("http://rdv.jxtahosts.net/cgi-bin/httpRdvsProd.cgi", this.rdvPanel.http)) {
            return false;
        }
        if (!this.loadBootStrapping("http://rdv.jxtahosts.net/cgi-bin/routersProd.cgi", this.routerPanel.remote)) {
            return false;
        }
        if (!this.loadBootStrapping("", this.rdvPanel.tcp)) {
            return false;
        }
        routers = this.routerPanel.remote.getItems();
        httpRdvs = this.rdvPanel.http.getItems();
        i = httpRdvs.length;
        while (i-- > 0) {
            j = routers.length;
            while (j-- > 0) {
                if (!httpRdvs[i].equals(routers[j])) continue;
                return true;
            }
        }
        return false;
    }

    private void saveValues() {
        StructuredDocument tdoc;
        if (!this.verifyInput()) {
            return;
        }
        try {
            TextElement e;
            this.httpAdv.setInterfaceAddress(this.httpPanel.getInterfaceAddress());
            this.httpAdv.setPort(this.httpPanel.getLocalPort());
            this.httpAdv.setConfigMode(this.httpPanel.getConfigMode());
            if (this.idPanel.proxyPanel.getHost().equals("")) {
                this.httpAdv.setProxy(null);
            } else {
                this.httpAdv.setProxyEnabled(this.idPanel.proxyPanel.getState());
                this.httpAdv.setProxy(this.idPanel.proxyPanel.getHost() + ":" + this.idPanel.proxyPanel.getPort());
            }
            String[] routers = this.routerPanel.remote.getItems();
            if (routers.length == 0) {
                this.httpAdv.setRouters(null);
            } else {
                Vector<String> routersVect = new Vector<String>();
                int i = routers.length;
                while (i-- > 0) {
                    routersVect.addElement(routers[i]);
                }
                this.httpAdv.setRouters(routersVect);
            }
            this.httpAdv.setRouterEnabled(this.routerPanel.remote.getState());
            this.tcpAdv.setPort(this.tcpPanel.getLocalPort());
            this.tcpAdv.setInterfaceAddress(this.tcpPanel.getInterfaceAddress());
            if (this.tcpPanel.getPublicAddress().equals("")) {
                this.tcpAdv.setServer(null);
            } else {
                this.tcpAdv.setServer(this.tcpPanel.getPublicAddress() + ":" + this.tcpPanel.getPublicPort());
            }
            this.tcpAdv.setConfigMode(this.tcpPanel.getConfigMode());
            if (this.routerPanel.publicAddr.getHost().equals("")) {
                this.httpAdv.setServer(null);
            } else {
                this.httpAdv.setServerEnabled(this.httpPanel.getState() && this.tcpPanel.getState() && this.routerPanel.publicAddr.getState());
                this.httpAdv.setServer(this.routerPanel.publicAddr.getHost() + ":" + this.routerPanel.publicAddr.getPort());
            }
            this.configAdv.setName(this.idPanel.getName());
            if (!this.secPanel.getAlreadyInitialized()) {
                System.setProperty("net.jxta.tls.password", this.secPanel.getPasswd());
                System.setProperty("net.jxta.tls.principal", this.secPanel.getPrincipal());
            }
            StructuredTextDocument pdoc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
            if (this.httpPanel.getState()) {
                String[] rdvs = this.rdvPanel.http.getItems();
                int i = rdvs.length;
                while (i-- > 0) {
                    e = pdoc.createElement("Addr", "http://" + rdvs[i]);
                    pdoc.appendChild((Element)e);
                }
            }
            String[] rdvs = this.rdvPanel.tcp.getItems();
            int i = rdvs.length;
            while (i-- > 0) {
                e = pdoc.createElement("Addr", "tcp://" + rdvs[i]);
                pdoc.appendChild((Element)e);
            }
            if (!this.httpPanel.getState()) {
                rdvs = this.rdvPanel.http.getItems();
                i = rdvs.length;
                while (i-- > 0) {
                    e = pdoc.createElement("Addr", "http://" + rdvs[i]);
                    pdoc.appendChild((Element)e);
                }
            }
            if (this.rdvPanel.isRdv.getState()) {
                e = pdoc.createElement("Rdv", "true");
                pdoc.appendChild((Element)e);
            }
            this.configAdv.putServiceParam(PeerGroup.rendezvousClassID, pdoc);
            StructuredTextDocument proxy = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
            if (!this.rdvPanel.isProxy.getState()) {
                proxy.appendChild(proxy.createElement("isOff"));
            }
            this.configAdv.putServiceParam(PeerGroup.proxyClassID, proxy);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            tdoc = (StructuredDocument)this.httpAdv.getDocument(new MimeMediaType("text", "xml"));
            this.configAdv.putServiceParam(PeerGroup.httpProtoClassID, this.wrapParm(tdoc, this.httpPanel.getState()));
        }
        catch (Exception ez1) {
            ez1.printStackTrace();
        }
        try {
            tdoc = (StructuredDocument)this.tcpAdv.getDocument(new MimeMediaType("text", "xml"));
            this.configAdv.putServiceParam(PeerGroup.tcpProtoClassID, this.wrapParm(tdoc, this.tcpPanel.getState()));
        }
        catch (Exception ez1) {
            ez1.printStackTrace();
        }
        this.configAdv.setDebugLevel(this.debugPanel.getDebugLevel());
        this.beDone();
    }

    /*
     * WARNING - void declaration
     */
    private StructuredDocument wrapParm(StructuredDocument srcAdv, boolean enabled) {
        try {
            void ez1;
            StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
            StructuredDocumentUtils.copyElements(doc, doc, srcAdv);
            if (!enabled) {
                doc.appendChild(doc.createElement("isOff"));
            }
            return ez1;
        }
        catch (Exception ez1) {
            ez1.printStackTrace();
            return null;
        }
    }

    class RouterPanel
    extends BorderPanelGBL
    implements ItemListener {
        public HostPortPanel publicAddr;
        public HostListPanel remote;
        private ItemListener listener;

        public void itemStateChanged(ItemEvent e) {
            if (ConfigDialog.this.routerPanel.publicAddr.getState() && ConfigDialog.this.routerPanel.remote.getState()) {
                if (e.getSource() == ConfigDialog.this.routerPanel.remote.useMe) {
                    ConfigDialog.this.routerPanel.publicAddr.setState(false);
                } else {
                    ConfigDialog.this.routerPanel.remote.setState(false);
                }
            }
            this.listener.itemStateChanged(e);
        }

        public RouterPanel(ItemListener l, String title, String defaultName, String defaultPort, boolean serverDefault, boolean routerDefault) {
            super(title);
            this.listener = l;
            this.publicAddr = new HostPortPanel(this, "Act as a relay (Both TCP and HTTP must be enabled.)", "Public address (static NAT address)", defaultName, defaultPort, serverDefault);
            this.remote = new HostListPanel(this, "Use a relay (Required if behind firewall/NAT)", "Available relays", routerDefault);
            this.add((Component)this.publicAddr, ConfigDialog.this.stdConstr);
            this.add((Component)this.remote, ConfigDialog.this.stdConstr);
        }
    }

    class RdvPanel
    extends BorderPanelGBL {
        public Checkbox isRdv;
        public Checkbox isProxy;
        public HostListPanel http;
        public HostListPanel tcp;

        RdvPanel(String title, boolean isRendezVous, boolean isJxtaProxy) {
            super(title);
            this.isRdv = new Checkbox("Act as a Rendezvous", null, isRendezVous);
            this.isProxy = new Checkbox("Act as a JxtaProxy", null, isJxtaProxy);
            this.http = new HostListPanel("Available HTTP rendez-vous");
            this.tcp = new HostListPanel("Available TCP rendez-vous");
            this.add((Component)this.isRdv, ConfigDialog.this.stdConstr);
            this.add((Component)this.isProxy, ConfigDialog.this.stdConstr);
            this.add((Component)this.tcp, ConfigDialog.this.leftPanelConstr);
            this.add((Component)this.http, ConfigDialog.this.rightPanelConstr);
        }
    }

    class DebugPanel
    extends PanelGBL {
        private Choice debugLevel = new Choice();

        public String getDebugLevel() {
            return this.debugLevel.getSelectedItem();
        }

        public DebugPanel(String dftDebugLevel) {
            this.debugLevel.addItem("error");
            this.debugLevel.addItem("warn");
            this.debugLevel.addItem("info");
            this.debugLevel.addItem("debug");
            this.debugLevel.addItem("user default");
            this.debugLevel.select(dftDebugLevel);
            this.add((Component)new Label("Trace Level"), ConfigDialog.this.leftLineConstr);
            this.add((Component)this.debugLevel, ConfigDialog.this.rightLineConstr);
        }
    }

    class SecPanel
    extends PanelGBL
    implements ItemListener {
        private TextField principal;
        private TextField passwd;
        private TextField vpasswd;
        private Label principalLabel = new Label("Secure Username");
        private Label secLabel = new Label("Password");
        private Label vsecLabel = new Label("Verify Password");
        private Label init1 = new Label("Security parameters already initialized");
        private Label init2 = new Label("No further input is required");
        private Label please1 = new Label("Please note your secure username and password");
        private Label please2 = new Label("They will be required for all future access");
        private boolean passwordEntered = false;
        private boolean securityInitialized = false;

        public String getPrincipal() {
            return this.principal.getText();
        }

        public String getPasswd() {
            return this.passwd.getText();
        }

        public String getVerifyPasswd() {
            return this.vpasswd.getText();
        }

        public boolean getAlreadyInitialized() {
            return this.securityInitialized;
        }

        public void setState(boolean state) {
            this.principalLabel.setEnabled(state);
            this.passwd.setEnabled(state);
            this.vpasswd.setEnabled(state);
            this.secLabel.setEnabled(state);
            this.vsecLabel.setEnabled(state);
        }

        public void itemStateChanged(ItemEvent e) {
        }

        public SecPanel(boolean initSecurity) {
            boolean bl = this.securityInitialized = !initSecurity;
            if (initSecurity) {
                this.principal = new TextField("", 20);
                this.passwd = new TextField("", 20);
                this.vpasswd = new TextField("", 20);
                this.passwd.setEchoChar('*');
                this.vpasswd.setEchoChar('*');
                this.add((Component)this.principalLabel, ConfigDialog.this.leftPanelConstr);
                this.add((Component)this.principal, ConfigDialog.this.rightPanelConstr);
                this.add((Component)this.secLabel, ConfigDialog.this.leftPanelConstr);
                this.add((Component)this.passwd, ConfigDialog.this.rightPanelConstr);
                this.add((Component)this.vsecLabel, ConfigDialog.this.leftPanelConstr);
                this.add((Component)this.vpasswd, ConfigDialog.this.rightPanelConstr);
                this.add((Component)this.please1, ConfigDialog.this.leftPanelConstr);
                this.add((Component)this.please2, ConfigDialog.this.leftPanelConstr);
                this.setState(true);
            } else {
                this.add((Component)this.init1, ConfigDialog.this.leftPanelConstr);
                this.add((Component)this.init2, ConfigDialog.this.leftPanelConstr);
            }
        }

        public void clearPasswds() {
            this.passwd.setText("");
            this.vpasswd.setText("");
        }

        public void clearPrincipal() {
            this.principal.setText("");
        }
    }

    class IdPanel
    extends PanelGBL
    implements ItemListener {
        private TextField peerName;
        public HostPortPanel proxyPanel;

        public String getName() {
            return this.peerName.getText();
        }

        public void setState(boolean state) {
            ConfigDialog.this.httpPanel.useMe.setState(state);
            this.proxyPanel.setEnabled(state);
        }

        public boolean getState() {
            return ConfigDialog.this.httpPanel.useMe.getState();
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == ConfigDialog.this.httpPanel.useMe) {
                this.setState(ConfigDialog.this.httpPanel.useMe.getState());
                ConfigDialog.this.httpPanel.listener.itemStateChanged(e);
                return;
            }
        }

        public IdPanel(String defaultPeer, String defaultProxyName, String defaultProxyPort, boolean proxyOn) {
            this.peerName = new TextField(defaultPeer, 20);
            this.add((Component)new Label("Peer Name"), ConfigDialog.this.leftLineConstr);
            this.add((Component)this.peerName, ConfigDialog.this.midLineConstr);
            this.add((Component)new Label("(Mandatory)"), ConfigDialog.this.rightLineConstr);
            this.add((Component)new Label(""), ConfigDialog.this.leftLineConstr);
            this.proxyPanel = new HostPortPanel(this, "Use a proxy server if behind firewall)", "Proxy address", defaultProxyName, defaultProxyPort, proxyOn);
            this.add((Component)this.proxyPanel, ConfigDialog.this.fillConstr);
        }
    }

    class TcpPanel
    extends BorderPanelGBL
    implements ItemListener {
        public Checkbox useMe;
        private IfAddrPanel ifAddr;
        private TextField localPort;
        private HostPortPanel publicAddr;
        public ItemListener listener;

        public String getLocalPort() {
            return this.localPort.getText();
        }

        public String getPublicPort() {
            return this.publicAddr.getPort();
        }

        public void setState(boolean state) {
            this.useMe.setState(state);
            this.localPort.setEnabled(state);
            this.ifAddr.setEnabled(state);
            this.publicAddr.setEnabled(state);
        }

        public boolean getState() {
            return this.useMe.getState();
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == this.useMe) {
                this.setState(this.useMe.getState());
                this.listener.itemStateChanged(e);
            }
        }

        public String getInterfaceAddress() {
            return this.ifAddr.getAddress();
        }

        public String getPublicAddress() {
            return this.publicAddr.getHost();
        }

        public String getConfigMode() {
            return this.ifAddr.getMode();
        }

        public TcpPanel(ItemListener listener, String defaultInterfaceAddr, String defaultPort, String defaultPublicAddr, String defaultPublicPort, boolean defaultState, boolean prefAlwaysManual) {
            super("TCP settings", "Enable if direct LAN connection.");
            this.listener = listener;
            this.ifAddr = new IfAddrPanel(defaultInterfaceAddr, prefAlwaysManual);
            this.useMe = new Checkbox("Enabled", null, defaultState);
            this.localPort = new TextField(defaultPort, 8);
            this.publicAddr = new HostPortPanel(this, null, "(Optional) Public NAT address", defaultPublicAddr, defaultPublicPort, true);
            this.add((Component)this.useMe, ConfigDialog.this.stdConstr);
            this.add((Component)this.ifAddr, ConfigDialog.this.midLineEastConstr);
            this.add((Component)this.localPort, ConfigDialog.this.midLineConstr);
            this.add((Component)this.publicAddr, ConfigDialog.this.stdConstr);
            this.setState(defaultState);
            this.useMe.addItemListener(this);
        }
    }

    class HttpPanel
    extends BorderPanelGBL
    implements ItemListener {
        public Checkbox useMe;
        private IfAddrPanel ifAddr;
        private TextField localPort;
        ItemListener listener;

        public String getLocalPort() {
            return this.localPort.getText();
        }

        public void setState(boolean state) {
            this.useMe.setState(state);
            this.ifAddr.setEnabled(state);
        }

        public boolean getState() {
            return this.useMe.getState();
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == this.useMe) {
                this.setState(this.useMe.getState());
                this.listener.itemStateChanged(e);
                return;
            }
        }

        public String getInterfaceAddress() {
            return this.ifAddr.getAddress();
        }

        public String getConfigMode() {
            return this.ifAddr.getMode();
        }

        public HttpPanel(ItemListener listener, String defaultInterfaceAddress, String defaultPort, boolean defaultState, boolean prefAlwaysManual) {
            super("HTTP settings", "Must enable if behind a firewall/NAT");
            this.listener = listener;
            this.useMe = new Checkbox("Enabled", null, defaultState);
            this.ifAddr = new IfAddrPanel(defaultInterfaceAddress, prefAlwaysManual);
            this.localPort = new TextField(defaultPort, 8);
            this.add((Component)this.useMe, ConfigDialog.this.stdConstr);
            this.add((Component)this.ifAddr, ConfigDialog.this.midLineEastConstr);
            this.add((Component)this.localPort, ConfigDialog.this.midLineConstr);
            this.setState(defaultState);
            this.useMe.addItemListener(this);
        }
    }

    class IfAddrPanel
    extends Panel
    implements ItemListener {
        private Choice ips = new Choice();
        private Checkbox manual;
        private Checkbox alwaysManual;
        private TextField interfaceAddr;
        private Panel addrPanel;
        private CardLayout addrLayout;

        private void setManual(boolean m) {
            if (m) {
                this.addrLayout.show(this.addrPanel, "man");
            } else {
                this.addrLayout.show(this.addrPanel, "auto");
            }
            this.validate();
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == this.manual) {
                this.setManual(this.manual.getState());
            }
        }

        public String getAddress() {
            if (this.manual.getState()) {
                return this.interfaceAddr.getText();
            }
            return this.ips.getSelectedItem();
        }

        public String getMode() {
            if (this.manual.getState()) {
                if (this.alwaysManual.getState()) {
                    return "alwaysManual";
                }
                return "manual";
            }
            return "auto";
        }

        public IfAddrPanel(String defaultInterfaceAddr, boolean prefAlwaysManual) {
            this.interfaceAddr = new TextField(defaultInterfaceAddr, 20);
            boolean modeManual = false;
            try {
                String hostName = InetAddress.getLocalHost().getHostAddress();
                InetAddress[] all = InetAddress.getAllByName(hostName);
                int i = all.length;
                while (i-- > 0) {
                    this.ips.addItem(all[i].getHostAddress());
                }
                if (all.length == 0 || defaultInterfaceAddr != null && !defaultInterfaceAddr.equals("")) {
                    modeManual = true;
                    i = all.length;
                    while (i-- > 0) {
                        if (!defaultInterfaceAddr.equals(all[i].getHostAddress())) continue;
                        modeManual = false;
                        this.ips.select(defaultInterfaceAddr);
                    }
                }
            }
            catch (Exception e) {
                modeManual = true;
            }
            this.manual = new Checkbox("Manual ", null, modeManual);
            Panel autoPanel = new Panel(new FlowLayout(2));
            autoPanel.add(this.ips);
            this.alwaysManual = new Checkbox("Always manual", null, prefAlwaysManual);
            PanelGBL manPanel = new PanelGBL();
            manPanel.add((Component)this.alwaysManual, ConfigDialog.this.leftLineConstr);
            manPanel.add((Component)this.interfaceAddr, ConfigDialog.this.midLineEastConstr);
            this.addrLayout = new CardLayout();
            this.addrPanel = new Panel(this.addrLayout);
            this.addrPanel.add((Component)manPanel, "man");
            this.addrPanel.add((Component)autoPanel, "auto");
            this.add(this.manual);
            this.add(this.addrPanel);
            this.setManual(modeManual);
            this.manual.addItemListener(this);
        }
    }

    class HostListPanel
    extends PanelGBL
    implements ActionListener,
    ItemListener {
        public Checkbox useMe;
        private TextField host;
        private TextField port;
        private Button insert;
        private Button remove;
        private List list;
        private Label listLabel;
        private ItemListener listener;

        public void setState(boolean state) {
            if (this.useMe != null) {
                this.useMe.setState(state);
            }
            this.list.setEnabled(state);
            this.host.setEnabled(state);
            this.port.setEnabled(state);
            this.insert.setEnabled(state);
            this.remove.setEnabled(state);
            this.listLabel.setEnabled(state);
        }

        public boolean getState() {
            return this.useMe.getState();
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == this.useMe) {
                if (this.useMe != null) {
                    this.setState(this.useMe.getState());
                }
                this.listener.itemStateChanged(e);
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.insert) {
                if (this.addItem(this.host.getText() + ":" + this.port.getText())) {
                    this.host.setText("");
                    this.port.setText("");
                }
                return;
            }
            if (e.getSource() == this.remove) {
                int[] sel = this.list.getSelectedIndexes();
                int i = sel.length;
                while (i-- > 0) {
                    this.list.remove(sel[i]);
                }
                return;
            }
        }

        public HostListPanel(String lstLabel) {
            this(null, null, lstLabel, true);
        }

        public HostListPanel(ItemListener l, String checkLabel, String lstLabel, boolean defaultState) {
            this.listener = l;
            this.host = new TextField("", 16);
            this.port = new TextField("", 4);
            this.insert = new Button(" + ");
            this.remove = new Button(" - ");
            this.list = new List(3, true);
            this.listLabel = new Label(lstLabel);
            PanelGBL p1 = new PanelGBL();
            PanelGBL p2 = new PanelGBL();
            GridBagConstraints c1 = (GridBagConstraints)ConfigDialog.this.leftLineConstr.clone();
            c1.insets = new Insets(0, 0, 0, 0);
            p1.add((Component)this.host, c1);
            p1.add((Component)this.port, ConfigDialog.this.rightLineConstr);
            p1.add((Component)this.list, ConfigDialog.this.fillConstr);
            p2.add((Component)this.insert, ConfigDialog.this.fillConstr);
            p2.add((Component)this.remove, ConfigDialog.this.fillConstr);
            GridBagConstraints c2 = (GridBagConstraints)ConfigDialog.this.rightLineConstr.clone();
            c2.anchor = 18;
            c2.insets = new Insets(4, 2, 2, 8);
            if (this.listener != null && checkLabel != null) {
                this.useMe = new Checkbox(checkLabel, null, defaultState);
                this.add((Component)this.useMe, ConfigDialog.this.stdConstr);
                this.useMe.addItemListener(this);
            }
            this.add((Component)this.listLabel, ConfigDialog.this.stdConstr);
            this.add((Component)p1, c1);
            this.add((Component)p2, c2);
            this.setState(defaultState);
            this.insert.addActionListener(this);
            this.remove.addActionListener(this);
        }

        public boolean addItem(String item) {
            int i = item.indexOf(58);
            if (i == -1) {
                return false;
            }
            try {
                String ips = item.substring(0, i);
                String ports = item.substring(i + 1);
                int port = Integer.parseInt(ports);
                if (port < 0 || port > 65535) {
                    return false;
                }
                this.list.add(ips.trim() + ":" + port);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public String[] getItems() {
            return this.list.getItems();
        }
    }

    class AutoLoader
    extends Dialog
    implements ActionListener,
    MouseListener {
        HostListPanel list1;
        HostListPanel list2;
        HostListPanel list3;
        Button load;
        Button quit;
        TextField urlField1;
        TextField urlField2;
        TextField urlField3;
        Label helpLabel;
        boolean once;
        String helpText = "Edit the urls below and click \"Load\". Blank those you do not want to load. Repeat if needed.";

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            this.helpLabel.setForeground(Color.black);
            this.helpLabel.setText(this.helpText);
        }

        /*
         * WARNING - void declaration
         */
        private boolean loadList(TextField urlField, HostListPanel list) {
            String urlString = urlField.getText();
            if (urlString.equals("")) {
                return true;
            }
            this.helpLabel.setForeground(Color.black);
            this.helpLabel.setText("Trying " + urlString + "...");
            InputStream inp = null;
            try {
                String s;
                inp = new URL(urlString).openStream();
                BufferedReader l = new BufferedReader(new InputStreamReader(inp));
                int valid = 0;
                while ((s = l.readLine()) != null) {
                    void var6_9;
                    if (!list.addItem((String)var6_9)) continue;
                    ++valid;
                }
                if (valid == 0) {
                    this.helpLabel.setForeground(Color.red.darker());
                    this.helpLabel.setText(urlString + ": not a valid list.");
                    return false;
                }
            }
            catch (MalformedURLException e) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText(urlString + ": malformed URL.");
                return false;
            }
            catch (IOException e) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText(urlString + ": not accessible. " + (ConfigDialog.this.idPanel.proxyPanel.getState() ? "" : "You might need a proxy."));
                return false;
            }
            try {
                inp.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.helpLabel.setForeground(Color.black);
            this.helpLabel.setText(this.helpText);
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.quit) {
                this.dispose();
                return;
            }
            try {
                if (ConfigDialog.this.idPanel.proxyPanel.getState()) {
                    System.setProperty("http.proxyHost", ConfigDialog.this.idPanel.proxyPanel.getHost());
                    System.setProperty("http.proxyPort", ConfigDialog.this.idPanel.proxyPanel.getPort());
                }
            }
            catch (Exception ee) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Cannot turn-on proxying w/ JDK 1.1. you must edit your system properties.");
            }
            if (this.loadList(this.urlField1, this.list1) && this.loadList(this.urlField2, this.list2) && this.loadList(this.urlField3, this.list3) && this.once) {
                this.dispose();
            }
        }

        public AutoLoader(Frame owner, HostListPanel lst1, HostListPanel lst2, HostListPanel lst3, String defaultUrl1, String defaultUrl2, String defaultUrl3, boolean once) {
            super(owner, "Load list from URL", true);
            this.once = once;
            if (once) {
                this.helpText = "Edit the urls below and click \"Done\". Blank those you do not want to load.";
            }
            this.setLayout(new BorderLayout());
            Panel cent = new Panel(this, new GridLayout(0, 1, 0, 0)){
                private final /* synthetic */ AutoLoader this$1;
                {
                    this.this$1 = this$1;
                }

                public Insets getInsets() {
                    return new Insets(0, 5, 0, 5);
                }
            };
            this.list1 = lst1;
            this.list2 = lst2;
            this.list3 = lst3;
            this.urlField1 = new TextField(defaultUrl1, 50);
            this.urlField2 = new TextField(defaultUrl2, 50);
            this.urlField3 = new TextField(defaultUrl3, 50);
            this.helpLabel = new Label(this.helpText, 1);
            this.helpLabel.setBackground(new Color(220, 220, 220));
            this.helpLabel.setForeground(Color.black);
            this.load = new Button(once ? " Done " : " Load ");
            this.quit = new Button(once ? " Cancel " : " Dismiss ");
            Panel okPanel = new Panel();
            okPanel.add(this.load);
            okPanel.add(this.quit);
            Panel urlPanel1 = new Panel(new FlowLayout(2));
            Panel urlPanel2 = new Panel(new FlowLayout(2));
            Panel urlPanel3 = new Panel(new FlowLayout(2));
            urlPanel1.add(new Label("Tcp rendez-vous list:"));
            urlPanel2.add(new Label("Http rendez-vous list:"));
            urlPanel3.add(new Label("HTTP relays list:"));
            urlPanel1.add(this.urlField1);
            urlPanel2.add(this.urlField2);
            urlPanel3.add(this.urlField3);
            this.add((Component)this.helpLabel, "North");
            cent.add(new Label("See also: http://platform.jxta.org/java/rendezvous.html"));
            cent.add(urlPanel1);
            cent.add(urlPanel2);
            cent.add(urlPanel3);
            this.add((Component)cent, "Center");
            this.add((Component)okPanel, "South");
            this.helpLabel.addMouseListener(this);
            this.load.addActionListener(this);
            this.quit.addActionListener(this);
            this.pack();
            this.show();
        }
    }

    class HostPortPanel
    extends PanelGBL
    implements ItemListener {
        public Checkbox useMe;
        private TextField host;
        private TextField port;
        Label addressLabel;
        ItemListener listener;

        public String getHost() {
            return this.host.getText();
        }

        public String getPort() {
            return this.port.getText();
        }

        public void setState(boolean state) {
            this.useMe.setState(state);
            this.host.setEnabled(state);
            this.port.setEnabled(state);
            this.addressLabel.setEnabled(state);
        }

        public boolean getState() {
            return this.useMe.getState();
        }

        public void itemStateChanged(ItemEvent e) {
            this.setState(this.useMe.getState());
            this.listener.itemStateChanged(e);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
        }

        HostPortPanel(ItemListener l, String checkLabel, String addrLabel, String defaultHost, String defaultPort, boolean defaultState) {
            if (checkLabel == null) {
                checkLabel = "";
            }
            this.listener = l;
            this.useMe = new Checkbox(checkLabel, null, defaultState);
            this.host = new TextField(defaultHost, 20);
            this.port = new TextField(defaultPort, 8);
            this.addressLabel = new Label(addrLabel);
            if (!checkLabel.equals("")) {
                this.add((Component)this.useMe, ConfigDialog.this.stdConstr);
            }
            this.add((Component)this.addressLabel, ConfigDialog.this.leftLineConstr);
            this.add((Component)this.host, ConfigDialog.this.midLineConstr);
            this.add((Component)this.port, ConfigDialog.this.rightLineConstr);
            this.setState(defaultState);
            this.useMe.addItemListener(this);
        }
    }
}

