/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointService;
import net.jxta.exception.DiscardQueryException;
import net.jxta.exception.NoResponseException;
import net.jxta.exception.ResendQueryException;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.impl.util.JxtaTimer;
import net.jxta.impl.util.JxtaTimerHandler;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.resolver.QueryHandler;
import net.jxta.resolver.ResolverService;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class PipeResolver
implements JxtaTimerHandler,
QueryHandler {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$pipe$PipeResolver == null ? (class$net$jxta$impl$pipe$PipeResolver = PipeResolver.class$("net.jxta.impl.pipe.PipeResolver")) : class$net$jxta$impl$pipe$PipeResolver).getName());
    private static final String PipeResolverName = "JxtaPipeResolver";
    private static final String MsgTypeTag = "MsgType";
    private static final String PipeIdTag = "PipeId";
    private static final String TypeTag = "Type";
    private static final String PeerIdTag = "Peer";
    private static final String CachedTag = "Cached";
    private static final String PeerAdvTag = "PeerAdv";
    private static final String FoundTag = "Found";
    private static final String QueryMsgType = "Query";
    private static final String AnswerMsgType = "Answer";
    private static long DefaultPipeLease = 3600000L;
    private static long GcDelay = 600000L;
    private static int qid = 0;
    private ResolverService resolver = null;
    private Hashtable pipes = null;
    private Hashtable cachedPipes = null;
    private Vector localAddrs = null;
    private RefPeerGroup myGroup = null;
    private EndpointService endpoint = null;
    private DiscoveryService discovery = null;
    private String localPeerId = null;
    private JxtaTimer gcTimer = null;
    private Hashtable listeners = new Hashtable();
    static /* synthetic */ Class class$net$jxta$impl$pipe$PipeResolver;

    public PipeResolver(PeerGroup g) {
        this.myGroup = (RefPeerGroup)g;
        this.localPeerId = this.myGroup.getPeerID().toString();
        this.endpoint = this.myGroup.getEndpointService();
        this.pipes = new Hashtable();
        this.cachedPipes = new Hashtable();
        this.resolver = g.getResolverService();
        this.discovery = this.myGroup.getDiscoveryService();
        this.resolver.registerHandler(PipeResolverName, this);
        this.gcTimer = new JxtaTimer(this, GcDelay, true);
    }

    protected void stop() {
        this.resolver.unregisterHandler(PipeResolverName);
    }

    public void registerCached(String ipId, String peer) {
        if (LOG.isDebugEnabled()) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"registerCached:");
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("      Id = " + ipId));
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("    peer = " + peer));
            }
        }
        PipeEntry entry = null;
        if (this.cachedPipes.containsKey(ipId)) {
            entry = (PipeEntry)this.cachedPipes.get(ipId);
            if (entry != null) {
                entry.peer = peer;
                this.resetLease(entry);
            } else if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"registerCached. unexpected null pointer");
            }
            return;
        }
        entry = new PipeEntry(peer);
        this.resetLease(entry);
        try {
            PipeEntry obj = this.cachedPipes.put(ipId, entry);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("registerCached failed " + e));
            }
            return;
        }
        this.notifyWaitingThreads();
    }

    public void register(String ipId, InputPipe ip) {
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("register " + ipId));
        }
        try {
            InputPipe obj = this.pipes.put(ipId, ip);
        }
        catch (Exception e) {
            return;
        }
        this.notifyWaitingThreads();
    }

    public void forget(String ipId) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("forget " + ipId));
        }
        Object v = this.pipes.remove(ipId);
    }

    public void forgetCached(String ipId) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("forgetCached " + ipId));
        }
        Object v = this.cachedPipes.remove(ipId);
    }

    public String findLocal(String ipId) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("findLocal " + ipId));
        }
        String peer = null;
        Object obj = this.pipes.get(ipId);
        if (obj != null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("findLocal: found local InputPipe for " + ipId));
            }
            return this.localPeerId;
        }
        peer = this.findCached(ipId);
        return peer;
    }

    public String find(PipeAdvertisement pAdv, long timeout, boolean nocache) {
        String peer;
        String ipId = pAdv.getPipeID().toString();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("find " + ipId));
        }
        if ((peer = this.findLocal(ipId)) == null) {
            Object enum_ = null;
            peer = this.findRemote(pAdv, timeout, nocache);
            return peer;
        }
        if (this.listeners.containsKey(ipId)) {
            Event newevent = new Event(this, peer, ipId, "JxtaUnicast", 0);
            Listener pl = (Listener)this.listeners.get(ipId);
            pl.pipeResolverEvent(newevent);
        }
        return peer;
    }

    public void sendVerify(String peer, String ipId, String type) {
        if (LOG.isDebugEnabled()) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"sendVerify:");
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("    pipe= " + ipId));
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("    peer= " + peer));
            }
        }
        try {
            StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), "jxta:PipeResolver");
            TextElement e = null;
            e = doc.createElement(MsgTypeTag, QueryMsgType);
            doc.appendChild((Element)e);
            e = doc.createElement(PipeIdTag, ipId);
            doc.appendChild((Element)e);
            e = doc.createElement(TypeTag, type);
            doc.appendChild((Element)e);
            e = doc.createElement(PeerIdTag, peer);
            doc.appendChild((Element)e);
            e = doc.createElement(CachedTag, "false");
            doc.appendChild((Element)e);
            StringWriter dumped = new StringWriter();
            doc.sendToWriter(dumped);
            ResolverQuery query = new ResolverQuery(PipeResolverName, null, this.localPeerId, dumped.toString(), qid++);
            this.resolver.sendQuery(peer, query);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("sendVerify failed with " + e));
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void processResponse(ResolverResponseMsg response) {
        if (PipeResolver.LOG.isEnabledFor(Priority.DEBUG)) {
            PipeResolver.LOG.debug((Object)"processResponse got a response");
        }
        enum = null;
        peer = null;
        mediaType = null;
        ipId = null;
        type = null;
        peerAdv = null;
        try {
            mediaType = new MimeMediaType("text/xml");
        }
        catch (RuntimeException e) {
            if (PipeResolver.LOG.isEnabledFor(Priority.DEBUG)) {
                PipeResolver.LOG.debug((Object)("processResponse: cannot get MimeMediaType " + e));
            }
            return;
        }
        ip = new ByteArrayInputStream(response.getResponse().getBytes());
        doc = null;
        try {
            doc = StructuredDocumentFactory.newStructuredDocument(mediaType, ip);
        }
        catch (Exception e) {
            if (PipeResolver.LOG.isEnabledFor(Priority.DEBUG)) {
                PipeResolver.LOG.debug((Object)"processResponse: malformed response - discard");
            }
            return;
        }
        enum = doc.getChildren();
        tmp = new Vector<Object>();
        found = true;
        while (enum.hasMoreElements()) {
            elem = (TextElement)enum.nextElement();
            if (elem.getName().equals("Peer")) {
                tmp.addElement(elem.getValue());
                continue;
            }
            if (elem.getName().equals("PipeId")) {
                ipId = (String)elem.getValue();
                continue;
            }
            if (elem.getName().equals("Type")) {
                type = (String)elem.getValue();
                continue;
            }
            if (elem.getName().equals("Found")) {
                found = ((String)elem.getValue()).equals("true");
                continue;
            }
            if (!elem.getName().equals("PeerAdv")) continue;
            peerAdv = (String)elem.getValue();
            this.saveAdv(peerAdv);
        }
        if (ipId == null || tmp.size() == 0) {
            if (PipeResolver.LOG.isEnabledFor(Priority.DEBUG)) {
                PipeResolver.LOG.debug((Object)"processResponse: malformed response - discard.");
            }
            return;
        }
        if (type == null) {
            if (PipeResolver.LOG.isEnabledFor(Priority.DEBUG)) {
                PipeResolver.LOG.debug((Object)"processResponse: no type - using UnicastType as default");
            }
            type = "JxtaUnicast";
        }
        if ((enum = tmp.elements()) != null) ** GOTO lbl69
        if (PipeResolver.LOG.isEnabledFor(Priority.DEBUG)) {
            PipeResolver.LOG.debug((Object)"processResponse: empty response");
        }
        return;
lbl-1000:
        // 1 sources

        {
            peer = (String)enum.nextElement();
            if (!found) {
                cachedPeer = this.findLocal(ipId);
                if (cachedPeer == null || !cachedPeer.equals(peer)) continue;
                this.forgetCached(ipId);
                return;
            }
            this.registerCached(ipId, peer);
            if (!this.listeners.containsKey(ipId)) continue;
            newevent = new Event(this, peer, ipId, type, response.getQueryId());
            pl = (Listener)this.listeners.get(ipId);
            pl.pipeResolverEvent(newevent);
lbl69:
            // 4 sources

            ** while (enum.hasMoreElements())
        }
lbl70:
        // 1 sources

    }

    public ResolverResponseMsg processQuery(ResolverQueryMsg query) throws NoResponseException, DiscardQueryException, IOException, ResendQueryException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"processQuery starts");
        }
        MimeMediaType mediaType = null;
        mediaType = new MimeMediaType("text/xml");
        ByteArrayInputStream ip = new ByteArrayInputStream(query.getQuery().getBytes());
        StructuredTextDocument doc = null;
        try {
            doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(mediaType, ip);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery: malformed request ", (Throwable)e);
            }
            throw new IOException("processQuery: malformed request ");
        }
        String pId = null;
        boolean cached = true;
        String destPeer = null;
        String type = null;
        Enumeration enumeration = doc.getChildren();
        while (enumeration.hasMoreElements()) {
            TextElement elem = (TextElement)enumeration.nextElement();
            if (elem.getName().equals(PipeIdTag)) {
                pId = (String)elem.getValue();
                continue;
            }
            if (elem.getName().equals(PeerIdTag)) {
                destPeer = (String)elem.getValue();
                continue;
            }
            if (elem.getName().equals(TypeTag)) {
                type = (String)elem.getValue();
                continue;
            }
            if (!elem.getName().equals(CachedTag)) continue;
            cached = ((String)elem.getValue()).equals("true");
        }
        if (pId == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery: malformed request, no PipeId.");
            }
            throw new IOException();
        }
        if (type == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery: type is null, discarded.");
            }
            throw new DiscardQueryException("processQuery: type is null, discarded.");
        }
        if (destPeer != null && !destPeer.equals(this.localPeerId)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery: request not for this peer, discarded.");
            }
            throw new DiscardQueryException("processQuery: request not for this peer, discarded.");
        }
        int queryId = query.getQueryId();
        String peer = null;
        peer = !cached ? (this.pipes.get(pId) != null ? this.localPeerId : null) : this.findLocal(pId);
        if (peer == null && destPeer == null) {
            if (this.myGroup.isRendezvous()) {
                throw new NoResponseException();
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery: message discarded.");
            }
            throw new DiscardQueryException("processQuery: message discarded.");
        }
        try {
            doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), "jxta:PipeResolver");
            TextElement e = null;
            e = doc.createElement(MsgTypeTag, AnswerMsgType);
            doc.appendChild((Element)e);
            e = doc.createElement(PipeIdTag, pId);
            doc.appendChild((Element)e);
            e = doc.createElement(TypeTag, type);
            doc.appendChild((Element)e);
            if (peer == null) {
                e = doc.createElement(PeerIdTag, this.localPeerId);
                doc.appendChild((Element)e);
                e = doc.createElement(FoundTag, "false");
                doc.appendChild((Element)e);
            } else {
                e = doc.createElement(PeerIdTag, peer);
                doc.appendChild((Element)e);
                String advStr = this.advString(peer);
                if (advStr != null) {
                    e = doc.createElement(PeerAdvTag, advStr);
                    doc.appendChild((Element)e);
                }
            }
            StringWriter dumped = new StringWriter();
            doc.sendToWriter(dumped);
            ResolverResponse res = new ResolverResponse(PipeResolverName, null, queryId, dumped.toString());
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery: sending answer.");
            }
            return res;
        }
        catch (Exception ee) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery: error while processing query:", (Throwable)ee);
            }
            throw new IOException(ee.toString());
        }
    }

    public void signal(JxtaTimer timer) {
        this.refreshCachedPipes();
    }

    private void resetLease(PipeEntry entry) {
        if (entry == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        entry.lease = currentTime + DefaultPipeLease;
    }

    private synchronized void refreshCachedPipes() {
        long currentTime = System.currentTimeMillis();
        Enumeration enumeration = this.cachedPipes.keys();
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return;
        }
        PipeEntry entry = null;
        String pipe = null;
        while (enumeration.hasMoreElements()) {
            try {
                pipe = (String)enumeration.nextElement();
                entry = (PipeEntry)this.cachedPipes.get(pipe);
                if (entry == null) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                    LOG.debug((Object)("refreshCachedPipe: empty entry for pipe " + pipe));
                    continue;
                }
                if (entry.lease >= currentTime) continue;
                this.cachedPipes.remove(pipe);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break;
                LOG.debug((Object)("refreshCachedPipe: " + e));
                break;
            }
        }
    }

    private String findCached(String ipId) {
        PipeEntry entry = (PipeEntry)this.cachedPipes.get(ipId);
        if (entry == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("findCached did not find " + ipId));
            }
            return null;
        }
        this.resetLease(entry);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("findCached found" + ipId));
        }
        return entry.peer;
    }

    private String findRemote(PipeAdvertisement adv, long timeout, boolean nocache) {
        String ipId = adv.getPipeID().toString();
        String type = adv.getType();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("findRemote " + ipId));
        }
        try {
            StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), "jxta:PipeResolver");
            TextElement e = null;
            e = doc.createElement(MsgTypeTag, QueryMsgType);
            doc.appendChild((Element)e);
            e = doc.createElement(PipeIdTag, ipId);
            doc.appendChild((Element)e);
            e = doc.createElement(TypeTag, type);
            doc.appendChild((Element)e);
            if (nocache) {
                e = doc.createElement(CachedTag, "false");
                doc.appendChild((Element)e);
            }
            StringWriter dumped = new StringWriter();
            doc.sendToWriter(dumped);
            ResolverQuery query = new ResolverQuery(PipeResolverName, null, this.localPeerId, dumped.toString(), qid++);
            this.resolver.sendQuery(null, query);
        }
        catch (Exception ee) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("findRemote failed with " + ee));
            }
            return null;
        }
        if (timeout == 0L) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"findRemote no timeout");
            }
            return null;
        }
        long endTime = System.currentTimeMillis() + timeout;
        String peer = null;
        while (true) {
            if ((peer = this.findLocal(ipId)) != null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("findRemote found " + peer));
                }
                return peer;
            }
            peer = this.findCached(ipId);
            if (peer != null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("findRemote found " + peer));
                }
                return peer;
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"findRemote waiting...");
            }
            if (timeout < 0L) {
                this.goWait(Long.MAX_VALUE);
                continue;
            }
            long remain = endTime - System.currentTimeMillis();
            if (remain <= 0L) break;
            this.goWait(remain);
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"findRemote timeout.");
        }
        return null;
    }

    private synchronized void goWait(long timeout) {
        try {
            this.wait(timeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void notifyWaitingThreads() {
        this.notifyAll();
    }

    private String advString(String peer) {
        Enumeration enumeration;
        DiscoveryService discovery = this.myGroup.getDiscoveryService();
        try {
            enumeration = discovery.getLocalAdvertisements(0, "PID", peer);
        }
        catch (IOException e) {
            return null;
        }
        if (enumeration.hasMoreElements()) {
            Advertisement adv = (Advertisement)enumeration.nextElement();
            StringWriter out = new StringWriter();
            MimeMediaType displayAs = new MimeMediaType("text/xml");
            try {
                StructuredTextDocument doc = (StructuredTextDocument)adv.getDocument(displayAs);
                doc.sendToWriter(out);
                return out.toString();
            }
            catch (Exception e) {
                if (LOG.isEnabledFor(Priority.ERROR)) {
                    LOG.error((Object)"Bad Peer Adverisement, or error during toString conversion");
                }
                return null;
            }
        }
        return null;
    }

    private void saveAdv(String adv) {
        block3: {
            PeerAdvertisement padv = null;
            this.discovery = this.myGroup.getDiscoveryService();
            try {
                padv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), new ByteArrayInputStream(adv.getBytes()));
                if (!padv.getPeerID().toString().equals(this.localPeerId)) {
                    this.discovery.publish(padv, 0, 0x6DDD00L, 0x6DDD00L);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.ERROR)) break block3;
                LOG.error((Object)"Error Saving Peer Advertisement during pipe resolution");
            }
        }
    }

    public synchronized void addListener(String pipeid, Listener listener) {
        this.listeners.put(pipeid, listener);
    }

    public synchronized Listener removeListener(String pipeid) {
        return (Listener)this.listeners.remove(pipeid);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Event
    extends EventObject {
        private String peerid = null;
        private String pipeid = null;
        private int queryID = -1;
        private String type = null;

        public Event(Object source, String peerid, String pipeid, String type, int queryid) {
            super(source);
            this.peerid = peerid;
            this.pipeid = pipeid;
            this.type = type;
            this.queryID = queryid;
        }

        public String getPeerID() {
            return new String(this.peerid);
        }

        public String getPipeID() {
            return new String(this.pipeid);
        }

        public String getType() {
            return this.type;
        }

        public int getQueryID() {
            return this.queryID;
        }
    }

    public static interface Listener
    extends EventListener {
        public void pipeResolverEvent(Event var1);
    }

    public class PipeEntry {
        protected String peer = null;
        protected long lease = 0L;

        public PipeEntry(String peer) {
            this.peer = peer;
            this.lease = DefaultPipeLease;
        }

        public boolean equals(Object obj) {
            PipeEntry tmp = (PipeEntry)obj;
            return this.peer.equals(tmp.peer);
        }
    }
}

