/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.protocol.TransportAdvertisement;

public class HTTPAdv
extends TransportAdvertisement {
    private String proxy = null;
    private Vector routers = null;
    private String server = null;
    private String port = null;
    private String interfaceAddress = null;
    private String configMode = null;
    private static final String ProtocolTag = "Protocol";
    private static final String RouterTag = "Router";
    private static final String ProxyTag = "Proxy";
    private static final String ServerTag = "Server";
    private static final String PortTag = "Port";
    private static final String IntfAddrTag = "InterfaceAddress";
    private static final String ConfModeTag = "ConfigMode";
    private boolean proxyEnabled = true;
    private boolean routerEnabled = true;
    private boolean serverEnabled = true;
    private static final String RouterOffTag = "RouterOff";
    private static final String ProxyOffTag = "ProxyOff";
    private static final String ServerOffTag = "ServerOff";
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public static String getAdvertisementType() {
        return "jxta:HTTPTransportAdvertisement";
    }

    public HTTPAdv() {
    }

    public HTTPAdv(Element root) {
        this.initialize(root);
    }

    public void initialize(Element root) {
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = HTTPAdv.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement doc = (TextElement)root;
        String docName = doc.getName();
        if (!docName.equals(HTTPAdv.getAdvertisementType()) && !docName.equals(TransportAdvertisement.getAdvertisementType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            String tag = elem.getName();
            String value = null;
            if (tag.equals(RouterOffTag)) {
                this.routerEnabled = false;
                continue;
            }
            if (tag.equals(ProxyOffTag)) {
                this.proxyEnabled = false;
                continue;
            }
            if (tag.equals(ServerOffTag)) {
                this.serverEnabled = false;
                continue;
            }
            try {
                value = elem.getTextValue();
            }
            catch (Exception e) {
                continue;
            }
            if (tag.equals(ProtocolTag)) {
                this.setProtocol(value);
                continue;
            }
            if (tag.equals(IntfAddrTag)) {
                this.setInterfaceAddress(value);
                continue;
            }
            if (tag.equals(ConfModeTag)) {
                this.setConfigMode(value);
                continue;
            }
            if (tag.equals(PortTag)) {
                this.setPort(value);
                continue;
            }
            if (tag.equals(RouterTag)) {
                if (this.routers == null) {
                    this.routers = new Vector();
                }
                this.routers.addElement(value);
                continue;
            }
            if (tag.equals(ProxyTag)) {
                this.proxy = value;
                continue;
            }
            if (!tag.equals(ServerTag)) continue;
            this.server = value;
        }
        if (this.proxy == null) {
            this.proxyEnabled = false;
        }
        if (this.server == null) {
            this.serverEnabled = false;
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        TextElement ext;
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, TransportAdvertisement.getAdvertisementType());
        if (adv instanceof Attributable) {
            ((Attributable)((Object)adv)).addAttribute("type", HTTPAdv.getAdvertisementType());
        }
        TextElement e1 = adv.createElement(ProtocolTag, this.getProtocol());
        adv.appendChild((Element)e1);
        TextElement e2 = adv.createElement(IntfAddrTag, this.getInterfaceAddress());
        adv.appendChild((Element)e2);
        TextElement e3 = adv.createElement(ConfModeTag, this.getConfigMode());
        adv.appendChild((Element)e3);
        TextElement e4 = adv.createElement(PortTag, this.getPort());
        adv.appendChild((Element)e4);
        if (this.routers != null) {
            Enumeration e = this.routers.elements();
            while (e.hasMoreElements()) {
                String router = (String)e.nextElement();
                ext = adv.createElement(RouterTag, router);
                adv.appendChild((Element)ext);
            }
        }
        if (!this.routerEnabled) {
            ext = adv.createElement(RouterOffTag);
            adv.appendChild((Element)ext);
        }
        if (this.proxy != null) {
            ext = adv.createElement(ProxyTag, this.proxy);
            adv.appendChild((Element)ext);
            if (!this.proxyEnabled) {
                ext = adv.createElement(ProxyOffTag);
                adv.appendChild((Element)ext);
            }
        }
        if (this.server != null) {
            ext = adv.createElement(ServerTag, this.server);
            adv.appendChild((Element)ext);
            if (!this.serverEnabled) {
                ext = adv.createElement(ServerOffTag);
                adv.appendChild((Element)ext);
            }
        }
        return adv;
    }

    public String getInterfaceAddress() {
        return this.interfaceAddress;
    }

    public void setInterfaceAddress(String address) {
        this.interfaceAddress = address;
    }

    public String getConfigMode() {
        return this.configMode;
    }

    public void setConfigMode(String configMode) {
        this.configMode = configMode;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getProxy() {
        return this.proxy;
    }

    public Vector getRouters() {
        return this.routers;
    }

    public String getServer() {
        return this.server;
    }

    public boolean getProxyEnabled() {
        return this.proxyEnabled;
    }

    public boolean getRouterEnabled() {
        return this.routerEnabled;
    }

    public boolean getServerEnabled() {
        return this.serverEnabled;
    }

    public void setProxy(String name) {
        this.proxy = name;
        if (name == null) {
            this.proxyEnabled = false;
        }
    }

    public void setRouters(Vector list) {
        this.routers = list;
    }

    public void setServer(String name) {
        this.server = name;
        if (name == null) {
            this.serverEnabled = false;
        }
    }

    public void setProxyEnabled(boolean enabled) {
        this.proxyEnabled = enabled;
    }

    public void setRouterEnabled(boolean enabled) {
        this.routerEnabled = enabled;
    }

    public void setServerEnabled(boolean enabled) {
        this.serverEnabled = enabled;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return HTTPAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new HTTPAdv();
        }

        public Advertisement newInstance(Element root) {
            return new HTTPAdv(root);
        }
    }
}

