/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.IDFactory;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleSpecAdvertisement;
import net.jxta.protocol.PipeAdvertisement;

public class ModuleSpecAdv
extends ModuleSpecAdvertisement {
    private static final String idTag = "MSID";
    private static final String nameTag = "Name";
    private static final String creatorTag = "Crtr";
    private static final String uriTag = "SURI";
    private static final String versTag = "Vers";
    private static final String descTag = "Desc";
    private static final String paramTag = "Parm";
    private static final String proxyIdTag = "Proxy";
    private static final String authIdTag = "Auth";
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public ModuleSpecAdv() {
    }

    public ModuleSpecAdv(Element root) {
        this.initialize(root);
    }

    public void initialize(Element root) {
        if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = ModuleSpecAdv.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement doc = (TextElement)root;
        if (!doc.getName().equals(ModuleSpecAdvertisement.getAdvertisementType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.setDescription(null);
        this.setName(null);
        this.setModuleSpecID(null);
        this.setCreator(null);
        this.setSpecURI(null);
        this.setVersion(null);
        this.setDescription(null);
        this.setPipeAdvertisement(null);
        this.setProxySpecID(null);
        this.setAuthSpecID(null);
        this.setParam(null);
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            URL spID;
            TextElement elem = (TextElement)elements.nextElement();
            String nm = elem.getName();
            if (nm.equals(nameTag)) {
                this.setName(elem.getTextValue());
                continue;
            }
            if (nm.equals(descTag)) {
                this.setDescription(elem.getTextValue());
                continue;
            }
            if (nm.equals(idTag)) {
                try {
                    spID = IDFactory.jxtaURL(elem.getTextValue());
                    this.setModuleSpecID((ModuleSpecID)IDFactory.fromURL(spID));
                    continue;
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad spec ID in advertisement");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (nm.equals(creatorTag)) {
                this.setCreator(elem.getTextValue());
                continue;
            }
            if (nm.equals(uriTag)) {
                this.setSpecURI(elem.getTextValue());
                continue;
            }
            if (nm.equals(versTag)) {
                this.setVersion(elem.getTextValue());
                continue;
            }
            if (nm.equals(paramTag)) {
                StructuredTextDocument paramDoc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(doc.getRoot().getMimeType(), paramTag, elem.getTextValue());
                StructuredDocumentUtils.copyChildren(paramDoc, paramDoc, elem);
                this.setParam(paramDoc);
                continue;
            }
            if (nm.equals(proxyIdTag)) {
                try {
                    spID = IDFactory.jxtaURL(elem.getTextValue());
                    this.setProxySpecID((ModuleSpecID)IDFactory.fromURL(spID));
                    continue;
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad proxy spec ID in advertisement");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (nm.equals(authIdTag)) {
                try {
                    spID = IDFactory.jxtaURL(elem.getTextValue());
                    this.setAuthSpecID((ModuleSpecID)IDFactory.fromURL(spID));
                    continue;
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad authenticator spec ID in advertisement");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
            }
            if (!nm.equals(PipeAdvertisement.getAdvertisementType())) continue;
            try {
                PipeAdvertisement pipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(elem);
                this.setPipeAdvertisement(pipeAdv);
            }
            catch (ClassCastException wrongAdv) {
                throw new IllegalArgumentException("Bad pipe advertisement in advertisement");
            }
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        ModuleSpecID tmpId;
        PipeAdvertisement pipeAdv;
        StructuredTextDocument adv = null;
        try {
            adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, ModuleSpecAdvertisement.getAdvertisementType());
        }
        catch (Throwable everything) {
            return null;
        }
        Element e = adv.createElement(idTag, this.getModuleSpecID().toString());
        adv.appendChild(e);
        e = adv.createElement(nameTag, this.getName());
        adv.appendChild(e);
        e = adv.createElement(creatorTag, this.getCreator());
        adv.appendChild(e);
        e = adv.createElement(uriTag, this.getSpecURI());
        adv.appendChild(e);
        e = adv.createElement(versTag, this.getVersion());
        adv.appendChild(e);
        String description = this.getDescription();
        if (null != description) {
            e = adv.createElement(descTag, description);
            adv.appendChild(e);
        }
        if ((e = this.getParam()) != null) {
            StructuredDocumentUtils.copyElements(adv, adv, e);
        }
        if ((pipeAdv = this.getPipeAdvertisement()) != null) {
            StructuredTextDocument advDoc = (StructuredTextDocument)pipeAdv.getDocument(new MimeMediaType("text", "xml"));
            StructuredDocumentUtils.copyElements(adv, adv, advDoc);
        }
        if ((tmpId = this.getProxySpecID()) != null) {
            e = adv.createElement(proxyIdTag, tmpId.toString());
            adv.appendChild(e);
        }
        if ((tmpId = this.getAuthSpecID()) != null) {
            e = adv.createElement(authIdTag, tmpId.toString());
            adv.appendChild(e);
        }
        return adv;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return ModuleSpecAdvertisement.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new ModuleSpecAdv();
        }

        public Advertisement newInstance(Element root) {
            return new ModuleSpecAdv(root);
        }
    }
}

