/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.credential.Credential;
import net.jxta.document.Advertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageElementEnumeration;
import net.jxta.exception.DiscardQueryException;
import net.jxta.exception.NoResponseException;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ResendQueryException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.impl.resolver.ResolverServiceInterface;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.resolver.QueryHandler;
import net.jxta.resolver.ResolverService;
import net.jxta.service.Service;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class ResolverServiceImpl
implements ResolverService,
EndpointListener {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$resolver$ResolverServiceImpl == null ? (class$net$jxta$impl$resolver$ResolverServiceImpl = ResolverServiceImpl.class$("net.jxta.impl.resolver.ResolverServiceImpl")) : class$net$jxta$impl$resolver$ResolverServiceImpl).getName());
    public static final String outQueNameShort = "ORes";
    public static final String inQueNameShort = "IRes";
    public String outQueName = "ORes";
    public String inQueName = "IRes";
    private EndpointService endpoint;
    private Hashtable handlers = new Hashtable(50);
    private PeerGroup myGroup = null;
    private String localPeerId = null;
    private RendezVousService rendezvous = null;
    private MembershipService membership = null;
    private Credential credential = null;
    private StructuredDocument credentialDoc = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private RecvDemux recvMux = null;
    private String handlerName = null;
    private MimeMediaType textXml = new MimeMediaType("text/xml");
    static /* synthetic */ Class class$net$jxta$impl$resolver$ResolverServiceImpl;

    private EndpointAddress mkAddress(String destPeer, String serv, String parm) {
        try {
            PeerID asID = (PeerID)IDFactory.fromURL(IDFactory.jxtaURL(destPeer));
            String asString = "jxta://" + asID.getUniqueValue().toString();
            EndpointAddress addr = this.endpoint.newEndpointAddress(asString);
            addr.setServiceName(serv);
            addr.setServiceParameter(parm);
            return addr;
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)("Invalid peerID string " + destPeer));
            }
            throw new RuntimeException("Error creating Peer Address :" + e.toString());
        }
    }

    public int startApp(String[] arg) {
        block6: {
            this.rendezvous = this.myGroup.getRendezVousService();
            this.membership = this.myGroup.getMembershipService();
            try {
                this.rendezvous.addPropagateListener(this.handlerName + this.outQueName, this);
                this.rendezvous.addPropagateListener(this.handlerName + this.inQueName, this.recvMux);
            }
            catch (Exception e) {
                if (LOG.isEnabledFor(Priority.ERROR)) {
                    LOG.error((Object)"failed to add listeners", (Throwable)e);
                }
                return 1;
            }
            try {
                Enumeration enumeration = this.membership.getCurrentCredentials();
                if (enumeration.hasMoreElements()) {
                    this.credential = (Credential)enumeration.nextElement();
                    this.credentialDoc = this.credential.getDocument(this.textXml);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.ERROR)) break block6;
                LOG.error((Object)"failed to get credential", (Throwable)e);
            }
        }
        return 0;
    }

    public void stopApp() {
        block2: {
            try {
                this.rendezvous.removePropagateListener(this.handlerName + this.outQueName, this);
                this.rendezvous.removePropagateListener(this.handlerName + this.inQueName, this.recvMux);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.ERROR)) break block2;
                LOG.error((Object)"failed to detach from the Rendezvous Service", (Throwable)e);
            }
        }
    }

    public Service getInterface() {
        return new ResolverServiceInterface(this);
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public synchronized QueryHandler registerHandler(String name, QueryHandler handler) {
        return this.handlers.put(name, handler);
    }

    public synchronized QueryHandler unregisterHandler(String name) {
        return (QueryHandler)this.handlers.remove(name);
    }

    public QueryHandler getHandler(String name) {
        return (QueryHandler)this.handlers.get(name);
    }

    public void sendQuery(String rdvPeer, ResolverQueryMsg query) {
        if (this.rendezvous == null) {
            return;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"sending query");
        }
        Object doc = null;
        Message propagateMsg = this.endpoint.newMessage();
        if (rdvPeer == null) {
            try {
                propagateMsg.addElement(propagateMsg.newMessageElement(this.outQueName, this.textXml, query.getDocument(this.textXml).getStream()));
                this.rendezvous.propagateInGroup(propagateMsg, this.handlerName, this.outQueName, 7, null);
            }
            catch (Exception e) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"Error during propagate", (Throwable)e);
                }
                throw new RuntimeException("Error during propagate :" + e.toString());
            }
        }
        try {
            this.respond(rdvPeer, this.handlerName, this.outQueName, this.outQueName, query.getDocument(this.textXml).getStream());
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"Error while unicasting query :", (Throwable)e);
            }
            throw new RuntimeException("Error while unicasting query :" + e.toString());
        }
    }

    public PeerGroup getGroup() {
        return this.myGroup;
    }

    private void propagateQuery(Message msg) {
        block4: {
            if (this.rendezvous == null) {
                return;
            }
            if (!this.myGroup.isRendezvous()) {
                return;
            }
            try {
                this.rendezvous.propagateInGroup(msg, this.handlerName, this.outQueName, 7, this.localPeerId);
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block4;
                LOG.debug((Object)"Error propagating query", (Throwable)e);
            }
        }
    }

    private void resendQuery(Message msg, String srcPeer) {
        block11: {
            if (this.rendezvous == null) {
                return;
            }
            if (!this.myGroup.isRendezvous()) {
                return;
            }
            MessageElementEnumeration elements = msg.getElements();
            String tagString = null;
            Vector<ResolverQuery> tmp = new Vector<ResolverQuery>();
            ResolverQuery query = null;
            while (elements.hasMoreMessageElements()) {
                MessageElement el = elements.nextMessageElement();
                tagString = el.getName();
                if (!tagString.endsWith(outQueNameShort)) continue;
                try {
                    query = new ResolverQuery(el.getStream());
                    msg.removeElement(el);
                    query.setSrc(srcPeer);
                    tmp.addElement(query);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (tmp.size() == 0) {
                return;
            }
            Message newMsg = this.endpoint.newMessage();
            int i = 0;
            while (i < tmp.size()) {
                try {
                    query = (ResolverQuery)tmp.elementAt(i);
                    newMsg.addElement(newMsg.newMessageElement(this.outQueName, this.textXml, query.getDocument(this.textXml).getStream()));
                }
                catch (Exception e) {
                    return;
                }
                ++i;
            }
            try {
                this.rendezvous.propagateInGroup(newMsg, this.handlerName, this.outQueName, 7, this.localPeerId);
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block11;
                LOG.debug((Object)"Error propagating resending query", (Throwable)e);
            }
        }
    }

    public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"demuxing a query");
        }
        Message srcMsg = (Message)message.clone();
        MessageElementEnumeration elements = message.getElements();
        while (elements.hasMoreElements()) {
            MessageElement element = elements.nextMessageElement();
            String tagString = element.getName();
            if (!tagString.endsWith(outQueNameShort)) continue;
            try {
                message.removeElement(element);
                ResolverQuery doc = new ResolverQuery(element.getStream());
                ResolverResponseMsg res = this.processQuery(doc);
                if (res != null) {
                    this.respond(doc.getSrc(), this.handlerName, this.inQueName, this.inQueName, res.getDocument(this.textXml).getStream());
                }
                this.propagateQuery(srcMsg);
            }
            catch (ResendQueryException e2) {
                this.propagateQuery((Message)srcMsg.clone());
                this.resendQuery(srcMsg, this.localPeerId);
            }
            catch (NoResponseException e1) {
                this.propagateQuery(srcMsg);
            }
            catch (DiscardQueryException e3) {
                return;
            }
            catch (IOException e4) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"query was malformed", (Throwable)e4);
                }
                return;
            }
        }
    }

    public ResolverResponseMsg processQuery(ResolverQueryMsg query) throws NoResponseException, ResendQueryException, DiscardQueryException, IOException {
        QueryHandler theHandler;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("handing a query to  " + ((ResolverQuery)query).getHandlerName()));
        }
        if ((theHandler = this.getHandler(((ResolverQuery)query).getHandlerName())) == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("throwing away " + ((ResolverQuery)query).getHandlerName()));
            }
            return null;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("handing a query to  " + ((ResolverQuery)query).getHandlerName()));
        }
        ResolverResponseMsg result = theHandler.processQuery(query);
        return result;
    }

    public void processResponse(ResolverResponseMsg resp) {
        String handlerName = resp.getHandlerName();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("pushing a response to  " + handlerName));
        }
        QueryHandler theHandler = this.getHandler(handlerName);
        theHandler.processResponse(resp);
    }

    public void sendResponse(String destPeer, ResolverResponseMsg response) {
        block4: {
            if (destPeer == null) {
                this.propagateResponse(response);
            } else {
                try {
                    this.respond(destPeer, this.handlerName, this.inQueName, this.inQueName, response.getDocument(this.textXml).getStream());
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block4;
                    LOG.debug((Object)"error in sending response", (Throwable)e);
                }
            }
        }
    }

    private void propagateResponse(ResolverResponseMsg response) {
        block3: {
            if (this.rendezvous == null) {
                return;
            }
            Message propagateMsg = this.endpoint.newMessage();
            try {
                propagateMsg.addElement(propagateMsg.newMessageElement(this.inQueName, this.textXml, response.getDocument(this.textXml).getStream()));
                this.rendezvous.propagateInGroup(propagateMsg, this.handlerName, this.inQueName, 1, null);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block3;
                LOG.debug((Object)"failure on propagateResponse", (Throwable)e);
            }
        }
    }

    private void respond(String destPeer, String pName, String pParam, String tagName, InputStream response) throws RuntimeException {
        Message msg;
        block13: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("destPeer :\n" + destPeer));
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("responding to " + pName + "  " + pParam + " " + tagName));
            }
            if (response == null) {
                throw new RuntimeException("Attempting to respond with a empty message");
            }
            msg = this.endpoint.newMessage();
            try {
                msg.addElement(msg.newMessageElement(tagName, null, response));
            }
            catch (Exception ez1) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block13;
                LOG.debug((Object)"Exception ", (Throwable)ez1);
            }
        }
        EndpointMessenger messenger = null;
        try {
            messenger = this.endpoint.getMessenger(this.mkAddress(destPeer, pName, pParam));
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"endpoint.getMessenger failed to get messenger", (Throwable)e);
            }
            return;
        }
        if (messenger == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"endpoint.getMessenger failed to get messenger");
            }
            return;
        }
        try {
            messenger.sendMessage(msg);
        }
        catch (IOException e) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"messenger.sendMessage failed to send", (Throwable)e);
            }
            throw new RuntimeException("messenger.sendMessage failed to send");
        }
    }

    public void init(PeerGroup g, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.myGroup = g;
        this.endpoint = g.getEndpointService();
        this.localPeerId = g.getPeerID().toString();
        this.handlerName = assignedID.toString();
        String uniqueStr = g.getPeerGroupID().getUniqueValue().toString();
        this.outQueName = uniqueStr + outQueNameShort;
        this.inQueName = uniqueStr + inQueNameShort;
        this.localPeerId = g.getPeerID().toString();
        this.recvMux = new RecvDemux();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class RecvDemux
    implements EndpointListener {
        RecvDemux() {
        }

        public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
            if (message == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"RecvDemux.demux: got a null message");
                }
                return;
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"demuxing a response ");
            }
            MessageElementEnumeration elements = message.getElements();
            while (elements.hasMoreElements()) {
                MessageElement el = elements.nextMessageElement();
                String tagString = el.getName();
                if (!tagString.endsWith(ResolverServiceImpl.inQueNameShort)) continue;
                try {
                    message.removeElement(el);
                    ResolverResponse resp = new ResolverResponse(el.getStream());
                    ResolverServiceImpl.this.processResponse(resp);
                }
                catch (IOException e) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                    LOG.debug((Object)"Ill formatted resolver response, ignoring.", (Throwable)e);
                }
            }
        }
    }
}

