/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointFilterListener;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageElementEnumeration;

public class EndpointServiceStatsFilter
implements EndpointFilterListener {
    long lastMessageTime;
    Hashtable channelTrafficTable = new Hashtable();
    Hashtable sourceCountTable = new Hashtable();
    Hashtable destCountTable = new Hashtable();

    public Message processIncomingMessage(Message msg, EndpointAddress source, EndpointAddress dest) {
        MessageElementEnumeration e = msg.getElements();
        while (e.hasMoreMessageElements()) {
            String namespace;
            MessageElement el = e.nextMessageElement();
            String name = el.getName();
            int colon = name.indexOf(58);
            if (colon == -1) {
                namespace = "";
            } else {
                namespace = name.substring(0, colon);
                name = name.substring(colon + 1);
            }
            this.incrementCount(this.channelTrafficTable, source.getProtocolName() + "://" + source.getProtocolAddress() + "/" + namespace, el.getLength());
            this.incrementCount(this.channelTrafficTable, source.getProtocolName() + "://" + source.getProtocolAddress() + "/" + el.getName(), el.getLength());
        }
        if (source != null) {
            this.incrementCount(this.sourceCountTable, source, 1);
        }
        if (dest != null) {
            this.incrementCount(this.destCountTable, dest, 1);
        }
        this.lastMessageTime = System.currentTimeMillis();
        return msg;
    }

    public long getLastMessageTime() {
        return this.lastMessageTime;
    }

    public long getTrafficOnChannel(String channel) {
        return this.getCount(this.channelTrafficTable, channel);
    }

    public Enumeration getChannelNames() {
        return this.channelTrafficTable.keys();
    }

    public long getMessageCountFrom(EndpointAddress addr) {
        return this.getCount(this.sourceCountTable, addr);
    }

    public long getMessageCountTo(EndpointAddress addr) {
        return this.getCount(this.destCountTable, addr);
    }

    private long getCount(Hashtable table, Object key) {
        Counter counter = (Counter)table.get(key);
        return counter == null ? -1L : counter.value;
    }

    private void incrementCount(Hashtable table, Object key, int incr) {
        Counter counter = (Counter)table.get(key);
        if (counter == null) {
            counter = new Counter();
            table.put(key, counter);
        }
        counter.value += (long)incr;
    }

    private static final class Counter {
        long value;

        private Counter() {
        }
    }
}

