/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.AdvertisementFactory;
import net.jxta.id.IDFactory;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.platform.ModuleClassID;
import net.jxta.protocol.ModuleClassAdvertisement;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.ModuleSpecAdvertisement;

public class ModuleManager {
    private static Hashtable managers = null;
    private static long LOCAL_ADV_TTL = 300000L;
    private static long REMOTE_ADV_TTL = 0L;
    private Hashtable modules = new Hashtable();
    private PeerGroup group = null;

    private ModuleManager(PeerGroup group) {
        this.group = group;
    }

    public void startModule(String moduleName, String[] args) {
        ModuleDesc moduleDesc = (ModuleDesc)this.modules.get(moduleName);
        if (moduleDesc == null) {
            return;
        }
        moduleDesc.startApp(args);
    }

    public void stopModule(String moduleName) {
        ModuleDesc moduleDesc = (ModuleDesc)this.modules.get(moduleName);
        if (moduleDesc == null) {
            return;
        }
        moduleDesc.stopApp();
    }

    public static ModuleManager getModuleManager(PeerGroup group) {
        if (managers == null) {
            managers = new Hashtable();
        }
        ModuleManager manager = null;
        manager = (ModuleManager)managers.get(group.getPeerGroupID());
        if (manager == null) {
            manager = new ModuleManager(group);
            managers.put(group.getPeerGroupID(), manager);
        }
        return manager;
    }

    private synchronized boolean registerModule(String moduleName, Module module) {
        ModuleDesc moduleDesc = (ModuleDesc)this.modules.get(module);
        if (moduleDesc != null) {
            return false;
        }
        moduleDesc = new ModuleDesc(module);
        this.modules.put(moduleName, moduleDesc);
        return true;
    }

    private synchronized Module unregisterModule(String moduleName) {
        ModuleDesc moduleDesc = (ModuleDesc)this.modules.get(moduleName);
        if (moduleDesc == null) {
            return null;
        }
        this.modules.remove(moduleName);
        return moduleDesc.module;
    }

    public synchronized Module lookupModule(String moduleName) {
        ModuleDesc moduleDesc = (ModuleDesc)this.modules.get(moduleName);
        if (moduleDesc == null) {
            return null;
        }
        return moduleDesc.module;
    }

    public synchronized Module loadModule(String moduleName, ModuleManagerLoader loader) {
        Module module = this.lookupModule(moduleName);
        if (module != null) {
            return module;
        }
        module = loader.loadModule(moduleName);
        if (module != null) {
            try {
                module.init(this.group, null, null);
            }
            catch (Exception e) {
                return null;
            }
            this.registerModule(moduleName, module);
        }
        return module;
    }

    public synchronized Module loadModule(String moduleName, String moduleCode) {
        Module module = this.lookupModule(moduleName);
        if (module != null) {
            return module;
        }
        if (!this.createModuleAdvs(moduleName, null, moduleCode, null, LOCAL_ADV_TTL, REMOTE_ADV_TTL)) {
            return null;
        }
        module = this.loadModule(moduleName);
        if (module == null) {
            return null;
        }
        return module;
    }

    private synchronized Module loadModule(String moduleName) {
        Module module = this.lookupModule(moduleName);
        if (module != null) {
            return module;
        }
        try {
            Enumeration enumeration = this.group.getDiscoveryService().getLocalAdvertisements(2, "Name", moduleName);
            if (enumeration == null || !enumeration.hasMoreElements()) {
                return null;
            }
            ModuleClassAdvertisement mcAdv = null;
            while (enumeration.hasMoreElements()) {
                try {
                    mcAdv = (ModuleClassAdvertisement)enumeration.nextElement();
                    break;
                }
                catch (Exception ez1) {
                    // empty catch block
                }
            }
            enumeration = this.group.getDiscoveryService().getLocalAdvertisements(2, "Name", moduleName);
            if (enumeration == null || !enumeration.hasMoreElements()) {
                return null;
            }
            ModuleSpecAdvertisement mSpecAdv = null;
            while (enumeration.hasMoreElements()) {
                try {
                    mSpecAdv = (ModuleSpecAdvertisement)enumeration.nextElement();
                    break;
                }
                catch (Exception ez1) {
                    // empty catch block
                }
            }
            module = this.group.loadModule(mcAdv.getModuleClassID(), mSpecAdv.getModuleSpecID(), 0);
            if (module != null) {
                this.registerModule(moduleName, module);
            }
            return module;
        }
        catch (Exception ez2) {
            return null;
        }
    }

    private boolean createModuleAdvs(String moduleName, String moduleSpecURI, String moduleCode, String moduleCodeURI, long localTTL, long remoteTTL) {
        DiscoveryService disco = this.group.getDiscoveryService();
        try {
            ModuleClassAdvertisement mcadv = (ModuleClassAdvertisement)AdvertisementFactory.newAdvertisement(ModuleClassAdvertisement.getAdvertisementType());
            mcadv.setName(moduleName);
            mcadv.setDescription("Created by ModuleManager: " + moduleName);
            ModuleClassID mcID = IDFactory.newModuleClassID();
            mcadv.setModuleClassID(mcID);
            disco.publish(mcadv, 2, localTTL, remoteTTL);
            ModuleSpecAdvertisement mdadv = (ModuleSpecAdvertisement)AdvertisementFactory.newAdvertisement(ModuleSpecAdvertisement.getAdvertisementType());
            mdadv.setName(moduleName);
            mdadv.setCreator("jxta.org");
            mdadv.setModuleSpecID(IDFactory.newModuleSpecID(mcID));
            if (moduleSpecURI != null) {
                mdadv.setSpecURI(moduleSpecURI);
            }
            disco.publish(mdadv, 2, localTTL, remoteTTL);
            ModuleImplAdvertisement miadv = (ModuleImplAdvertisement)AdvertisementFactory.newAdvertisement(ModuleImplAdvertisement.getAdvertisementType());
            miadv.setModuleSpecID(mdadv.getModuleSpecID());
            if (moduleCode != null) {
                miadv.setCode(moduleCode);
            }
            if (moduleCodeURI != null) {
                miadv.setUri(moduleCodeURI);
            }
            miadv.setDescription("Created by ModuleManager: " + moduleName);
            ModuleImplAdvertisement pgImpl = (ModuleImplAdvertisement)this.group.getImplAdvertisement();
            miadv.setCompat(pgImpl.getCompat());
            disco.publish(miadv, 2, localTTL, remoteTTL);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private class ModuleDesc {
        protected Module module = null;
        private boolean started = false;
        private boolean stopped = true;

        public ModuleDesc(Module module) {
            this.module = module;
        }

        public void startApp(String[] args) {
            if (this.module == null) {
                return;
            }
            if (this.started) {
                return;
            }
            this.module.startApp(args);
            this.started = true;
            this.stopped = false;
        }

        public void stopApp() {
            if (this.module == null) {
                return;
            }
            if (this.stopped) {
                return;
            }
            this.module.stopApp();
            this.stopped = true;
            this.started = false;
        }
    }

    public static interface ModuleManagerLoader {
        public Module loadModule(String var1);
    }
}

