/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.peergroup;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.UnknownServiceException;
import java.util.HashMap;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.Element;
import net.jxta.endpoint.EndpointService;
import net.jxta.exception.JxtaError;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ProtocolNotSupportedException;
import net.jxta.exception.ServiceNotFoundException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peer.PeerInfoService;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeService;
import net.jxta.platform.JxtaLoader;
import net.jxta.platform.Module;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.resolver.ResolverService;
import net.jxta.service.Service;

public interface PeerGroup
extends Service {
    public static final int Here = 0;
    public static final int FromParent = 1;
    public static final int Both = 2;
    public static final long DEFAULT_LIFETIME = 1471228928L;
    public static final long DEFAULT_EXPIRATION = 1209600000L;
    public static final ModuleClassID peerGroupClassID = (ModuleClassID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000105");
    public static final ModuleClassID resolverClassID = (ModuleClassID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000205");
    public static final ModuleClassID discoveryClassID = (ModuleClassID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000305");
    public static final ModuleClassID pipeClassID = (ModuleClassID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000405");
    public static final ModuleClassID membershipClassID = (ModuleClassID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000505");
    public static final ModuleClassID rendezvousClassID = (ModuleClassID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000605");
    public static final ModuleClassID peerinfoClassID = (ModuleClassID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000705");
    public static final ModuleClassID endpointClassID = (ModuleClassID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000805");
    public static final ModuleClassID tcpProtoClassID = (ModuleClassID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000905");
    public static final ModuleClassID httpProtoClassID = (ModuleClassID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000A05");
    public static final ModuleClassID routerProtoClassID = (ModuleClassID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000B05");
    public static final ModuleClassID applicationClassID = (ModuleClassID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000C05");
    public static final ModuleClassID tlsProtoClassID = (ModuleClassID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000D05");
    public static final ModuleClassID proxyClassID = (ModuleClassID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000E05");
    public static final ModuleSpecID refPlatformSpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe000000010106");
    public static final ModuleSpecID refNetPeerGroupSpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe000000010206");
    public static final ModuleSpecID refResolverSpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe000000020106");
    public static final ModuleSpecID refDiscoverySpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe000000030106");
    public static final ModuleSpecID refPipeSpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe000000040106");
    public static final ModuleSpecID refMembershipSpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe000000050106");
    public static final ModuleSpecID refRendezvousSpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe000000060106");
    public static final ModuleSpecID refPeerinfoSpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe000000070106");
    public static final ModuleSpecID refEndpointSpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe000000080106");
    public static final ModuleSpecID refTcpProtoSpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe000000090106");
    public static final ModuleSpecID refHttpProtoSpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000A0106");
    public static final ModuleSpecID refRouterProtoSpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000B0106");
    public static final ModuleSpecID refTlsProtoSpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000D0106");
    public static final ModuleSpecID allPurposePeerGroupSpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe000000010306");
    public static final ModuleSpecID refStartNetPeerGroupSpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000C0106");
    public static final ModuleSpecID refShellSpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000C0206");
    public static final ModuleSpecID refProxySpecID = (ModuleSpecID)IdMaker.mkID("DeadBeefDeafBabaFeedBabe0000000E0106");
    public static final GlobalRegistry globalRegistry = new GlobalRegistry();

    public JxtaLoader getLoader();

    public boolean isRendezvous();

    public PeerGroupAdvertisement getPeerGroupAdvertisement();

    public PeerAdvertisement getPeerAdvertisement();

    public Service lookupService(ID var1) throws ServiceNotFoundException;

    public boolean compatible(Element var1);

    public Module loadModule(ID var1, Advertisement var2) throws ProtocolNotSupportedException, PeerGroupException;

    public Module loadModule(ID var1, ModuleSpecID var2, int var3);

    public void publishGroup(String var1, String var2) throws IOException;

    public PeerGroup newGroup(Advertisement var1) throws PeerGroupException;

    public PeerGroup newGroup(PeerGroupID var1, Advertisement var2, String var3, String var4) throws PeerGroupException;

    public PeerGroup newGroup(PeerGroupID var1) throws PeerGroupException;

    public RendezVousService getRendezVousService();

    public EndpointService getEndpointService();

    public ResolverService getResolverService();

    public DiscoveryService getDiscoveryService();

    public PeerInfoService getPeerInfoService();

    public MembershipService getMembershipService();

    public PipeService getPipeService();

    public PeerGroupID getPeerGroupID();

    public PeerID getPeerID();

    public String getPeerGroupName();

    public String getPeerName();

    public Advertisement getConfigAdvertisement();

    public ModuleImplAdvertisement getAllPurposePeerGroupImplAdvertisement() throws Exception;

    public void unref();

    public static class IdMaker {
        static ID mkID(String s) {
            try {
                return IDFactory.fromURL(IDFactory.jxtaURL("urn", "", "jxta:uuid-" + s));
            }
            catch (MalformedURLException absurd) {
                throw new JxtaError("Hardcoded Spec and Class IDs are malformed." + s);
            }
            catch (UnknownServiceException absurd3) {
                throw new JxtaError("Unknown Service");
            }
        }
    }

    public static class GlobalRegistry {
        private HashMap registry = new HashMap(8);

        public synchronized boolean registerInstance(PeerGroupID gid, PeerGroup pg) {
            WeakReference ref = (WeakReference)this.registry.get(gid);
            if (ref != null && ref.get() != null) {
                return false;
            }
            this.registry.put(gid, new WeakReference<PeerGroup>(pg));
            return true;
        }

        public synchronized boolean unRegisterInstance(PeerGroupID gid, PeerGroup pg) {
            WeakReference ref = (WeakReference)this.registry.get(gid);
            if (ref == null) {
                return false;
            }
            PeerGroup found = (PeerGroup)ref.get();
            if (found == null) {
                this.registry.remove(gid);
                return false;
            }
            if (pg != found) {
                return false;
            }
            this.registry.remove(gid);
            return true;
        }

        public synchronized PeerGroup lookupInstance(PeerGroupID gid) {
            WeakReference ref = (WeakReference)this.registry.get(gid);
            if (ref == null) {
                return null;
            }
            PeerGroup pg = (PeerGroup)ref.get();
            if (pg == null) {
                this.registry.remove(gid);
                return null;
            }
            return (PeerGroup)pg.getInterface();
        }
    }
}

