/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.peergroup;

import net.jxta.exception.JxtaError;
import net.jxta.exception.PeerGroupException;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.ModuleImplAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class PeerGroupFactory {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$peergroup$PeerGroupFactory == null ? (class$net$jxta$peergroup$PeerGroupFactory = PeerGroupFactory.class$("net.jxta.peergroup.PeerGroupFactory")) : class$net$jxta$peergroup$PeerGroupFactory).getName());
    private static Class stdPeerGroupClass;
    private static Class platformClass;
    static /* synthetic */ Class class$net$jxta$peergroup$PeerGroupFactory;
    static /* synthetic */ Class class$net$jxta$impl$peergroup$Platform;
    static /* synthetic */ Class class$net$jxta$impl$peergroup$StdPeerGroup;

    public static void setStdPeerGroupClass(Class c) {
        stdPeerGroupClass = c;
    }

    public static void setPlatformClass(Class c) {
        platformClass = c;
    }

    public static PeerGroup newPeerGroup() {
        try {
            return (PeerGroup)stdPeerGroupClass.newInstance();
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"newInstace failed : ", (Throwable)e);
            }
            throw new JxtaError("No valid Standard PeerGroup class" + e.getMessage());
        }
    }

    public static PeerGroup newPlatform() {
        PeerGroup plat = null;
        try {
            plat = (PeerGroup)platformClass.newInstance();
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.ERROR)) {
                LOG.error((Object)"newInstace failed : ", (Throwable)e);
            }
            throw new JxtaError("No valid Platform class : " + e.getMessage());
        }
        try {
            plat.init(null, null, null);
            return (PeerGroup)plat.getInterface();
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.ERROR)) {
                LOG.error((Object)"Platform.init failed : ", (Throwable)e);
            }
            throw new JxtaError("Platform.init failed : " + e.getMessage());
        }
    }

    public static PeerGroup newNetPeerGroup(PeerGroup pg) throws PeerGroupException {
        try {
            ModuleImplAdvertisement netPgImplAdv = pg.getAllPurposePeerGroupImplAdvertisement();
            netPgImplAdv.setModuleSpecID(PeerGroup.refNetPeerGroupSpecID);
            netPgImplAdv.setCode("net.jxta.impl.peergroup.ShadowPeerGroup");
            netPgImplAdv.setDescription("Default NetPeerGroup reference implementation.");
            PeerGroupID pgId = PeerGroupID.defaultNetPeerGroupID;
            PeerGroup newPg = pg.newGroup(pgId, netPgImplAdv, "NetPeerGroup", "NetPeerGroup by default");
            return newPg;
        }
        catch (Exception e) {
            if (LOG.isEnabledFor(Priority.ERROR)) {
                LOG.error((Object)"newNetPeerGroup failed : ", (Throwable)e);
            }
            throw new PeerGroupException("newNetPeerGroup failed : " + e.getMessage());
        }
    }

    public static PeerGroup newNetPeerGroup() throws PeerGroupException {
        try {
            PeerGroupFactory.setPlatformClass(class$net$jxta$impl$peergroup$Platform == null ? (class$net$jxta$impl$peergroup$Platform = PeerGroupFactory.class$("net.jxta.impl.peergroup.Platform")) : class$net$jxta$impl$peergroup$Platform);
            PeerGroupFactory.setStdPeerGroupClass(class$net$jxta$impl$peergroup$StdPeerGroup == null ? (class$net$jxta$impl$peergroup$StdPeerGroup = PeerGroupFactory.class$("net.jxta.impl.peergroup.StdPeerGroup")) : class$net$jxta$impl$peergroup$StdPeerGroup);
        }
        catch (Throwable t) {
            if (LOG.isEnabledFor(Priority.ERROR)) {
                LOG.error((Object)"newNetPeerGroup failed : ", t);
            }
            throw new PeerGroupException("Unable to find class :" + t.getMessage());
        }
        PeerGroup platformGroup = PeerGroupFactory.newPlatform();
        PeerGroup npg = PeerGroupFactory.newNetPeerGroup(platformGroup);
        return npg;
    }

    private PeerGroupFactory() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

