/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.hook.data;

import com.jniwrapper.Parameter;
import com.jniwrapper.Structure;
import com.jniwrapper.win32.hook.CallWndProcEvent;
import com.jniwrapper.win32.hook.CallWndProcRetEvent;
import com.jniwrapper.win32.hook.ForegroungIdleEvent;
import com.jniwrapper.win32.hook.GetMsgEvent;
import com.jniwrapper.win32.hook.Hook;
import com.jniwrapper.win32.hook.HookEventObject;
import com.jniwrapper.win32.hook.JournalRecordEvent;
import com.jniwrapper.win32.hook.KeyboardEvent;
import com.jniwrapper.win32.hook.MouseEvent;
import com.jniwrapper.win32.hook.ShellEvent;
import com.jniwrapper.win32.hook.SysMsgProcEvent;
import com.jniwrapper.win32.hook.data.CWndProcRetStructure;
import com.jniwrapper.win32.hook.data.CWndProcStructure;
import com.jniwrapper.win32.hook.data.EventMessageStructure;
import com.jniwrapper.win32.hook.data.ForegroungIdleHookData;
import com.jniwrapper.win32.hook.data.GetMsgHookData;
import com.jniwrapper.win32.hook.data.JournalRecordHookData;
import com.jniwrapper.win32.hook.data.KeyboardHookData;
import com.jniwrapper.win32.hook.data.MouseHookData;
import com.jniwrapper.win32.hook.data.MouseHookStructure;
import com.jniwrapper.win32.hook.data.ShellHookData;
import com.jniwrapper.win32.hook.data.SysMsgProcHookData;
import com.jniwrapper.win32.hook.data.WndProcHookData;
import com.jniwrapper.win32.hook.data.WndProcRetHookData;
import java.util.HashMap;
import java.util.Map;

public class HooksData
extends Structure {
    private MouseHookData _mouseHookData = new MouseHookData();
    private KeyboardHookData _keyboardHookData = new KeyboardHookData();
    private WndProcHookData _wndProcHookData = new WndProcHookData();
    private WndProcRetHookData _wndProcRetHookData = new WndProcRetHookData();
    private GetMsgHookData _getMsgHookData = new GetMsgHookData();
    private SysMsgProcHookData _sysMsgProcHookData = new SysMsgProcHookData();
    private ShellHookData _shellHookData = new ShellHookData();
    private ForegroungIdleHookData _foregroungIdleHookData = new ForegroungIdleHookData();
    private JournalRecordHookData _journalRecordHookData = new JournalRecordHookData();
    private static final Map DESCRIPTOR2READER = new HashMap();

    public HooksData() {
        this.init(new Parameter[]{this._mouseHookData, this._keyboardHookData, this._wndProcHookData, this._wndProcRetHookData, this._getMsgHookData, this._sysMsgProcHookData, this._shellHookData, this._foregroungIdleHookData, this._journalRecordHookData});
    }

    public HookEventObject readEvent(Hook.Descriptor descriptor) {
        HookEventReader reader = (HookEventReader)DESCRIPTOR2READER.get((Object)descriptor);
        return reader.readEvent(this);
    }

    static {
        DESCRIPTOR2READER.put(Hook.Descriptor.MOUSE, new MouseHookEventReader());
        DESCRIPTOR2READER.put(Hook.Descriptor.KEYBOARD, new KeyboardHookEventReader());
        DESCRIPTOR2READER.put(Hook.Descriptor.CALLWNDPROC, new CallWndProcEventReader());
        DESCRIPTOR2READER.put(Hook.Descriptor.CALLWNDPROCRET, new CallWndProcRetEventReader());
        DESCRIPTOR2READER.put(Hook.Descriptor.GETMESSAGE, new GetMsgHookEventReader());
        DESCRIPTOR2READER.put(Hook.Descriptor.SYSMSGFILTER, new SysMsgProcHookEventReader());
        DESCRIPTOR2READER.put(Hook.Descriptor.SHELL, new ShellHookEventReader());
        DESCRIPTOR2READER.put(Hook.Descriptor.FOREGROUNDIDLE, new ForegroungIdleHookEventReader());
        DESCRIPTOR2READER.put(Hook.Descriptor.JOURNALRECORD, new JournalRecordHookEventReader());
    }

    private static class JournalRecordHookEventReader
    implements HookEventReader {
        private JournalRecordHookEventReader() {
        }

        public HookEventObject readEvent(HooksData hookData) {
            JournalRecordHookData jornalRecordHookData = hookData._journalRecordHookData;
            JournalRecordEvent result = null;
            long code = jornalRecordHookData.getCode();
            if (code == 0L) {
                EventMessageStructure eventMessage = jornalRecordHookData.getEventMessage();
                result = new JournalRecordEvent(jornalRecordHookData.getEventDescriptor(), code, eventMessage.getMessage(), eventMessage.getParamL(), eventMessage.getParamH(), eventMessage.getTime(), eventMessage.getHwnd());
            } else {
                result = new JournalRecordEvent(jornalRecordHookData.getEventDescriptor(), code);
            }
            return result;
        }
    }

    private static class ForegroungIdleHookEventReader
    implements HookEventReader {
        private ForegroungIdleHookEventReader() {
        }

        public HookEventObject readEvent(HooksData hookData) {
            ForegroungIdleHookData foregroungIdleHookData = hookData._foregroungIdleHookData;
            ForegroungIdleEvent result = new ForegroungIdleEvent(foregroungIdleHookData.getEventDescriptor());
            return result;
        }
    }

    private static class ShellHookEventReader
    implements HookEventReader {
        private ShellHookEventReader() {
        }

        public HookEventObject readEvent(HooksData hookData) {
            ShellHookData shellHookData = hookData._shellHookData;
            ShellEvent result = new ShellEvent(shellHookData.getEventDescriptor(), shellHookData.getCode(), shellHookData.getWParam(), shellHookData.getLParam());
            return result;
        }
    }

    private static class SysMsgProcHookEventReader
    implements HookEventReader {
        private SysMsgProcHookEventReader() {
        }

        public HookEventObject readEvent(HooksData hookData) {
            SysMsgProcHookData sysMsgProcHookData = hookData._sysMsgProcHookData;
            SysMsgProcEvent result = new SysMsgProcEvent(sysMsgProcHookData.getEventDescriptor(), sysMsgProcHookData.getCode(), sysMsgProcHookData.getMsg());
            return result;
        }
    }

    private static class GetMsgHookEventReader
    implements HookEventReader {
        private static final int PM_REMOVE = 1;

        private GetMsgHookEventReader() {
        }

        public HookEventObject readEvent(HooksData hookData) {
            GetMsgHookData getMsgHookData = hookData._getMsgHookData;
            GetMsgEvent result = new GetMsgEvent(getMsgHookData.getEventDescriptor(), getMsgHookData.getWParam() == 1L, getMsgHookData.getMsg());
            return result;
        }

        static {
            PM_REMOVE = 1;
        }
    }

    private static class CallWndProcRetEventReader
    implements HookEventReader {
        private CallWndProcRetEventReader() {
        }

        public HookEventObject readEvent(HooksData hookData) {
            WndProcRetHookData wndProcRetHookData = hookData._wndProcRetHookData;
            CWndProcRetStructure cwpRetStruct = wndProcRetHookData.getCwpRetStruct();
            CallWndProcRetEvent result = new CallWndProcRetEvent(wndProcRetHookData.getEventDescriptor(), cwpRetStruct.getResult(), cwpRetStruct.getLParam(), cwpRetStruct.getWParam(), cwpRetStruct.getMessage(), cwpRetStruct.getWnd(), cwpRetStruct.wParam.getValue() != 0L);
            return result;
        }
    }

    private static class CallWndProcEventReader
    implements HookEventReader {
        private CallWndProcEventReader() {
        }

        public HookEventObject readEvent(HooksData hookData) {
            WndProcHookData wndProcHookData = hookData._wndProcHookData;
            CWndProcStructure cwpStruct = wndProcHookData.getCwpStruct();
            CallWndProcEvent result = new CallWndProcEvent(wndProcHookData.getEventDescriptor(), cwpStruct.getLParam(), cwpStruct.getWParam(), cwpStruct.getMessage(), cwpStruct.getWnd(), cwpStruct.wParam.getValue() != 0L);
            return result;
        }
    }

    private static class KeyboardHookEventReader
    implements HookEventReader {
        private KeyboardHookEventReader() {
        }

        public HookEventObject readEvent(HooksData hookData) {
            KeyboardHookData keyboardHookData = hookData._keyboardHookData;
            KeyboardEvent result = new KeyboardEvent(keyboardHookData.getEventDescriptor(), keyboardHookData.getWParam(), keyboardHookData.getLParam());
            return result;
        }
    }

    private static class MouseHookEventReader
    implements HookEventReader {
        private MouseHookEventReader() {
        }

        public HookEventObject readEvent(HooksData hookData) {
            MouseHookData mouseHookData = hookData._mouseHookData;
            MouseHookStructure mouseHookStruct = mouseHookData.getMouseHookStruct();
            MouseEvent result = new MouseEvent(mouseHookData.getEventDescriptor(), mouseHookData.getWParam(), mouseHookStruct.getPoint(), mouseHookStruct.getWnd(), mouseHookStruct.getHitTestCode(), mouseHookStruct.getExtraInfo());
            return result;
        }
    }

    private static interface HookEventReader {
        public HookEventObject readEvent(HooksData var1);
    }
}

