/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.io;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int64;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.Enums;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.system.Kernel32;
import java.io.File;

public class FileSystem {
    static final FunctionName FUNCTION_GET_DRIVE_TYPE = new FunctionName("GetDriveType");
    static final FunctionName FUNCTION_GET_DISK_FREE_SPACE = new FunctionName("GetDiskFreeSpaceEx");
    static final FunctionName FUNCTION_GET_FILE_ATTRIBUTES = new FunctionName("GetFileAttributes");
    static final FunctionName FUNCTION_SET_FILE_ATTRIBUTES = new FunctionName("SetFileAttributes");
    static /* synthetic */ Class class$com$jniwrapper$win32$io$FileSystem$DriveType;

    static Function getFunction(Object functionName) {
        return Kernel32.get((Object)functionName);
    }

    public static DriveType getDriveType(String diskName) {
        Function function = FileSystem.getFunction(FUNCTION_GET_DRIVE_TYPE);
        UInt result = new UInt();
        function.invoke((Parameter)result, (Parameter)new Str(diskName, Kernel32.getInstance().isUnicode()));
        return (DriveType)Enums.getItem((Class)(class$com$jniwrapper$win32$io$FileSystem$DriveType == null ? (class$com$jniwrapper$win32$io$FileSystem$DriveType = FileSystem.class$("com.jniwrapper.win32.io.FileSystem$DriveType")) : class$com$jniwrapper$win32$io$FileSystem$DriveType), (int)((int)result.getValue()));
    }

    public static DriveType getDriveType(File drive) {
        return FileSystem.getDriveType(drive.getAbsolutePath());
    }

    public static long getDiskFreeSpace(String path) {
        Function function = FileSystem.getFunction(FUNCTION_GET_DISK_FREE_SPACE);
        Bool result = new Bool();
        Int64 freeToCaller = new Int64();
        function.invoke((Parameter)result, (Parameter)new Str(path), (Parameter)new Pointer((Parameter)freeToCaller), (Parameter)new Pointer((Parameter)new Int64()), (Parameter)new Pointer.Const((Parameter)new Int64(), true));
        return freeToCaller.getValue();
    }

    public static long getDiskFreeSpace(File path) {
        return FileSystem.getDiskFreeSpace(path.getAbsolutePath());
    }

    public static FileAttributes getFileAttributes(String fileName) {
        Function function = FileSystem.getFunction(FUNCTION_GET_FILE_ATTRIBUTES);
        UInt32 result = new UInt32();
        Str fName = new Str(fileName, Kernel32.getInstance().isUnicode());
        function.invoke((Parameter)result, (Parameter)fName);
        return new FileAttributes(result.getValue());
    }

    public static FileAttributes getFileAttributes(File file) {
        return FileSystem.getFileAttributes(file.getAbsolutePath());
    }

    public static boolean setFileAttributes(String fileName, FileAttributes attributes) {
        Function function = FileSystem.getFunction(FUNCTION_SET_FILE_ATTRIBUTES);
        Bool result = new Bool();
        Str fName = new Str(fileName, Kernel32.getInstance().isUnicode());
        function.invoke((Parameter)result, (Parameter)fName, (Parameter)new UInt32(attributes.getFlags()));
        return result.getValue();
    }

    public static boolean setFileAttributes(File file, FileAttributes attributes) {
        return FileSystem.setFileAttributes(file.getAbsolutePath(), attributes);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DriveType
    extends EnumItem {
        public static final DriveType UNKNOWN = new DriveType(0);
        public static final DriveType NO_ROOT_DIR = new DriveType(1);
        public static final DriveType REMOVABLE = new DriveType(2);
        public static final DriveType FIXED = new DriveType(3);
        public static final DriveType REMOTE = new DriveType(4);
        public static final DriveType CDROM = new DriveType(5);
        public static final DriveType RAMDISK = new DriveType(6);

        private DriveType(int value) {
            super(value);
        }
    }

    public static class FileAttributes
    extends FlagSet {
        public static final int READONLY = 1;
        public static final int HIDDEN = 2;
        public static final int SYSTEM = 4;
        public static final int DIRECTORY = 16;
        public static final int ARCHIVE = 32;
        public static final int ENCRYPTED = 64;
        public static final int NORMAL = 128;
        public static final int TEMPORARY = 256;
        public static final int SPARSE_FILE = 512;
        public static final int REPARSE_POINT = 1024;
        public static final int COMPRESSED = 2048;
        public static final int OFFLINE = 4096;
        public static final int NOT_CONTENT_INDEXED = 8192;

        public FileAttributes(long flags) {
            super(flags);
        }

        public boolean isReadOnly() {
            return this.contains(1L);
        }

        public boolean isArchive() {
            return this.contains(32L);
        }

        public boolean isSystem() {
            return this.contains(4L);
        }

        public boolean isHidden() {
            return this.contains(2L);
        }

        static {
            READONLY = 1;
            HIDDEN = 2;
            SYSTEM = 4;
            DIRECTORY = 16;
            ARCHIVE = 32;
            ENCRYPTED = 64;
            NORMAL = 128;
            TEMPORARY = 256;
            SPARSE_FILE = 512;
            REPARSE_POINT = 1024;
            COMPRESSED = 2048;
            OFFLINE = 4096;
            NOT_CONTENT_INDEXED = 8192;
        }
    }
}

