/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.process;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.NativeResource;
import com.jniwrapper.NativeResourceCollector;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.Enums;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.io.FileTime;
import com.jniwrapper.win32.process.IOCounters;
import com.jniwrapper.win32.process.ProcessInformation;
import com.jniwrapper.win32.process.ProcessOptions;
import com.jniwrapper.win32.process.ProcessSecurityOptions;
import com.jniwrapper.win32.process.ProcessVariables;
import com.jniwrapper.win32.process.StartupInfo;
import com.jniwrapper.win32.system.Kernel32;
import com.jniwrapper.win32.system.SecurityAttributes;

public class Process
extends Handle {
    private static final FunctionName FUNCTION_CreateProcess = new FunctionName("CreateProcess");
    private static final String FUNCTION_CreateProcessWithLogonW = "CreateProcessWithLogonW";
    private static final String FUNCTION_GetProcessID = "GetProcessId";
    private static final String FUNCTION_GetExitCodeProcess = "GetExitCodeProcess";
    private static final String FUNCTION_GetPriorityClass = "GetPriorityClass";
    private static final String FUNCTION_GetGuiResources = "GetGuiResources";
    private static final String FUNCTION_GetProcessHandleCount = "GetProcessHandleCount";
    private static final String FUNCTION_GetProcessIoCounters = "GetProcessIoCounters";
    private static final String FUNCTION_GetProcessPriorityBoost = "GetProcessPriorityBoost";
    private static final String FUNCTION_GetProcessTimes = "GetProcessTimes";
    private static final String FUNCTION_OpenProcess = "OpenProcess";
    private static final String FUNCTION_SetPriorityClass = "SetPriorityClass";
    private static final String FUNCTION_SetProcessPriorityBoost = "SetProcessPriorityBoost";
    private static final String FUNCTION_TerminateProces = "TerminateProcess";
    private static final String FUNCTION_GetProcessVersion = "GetProcessVersion";
    private static final String FUNCTION_GetStartupInfo = "GetStartupInfo";
    private static final String FUNCTION_GetProcessIdOfThread = "GetProcessIdOfThread";
    private static final String FUNCTION_GetThreadID = "GetThreadId";
    private static final String FUNCTION_GetProcessWorkingSetSize = "GetProcessWorkingSetSize";
    private static final String FUNCTION_SetProcessWorkingSetSize = "SetProcessWorkingSetSize";
    private static final String FUNCTION_GetProcessAffinityMask = "GetProcessAffinityMask";
    private static final String FUNCTION_SetProcessAffinityMask = "SetProcessAffinityMask";
    private static final String FUNCTION_WAIT_FOR_SINGLE_OBJECT = "WaitForSingleObject";
    private static final String FUNCTION_CloseHandle = "CloseHandle";
    private static final int GR_GDIOBJECTS = 0;
    private static final int GR_USEROBJECTS = 1;
    private static final int INFINITE_TIMEOUT = -1;
    private static final int STATUS_ABANDONED_WAIT_0 = 128;
    private static final int STATUS_TIMEOUT = 258;
    private static final int LOGON_WITH_PROFILE = 1;
    private static final int LOGON_NETCREDENTIALS_ONLY = 2;
    private Handle _thread = new Handle();
    private long _processID;
    private long _threadID;
    static /* synthetic */ Class class$com$jniwrapper$win32$process$Process$PriorityClass;

    Process(long value) {
        super(value);
    }

    Process() {
    }

    public Process(String applicationName, String commandLine, ProcessOptions options, String currentDirectory, StartupInfo startupInfo) {
        this(applicationName, commandLine, null, null, false, options, null, currentDirectory, startupInfo);
    }

    public Process(String applicationName, String commandLine, SecurityAttributes processAttributes, SecurityAttributes threadAttributes, boolean inheritHandles, ProcessOptions options, ProcessVariables environment, String currentDirectory, StartupInfo startupInfo) {
        ProcessInformation processInformation = new ProcessInformation();
        Bool functionResult = new Bool();
        Function function = Kernel32.getInstance().getFunction(FUNCTION_CreateProcess.toString());
        function.invoke((Parameter)functionResult, new Parameter[]{applicationName == null ? new Handle() : new Str(applicationName), commandLine == null ? new Handle() : new Str(commandLine), new Pointer((Parameter)processAttributes, processAttributes == null), new Pointer((Parameter)threadAttributes, threadAttributes == null), new Bool(inheritHandles), new UInt32(options.getFlags()), environment == null ? new Handle() : environment, currentDirectory == null ? new Handle() : new Str(currentDirectory), new Pointer((Parameter)startupInfo), new Pointer.OutOnly((Parameter)processInformation)});
        if (!functionResult.getValue()) {
            throw new LastErrorException();
        }
        this.setValue(processInformation.getProcess().getValue());
        this._processID = processInformation.getProcessID();
        this._threadID = processInformation.getThreadID();
        this.registerResource();
    }

    public Process(String userName, String domain, String password, boolean logonWithProfile, String applicationName, String commandLine, ProcessOptions options, ProcessVariables environment, String currentDirectory, StartupInfo startupInfo) {
        ProcessInformation processInformation = new ProcessInformation();
        Bool functionResult = new Bool();
        Function function = Kernel32.getInstance().getFunction(FUNCTION_CreateProcessWithLogonW);
        function.invoke((Parameter)functionResult, new Parameter[]{new Str(userName), domain == null ? new Handle() : new Str(domain), new Str(password), new UInt32(logonWithProfile ? 1L : 2L), applicationName == null ? new Handle() : new Str(applicationName), commandLine == null ? new Handle() : new Str(commandLine), new UInt32(options.getFlags()), environment == null ? new Handle() : environment, currentDirectory == null ? new Handle() : new Str(currentDirectory), new Pointer((Parameter)startupInfo), new Pointer.OutOnly((Parameter)processInformation)});
        if (!functionResult.getValue()) {
            throw new LastErrorException();
        }
        this.setValue(processInformation.getProcess().getValue());
        this._processID = processInformation.getProcessID();
        this._threadID = processInformation.getThreadID();
        this.registerResource();
    }

    public static Process openProcess(ProcessSecurityOptions desiredAccess, boolean inheritHandle, long processID) {
        Process result = new Process();
        Function function = Kernel32.getInstance().getFunction(FUNCTION_OpenProcess);
        function.invoke((Parameter)result, (Parameter)new UInt32(desiredAccess.getFlags()), (Parameter)new Bool(inheritHandle), (Parameter)new UInt32(processID));
        result._processID = processID;
        result._threadID = 0L;
        result.registerResource();
        return result;
    }

    protected void registerResource() {
        NativeResourceCollector.getInstance().addNativeResource((Object)this, (NativeResource)new ProcessResource(this.getValue()));
    }

    public static long getProcessID(Process process) {
        UInt32 result = new UInt32();
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetProcessID);
        function.invoke((Parameter)result, (Parameter)process);
        return result.getValue();
    }

    public long getExitCode() {
        UInt32 result = new UInt32();
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetExitCodeProcess);
        function.invoke(null, (Parameter)this, (Parameter)new Pointer.OutOnly((Parameter)result));
        return result.getValue();
    }

    public PriorityClass getPriorityClass() {
        UInt32 result = new UInt32();
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetPriorityClass);
        function.invoke((Parameter)result, (Parameter)this);
        return (PriorityClass)Enums.getItem((Class)(class$com$jniwrapper$win32$process$Process$PriorityClass == null ? (class$com$jniwrapper$win32$process$Process$PriorityClass = Process.class$("com.jniwrapper.win32.process.Process$PriorityClass")) : class$com$jniwrapper$win32$process$Process$PriorityClass), (int)((int)result.getValue()));
    }

    public void setPriorityClass(PriorityClass prioriryClass) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_SetPriorityClass);
        Bool functionResult = new Bool();
        function.invoke((Parameter)functionResult, (Parameter)this, (Parameter)new UInt32((long)prioriryClass.getValue()));
        if (!functionResult.getValue()) {
            throw new LastErrorException();
        }
    }

    private long getGuiResourceCount(long flags) {
        UInt32 result = new UInt32();
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetGuiResources);
        function.invoke((Parameter)result, (Parameter)this, (Parameter)new UInt32(flags));
        return result.getValue();
    }

    public long getGdiObjectsCount() {
        return this.getGuiResourceCount(0L);
    }

    public long getUSERObjectsCount() {
        return this.getGuiResourceCount(1L);
    }

    public long getHandleCount() {
        UInt32 result = new UInt32();
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetProcessHandleCount);
        Bool returnValue = new Bool();
        function.invoke((Parameter)returnValue, (Parameter)this, (Parameter)result);
        if (!returnValue.getValue()) {
            throw new LastErrorException();
        }
        return result.getValue();
    }

    public IOCounters getIOCounters() {
        IOCounters result = new IOCounters();
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetProcessIoCounters);
        Bool returnValue = new Bool();
        function.invoke((Parameter)returnValue, (Parameter)this, (Parameter)new Pointer.OutOnly((Parameter)result));
        if (!returnValue.getValue()) {
            throw new LastErrorException();
        }
        return result;
    }

    public void getProcessTimes(FileTime creationTime, FileTime exitTime, FileTime kernelTime, FileTime userTime) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetProcessTimes);
        Bool returnValue = new Bool();
        function.invoke((Parameter)returnValue, new Parameter[]{new Pointer.OutOnly((Parameter)creationTime), new Pointer.OutOnly((Parameter)exitTime), new Pointer.OutOnly((Parameter)kernelTime), new Pointer.OutOnly((Parameter)userTime)});
        if (!returnValue.getValue()) {
            throw new LastErrorException();
        }
    }

    public void setPriorityBoost(boolean enable) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_SetProcessPriorityBoost);
        Bool returnValue = new Bool();
        function.invoke((Parameter)returnValue, (Parameter)this, (Parameter)new Bool(!enable));
        if (!returnValue.getValue()) {
            throw new LastErrorException();
        }
    }

    public boolean getPriorityBoost() {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetProcessPriorityBoost);
        Bool result = new Bool();
        Bool functionResult = new Bool();
        function.invoke((Parameter)functionResult, (Parameter)this, (Parameter)new Pointer((Parameter)result));
        if (!functionResult.getValue()) {
            throw new LastErrorException();
        }
        return !result.getValue();
    }

    public void terminate(long exitCode) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_TerminateProces);
        Bool functionResult = new Bool();
        function.invoke((Parameter)functionResult, (Parameter)this, (Parameter)new UInt(exitCode));
        if (!functionResult.getValue()) {
            throw new LastErrorException();
        }
    }

    public long getVersion() {
        return Process.getVersion(this.getProcessID());
    }

    public static long getVersion(long processID) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetProcessVersion);
        UInt32 result = new UInt32();
        function.invoke((Parameter)result, (Parameter)new UInt32(processID));
        return result.getValue();
    }

    public StartupInfo getStartupInfo() {
        StartupInfo result = new StartupInfo();
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetStartupInfo);
        Bool returnValue = new Bool();
        function.invoke((Parameter)returnValue, (Parameter)new Pointer.OutOnly((Parameter)result));
        if (!returnValue.getValue()) {
            throw new LastErrorException();
        }
        return result;
    }

    public void getWorkingSetSize(UInt32 minimumWorkingSetSize, UInt32 maximumWorkingSetSize) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetProcessWorkingSetSize);
        Bool functionResult = new Bool();
        function.invoke((Parameter)functionResult, (Parameter)this, (Parameter)new Pointer((Parameter)minimumWorkingSetSize), (Parameter)new Pointer((Parameter)maximumWorkingSetSize));
        if (!functionResult.getValue()) {
            throw new LastErrorException();
        }
    }

    public void setWorkingSetSize(long minSize, long maxSize) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_SetProcessWorkingSetSize);
        Bool functionResult = new Bool();
        function.invoke((Parameter)functionResult, (Parameter)this, (Parameter)new UInt32(minSize), (Parameter)new UInt32(maxSize));
        if (!functionResult.getValue()) {
            throw new LastErrorException();
        }
    }

    private void retrieveAffinityMasks(UInt32 processAffinityMask, UInt32 systemAffinityMask) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetProcessAffinityMask);
        Bool functionResult = new Bool();
        function.invoke((Parameter)functionResult, (Parameter)this, (Parameter)new Pointer((Parameter)processAffinityMask), (Parameter)new Pointer((Parameter)systemAffinityMask));
        if (!functionResult.getValue()) {
            throw new LastErrorException();
        }
    }

    public long getAffinityMask() {
        UInt32 processAffinityMask = new UInt32();
        UInt32 systemAffinityMask = new UInt32();
        this.retrieveAffinityMasks(processAffinityMask, systemAffinityMask);
        return processAffinityMask.getValue();
    }

    public long getSystemAffinityMask() {
        UInt32 processAffinityMask = new UInt32();
        UInt32 systemAffinityMask = new UInt32();
        this.retrieveAffinityMasks(processAffinityMask, systemAffinityMask);
        return systemAffinityMask.getValue();
    }

    public void setAffinityMask(long affinityMask) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_SetProcessAffinityMask);
        Bool functionResult = new Bool();
        function.invoke((Parameter)functionResult, (Parameter)this, (Parameter)new UInt32(affinityMask));
        if (!functionResult.getValue()) {
            throw new LastErrorException();
        }
    }

    public static long getThreadProcessID(Handle thread) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetProcessIdOfThread);
        UInt32 result = new UInt32();
        function.invoke((Parameter)result, (Parameter)thread);
        return result.getValue();
    }

    public static long getThreadID(Handle thread) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetThreadID);
        UInt32 result = new UInt32();
        function.invoke((Parameter)result, (Parameter)thread);
        return result.getValue();
    }

    public long waitFor(long timeout) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_WAIT_FOR_SINGLE_OBJECT);
        UInt32 waitStatus = new UInt32();
        function.invoke((Parameter)waitStatus, (Parameter)this, (Parameter)new UInt32(timeout));
        switch ((int)waitStatus.getValue()) {
            case 128: {
                throw new RuntimeException("Process abandoned.");
            }
            case 258: {
                throw new RuntimeException("Timeout elapsed.");
            }
        }
        return waitStatus.getValue();
    }

    public long waitFor() {
        return this.waitFor(-1L);
    }

    public long getThreadID() {
        return this._threadID;
    }

    public long getProcessID() {
        return this._processID;
    }

    public Handle getThread() {
        return this._thread;
    }

    public void close() {
        try {
            Process.close(this);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void close(Process process) {
        if (!process.isNull()) {
            Function function = Kernel32.getInstance().getFunction(FUNCTION_CloseHandle);
            Bool functionResult = new Bool();
            function.invoke((Parameter)functionResult, (Parameter)process);
            if (!functionResult.getValue()) {
                throw new LastErrorException();
            }
            Handle thread = process.getThread();
            if (thread.isNull()) {
                function.invoke((Parameter)functionResult, (Parameter)thread);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        FUNCTION_CreateProcessWithLogonW = FUNCTION_CreateProcessWithLogonW;
        FUNCTION_GetProcessID = FUNCTION_GetProcessID;
        FUNCTION_GetExitCodeProcess = FUNCTION_GetExitCodeProcess;
        FUNCTION_GetPriorityClass = FUNCTION_GetPriorityClass;
        FUNCTION_GetGuiResources = FUNCTION_GetGuiResources;
        FUNCTION_GetProcessHandleCount = FUNCTION_GetProcessHandleCount;
        FUNCTION_GetProcessIoCounters = FUNCTION_GetProcessIoCounters;
        FUNCTION_GetProcessPriorityBoost = FUNCTION_GetProcessPriorityBoost;
        FUNCTION_GetProcessTimes = FUNCTION_GetProcessTimes;
        FUNCTION_OpenProcess = FUNCTION_OpenProcess;
        FUNCTION_SetPriorityClass = FUNCTION_SetPriorityClass;
        FUNCTION_SetProcessPriorityBoost = FUNCTION_SetProcessPriorityBoost;
        FUNCTION_TerminateProces = FUNCTION_TerminateProces;
        FUNCTION_GetProcessVersion = FUNCTION_GetProcessVersion;
        FUNCTION_GetStartupInfo = FUNCTION_GetStartupInfo;
        FUNCTION_GetProcessIdOfThread = FUNCTION_GetProcessIdOfThread;
        FUNCTION_GetThreadID = FUNCTION_GetThreadID;
        FUNCTION_GetProcessWorkingSetSize = FUNCTION_GetProcessWorkingSetSize;
        FUNCTION_SetProcessWorkingSetSize = FUNCTION_SetProcessWorkingSetSize;
        FUNCTION_GetProcessAffinityMask = FUNCTION_GetProcessAffinityMask;
        FUNCTION_SetProcessAffinityMask = FUNCTION_SetProcessAffinityMask;
        FUNCTION_WAIT_FOR_SINGLE_OBJECT = FUNCTION_WAIT_FOR_SINGLE_OBJECT;
        FUNCTION_CloseHandle = FUNCTION_CloseHandle;
        GR_GDIOBJECTS = 0;
        GR_USEROBJECTS = 1;
        INFINITE_TIMEOUT = -1;
        STATUS_ABANDONED_WAIT_0 = 128;
        STATUS_TIMEOUT = 258;
        LOGON_WITH_PROFILE = 1;
        LOGON_NETCREDENTIALS_ONLY = 2;
    }

    protected static class ProcessResource
    implements NativeResource {
        private long _handle;

        public ProcessResource(long handle) {
            this._handle = handle;
        }

        public void release() throws Throwable {
            Process.close(new Process(this._handle));
        }
    }

    public static class PriorityClass
    extends EnumItem {
        public static final PriorityClass NORMAL_PRIORITY_CLASS = new PriorityClass(32);
        public static final PriorityClass IDLE_PRIORITY_CLASS = new PriorityClass(64);
        public static final PriorityClass HIGH_PRIORITY_CLASS = new PriorityClass(128);
        public static final PriorityClass REALTIME_PRIORITY_CLASS = new PriorityClass(256);

        PriorityClass(int value) {
            super(value);
        }
    }
}

