/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.process;

import com.jniwrapper.util.FlagSet;

public class ProcessSecurityOptions
extends FlagSet {
    public static final int PROCESS_TERMINATE = 1;
    public static final int PROCESS_CREATE_THREAD = 2;
    public static final int PROCESS_SET_SESSIONID = 4;
    public static final int PROCESS_VM_OPERATION = 8;
    public static final int PROCESS_VM_READ = 16;
    public static final int PROCESS_VM_WRITE = 32;
    public static final int PROCESS_DUP_HANDLE = 64;
    public static final int PROCESS_CREATE_PROCESS = 128;
    public static final int PROCESS_SET_QUOTA = 256;
    public static final int PROCESS_SET_INFORMATION = 512;
    public static final int PROCESS_QUERY_INFORMATION = 1024;
    public static final int PROCESS_ALL_ACCESS = 0x1F0FFF;

    public ProcessSecurityOptions() {
    }

    public ProcessSecurityOptions(boolean allAccess) {
        this.setupFlag(0x1F0FFFL, allAccess);
    }

    public ProcessSecurityOptions(long flags) {
        super(flags);
    }

    public void setAllAccess(boolean value) {
        this.setupFlag(0x1F0FFFL, value);
    }

    public boolean isAllAccess() {
        return this.contains(0x1F0FFFL);
    }

    public void setCreateProcess(boolean value) {
        this.setupFlag(128L, value);
    }

    public boolean isCreateProcess() {
        return this.contains(128L);
    }

    public void setCreateThread(boolean value) {
        this.setupFlag(2L, value);
    }

    public boolean isCreateThread() {
        return this.contains(2L);
    }

    public void setDuplicateHandle(boolean value) {
        this.setupFlag(64L, value);
    }

    public boolean isDuplicateHandle() {
        return this.contains(64L);
    }

    public void setQueryInformation(boolean value) {
        this.setupFlag(1024L, value);
    }

    public boolean isQueryInformation() {
        return this.contains(1024L);
    }

    public void setQuota(boolean value) {
        this.setupFlag(256L, value);
    }

    public boolean isQuota() {
        return this.contains(256L);
    }

    public void setInformation(boolean value) {
        this.setupFlag(512L, value);
    }

    public boolean isInformation() {
        return this.contains(512L);
    }

    public void setTerminate(boolean value) {
        this.setupFlag(1L, value);
    }

    public boolean isTerminate() {
        return this.contains(1L);
    }

    public void setVMOperation(boolean value) {
        this.setupFlag(8L, value);
    }

    public boolean isVMOperation() {
        return this.contains(8L);
    }

    public void setVMRead(boolean value) {
        this.setupFlag(16L, value);
    }

    public boolean isVMRead() {
        return this.contains(16L);
    }

    public void setVMWrite(boolean value) {
        this.setupFlag(32L, value);
    }

    public boolean isVMWrite() {
        return this.contains(32L);
    }

    static {
        PROCESS_TERMINATE = 1;
        PROCESS_CREATE_THREAD = 2;
        PROCESS_SET_SESSIONID = 4;
        PROCESS_VM_OPERATION = 8;
        PROCESS_VM_READ = 16;
        PROCESS_VM_WRITE = 32;
        PROCESS_DUP_HANDLE = 64;
        PROCESS_CREATE_PROCESS = 128;
        PROCESS_SET_QUOTA = 256;
        PROCESS_SET_INFORMATION = 512;
        PROCESS_QUERY_INFORMATION = 1024;
        PROCESS_ALL_ACCESS = 0x1F0FFF;
    }
}

