/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.process;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.NativeResource;
import com.jniwrapper.NativeResourceCollector;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.StringArray;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.system.EnvironmentVariables;
import com.jniwrapper.win32.system.Kernel32;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;

public class ProcessVariables
extends Handle
implements EnvironmentVariables {
    private static final FunctionName FUNCTION_GetEnvironmentStrings = new FunctionName("GetEnvironmentStrings", false);
    private static final FunctionName FUNCTION_GetEnvironmentVariable = new FunctionName("GetEnvironmentVariable");
    private static final FunctionName FUNCTION_SetEnvironmentVariable = new FunctionName("SetEnvironmentVariable");
    private static final FunctionName FUNCTION_FreeEnvironmentStrings = new FunctionName("FreeEnvironmentStrings");

    public ProcessVariables() {
        this.readStrings();
        this.registerResource();
    }

    public ProcessVariables(String[] variables) {
        StringArray stringArray = new StringArray(variables);
        Pointer stringArrayPtr = new Pointer((Parameter)stringArray);
        stringArrayPtr.asVoidPointer((Pointer.Void)this);
        this.registerResource();
    }

    protected void registerResource() {
        NativeResourceCollector.getInstance().addNativeResource((Object)this, (NativeResource)new EnvironmentVariablesResource(this.getValue()));
    }

    private void readStrings() {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetEnvironmentStrings.toString());
        function.invoke((Parameter)this);
    }

    public String[] getStrings() {
        StringArray stringArray = new StringArray(10240);
        Pointer stringArrayPtr = new Pointer((Parameter)stringArray);
        this.asTypedPointer(stringArrayPtr);
        String[] values = stringArray.getValue();
        return values;
    }

    public Map toMap() {
        this.readStrings();
        HashMap<String, String> result = new HashMap<String, String>();
        String[] values = this.getStrings();
        int i = 0;
        while (i < values.length) {
            StringTokenizer tokenizer = new StringTokenizer(values[i], "=");
            result.put(tokenizer.nextToken(), tokenizer.nextToken());
            ++i;
        }
        return result;
    }

    public String getValue(String variable) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_GetEnvironmentVariable.toString());
        Str varName = new Str(variable);
        UInt32 length = new UInt32();
        Str result = new Str();
        function.invoke((Parameter)length, (Parameter)varName, (Parameter)new Pointer.OutOnly((Parameter)result), (Parameter)new UInt32((long)result.getMaxLength()));
        if (length.getValue() == 0L) {
            throw new LastErrorException();
        }
        int requiredLength = (int)length.getValue();
        if (requiredLength > result.getMaxLength()) {
            result = new Str(requiredLength);
            function.invoke((Parameter)length, (Parameter)varName, (Parameter)new Pointer.OutOnly((Parameter)result), (Parameter)new UInt32((long)requiredLength));
        }
        if (length.getValue() == 0L) {
            throw new LastErrorException();
        }
        return result.getValue();
    }

    public void setValue(String variable, String value) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_SetEnvironmentVariable.toString());
        Bool functionResult = new Bool();
        function.invoke((Parameter)functionResult, (Parameter)new Str(variable), (Parameter)new Str(value));
        if (!functionResult.getValue()) {
            throw new LastErrorException();
        }
    }

    public boolean contains(String variable) {
        return this.toMap().containsKey(variable);
    }

    public String[] getVariableNames() {
        Map map = this.toMap();
        LinkedList names = new LinkedList();
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            names.add(i.next());
        }
        return (String[])names.toArray();
    }

    public void freeEnvironmentStrings() {
        try {
            ProcessVariables.freeEnvironmentStrings(this);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void freeEnvironmentStrings(Handle environmentBlock) {
        if (!environmentBlock.isNull()) {
            Function function = Kernel32.getInstance().getFunction(FUNCTION_FreeEnvironmentStrings.toString());
            Bool functionResult = new Bool();
            function.invoke((Parameter)functionResult, (Parameter)environmentBlock);
            if (!functionResult.getValue()) {
                throw new LastErrorException();
            }
        }
    }

    protected static class EnvironmentVariablesResource
    implements NativeResource {
        private long _handle;

        public EnvironmentVariablesResource(long handle) {
            this._handle = handle;
        }

        public void release() throws Throwable {
            ProcessVariables.freeEnvironmentStrings(new Handle(this._handle));
        }
    }
}

