/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.service;

import com.jniwrapper.Bool;
import com.jniwrapper.ComplexArray;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.StringArray;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.service.EnumServiceStatus;
import com.jniwrapper.win32.service.ScHandle;
import com.jniwrapper.win32.service.Service;
import com.jniwrapper.win32.system.AdvApi32;
import com.jniwrapper.win32.system.Kernel32;
import java.io.File;

public class ServiceManager
extends ScHandle {
    private static final FunctionName FUNCTION_OPEB_SC_MANAGER = new FunctionName("OpenSCManager");
    private static final FunctionName FUNCTION_ENUM_SERVICES_STATUS = new FunctionName("EnumServicesStatus");
    private static final FunctionName FUNCTION_CREATE_SERVICE = new FunctionName("CreateService");
    private static final FunctionName FUNCTION_OPEN_SERVICE = new FunctionName("OpenService");
    private String _computerName = null;
    private Access _access = new Access();

    public ServiceManager() {
        this._access.setAll(true);
    }

    public String getComputerName() {
        return this._computerName;
    }

    public void setComputerName(String computerName) {
        this._computerName = computerName;
    }

    public Access getAccess() {
        return this._access;
    }

    public void setAccess(Access access) {
        this._access = access;
    }

    public void open() {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_OPEB_SC_MANAGER.toString());
        function.invoke((Parameter)this, new Parameter[]{this._computerName != null ? new Str(this._computerName) : new Handle(), new Handle(), new UInt32(this._access.getFlags())});
        if (!this.isNull()) {
            this.setOpened(true);
        }
    }

    public Service create(String serviceName, String displayName, File executable) {
        return this.create(serviceName, displayName, executable, Service.StartupType.DEMAND_START, null);
    }

    public Service create(String serviceName, String displayName, File executable, Service.StartupType startupType) {
        return this.create(serviceName, displayName, executable, startupType, null);
    }

    public Service create(String serviceName, String displayName, File executable, Service.StartupType startupType, String[] dependencies) {
        Service.Access access = new Service.Access();
        access.setAll(true);
        return this.create(serviceName, displayName, executable, startupType, dependencies, access, Service.Type.WIN32_OWN_PROCESS, Service.ErrorControl.NORMAL, null, null);
    }

    public Service create(String serviceName, String displayName, File executableFile, Service.StartupType startupType, String[] dependencies, Service.Access access, Service.Type serviceType, Service.ErrorControl errorControl, String startAccount, String password) {
        this.checkOpened();
        if (executableFile == null) {
            throw new RuntimeException("executable file is required");
        }
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_CREATE_SERVICE.toString());
        Handle handle = new Handle();
        function.invoke((Parameter)handle, new Parameter[]{this, new Str(serviceName), displayName != null ? new Str(displayName) : new Str(""), new UInt32(access.getFlags()), new UInt32((long)serviceType.getValue()), new UInt32((long)startupType.getValue()), new UInt32((long)errorControl.getValue()), new Str(executableFile.getAbsolutePath()), new Handle(), new Handle(), dependencies != null ? new Pointer((Parameter)new StringArray(dependencies)) : new Handle(), startAccount != null ? new Str(startAccount) : new Handle(), password != null ? new Str(password) : new Handle()});
        if (handle.isNull()) {
            throw new RuntimeException("Can't create service " + serviceName);
        }
        Service result = new Service(serviceName);
        result.setValue(handle.getValue());
        return result;
    }

    public Service open(String serviceName) {
        Service.Access access = new Service.Access();
        access.setAll(true);
        return this.open(serviceName, access);
    }

    private Handle doOpenService(String serviceName, Service.Access access) {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_OPEN_SERVICE.toString());
        Handle result = new Handle();
        function.invoke((Parameter)result, new Parameter[]{this, new Str(serviceName), new UInt32(access.getFlags())});
        return result;
    }

    public Service open(String serviceName, Service.Access access) {
        Handle handle = this.doOpenService(serviceName, access);
        if (handle.isNull()) {
            throw new RuntimeException("Can't find service " + serviceName);
        }
        Service result = new Service(serviceName, access);
        result.setValue(handle.getValue());
        return result;
    }

    private boolean enumServicesStatus(Pointer.Void lpServices, int bufferSize, UInt32 bytesNeeded, UInt32 servicesReturned, UInt32 resumeHandler) {
        Function function = AdvApi32.getInstance().getFunction(FUNCTION_ENUM_SERVICES_STATUS.toString());
        Bool result = new Bool();
        function.invoke((Parameter)result, new Parameter[]{this, new UInt32((long)Service.Type.WIN32.getValue()), new UInt32((long)ServiceState.ALL.getValue()), lpServices, new UInt32((long)bufferSize), new Pointer((Parameter)bytesNeeded), new Pointer((Parameter)servicesReturned), new Pointer((Parameter)resumeHandler)});
        return result.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getServices() {
        String[] result;
        UInt32 bytesNeeded = new UInt32();
        UInt32 servicesReturned = new UInt32();
        UInt32 resumeHandler = new UInt32();
        this.enumServicesStatus((Pointer.Void)new Handle(), 0, bytesNeeded, servicesReturned, resumeHandler);
        int bufferSize = (int)bytesNeeded.getValue();
        Handle lpBuffer = Kernel32.localAlloc((long)bufferSize, (Kernel32.MemoryAllocationAttributes)Kernel32.MemoryAllocationAttributes.LPTR);
        try {
            this.enumServicesStatus((Pointer.Void)lpBuffer, bufferSize, bytesNeeded, servicesReturned, resumeHandler);
            int countServices = (int)servicesReturned.getValue();
            ComplexArray servicesArray = new ComplexArray((Parameter)new EnumServiceStatus(), countServices);
            Pointer pServices = new Pointer((Parameter)servicesArray);
            lpBuffer.asTypedPointer(pServices);
            result = new String[countServices];
            int i = 0;
            while (i < result.length) {
                Parameter status = servicesArray.getElement(i);
                result[i] = ((EnumServiceStatus)status).getServiceName();
                ++i;
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            Kernel32.localFree((Handle)lpBuffer);
            throw throwable;
        }
        Kernel32.localFree((Handle)lpBuffer);
        return result;
    }

    private static class ServiceState
    extends EnumItem {
        public static final ServiceState ACTIVE = new ServiceState(1);
        public static final ServiceState INACTIVE = new ServiceState(2);
        public static final ServiceState ALL = new ServiceState(ACTIVE.getValue() | INACTIVE.getValue());

        public ServiceState(int value) {
            super(value);
        }
    }

    public static class Access
    extends FlagSet {
        private static final int CONNECT = 1;
        private static final int CREATE_SERVICE = 2;
        private static final int ENUMERATE_SERVICE = 4;
        private static final int LOCK = 8;
        private static final int QUERY_LOCK_STATUS = 16;
        private static final int MODIFY_BOOT_CONFIG = 32;
        private static final int ALL = 983103;

        public void setConnect(boolean val) {
            if (val) {
                this.add(1L);
            } else {
                this.remove(1L);
            }
        }

        public boolean isConnect() {
            return this.contains(1L);
        }

        public void setCreateService(boolean val) {
            if (val) {
                this.add(2L);
            } else {
                this.remove(2L);
            }
        }

        public boolean isCreateService() {
            return this.contains(2L);
        }

        public void setEnumerateService(boolean val) {
            if (val) {
                this.add(4L);
            } else {
                this.remove(4L);
            }
        }

        public boolean isEnumerateService() {
            return this.contains(4L);
        }

        public void setLock(boolean val) {
            if (val) {
                this.add(8L);
            } else {
                this.remove(8L);
            }
        }

        public boolean isLock() {
            return this.contains(8L);
        }

        public void setQueryLockStatus(boolean val) {
            if (val) {
                this.add(16L);
            } else {
                this.remove(16L);
            }
        }

        public boolean isQueryLockStatus() {
            return this.contains(16L);
        }

        public void setModifyBootConfig(boolean val) {
            if (val) {
                this.add(32L);
            } else {
                this.remove(32L);
            }
        }

        public boolean isModifyBootConfig() {
            return this.contains(32L);
        }

        public void setAll(boolean val) {
            if (val) {
                this.add(983103L);
            } else {
                this.remove(983103L);
            }
        }

        public boolean isAll() {
            return this.contains(983103L);
        }

        static {
            CONNECT = 1;
            CREATE_SERVICE = 2;
            ENUMERATE_SERVICE = 4;
            LOCK = 8;
            QUERY_LOCK_STATUS = 16;
            MODIFY_BOOT_CONFIG = 32;
            ALL = 983103;
        }
    }
}

