/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.shell;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int32;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.shell.Shell32;

public class ShellFolder
extends EnumItem {
    static final FunctionName FUNCTION_GET_PATH_FROM_IDLIST = new FunctionName("SHGetPathFromIDList");
    static final FunctionName FUNCTION_GET_SPECIAL_FOLDER_PATH = new FunctionName("SHGetSpecialFolderPath");
    static final String FUNCTION_GET_SPECIAL_FOLDER_LOCATION = "SHGetSpecialFolderLocation";
    static final int MAX_PATH = 260;
    public static final ShellFolder ADMINTOOLS;
    public static final ShellFolder ALTSTARTUP;
    public static final ShellFolder APPDATA;
    public static final ShellFolder BITBUCKET;
    public static final ShellFolder CDBURN_AREA;
    public static final ShellFolder COMMON_ADMINTOOLS;
    public static final ShellFolder COMMON_ALTSTARTUP;
    public static final ShellFolder COMMON_APPDATA;
    public static final ShellFolder COMMON_DESKTOPDIRECTORY;
    public static final ShellFolder COMMON_DOCUMENTS;
    public static final ShellFolder COMMON_FAVORITES;
    public static final ShellFolder COMMON_MUSIC;
    public static final ShellFolder COMMON_PICTURES;
    public static final ShellFolder COMMON_PROGRAMS;
    public static final ShellFolder COMMON_STARTMENU;
    public static final ShellFolder COMMON_STARTUP;
    public static final ShellFolder COMMON_TEMPLATES;
    public static final ShellFolder COMMON_VIDEO;
    public static final ShellFolder CONTROLS;
    public static final ShellFolder COOKIES;
    public static final ShellFolder DESKTOP;
    public static final ShellFolder DESKTOPDIRECTORY;
    public static final ShellFolder DRIVES;
    public static final ShellFolder FAVORITES;
    public static final ShellFolder FONTS;
    public static final ShellFolder HISTORY;
    public static final ShellFolder INTERNET;
    public static final ShellFolder INTERNET_CACHE;
    public static final ShellFolder LOCAL_APPDATA;
    public static final ShellFolder MYDOCUMENTS;
    public static final ShellFolder MYMUSIC;
    public static final ShellFolder MYPICTURES;
    public static final ShellFolder MYVIDEO;
    public static final ShellFolder NETHOOD;
    public static final ShellFolder NETWORK;
    public static final ShellFolder PERSONAL;
    public static final ShellFolder PRINTERS;
    public static final ShellFolder PROFILE;
    public static final ShellFolder PROFILES;
    public static final ShellFolder PROGRAM_FILES;
    public static final ShellFolder PROGRAM_FILES_COMMON;
    public static final ShellFolder PROGRAMS;
    public static final ShellFolder RECENT;
    public static final ShellFolder SEND_TO;
    public static final ShellFolder START_MENU;
    public static final ShellFolder STARTUP;
    public static final ShellFolder SYSTEM;
    public static final ShellFolder TEMPLATES;
    public static final ShellFolder WINDOWS;
    public static final ShellFolder COMPUTER;
    public static final ShellFolder NET_CONNECTIONS;
    private boolean _virtual;
    private String _absolutePath;

    private ShellFolder(int folderID, boolean virtual) {
        super(folderID);
        this._absolutePath = ShellFolder.getSpecialFolderPath(folderID);
        this._virtual = virtual;
    }

    private ShellFolder(int folderID) {
        this(folderID, false);
    }

    public int getFolderID() {
        return this.getValue();
    }

    public boolean isVirtual() {
        return this._virtual;
    }

    public String getAbsolutePath() {
        return this._absolutePath;
    }

    public static Handle getFolderIDList(int folderID) {
        Handle result = new Handle();
        Function getSpecialFolderLocation = Shell32.getInstance().getFunction(FUNCTION_GET_SPECIAL_FOLDER_LOCATION);
        getSpecialFolderLocation.invoke(null, (Parameter)new Handle(), (Parameter)new Int32(folderID), (Parameter)new Pointer.OutOnly((Parameter)result));
        return result;
    }

    public static String getPathFromIDList(Handle idList) {
        if (idList.isNull()) {
            throw new IllegalArgumentException("Folder id list is null");
        }
        Function getPathFromIDList = Shell32.getInstance().getFunction(FUNCTION_GET_PATH_FROM_IDLIST.toString());
        Str folderPath = new Str("", 260);
        Bool retValue = new Bool();
        getPathFromIDList.invoke((Parameter)retValue, (Parameter)idList, (Parameter)new Pointer((Parameter)folderPath));
        if (!retValue.getValue()) {
            return "";
        }
        return folderPath.getValue();
    }

    public static String getSpecialFolderPath(int folderID, boolean create) {
        Function getSpecialFolderPath = Shell32.getInstance().getFunction(FUNCTION_GET_SPECIAL_FOLDER_PATH.toString());
        Bool result = new Bool();
        Str folderPath = new Str("", 260);
        getSpecialFolderPath.invoke((Parameter)result, (Parameter)new Handle(), (Parameter)folderPath, (Parameter)new Int32(folderID), (Parameter)new Bool(create));
        return folderPath.getValue();
    }

    public static String getSpecialFolderPath(int folderID) {
        return ShellFolder.getSpecialFolderPath(folderID, false);
    }

    static {
        FUNCTION_GET_SPECIAL_FOLDER_LOCATION = FUNCTION_GET_SPECIAL_FOLDER_LOCATION;
        MAX_PATH = 260;
        ADMINTOOLS = new ShellFolder(48);
        ALTSTARTUP = new ShellFolder(29);
        APPDATA = new ShellFolder(26);
        BITBUCKET = new ShellFolder(10, true);
        CDBURN_AREA = new ShellFolder(59);
        COMMON_ADMINTOOLS = new ShellFolder(47);
        COMMON_ALTSTARTUP = new ShellFolder(30);
        COMMON_APPDATA = new ShellFolder(35);
        COMMON_DESKTOPDIRECTORY = new ShellFolder(25);
        COMMON_DOCUMENTS = new ShellFolder(46);
        COMMON_FAVORITES = new ShellFolder(31);
        COMMON_MUSIC = new ShellFolder(53);
        COMMON_PICTURES = new ShellFolder(54);
        COMMON_PROGRAMS = new ShellFolder(23);
        COMMON_STARTMENU = new ShellFolder(22);
        COMMON_STARTUP = new ShellFolder(24);
        COMMON_TEMPLATES = new ShellFolder(45);
        COMMON_VIDEO = new ShellFolder(55);
        CONTROLS = new ShellFolder(3, true);
        COOKIES = new ShellFolder(33);
        DESKTOP = new ShellFolder(0, true);
        DESKTOPDIRECTORY = new ShellFolder(16);
        DRIVES = new ShellFolder(17, true);
        FAVORITES = new ShellFolder(6);
        FONTS = new ShellFolder(20);
        HISTORY = new ShellFolder(34);
        INTERNET = new ShellFolder(1, true);
        INTERNET_CACHE = new ShellFolder(32);
        LOCAL_APPDATA = new ShellFolder(28);
        MYDOCUMENTS = new ShellFolder(12, true);
        MYMUSIC = new ShellFolder(13);
        MYPICTURES = new ShellFolder(39);
        MYVIDEO = new ShellFolder(14);
        NETHOOD = new ShellFolder(19);
        NETWORK = new ShellFolder(18);
        PERSONAL = new ShellFolder(5);
        PRINTERS = new ShellFolder(4, true);
        PROFILE = new ShellFolder(40);
        PROFILES = new ShellFolder(62);
        PROGRAM_FILES = new ShellFolder(38);
        PROGRAM_FILES_COMMON = new ShellFolder(43);
        PROGRAMS = new ShellFolder(2);
        RECENT = new ShellFolder(8);
        SEND_TO = new ShellFolder(9);
        START_MENU = new ShellFolder(11);
        STARTUP = new ShellFolder(7);
        SYSTEM = new ShellFolder(37);
        TEMPLATES = new ShellFolder(21);
        WINDOWS = new ShellFolder(36);
        COMPUTER = new ShellFolder(17);
        NET_CONNECTIONS = new ShellFolder(49);
    }
}

