/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemSort;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.transformer.NodeSorter;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xpath.Expression;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XNodeSet;
import org.xml.sax.ContentHandler;

public class ElemForEach
extends ElemTemplateElement {
    protected Expression m_selectExpression = null;
    protected Vector m_sortElems = null;

    public ElemTemplateElement appendChild(ElemTemplateElement newChild) {
        int type = newChild.getXSLToken();
        if (type == 64) {
            this.setSortElem((ElemSort)newChild);
            return newChild;
        }
        return super.appendChild(newChild);
    }

    public void compose(StylesheetRoot sroot) throws TransformerException {
        super.compose(sroot);
        int length = this.getSortElemCount();
        int i = 0;
        while (i < length) {
            this.getSortElem(i).compose(sroot);
            ++i;
        }
        Vector vnames = sroot.getComposeState().getVariableNames();
        if (this.m_selectExpression != null) {
            this.m_selectExpression.fixupVariables(vnames, sroot.getComposeState().getGlobalsSize());
        } else {
            this.m_selectExpression = this.getStylesheetRoot().m_selectDefault.getExpression();
        }
    }

    public void endCompose(StylesheetRoot sroot) throws TransformerException {
        int length = this.getSortElemCount();
        int i = 0;
        while (i < length) {
            this.getSortElem(i).endCompose(sroot);
            ++i;
        }
        super.endCompose(sroot);
    }

    public void execute(TransformerImpl transformer) throws TransformerException {
        transformer.pushCurrentTemplateRuleIsNull(true);
        try {
            if (TransformerImpl.S_DEBUG) {
                transformer.getTraceManager().fireTraceEvent(this);
            }
            this.transformSelectedNodes(transformer);
        }
        finally {
            Object var3_2 = null;
            transformer.popCurrentTemplateRuleIsNull();
        }
    }

    public String getNodeName() {
        return "for-each";
    }

    public Expression getSelect() {
        return this.m_selectExpression;
    }

    public ElemSort getSortElem(int i) {
        return (ElemSort)this.m_sortElems.elementAt(i);
    }

    public int getSortElemCount() {
        return this.m_sortElems == null ? 0 : this.m_sortElems.size();
    }

    protected ElemTemplateElement getTemplateMatch() {
        return this;
    }

    public int getXSLToken() {
        return 28;
    }

    public void setSelect(XPath xpath) {
        this.m_selectExpression = xpath.getExpression();
    }

    public void setSortElem(ElemSort sortElem) {
        if (this.m_sortElems == null) {
            this.m_sortElems = new Vector();
        }
        this.m_sortElems.addElement(sortElem);
    }

    public DTMIterator sortNodes(XPathContext xctxt, Vector keys, DTMIterator sourceNodes) throws TransformerException {
        NodeSorter sorter = new NodeSorter(xctxt);
        sourceNodes.setShouldCacheNodes(true);
        sourceNodes.runTo(-1);
        xctxt.pushContextNodeList(sourceNodes);
        try {
            sorter.sort(sourceNodes, keys, xctxt);
            sourceNodes.setCurrentPos(0);
        }
        finally {
            Object var6_5 = null;
            xctxt.popContextNodeList();
        }
        return sourceNodes;
    }

    public void transformSelectedNodes(TransformerImpl transformer) throws TransformerException {
        XPathContext xctxt = transformer.getXPathContext();
        int sourceNode = xctxt.getCurrentNode();
        DTMIterator sourceNodes = this.m_selectExpression.asIterator(xctxt, sourceNode);
        try {
            int child;
            Vector keys;
            Vector vector = keys = this.m_sortElems == null ? null : transformer.processSortKeys(this, sourceNode);
            if (keys != null) {
                sourceNodes = this.sortNodes(xctxt, keys, sourceNodes);
            }
            if (TransformerImpl.S_DEBUG) {
                transformer.getTraceManager().fireSelectedEvent(sourceNode, this, "select", new XPath(this.m_selectExpression), new XNodeSet(sourceNodes));
            }
            ResultTreeHandler rth = transformer.getResultTreeHandler();
            ContentHandler chandler = rth.getContentHandler();
            xctxt.pushCurrentNode(-1);
            int[] currentNodes = xctxt.getCurrentNodeStack();
            int currentNodePos = xctxt.getCurrentNodeFirstFree() - 1;
            xctxt.pushCurrentExpressionNode(-1);
            int[] currentExpressionNodes = xctxt.getCurrentExpressionNodeStack();
            int currentExpressionNodePos = xctxt.getCurrentExpressionNodesFirstFree() - 1;
            xctxt.pushSAXLocatorNull();
            xctxt.pushContextNodeList(sourceNodes);
            transformer.pushElemTemplateElement(null);
            DTM dtm = xctxt.getDTM(sourceNode);
            int docID = sourceNode & 0xFFC00000;
            while ((child = sourceNodes.nextNode()) != -1) {
                currentNodes[currentNodePos] = child;
                currentExpressionNodes[currentExpressionNodePos] = child;
                if ((child & 0xFFC00000) != docID) {
                    dtm = xctxt.getDTM(child);
                    docID = sourceNode & 0xFFC00000;
                }
                int exNodeType = dtm.getExpandedTypeID(child);
                int nodeType = exNodeType >> ExpandedNameTable.ROTAMOUNT_TYPE;
                if (TransformerImpl.S_DEBUG) {
                    transformer.getTraceManager().fireTraceEvent(this);
                }
                ElemTemplateElement t = this.m_firstChild;
                while (t != null) {
                    xctxt.setSAXLocator(t);
                    transformer.setCurrentElement(t);
                    t.execute(transformer);
                    t = t.m_nextSibling;
                }
            }
        }
        finally {
            Object var6_18 = null;
            if (TransformerImpl.S_DEBUG) {
                transformer.getTraceManager().fireSelectedEndEvent(sourceNode, this, "select", new XPath(this.m_selectExpression), new XNodeSet(sourceNodes));
            }
            xctxt.popSAXLocator();
            xctxt.popContextNodeList();
            transformer.popElemTemplateElement();
            xctxt.popCurrentExpressionNode();
            xctxt.popCurrentNode();
            sourceNodes.detach();
        }
    }
}

