/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemTextLiteral;
import org.apache.xalan.templates.ElemValueOf;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XRTreeFrag;
import org.apache.xpath.objects.XRTreeFragSelectWrapper;
import org.apache.xpath.objects.XString;

public class ElemVariable
extends ElemTemplateElement {
    protected int m_index;
    private XPath m_selectPattern;
    protected QName m_qname;
    private boolean m_isTopLevel = false;

    public ElemVariable() {
    }

    public ElemVariable(ElemVariable param) throws TransformerException {
        this.m_selectPattern = param.m_selectPattern;
        this.m_qname = param.m_qname;
        this.m_isTopLevel = param.m_isTopLevel;
    }

    public void compose(StylesheetRoot sroot) throws TransformerException {
        XPath newSelect;
        if (this.m_selectPattern == null && TransformerFactoryImpl.m_optimize && (newSelect = ElemVariable.rewriteChildToExpression(this)) != null) {
            this.m_selectPattern = newSelect;
        }
        StylesheetRoot.ComposeState cstate = sroot.getComposeState();
        Vector vnames = cstate.getVariableNames();
        if (this.m_selectPattern != null) {
            this.m_selectPattern.fixupVariables(vnames, cstate.getGlobalsSize());
        }
        if (!(this.m_parentNode instanceof Stylesheet)) {
            this.m_index = cstate.addVariableName(this.m_qname) - cstate.getGlobalsSize();
        }
        super.compose(sroot);
    }

    public void execute(TransformerImpl transformer) throws TransformerException {
        if (TransformerImpl.S_DEBUG) {
            transformer.getTraceManager().fireTraceEvent(this);
        }
        int sourceNode = transformer.getXPathContext().getCurrentNode();
        XObject var = this.getValue(transformer, sourceNode);
        transformer.getXPathContext().getVarStack().setLocalVariable(this.m_index, var);
    }

    public int getIndex() {
        return this.m_index;
    }

    public boolean getIsTopLevel() {
        return this.m_isTopLevel;
    }

    public QName getName() {
        return this.m_qname;
    }

    public String getNodeName() {
        return "variable";
    }

    public XPath getSelect() {
        return this.m_selectPattern;
    }

    public XObject getValue(TransformerImpl transformer, int sourceNode) throws TransformerException {
        XObject var;
        XPathContext xctxt;
        block5: {
            xctxt = transformer.getXPathContext();
            xctxt.pushCurrentNode(sourceNode);
            try {
                if (this.m_selectPattern != null) {
                    var = this.m_selectPattern.execute(xctxt, sourceNode, (PrefixResolver)this);
                    var.allowDetachToRelease(false);
                    if (TransformerImpl.S_DEBUG) {
                        transformer.getTraceManager().fireSelectedEvent(sourceNode, this, "select", this.m_selectPattern, var);
                    }
                    break block5;
                }
                if (this.getFirstChildElem() == null) {
                    var = XString.EMPTYSTRING;
                    break block5;
                }
                int df = transformer.transformToRTF(this);
                var = new XRTreeFrag(df, xctxt);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                xctxt.popCurrentNode();
                throw throwable;
            }
        }
        Object var6_6 = null;
        xctxt.popCurrentNode();
        return var;
    }

    public int getXSLToken() {
        return 73;
    }

    public void recompose(StylesheetRoot root) {
        root.recomposeVariables(this);
    }

    static XPath rewriteChildToExpression(ElemTemplateElement varElem) throws TransformerException {
        ElemTemplateElement t = varElem.getFirstChildElem();
        if (t != null && t.getNextSiblingElem() == null) {
            ElemTextLiteral lit;
            int etype = t.getXSLToken();
            if (etype == 30) {
                ElemValueOf valueof = (ElemValueOf)t;
                if (!valueof.getDisableOutputEscaping() && valueof.getDOMBackPointer() == null) {
                    varElem.m_firstChild = null;
                    return new XPath(new XRTreeFragSelectWrapper(valueof.getSelect().getExpression()));
                }
            } else if (etype == 78 && !(lit = (ElemTextLiteral)t).getDisableOutputEscaping() && lit.getDOMBackPointer() == null) {
                String str = lit.getNodeValue();
                XString xstr = new XString(str);
                varElem.m_firstChild = null;
                return new XPath(new XRTreeFragSelectWrapper(xstr));
            }
        }
        return null;
    }

    public void setIndex(int index) {
        this.m_index = index;
    }

    public void setIsTopLevel(boolean v) {
        this.m_isTopLevel = v;
    }

    public void setName(QName v) {
        this.m_qname = v;
    }

    public void setParentElem(ElemTemplateElement p) {
        super.setParentElem(p);
        p.m_hasVariableDecl = true;
    }

    public void setSelect(XPath v) {
        this.m_selectPattern = v;
    }
}

