/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import org.apache.xalan.transformer.KeyIterator;
import org.apache.xalan.transformer.KeyWalker;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.axes.LocPathIterator;

public class KeyRefIterator
extends LocPathIterator {
    private final QName m_name;
    private final XMLString m_lookupKey;
    private final KeyIterator m_ki;

    public KeyRefIterator(XMLString ref, KeyIterator ki) {
        super(ki.getPrefixResolver());
        this.m_ki = ki;
        this.m_name = ki.getName();
        this.m_lookupKey = ref;
        this.m_execContext = ki.getXPathContext();
        this.setShouldCacheNodes(true);
    }

    public void addNode(int node) {
        NodeSetDTM m_cachedNodes = this.getCachedNodes();
        if (m_cachedNodes != null && !m_cachedNodes.contains(node)) {
            m_cachedNodes.addElement(node);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        KeyRefIterator clone = (KeyRefIterator)super.clone();
        return clone;
    }

    public void detach() {
    }

    public QName getName() {
        return this.m_name;
    }

    public int nextNode() {
        NodeSetDTM m_cachedNodes = this.getCachedNodes();
        if (m_cachedNodes != null && this.m_next < m_cachedNodes.size()) {
            int next = m_cachedNodes.elementAt(this.m_next);
            this.setCurrentPos(++this.m_next);
            this.m_lastFetched = next;
            return next;
        }
        if (this.m_foundLast) {
            this.m_lastFetched = -1;
            return -1;
        }
        int next = -1;
        if (this.m_ki.getLookForMoreNodes()) {
            ((KeyWalker)this.m_ki.getFirstWalker()).m_lookupKey = this.m_lookupKey;
            next = this.m_ki.nextNode();
        }
        if (next != -1) {
            this.m_lastFetched = next;
            this.setCurrentPos(++this.m_next);
            return next;
        }
        this.m_foundLast = true;
        this.m_lastFetched = -1;
        return -1;
    }

    public void reset() {
        super.reset();
        this.setCurrentPos(0);
    }
}

