/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.transform.Source;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMDefaultBase;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.utils.XMLStringFactory;

public abstract class DTMDefaultBaseTraversers
extends DTMDefaultBase {
    public DTMDefaultBaseTraversers(DTMManager mgr, Source source, int dtmIdentity, DTMWSFilter whiteSpaceFilter, XMLStringFactory xstringfactory, boolean doIndexing) {
        super(mgr, source, dtmIdentity, whiteSpaceFilter, xstringfactory, doIndexing);
    }

    public DTMAxisTraverser getAxisTraverser(int axis) {
        DTMAxisTraverser traverser;
        if (this.m_traversers == null) {
            this.m_traversers = new DTMAxisTraverser[Axis.names.length];
            traverser = null;
        } else {
            traverser = this.m_traversers[axis];
            if (traverser != null) {
                return traverser;
            }
        }
        switch (axis) {
            case 0: {
                traverser = new AncestorTraverser();
                break;
            }
            case 1: {
                traverser = new AncestorOrSelfTraverser();
                break;
            }
            case 2: {
                traverser = new AttributeTraverser();
                break;
            }
            case 3: {
                traverser = new ChildTraverser();
                break;
            }
            case 4: {
                traverser = new DescendantTraverser();
                break;
            }
            case 5: {
                traverser = new DescendantOrSelfTraverser();
                break;
            }
            case 6: {
                traverser = new FollowingTraverser();
                break;
            }
            case 7: {
                traverser = new FollowingSiblingTraverser();
                break;
            }
            case 9: {
                traverser = new NamespaceTraverser();
                break;
            }
            case 8: {
                traverser = new NamespaceDeclsTraverser();
                break;
            }
            case 10: {
                traverser = new ParentTraverser();
                break;
            }
            case 11: {
                traverser = new PrecedingTraverser();
                break;
            }
            case 12: {
                traverser = new PrecedingSiblingTraverser();
                break;
            }
            case 13: {
                traverser = new SelfTraverser();
                break;
            }
            case 16: {
                traverser = new AllFromRootTraverser();
                break;
            }
            case 14: {
                traverser = new AllFromNodeTraverser();
                break;
            }
            case 15: {
                traverser = new PrecedingAndAncestorTraverser();
                break;
            }
            case 17: {
                traverser = new DescendantFromRootTraverser();
                break;
            }
            case 18: {
                traverser = new DescendantOrSelfFromRootTraverser();
                break;
            }
            case 19: {
                traverser = new RootTraverser();
                break;
            }
            case 20: {
                return null;
            }
            default: {
                throw new DTMException(XSLMessages.createMessage(168, new Object[]{Integer.toString(axis)}));
            }
        }
        if (traverser == null) {
            throw new DTMException("Axis traverser not supported: " + Axis.names[axis]);
        }
        this.m_traversers[axis] = traverser;
        return traverser;
    }

    private class AncestorTraverser
    extends DTMAxisTraverser {
        AncestorTraverser() {
        }

        public int next(int context, int current) {
            return DTMDefaultBaseTraversers.this.m_parent.elementAt(current & 0x3FFFFF) | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        public int next(int context, int current, int extendedTypeID) {
            current &= 0x3FFFFF;
            while ((current = DTMDefaultBaseTraversers.this.m_parent.elementAt(current)) != -1) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(current) != extendedTypeID) continue;
                return current | DTMDefaultBaseTraversers.this.m_dtmIdent;
            }
            return -1;
        }
    }

    private class AncestorOrSelfTraverser
    extends AncestorTraverser {
        AncestorOrSelfTraverser() {
        }

        public int first(int context) {
            return context;
        }

        public int first(int context, int extendedTypeID) {
            return DTMDefaultBaseTraversers.this.m_exptype.elementAt(context & 0x3FFFFF) == extendedTypeID ? context : this.next(context, context, extendedTypeID);
        }
    }

    private class AttributeTraverser
    extends DTMAxisTraverser {
        AttributeTraverser() {
        }

        public int next(int context, int current) {
            return context == current ? DTMDefaultBaseTraversers.this.getFirstAttribute(context) : DTMDefaultBaseTraversers.this.getNextAttribute(current);
        }

        public int next(int context, int current, int extendedTypeID) {
            int n = current = context == current ? DTMDefaultBaseTraversers.this.getFirstAttribute(context) : DTMDefaultBaseTraversers.this.getNextAttribute(current);
            do {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(current) != extendedTypeID) continue;
                return current;
            } while ((current = DTMDefaultBaseTraversers.this.getNextAttribute(current)) != -1);
            return -1;
        }
    }

    private class ChildTraverser
    extends DTMAxisTraverser {
        ChildTraverser() {
        }

        public int first(int context) {
            return DTMDefaultBaseTraversers.this._firstch(context & 0x3FFFFF) | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        public int first(int context, int extendedTypeID) {
            int identity = context & 0x3FFFFF;
            int firstMatch = this.getNextIndexed(identity, DTMDefaultBaseTraversers.this._firstch(identity), extendedTypeID);
            return firstMatch | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        protected int getNextIndexed(int axisRoot, int nextPotential, int extendedTypeID) {
            int nsIndex = ExpandedNameTable.getNamespaceID(extendedTypeID);
            int lnIndex = ExpandedNameTable.getLocalNameID(extendedTypeID);
            while (true) {
                int next;
                if ((next = DTMDefaultBaseTraversers.this.findElementFromIndex(nsIndex, lnIndex, nextPotential)) != -2) {
                    int parent = DTMDefaultBaseTraversers.this.m_parent.elementAt(next);
                    if (parent == axisRoot) {
                        return next;
                    }
                    if (parent < axisRoot) {
                        return -1;
                    }
                    do {
                        if ((parent = DTMDefaultBaseTraversers.this.m_parent.elementAt(parent)) >= axisRoot) continue;
                        return -1;
                    } while (parent > axisRoot);
                    nextPotential = next + 1;
                    continue;
                }
                DTMDefaultBaseTraversers.this.nextNode();
                if (DTMDefaultBaseTraversers.this.m_nextsib.elementAt(axisRoot) != -2) break;
            }
            return -1;
        }

        public int next(int context, int current) {
            return DTMDefaultBaseTraversers.this._nextsib(current & 0x3FFFFF) | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        public int next(int context, int current, int extendedTypeID) {
            current = DTMDefaultBaseTraversers.this._nextsib(current & 0x3FFFFF);
            while (current != -1) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(current) == extendedTypeID) {
                    return current | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                current = DTMDefaultBaseTraversers.this._nextsib(current);
            }
            return -1;
        }
    }

    private abstract class IndexedDTMAxisTraverser
    extends DTMAxisTraverser {
        IndexedDTMAxisTraverser() {
        }

        protected abstract boolean axisHasBeenProcessed(int var1);

        protected int getNextIndexed(int axisRoot, int nextPotential, int extendedTypeID) {
            int nsIndex = ExpandedNameTable.getNamespaceID(extendedTypeID);
            int lnIndex = ExpandedNameTable.getLocalNameID(extendedTypeID);
            while (true) {
                int next;
                if ((next = DTMDefaultBaseTraversers.this.findElementFromIndex(nsIndex, lnIndex, nextPotential)) != -2) {
                    if (this.isAfterAxis(axisRoot, next)) {
                        return -1;
                    }
                    return next;
                }
                if (this.axisHasBeenProcessed(axisRoot)) break;
                DTMDefaultBaseTraversers.this.nextNode();
            }
            return -1;
        }

        protected abstract boolean isAfterAxis(int var1, int var2);

        protected final boolean isIndexed(int extendedTypeID) {
            return DTMDefaultBaseTraversers.this.m_indexing && ExpandedNameTable.ELEMENT == (extendedTypeID & ExpandedNameTable.MASK_NODETYPE);
        }
    }

    private class DescendantTraverser
    extends IndexedDTMAxisTraverser {
        DescendantTraverser() {
        }

        protected boolean axisHasBeenProcessed(int axisRoot) {
            return DTMDefaultBaseTraversers.this.m_nextsib.elementAt(axisRoot) != -2;
        }

        public int first(int context, int extendedTypeID) {
            if (this.isIndexed(extendedTypeID)) {
                int identity = this.getSubtreeRoot(context);
                int firstPotential = this.getFirstPotential(identity);
                return this.getNextIndexed(identity, firstPotential, extendedTypeID) | DTMDefaultBaseTraversers.this.m_dtmIdent;
            }
            return this.next(context, context, extendedTypeID);
        }

        protected int getFirstPotential(int identity) {
            return identity + 1;
        }

        protected int getSubtreeRoot(int handle) {
            return handle & 0x3FFFFF;
        }

        protected boolean isAfterAxis(int axisRoot, int identity) {
            do {
                if (identity != axisRoot) continue;
                return false;
            } while ((identity = DTMDefaultBaseTraversers.this.m_parent.elementAt(identity)) >= axisRoot);
            return true;
        }

        protected boolean isDescendant(int subtreeRootIdentity, int identity) {
            return DTMDefaultBaseTraversers.this._parent(identity) >= subtreeRootIdentity;
        }

        public int next(int context, int current) {
            int subtreeRootIdent = this.getSubtreeRoot(context);
            current = (current & 0x3FFFFF) + 1;
            while (true) {
                short type = DTMDefaultBaseTraversers.this._type(current);
                if (!this.isDescendant(subtreeRootIdent, current)) {
                    return -1;
                }
                if (type != 2 && type != 13) {
                    return current | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                ++current;
            }
        }

        public int next(int context, int current, int extendedTypeID) {
            int subtreeRootIdent = this.getSubtreeRoot(context);
            current = (current & 0x3FFFFF) + 1;
            if (this.isIndexed(extendedTypeID)) {
                return this.getNextIndexed(subtreeRootIdent, current, extendedTypeID) | DTMDefaultBaseTraversers.this.m_dtmIdent;
            }
            while (true) {
                int exptype = DTMDefaultBaseTraversers.this._exptype(current);
                if (!this.isDescendant(subtreeRootIdent, current)) {
                    return -1;
                }
                if (exptype == extendedTypeID) {
                    return current | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                ++current;
            }
        }
    }

    private class DescendantOrSelfTraverser
    extends DescendantTraverser {
        DescendantOrSelfTraverser() {
        }

        public int first(int context) {
            return context;
        }

        protected int getFirstPotential(int identity) {
            return identity;
        }
    }

    private class AllFromNodeTraverser
    extends DescendantOrSelfTraverser {
        AllFromNodeTraverser() {
        }

        public int next(int context, int current) {
            int subtreeRootIdent = context & 0x3FFFFF;
            current = (current & 0x3FFFFF) + 1;
            DTMDefaultBaseTraversers.this._exptype(current);
            if (!this.isDescendant(subtreeRootIdent, current)) {
                return -1;
            }
            return current | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }
    }

    private class FollowingTraverser
    extends DescendantTraverser {
        FollowingTraverser() {
        }

        public int first(int context) {
            int first;
            short type = DTMDefaultBaseTraversers.this._type(context);
            if ((type == 2 || type == 13) && (first = DTMDefaultBaseTraversers.this.getFirstChild(context = DTMDefaultBaseTraversers.this.getParent(context))) != -1) {
                return first;
            }
            do {
                if ((first = DTMDefaultBaseTraversers.this.getNextSibling(context)) != -1) continue;
                context = DTMDefaultBaseTraversers.this.getParent(context);
            } while (first == -1 && context != -1);
            return first;
        }

        public int first(int context, int extendedTypeID) {
            int first;
            short type = DTMDefaultBaseTraversers.this._type(context);
            if ((type == 2 || type == 13) && (first = DTMDefaultBaseTraversers.this.getFirstChild(context = DTMDefaultBaseTraversers.this.getParent(context))) != -1) {
                if (DTMDefaultBaseTraversers.this._exptype(first) == extendedTypeID) {
                    return first;
                }
                return this.next(context, first, extendedTypeID);
            }
            do {
                if ((first = DTMDefaultBaseTraversers.this.getNextSibling(context)) != -1) {
                    if (DTMDefaultBaseTraversers.this._exptype(first) == extendedTypeID) {
                        return first;
                    }
                    return this.next(context, first, extendedTypeID);
                }
                context = DTMDefaultBaseTraversers.this.getParent(context);
            } while (first == -1 && context != -1);
            return first;
        }

        public int next(int context, int current) {
            short type;
            do {
                if ((type = DTMDefaultBaseTraversers.this._type(++current)) != -1) continue;
                return -1;
            } while (type == 2 || type == 13);
            return current | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        public int next(int context, int current, int extendedTypeID) {
            int etype;
            do {
                if ((etype = DTMDefaultBaseTraversers.this._exptype(++current)) != -1) continue;
                return -1;
            } while (etype != extendedTypeID);
            return current | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }
    }

    private class FollowingSiblingTraverser
    extends DTMAxisTraverser {
        FollowingSiblingTraverser() {
        }

        public int next(int context, int current) {
            return DTMDefaultBaseTraversers.this.getNextSibling(current);
        }

        public int next(int context, int current, int extendedTypeID) {
            while ((current = DTMDefaultBaseTraversers.this.getNextSibling(current)) != -1) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(current & 0x3FFFFF) != extendedTypeID) continue;
                return current;
            }
            return -1;
        }
    }

    private class NamespaceDeclsTraverser
    extends DTMAxisTraverser {
        NamespaceDeclsTraverser() {
        }

        public int next(int context, int current) {
            return context == current ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(context, false) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(context, current, false);
        }

        public int next(int context, int current, int extendedTypeID) {
            int n = current = context == current ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(context, false) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(context, current, false);
            do {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(current) != extendedTypeID) continue;
                return current;
            } while ((current = DTMDefaultBaseTraversers.this.getNextNamespaceNode(context, current, false)) != -1);
            return -1;
        }
    }

    private class NamespaceTraverser
    extends DTMAxisTraverser {
        NamespaceTraverser() {
        }

        public int next(int context, int current) {
            return context == current ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(context, true) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(context, current, true);
        }

        public int next(int context, int current, int extendedTypeID) {
            int n = current = context == current ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(context, true) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(context, current, true);
            do {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(current) != extendedTypeID) continue;
                return current;
            } while ((current = DTMDefaultBaseTraversers.this.getNextNamespaceNode(context, current, true)) != -1);
            return -1;
        }
    }

    private class ParentTraverser
    extends DTMAxisTraverser {
        ParentTraverser() {
        }

        public int first(int context) {
            return DTMDefaultBaseTraversers.this.m_parent.elementAt(context & 0x3FFFFF) | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        public int first(int current, int extendedTypeID) {
            current &= 0x3FFFFF;
            while ((current = DTMDefaultBaseTraversers.this.m_parent.elementAt(current)) != -1) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(current) != extendedTypeID) continue;
                return current | DTMDefaultBaseTraversers.this.m_dtmIdent;
            }
            return -1;
        }

        public int next(int context, int current) {
            return -1;
        }

        public int next(int context, int current, int extendedTypeID) {
            return -1;
        }
    }

    private class PrecedingTraverser
    extends DTMAxisTraverser {
        PrecedingTraverser() {
        }

        protected boolean isAncestor(int contextIdent, int currentIdent) {
            contextIdent = DTMDefaultBaseTraversers.this.m_parent.elementAt(contextIdent);
            while (contextIdent != -1) {
                if (contextIdent == currentIdent) {
                    return true;
                }
                contextIdent = DTMDefaultBaseTraversers.this.m_parent.elementAt(contextIdent);
            }
            return false;
        }

        public int next(int context, int current) {
            int subtreeRootIdent = context & 0x3FFFFF;
            current = (current & 0x3FFFFF) - 1;
            while (current >= 0) {
                int exptype = DTMDefaultBaseTraversers.this.m_exptype.elementAt(current);
                short type = ExpandedNameTable.getType(exptype);
                if (type != 2 && type != 13 && !this.isAncestor(subtreeRootIdent, current)) {
                    return current | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                --current;
            }
            return -1;
        }

        public int next(int context, int current, int extendedTypeID) {
            int subtreeRootIdent = context & 0x3FFFFF;
            current = (current & 0x3FFFFF) - 1;
            while (current >= 0) {
                int exptype = DTMDefaultBaseTraversers.this.m_exptype.elementAt(current);
                short type = ExpandedNameTable.getType(exptype);
                if (exptype == extendedTypeID && !this.isAncestor(subtreeRootIdent, current)) {
                    return current | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                --current;
            }
            return -1;
        }
    }

    private class PrecedingAndAncestorTraverser
    extends DTMAxisTraverser {
        PrecedingAndAncestorTraverser() {
        }

        public int next(int context, int current) {
            int subtreeRootIdent = context & 0x3FFFFF;
            current = (current & 0x3FFFFF) - 1;
            while (current >= 0) {
                int exptype = DTMDefaultBaseTraversers.this.m_exptype.elementAt(current);
                short type = ExpandedNameTable.getType(exptype);
                if (type != 2 && type != 13) {
                    return current | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                --current;
            }
            return -1;
        }

        public int next(int context, int current, int extendedTypeID) {
            int subtreeRootIdent = context & 0x3FFFFF;
            current = (current & 0x3FFFFF) - 1;
            while (current >= 0) {
                int exptype = DTMDefaultBaseTraversers.this.m_exptype.elementAt(current);
                short type = ExpandedNameTable.getType(exptype);
                if (exptype == extendedTypeID) {
                    return current | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                --current;
            }
            return -1;
        }
    }

    private class PrecedingSiblingTraverser
    extends DTMAxisTraverser {
        PrecedingSiblingTraverser() {
        }

        public int next(int context, int current) {
            return DTMDefaultBaseTraversers.this.getPreviousSibling(current);
        }

        public int next(int context, int current, int extendedTypeID) {
            while ((current = DTMDefaultBaseTraversers.this.getPreviousSibling(current)) != -1) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(current & 0x3FFFFF) != extendedTypeID) continue;
                return current;
            }
            return -1;
        }
    }

    private class SelfTraverser
    extends DTMAxisTraverser {
        SelfTraverser() {
        }

        public int first(int context) {
            return context;
        }

        public int first(int context, int extendedTypeID) {
            return DTMDefaultBaseTraversers.this.m_exptype.elementAt(context & 0x3FFFFF) == extendedTypeID ? context : -1;
        }

        public int next(int context, int current) {
            return -1;
        }

        public int next(int context, int current, int extendedTypeID) {
            return -1;
        }
    }

    private class AllFromRootTraverser
    extends AllFromNodeTraverser {
        AllFromRootTraverser() {
        }

        public int first(int context) {
            return DTMDefaultBaseTraversers.this.getDocument();
        }

        public int first(int context, int extendedTypeID) {
            return DTMDefaultBaseTraversers.this.m_exptype.elementAt(DTMDefaultBaseTraversers.this.getDocument() & 0x3FFFFF) == extendedTypeID ? context : this.next(context, context, extendedTypeID);
        }

        public int next(int context, int current) {
            int subtreeRootIdent = context & 0x3FFFFF;
            short type = DTMDefaultBaseTraversers.this._type(current = (current & 0x3FFFFF) + 1);
            if (type == -1) {
                return -1;
            }
            return current | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        public int next(int context, int current, int extendedTypeID) {
            int subtreeRootIdent = context & 0x3FFFFF;
            current = (current & 0x3FFFFF) + 1;
            int exptype;
            while ((exptype = DTMDefaultBaseTraversers.this._exptype(current)) != -1) {
                if (exptype == extendedTypeID) {
                    return current | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                ++current;
            }
            return -1;
        }
    }

    private class RootTraverser
    extends AllFromRootTraverser {
        RootTraverser() {
        }

        public int next(int context, int current) {
            return -1;
        }

        public int next(int context, int current, int extendedTypeID) {
            return -1;
        }
    }

    private class DescendantOrSelfFromRootTraverser
    extends DescendantTraverser {
        DescendantOrSelfFromRootTraverser() {
        }

        public int first(int context) {
            return DTMDefaultBaseTraversers.this.getDocument();
        }

        protected int getFirstPotential(int identity) {
            return identity;
        }

        protected int getSubtreeRoot(int handle) {
            return DTMDefaultBaseTraversers.this.getDocument() & 0x3FFFFF;
        }
    }

    private class DescendantFromRootTraverser
    extends DescendantTraverser {
        DescendantFromRootTraverser() {
        }

        public int first(int context) {
            return DTMDefaultBaseTraversers.this._firstch(0) | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        protected int getFirstPotential(int identity) {
            return DTMDefaultBaseTraversers.this._firstch(0);
        }

        protected int getSubtreeRoot(int handle) {
            return 0;
        }
    }
}

