/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import org.apache.xml.dtm.ref.DTMSafeStringPool;
import org.apache.xml.dtm.ref.DTMStringPool;

public class ExpandedNameTable {
    private DTMStringPool m_locNamesPool;
    private DTMStringPool m_namespaceNames;
    public static int BITS_PER_LOCALNAME = 16;
    public static int BITS_PER_NAMESPACE = 10;
    public static int MASK_LOCALNAME = 65535;
    public static int MASK_NAMESPACE = 0x3FF0000;
    public static int MASK_NODETYPE = -67108864;
    public static int MASK_NODEHANDLE = 1048575;
    public static final int ROTAMOUNT_TYPE = BITS_PER_NAMESPACE + BITS_PER_LOCALNAME;
    public static final int ELEMENT = 1 << ROTAMOUNT_TYPE;
    public static final int ATTRIBUTE = 2 << ROTAMOUNT_TYPE;
    public static final int TEXT = 3 << ROTAMOUNT_TYPE;
    public static final int CDATA_SECTION = 4 << ROTAMOUNT_TYPE;
    public static final int ENTITY_REFERENCE = 5 << ROTAMOUNT_TYPE;
    public static final int ENTITY = 6 << ROTAMOUNT_TYPE;
    public static final int PROCESSING_INSTRUCTION = 7 << ROTAMOUNT_TYPE;
    public static final int COMMENT = 8 << ROTAMOUNT_TYPE;
    public static final int DOCUMENT = 9 << ROTAMOUNT_TYPE;
    public static final int DOCUMENT_TYPE = 10 << ROTAMOUNT_TYPE;
    public static final int DOCUMENT_FRAGMENT = 11 << ROTAMOUNT_TYPE;
    public static final int NOTATION = 12 << ROTAMOUNT_TYPE;
    public static final int NAMESPACE = 13 << ROTAMOUNT_TYPE;

    public ExpandedNameTable() {
        this.m_locNamesPool = new DTMSafeStringPool();
        this.m_namespaceNames = new DTMSafeStringPool();
    }

    public ExpandedNameTable(DTMStringPool locNamesPool, DTMStringPool namespaceNames) {
        this.m_locNamesPool = locNamesPool;
        this.m_namespaceNames = namespaceNames;
    }

    public int getExpandedTypeID(int type) {
        int expandedTypeID = type << BITS_PER_NAMESPACE + BITS_PER_LOCALNAME;
        return expandedTypeID;
    }

    public int getExpandedTypeID(String namespace, String localName, int type) {
        int nsID = namespace != null ? this.m_namespaceNames.stringToIndex(namespace) : 0;
        int lnID = this.m_locNamesPool.stringToIndex(localName);
        int expandedTypeID = type << BITS_PER_NAMESPACE + BITS_PER_LOCALNAME | nsID << BITS_PER_LOCALNAME | lnID;
        return expandedTypeID;
    }

    public String getLocalName(int ExpandedNameID) {
        return this.m_locNamesPool.indexToString(ExpandedNameID & MASK_LOCALNAME);
    }

    public static final int getLocalNameID(int ExpandedNameID) {
        return ExpandedNameID & MASK_LOCALNAME;
    }

    public String getNamespace(int ExpandedNameID) {
        int id = (ExpandedNameID & MASK_NAMESPACE) >> BITS_PER_LOCALNAME;
        return id == 0 ? null : this.m_namespaceNames.indexToString(id);
    }

    public static final int getNamespaceID(int ExpandedNameID) {
        return (ExpandedNameID & MASK_NAMESPACE) >> BITS_PER_LOCALNAME;
    }

    public static final short getType(int ExpandedNameID) {
        return (short)(ExpandedNameID >> ROTAMOUNT_TYPE);
    }
}

