/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils.synthetic;

import java.io.IOException;

public class JavaUtils {
    private static boolean cantLoadCompiler = false;
    private static boolean debug = false;

    public static boolean JDKcompile(String fileName, String classPath) {
        String code_option;
        String moreClassPath = System.getProperty("org.apache.xml.utils.synthetic.moreclasspath", "").trim();
        if (moreClassPath.length() > 0) {
            classPath = String.valueOf(moreClassPath) + ';' + classPath;
        }
        if (debug) {
            System.err.println("JavaEngine: Compiling " + fileName);
            System.err.println("JavaEngine: Classpath is " + classPath);
        }
        String string = code_option = debug ? "-g" : "-O";
        if (!cantLoadCompiler) {
            String[] stringArray = new String[]{code_option, "-classpath", classPath, fileName};
        }
        String javac_command = System.getProperty("org.apache.xml.utils.synthetic.javac", "javac");
        String[] args = new String[]{javac_command, code_option, "-classpath", classPath, fileName};
        try {
            Process p = Runtime.getRuntime().exec(args);
            int compileOK = JavaUtils.waitHardFor(p);
            return compileOK == 0;
        }
        catch (IOException iOException) {
            System.err.println("ERROR: IO exception during exec(javac).");
        }
        catch (SecurityException securityException) {
            System.err.println("ERROR: Unable to create subprocess to exec(javac).");
        }
        return false;
    }

    public static void setDebug(boolean newDebug) {
        debug = newDebug;
    }

    static int waitHardFor(Process p) {
        boolean done = false;
        while (!done) {
            try {
                p.waitFor();
                done = true;
            }
            catch (InterruptedException interruptedException) {
                System.err.println("(Compiler process wait interrupted and resumed)");
            }
        }
        int ev = p.exitValue();
        return ev;
    }
}

