/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.ChildTestIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;

public class OneStepIterator
extends ChildTestIterator {
    protected int m_axis = -1;
    protected DTMAxisIterator m_iterator;

    public OneStepIterator(DTMAxisIterator iterator, int axis) throws TransformerException {
        super((DTMAxisTraverser)null);
        this.m_iterator = iterator;
        this.m_axis = axis;
        int whatToShow = -1;
        this.initNodeTest(whatToShow);
    }

    OneStepIterator(Compiler compiler, int opPos, int analysis) throws TransformerException {
        super(compiler, opPos, analysis);
        int firstStepPos = OpMap.getFirstChildPos(opPos);
        this.m_axis = WalkerFactory.getAxisFromStep(compiler, firstStepPos);
    }

    public Object clone() throws CloneNotSupportedException {
        OneStepIterator clone = (OneStepIterator)super.clone();
        if (this.m_iterator != null) {
            clone.m_iterator = this.m_iterator.cloneIterator();
        }
        return clone;
    }

    protected void countProximityPosition(int i) {
        if (!this.isReverseAxes()) {
            super.countProximityPosition(i);
        } else if (i < this.m_proximityPositions.length) {
            int n = i;
            this.m_proximityPositions[n] = this.m_proximityPositions[n] - 1;
        }
    }

    public int getAxis() {
        return this.m_axis;
    }

    public int getLastPos(XPathContext xctxt) {
        if (!this.isReverseAxes()) {
            return super.getLastPos(xctxt);
        }
        int count = 0;
        try {
            try {
                int next;
                OneStepIterator clone = (OneStepIterator)this.clone();
                int root = this.getRoot();
                xctxt.pushCurrentNode(root);
                clone.setRoot(root, xctxt);
                clone.setPredicateCount(this.getPredicateCount() - 1);
                while ((next = clone.nextNode()) != -1) {
                    ++count;
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
            }
            Object var4_6 = null;
            xctxt.popCurrentNode();
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            xctxt.popCurrentNode();
            throw throwable;
        }
        return count;
    }

    protected int getNextNode() {
        this.m_lastFetched = this.m_iterator.next();
        return this.m_lastFetched;
    }

    protected int getProximityPosition(int predicateIndex) {
        if (!this.isReverseAxes()) {
            return super.getProximityPosition(predicateIndex);
        }
        if (predicateIndex < 0) {
            return -1;
        }
        if (this.m_proximityPositions[predicateIndex] <= 0) {
            XPathContext xctxt = this.getXPathContext();
            try {
                try {
                    int next;
                    OneStepIterator clone = (OneStepIterator)this.clone();
                    int root = this.getRoot();
                    xctxt.pushCurrentNode(root);
                    clone.setRoot(root, xctxt);
                    clone.setPredicateCount(predicateIndex);
                    int count = 1;
                    while ((next = clone.nextNode()) != -1) {
                        ++count;
                    }
                    int n = predicateIndex;
                    this.m_proximityPositions[n] = this.m_proximityPositions[n] + count;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                }
                Object var4_7 = null;
                xctxt.popCurrentNode();
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                xctxt.popCurrentNode();
                throw throwable;
            }
        }
        return this.m_proximityPositions[predicateIndex];
    }

    public boolean isReverseAxes() {
        return this.m_iterator.isReverse();
    }

    public void reset() {
        super.reset();
        if (this.m_iterator != null) {
            this.m_iterator.reset();
        }
    }

    public void setRoot(int context, Object environment) {
        super.setRoot(context, environment);
        if (this.m_axis > -1) {
            this.m_iterator = this.m_cdtm.getAxisIterator(this.m_axis);
        }
        this.m_iterator.setStartNode(this.m_context);
    }
}

