/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.WalkingIterator;
import org.apache.xpath.compiler.Compiler;

public class WalkingIteratorSorted
extends WalkingIterator {
    protected boolean m_inNaturalOrder = false;

    public WalkingIteratorSorted(PrefixResolver nscontext) {
        super(nscontext);
    }

    public WalkingIteratorSorted(Compiler compiler, int opPos, int analysis, boolean shouldLoadWalkers) throws TransformerException {
        super(compiler, opPos, analysis, shouldLoadWalkers);
    }

    boolean canBeWalkedInNaturalDocOrder() {
        if (this.m_firstWalker != null) {
            AxesWalker walker = this.m_firstWalker;
            int prevAxis = -1;
            boolean prevIsSimpleDownAxis = true;
            int i = 0;
            while (walker != null) {
                boolean isSimpleDownAxis;
                int axis = walker.getAxis();
                boolean bl = isSimpleDownAxis = axis == 3 || axis == 13 || axis == 19;
                if (walker.isDocOrdered()) {
                    if (!isSimpleDownAxis) {
                        boolean isLastWalker;
                        boolean bl2 = isLastWalker = walker.getNextWalker() == null;
                        return isLastWalker && (walker.isDocOrdered() && (axis == 4 || axis == 5 || axis == 17 || axis == 18) || axis == 2);
                    }
                } else {
                    return false;
                }
                walker = walker.getNextWalker();
                ++i;
            }
            return true;
        }
        return false;
    }

    public void reset() {
        if (this.m_inNaturalOrder) {
            super.reset();
        } else {
            this.m_lastFetched = -1;
            this.m_next = 0;
            if (this.m_firstWalker != null) {
                this.m_lastUsedWalker = this.m_firstWalker;
                this.m_firstWalker.setRoot(this.m_context);
            }
        }
    }

    public void setRoot(int context, Object environment) {
        super.setRoot(context, environment);
        this.m_inNaturalOrder = this.canBeWalkedInNaturalDocOrder();
        if (!this.m_inNaturalOrder) {
            this.setShouldCacheNodes(true);
            this.m_cachedNodes.setLast(0);
            this.m_cachedNodes.reset();
            this.m_cachedNodes.RemoveAllNoClear();
            this.setNextPosition(0);
            this.m_firstWalker.setRoot(context);
            this.m_lastUsedWalker = this.m_firstWalker;
            int nextNode = -1;
            AxesWalker walker = this.getLastUsedWalker();
            XPathContext execContext = (XPathContext)environment;
            execContext.pushCurrentNodeAndExpression(context, context);
            try {
                while (true) {
                    if (walker != null) {
                        nextNode = walker.getNextNode();
                        if (nextNode == -1) {
                            walker = walker.m_prevWalker;
                            continue;
                        }
                        if (walker.acceptNode(nextNode) != 1) continue;
                        if (walker.m_nextWalker == null) {
                            this.setLastUsedWalker(walker);
                        } else {
                            AxesWalker prev = walker;
                            walker = walker.m_nextWalker;
                            walker.setRoot(nextNode);
                            walker.m_prevWalker = prev;
                            continue;
                        }
                    }
                    if (nextNode != -1) {
                        this.incrementNextPosition();
                        this.m_cachedNodes.addNodeInDocOrder(nextNode, execContext);
                        walker = this.getLastUsedWalker();
                    }
                    if (nextNode == -1) break;
                }
            }
            finally {
                Object var7_7 = null;
                execContext.popCurrentNodeAndExpression();
            }
            this.setNextPosition(0);
            this.m_last = this.m_cachedNodes.size();
            this.m_lastFetched = -1;
            this.m_currentContextNode = -1;
            this.m_foundLast = true;
        }
    }
}

