/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper;

import com.jniwrapper.DataBuffer;
import com.jniwrapper.IntegerParameter;
import com.jniwrapper.MemoryAccessViolationException;
import com.jniwrapper.Parameter;
import com.jniwrapper.PlatformContext;
import com.jniwrapper.j;
import java.util.Arrays;

public class Bool
extends Parameter {
    public static final Bool FALSE = new Bool(false);
    public static final Bool TRUE = new Bool(true);
    private static final int a = PlatformContext.isLittleEndian() ? 0 : PlatformContext.getBoolLength() - 1;

    public Bool() {
        super(new j(), 0);
    }

    public Bool(boolean bl) {
        this();
        this.setValue(bl);
    }

    public Bool(Bool bool) {
        this(bool.getValue());
    }

    public boolean getValue() {
        byte[] byArray = this.getDataBuffer().readByteArray(this.getDataBufferOffset(), this.getLength());
        int n2 = 0;
        while (n2 < this.getLength()) {
            if (byArray[n2] != 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setValue(boolean bl) {
        byte[] byArray = new byte[this.getLength()];
        Arrays.fill(byArray, 0, 0 + this.getLength(), (byte)0);
        byArray[Bool.a] = (byte)(bl ? 1 : 0);
        this.getDataBuffer().writeByteArray(this.getDataBufferOffset(), byArray);
    }

    public int getLength() {
        return PlatformContext.getBoolLength();
    }

    public void write(DataBuffer dataBuffer, int n2, boolean bl) throws MemoryAccessViolationException {
        dataBuffer.writeByteArray(n2, this.getDataBuffer().readByteArray(this.getDataBufferOffset(), this.getLength()));
    }

    public void read(DataBuffer dataBuffer, int n2, boolean bl) throws MemoryAccessViolationException {
        this.getDataBuffer().writeByteArray(this.getDataBufferOffset(), dataBuffer.readByteArray(n2, this.getLength()));
    }

    public Object clone() {
        return new Bool(this);
    }

    public String toString() {
        return this.getClass().getName() + " value: " + String.valueOf(this.getValue());
    }

    public Boolean toBoolean() {
        return new Boolean(this.getValue());
    }

    public boolean equals(Object object) {
        if (object instanceof Bool) {
            return this.getValue() == ((Bool)object).getValue();
        }
        if (object instanceof IntegerParameter) {
            return this.getValue() == (((IntegerParameter)object).getValue() != 0L);
        }
        return super.equals(object);
    }
}

