/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.util;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class ImageUtils {
    private static final String a = "Pixel grabber was interrupted during examining the image.";

    public static BufferedImage createBufferedImage(Image image) {
        if (image == null) {
            throw new RuntimeException("image == null for createBufferedImage");
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(a);
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new RuntimeException(a);
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        int n2 = pixelGrabber.getWidth();
        int n3 = pixelGrabber.getHeight();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n2, n3);
        writableRaster.setDataElements(0, 0, n2, n3, pixelGrabber.getPixels());
        return new BufferedImage(colorModel, writableRaster, false, new Hashtable());
    }

    public static Dimension getScaledSize(Dimension dimension, Dimension dimension2) {
        if (dimension.width <= dimension2.width && dimension.height <= dimension2.height) {
            return dimension;
        }
        double d2 = (double)dimension2.width / (double)dimension.width;
        double d3 = (double)dimension2.height / (double)dimension.height;
        if (d2 < d3) {
            return new Dimension(dimension2.width, (int)Math.round(d2 * (double)dimension.height));
        }
        return new Dimension((int)Math.round(d3 * (double)dimension.width), dimension2.height);
    }

    static {
        a = a;
    }
}

