/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32;

import com.jniwrapper.LongInt;
import com.jniwrapper.Parameter;
import com.jniwrapper.Structure;
import com.jniwrapper.win32.Size;
import java.awt.Rectangle;

public class Rect
extends Structure {
    private LongInt k = new LongInt();
    private LongInt j = new LongInt();
    private LongInt c = new LongInt();
    private LongInt f = new LongInt();

    public Rect() {
        this.init(new Parameter[]{this.k, this.j, this.c, this.f});
    }

    public Rect(Rect rect) {
        this.k = (LongInt)rect.k.clone();
        this.j = (LongInt)rect.j.clone();
        this.c = (LongInt)rect.c.clone();
        this.f = (LongInt)rect.f.clone();
        this.init(new Parameter[]{this.k, this.j, this.c, this.f});
    }

    public Rect(long l2, long l3, long l4, long l5) {
        this();
        this.setLeft(l2);
        this.setTop(l3);
        this.setRight(l4);
        this.setBottom(l5);
    }

    public Rect(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public void setLeft(long l2) {
        this.k.setValue(l2);
    }

    public long getLeft() {
        return this.k.getValue();
    }

    public void setTop(long l2) {
        this.j.setValue(l2);
    }

    public long getTop() {
        return this.j.getValue();
    }

    public void setRight(long l2) {
        this.c.setValue(l2);
    }

    public long getRight() {
        return this.c.getValue();
    }

    public void setBottom(long l2) {
        this.f.setValue(l2);
    }

    public long getBottom() {
        return this.f.getValue();
    }

    public void moveTo(long l2, long l3) {
        long l4 = this.getRight() - this.getLeft();
        long l5 = this.getBottom() - this.getTop();
        this.setLeft(l2);
        this.setTop(l3);
        this.setRight(l2 + l4);
        this.setBottom(l3 + l5);
    }

    public void moveBy(int n2, int n3) {
        this.setLeft(this.getTop() + (long)n2);
        this.setRight(this.getBottom() + (long)n2);
        this.setTop(this.getTop() + (long)n3);
        this.setBottom(this.getBottom() + (long)n3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Rect: [").append(this.getLeft()).append(',').append(this.getTop()).append(',').append(this.getRight()).append(',').append(this.getBottom()).append(']');
        return stringBuffer.toString();
    }

    public Object clone() {
        return new Rect(this);
    }

    public void assign(Rect rect) {
        this.setTop(rect.getTop());
        this.setBottom(rect.getBottom());
        this.setLeft(rect.getLeft());
        this.setRight(rect.getRight());
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        this.setTop(n3);
        this.setBottom(n5);
        this.setLeft(n2);
        this.setRight(n4);
    }

    public void setBounds(Rectangle rectangle) {
        this.setTop(rectangle.y);
        this.setBottom(rectangle.x + rectangle.width);
        this.setLeft(rectangle.x);
        this.setRight(rectangle.y + rectangle.height);
    }

    public int getWidth() {
        return (int)(this.c.getValue() - this.k.getValue());
    }

    public int getHeight() {
        return (int)(this.f.getValue() - this.j.getValue());
    }

    public int getLeftAsInt() {
        return (int)this.getLeft();
    }

    public int getTopAsInt() {
        return (int)this.getTop();
    }

    public int getBottomAsInt() {
        return (int)this.getBottom();
    }

    public int getRightAsInt() {
        return (int)this.getRight();
    }

    public Rect centerRect(Size size) {
        int n2 = (int)this.getLeft() + (this.getWidth() - size.getCx()) / 2;
        int n3 = (int)this.getTop() + (this.getHeight() - size.getCy()) / 2;
        return new Rect(n2, n3, n2 + size.getCx(), n3 + size.getCy());
    }
}

