/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.ComplexArray;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt16;
import com.jniwrapper.UInt32;
import com.jniwrapper.UInt8;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.util.ImageUtils;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.Size;
import com.jniwrapper.win32.gdi.BitmapInfo;
import com.jniwrapper.win32.gdi.BitmapInfoHeader;
import com.jniwrapper.win32.gdi.BitmapStructure;
import com.jniwrapper.win32.gdi.DC;
import com.jniwrapper.win32.gdi.Gdi32;
import com.jniwrapper.win32.gdi.GdiObject;
import com.jniwrapper.win32.gdi.RGBQuad;
import com.jniwrapper.win32.gdi.WindowDC;
import com.jniwrapper.win32.gdi.bitmap.BitmapBuilder;
import com.jniwrapper.win32.gdi.bitmap.BitmapBuilderFactory;
import com.jniwrapper.win32.gdi.bitmap.BitmapBuilderFactoryImpl;
import com.jniwrapper.win32.ui.User32;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class Bitmap
extends GdiObject {
    private static final BitmapBuilderFactory h = new BitmapBuilderFactoryImpl();
    private static final String k = "CreateBitmap";
    private static final String n = "CreateBitmapIndirect";
    private static final String b = "CreateCompatibleBitmap";
    private static final FunctionName o;
    private static final String c = "GetDIBits";
    private static final String f = "SetDIBits";
    private static final String m = "CreateDIBSection";
    public static final int DIB_RGB_COLORS = 0;
    public static final int DIB_PAL_COLORS = 1;
    public static final int CBM_INIT = 4;
    private Bitmap a = null;
    static Class d;

    public Bitmap() {
    }

    public Bitmap(long l2) {
        super(l2);
    }

    public Bitmap(long l2, long l3, int n2, int n3, UInt16[] uInt16Array) {
        Function function = Gdi32.get(k);
        Parameter[] parameterArray = new Parameter[5];
        parameterArray[0] = new Int(l2);
        parameterArray[1] = new Int(l3);
        parameterArray[2] = new UInt(n2);
        parameterArray[3] = new UInt(n3);
        if (uInt16Array == null) {
            parameterArray[4] = new Handle();
        } else {
            ComplexArray complexArray = new ComplexArray(uInt16Array);
            parameterArray[4] = new Pointer(complexArray);
        }
        function.invoke((Parameter)this, parameterArray);
    }

    public Bitmap(DC dC, int n2, int n3, boolean bl) {
        if (bl) {
            Function function = Gdi32.get(b);
            function.invoke(this, dC, new Int(n2), new Int(n3));
        } else {
            Function function = Gdi32.get(k);
            function.invoke((Parameter)this, new Parameter[]{new Int(n2), new Int(n3), new UInt(1L), new UInt(1L), new Handle()});
        }
    }

    public Bitmap(long l2, long l3, long l4, long l5, long l6) {
        BitmapStructure bitmapStructure = new BitmapStructure(l2, l3, l4, l5, l6);
        Function function = Gdi32.get(n);
        function.invoke((Parameter)this, new Pointer(bitmapStructure));
    }

    public Bitmap(DC dC, int n2, int n3) {
        this(dC, n2, n3, true);
    }

    public Bitmap(Image image) {
        BufferedImage bufferedImage = null;
        bufferedImage = ImageUtils.createBufferedImage(image);
        this.a(bufferedImage);
    }

    public Bitmap(PredefinedBitmap predefinedBitmap) {
        Function function = User32.getInstance().getFunction(o.toString());
        function.invoke(this, new Handle(), new UInt32(predefinedBitmap.getValue()));
    }

    public Bitmap(String string) {
        this.loadFromFile(string);
    }

    public void loadFromFile(String string) {
        this.setValue(User32.loadResourceFromFile(string, GdiObject.ImageType.BITMAP.getValue()).getValue());
    }

    public long setDIBits(DC dC, int n2, int n3, Pointer pointer, BitmapInfo bitmapInfo, int n4) {
        return Bitmap.a(dC, this, n2, n3, pointer, bitmapInfo, n4);
    }

    private static long a(DC dC, Bitmap bitmap, int n2, int n3, Pointer pointer, BitmapInfo bitmapInfo, int n4) {
        Int intVal = new Int();
        Function function = Gdi32.get(f);
        function.invoke((Parameter)intVal, new Parameter[]{dC, bitmap, new UInt(n2), new UInt(n3), pointer, new Pointer(bitmapInfo), new UInt(n4)});
        return intVal.getValue();
    }

    public long getDIBits(DC dC, int n2, int n3, Pointer pointer, BitmapInfo bitmapInfo, int n4) {
        return Bitmap.b(dC, this, n2, n3, pointer, bitmapInfo, n4);
    }

    private static long b(DC dC, Bitmap bitmap, int n2, int n3, Pointer pointer, BitmapInfo bitmapInfo, int n4) {
        Int intVal = new Int();
        Function function = Gdi32.get(c);
        function.invoke((Parameter)intVal, new Parameter[]{dC, bitmap, new UInt(n2), new UInt(n3), pointer, new Pointer(bitmapInfo), new UInt(n4)});
        return intVal.getValue();
    }

    public BufferedImage toImage() {
        BitmapStructure bitmapStructure = this.c();
        WindowDC windowDC = new WindowDC(null);
        int n2 = (int)bitmapStructure.getBitsPixel();
        BitmapInfo bitmapInfo = n2 >= 16 ? new BitmapInfo() : new BitmapInfo(n2);
        BitmapInfoHeader bitmapInfoHeader = bitmapInfo.getBitmapInfoHeader();
        int n3 = (int)bitmapStructure.getBitmapWidth();
        int n4 = (int)bitmapStructure.getBitmapHeight();
        bitmapInfoHeader.setWidth(n3);
        bitmapInfoHeader.setHeight(n4);
        bitmapInfoHeader.setPlanes(1L);
        bitmapInfoHeader.setBitCount(n2);
        bitmapInfoHeader.setCompression(Compression.RGB);
        if (n2 == 4 || n2 == 8) {
            int n5 = 1 << n2;
            bitmapInfoHeader.setClrUsed(n5);
            bitmapInfoHeader.setClrImportant(n5);
        }
        Pointer pointer = new Pointer(null, true);
        this.getDIBits(windowDC, 0, n4, pointer, bitmapInfo, 0);
        int n6 = (int)bitmapInfoHeader.getSizeImage();
        PrimitiveArray primitiveArray = new PrimitiveArray(d == null ? (d = Bitmap.a("com.jniwrapper.UInt8")) : d, n6);
        this.getDIBits(windowDC, 0, n4, new Pointer(primitiveArray), bitmapInfo, 0);
        windowDC.release();
        BufferedImage bufferedImage = n2 >= 8 ? this.a(bitmapInfo, n3, n4, n2, primitiveArray) : this.b(bitmapInfo, n3, n4, n2, primitiveArray);
        return bufferedImage;
    }

    private BufferedImage b(BitmapInfo bitmapInfo, int n2, int n3, int n4, PrimitiveArray primitiveArray) {
        int n5 = -16777216;
        PrimitiveArray primitiveArray2 = bitmapInfo.getColors();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        int n6 = 0;
        int n7 = 0;
        int n8 = (n2 * n4 + 31) / 32 * 4;
        int n9 = n3 - 1;
        while (n9 >= 0) {
            int n10 = 0;
            while (n10 < n2) {
                int n11 = 0;
                switch (n4) {
                    case 1: {
                        n7 = (n3 - 1 - n9) * n8 + n10 * n4 / 8;
                        n6 = n10 * n4 % 8;
                        int n12 = this.a(primitiveArray, n7);
                        FlagSet flagSet = new FlagSet(n12);
                        boolean bl = flagSet.getBit(7 - n6);
                        n11 = !bl ? n5 : 0;
                    }
                }
                bufferedImage.setRGB(n10, n9, n11);
                ++n10;
            }
            --n9;
        }
        return bufferedImage;
    }

    private BufferedImage a(BitmapInfo bitmapInfo, int n2, int n3, int n4, PrimitiveArray primitiveArray) {
        PrimitiveArray primitiveArray2 = bitmapInfo.getColors();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        int n5 = 0;
        int n6 = n3 - 1;
        while (n6 >= 0) {
            int n7 = 0;
            while (n7 < n2) {
                int n8 = 0;
                switch (n4) {
                    case 8: {
                        RGBQuad rGBQuad = (RGBQuad)primitiveArray2.getElement(n5++);
                        n8 = rGBQuad.getRGB();
                        break;
                    }
                    case 16: {
                        int n9 = this.a(primitiveArray, n5++);
                        int n10 = this.a(primitiveArray, n5++);
                        int n11 = n10 << 8 | n9;
                        int n12 = (n11 & 0x1F) << 3;
                        int n13 = (n11 & 0x3E0) << 6;
                        int n14 = (n11 & 0x7C00) << 9;
                        n8 = n12 | n13 | n14;
                        break;
                    }
                    case 24: 
                    case 32: {
                        int n12;
                        int n15 = this.a(primitiveArray, n5++);
                        int n10 = this.a(primitiveArray, n5++);
                        int n11 = this.a(primitiveArray, n5++);
                        n8 = n15 | n10 << 8 | n11 << 16;
                        if (n4 != 32) break;
                        if ((n12 = this.a(primitiveArray, n5++)) == 0) {
                            n12 = 255;
                        }
                        n8 |= n12 << 24;
                    }
                }
                bufferedImage.setRGB(n7, n6, n8);
                ++n7;
            }
            --n6;
        }
        return bufferedImage;
    }

    public Size getSize() {
        BitmapStructure bitmapStructure = this.c();
        Size size = new Size();
        size.setCx((int)bitmapStructure.getBitmapWidth());
        size.setCy((int)bitmapStructure.getBitmapHeight());
        return size;
    }

    private BitmapStructure c() {
        BitmapStructure bitmapStructure = new BitmapStructure();
        this.getObject(this, bitmapStructure);
        return bitmapStructure;
    }

    private int a(PrimitiveArray primitiveArray, int n2) {
        UInt8 uInt8 = (UInt8)primitiveArray.getElement(n2);
        return (int)uInt8.getValue();
    }

    private void a(Bitmap bitmap, DC dC, BitmapInfo bitmapInfo, int n2, Pointer pointer, Handle handle, int n3) {
        Function function = Gdi32.get(m);
        function.invoke((Parameter)bitmap, new Parameter[]{dC, new Pointer(bitmapInfo), new UInt16(n2), pointer, handle, new UInt(n3)});
    }

    private void a(BufferedImage bufferedImage) {
        BitmapBuilder bitmapBuilder = h.createBuilder(bufferedImage);
        BitmapInfo bitmapInfo = bitmapBuilder.getBitmapInfo();
        this.a(this, new Pointer((Parameter)new Pointer(bitmapBuilder.getBitmapData())), bitmapInfo);
        bitmapBuilder.setBitmapColors();
        Image image = bitmapBuilder.getTransparentMask();
        if (image != null) {
            this.a = new Bitmap(image);
        }
    }

    private void a(Bitmap bitmap, Pointer pointer, BitmapInfo bitmapInfo) {
        this.a(bitmap, new DC(), bitmapInfo, 0, pointer, new Handle(), 0);
    }

    public int getBitCount() {
        BitmapStructure bitmapStructure = this.c();
        return (int)bitmapStructure.getBitsPixel();
    }

    Bitmap b() {
        return this.a;
    }

    public boolean isTransparent() {
        return this.getBitCount() == 32 || this.a != null;
    }

    public void deleteObject() {
        super.deleteObject();
        if (this.a != null) {
            this.a.deleteObject();
        }
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        k = k;
        n = n;
        b = b;
        o = new FunctionName("LoadBitmap");
        c = c;
        f = f;
        m = m;
        DIB_RGB_COLORS = 0;
        DIB_PAL_COLORS = 1;
        CBM_INIT = 4;
    }

    public static class Compression
    extends EnumItem {
        public static final Compression RGB = new Compression(0);
        public static final Compression RLE8 = new Compression(1);
        public static final Compression RLE4 = new Compression(2);
        public static final Compression BITFIELDS = new Compression(3);
        public static final Compression JPEG = new Compression(4);
        public static final Compression PNG = new Compression(5);

        protected Compression(int n2) {
            super(n2);
        }
    }

    public static class PredefinedBitmap
    extends EnumItem {
        public static final PredefinedBitmap BTNCORNERS = new PredefinedBitmap(32758);
        public static final PredefinedBitmap BTSIZE = new PredefinedBitmap(32761);
        public static final PredefinedBitmap CHECK = new PredefinedBitmap(32760);
        public static final PredefinedBitmap CHECKBOXES = new PredefinedBitmap(32759);
        public static final PredefinedBitmap CLOSE = new PredefinedBitmap(32754);
        public static final PredefinedBitmap COMBO = new PredefinedBitmap(32738);
        public static final PredefinedBitmap DNARROW = new PredefinedBitmap(32752);
        public static final PredefinedBitmap DNARROWD = new PredefinedBitmap(32742);
        public static final PredefinedBitmap DNARROWI = new PredefinedBitmap(32736);
        public static final PredefinedBitmap LFARROW = new PredefinedBitmap(32750);
        public static final PredefinedBitmap LFARROWD = new PredefinedBitmap(32740);
        public static final PredefinedBitmap LFARROWI = new PredefinedBitmap(32734);
        public static final PredefinedBitmap MNARROW = new PredefinedBitmap(32739);
        public static final PredefinedBitmap REDUCE = new PredefinedBitmap(32749);
        public static final PredefinedBitmap REDUCED = new PredefinedBitmap(32746);
        public static final PredefinedBitmap RESTORE = new PredefinedBitmap(32747);
        public static final PredefinedBitmap RESTORED = new PredefinedBitmap(32744);
        public static final PredefinedBitmap RGARROW = new PredefinedBitmap(32751);
        public static final PredefinedBitmap RGARROWD = new PredefinedBitmap(32741);
        public static final PredefinedBitmap RGARROWI = new PredefinedBitmap(32735);
        public static final PredefinedBitmap SIZE = new PredefinedBitmap(32766);
        public static final PredefinedBitmap UPARROW = new PredefinedBitmap(32753);
        public static final PredefinedBitmap UPARROWD = new PredefinedBitmap(32743);
        public static final PredefinedBitmap UPARROWI = new PredefinedBitmap(32737);
        public static final PredefinedBitmap ZOOM = new PredefinedBitmap(32748);
        public static final PredefinedBitmap ZOOMD = new PredefinedBitmap(32745);

        private PredefinedBitmap(int n2) {
            super(n2);
        }
    }
}

