/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Int32;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt16;
import com.jniwrapper.UInt32;
import com.jniwrapper.UInt8;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.gdi.Bitmap;
import com.jniwrapper.win32.gdi.BitmapInfo;
import com.jniwrapper.win32.gdi.BitmapInfoHeader;
import com.jniwrapper.win32.gdi.BitmapStructure;
import com.jniwrapper.win32.gdi.GdiObject;
import com.jniwrapper.win32.gdi.IconInfo;
import com.jniwrapper.win32.gdi.RGBQuad;
import com.jniwrapper.win32.gdi.WindowDC;
import com.jniwrapper.win32.shell.SHFileInfo;
import com.jniwrapper.win32.shell.Shell32;
import com.jniwrapper.win32.system.Module;
import com.jniwrapper.win32.ui.User32;
import java.awt.image.BufferedImage;

public class Icon
extends GdiObject {
    static final FunctionName f = new FunctionName("LoadIcon");
    static final FunctionName h = new FunctionName("LoadImage");
    static final FunctionName a = new FunctionName("ExtractIcon");
    static final FunctionName d = new FunctionName("ExtractAssociatedIcon");
    static final String k = "GetIconInfo";
    public static final int ICON_SMALL = 0;
    public static final int ICON_BIG = 1;
    public static final int ICON_SMALL_WIDTH = 16;
    public static final int ICON_SMALL_HEIGHT = 16;
    public static final int ICON_BIG_WIDTH = 32;
    public static final int ICON_BIG_HEIGHT = 32;
    private int b = 0;
    static Class c;

    public Icon() {
    }

    public Icon(int n2) {
        this.setType(n2);
    }

    public Icon(long l2) {
        super(l2);
    }

    public Icon(long l2, int n2) {
        super(l2);
        this.setType(n2);
    }

    public int getType() {
        return this.b;
    }

    public void setType(int n2) {
        this.b = n2;
    }

    static Function a(Object object) {
        return User32.getInstance().getFunction(object.toString());
    }

    public void loadIcon(Pointer pointer, String string) {
        Function function = Icon.a(f);
        function.invoke((Parameter)this, new Parameter[]{pointer, new Str(string)});
    }

    public int getWidth(int n2) {
        int n3 = n2 == 1 ? 32 : 16;
        return n3;
    }

    public int getHeight(int n2) {
        int n3 = n2 == 1 ? 32 : 16;
        return n3;
    }

    public int getWidth() {
        return this.getWidth(this.getType());
    }

    public int getHeight() {
        return this.getHeight(this.getType());
    }

    public void loadFromFile(String string) {
        this.loadFromFile(string, this.getWidth(), this.getHeight());
    }

    public void loadFromFile(String string, int n2, int n3) {
        Handle handle = User32.loadResourceFromFile(string, GdiObject.ImageType.ICON.getValue(), n2, n3);
        this.setValue(handle.getValue());
    }

    public void loadStandardIcon(int n2) {
        this.loadStandardIcon(n2, this.getWidth(), this.getHeight());
    }

    public void loadStandardIcon(int n2, int n3, int n4) {
        Function function = Icon.a(h);
        function.invoke((Parameter)this, new Parameter[]{new Handle(), new Int32(n2), new UInt32(GdiObject.ImageType.ICON.getValue()), new Int(n3), new Int(n4), new UInt32(32768L)});
        if (this.getValue() == 0L) {
            throw new LastErrorException("Cannot load icon for " + n2 + ".");
        }
    }

    public static Icon loadStandardIconByID(int n2) {
        Icon icon = new Icon();
        icon.loadStandardIcon(n2);
        return icon;
    }

    public static Icon extractFromFile(String string, int n2, int n3) {
        Icon icon = new Icon(n2);
        Function function = Shell32.getInstance().getFunction(a.toString());
        function.invoke(icon, Module.getCurrent(), new Str(string), new UInt(n3));
        return icon;
    }

    public static Icon extractSmallAssociatedIcon(String string) {
        SHFileInfo sHFileInfo = SHFileInfo.getFileInfo(string, 257);
        return sHFileInfo.getIcon();
    }

    public static Icon extractBigAssociatedIcon(String string) {
        Icon icon = new Icon();
        Function function = Shell32.getInstance().getFunction(d.toString());
        function.invoke(icon, Module.getCurrent(), new Str(string), new Pointer(new UInt16()));
        return icon;
    }

    public IconInfo getIconInfo() {
        IconInfo iconInfo = new IconInfo();
        Function function = User32.getInstance().getFunction(k);
        Bool bool = new Bool();
        function.invoke(bool, this, new Pointer(iconInfo));
        if (!bool.getValue()) {
            throw new LastErrorException("Failed to retrieve IconInfo");
        }
        return iconInfo;
    }

    public BufferedImage toImage() {
        IconInfo iconInfo = this.getIconInfo();
        Bitmap bitmap = iconInfo.getMaskBitmap();
        Bitmap bitmap2 = iconInfo.getColorBitmap();
        WindowDC windowDC = new WindowDC(null);
        BitmapStructure bitmapStructure = new BitmapStructure();
        this.getObject(bitmap2, bitmapStructure);
        int n2 = (int)bitmapStructure.getBitsPixel();
        BitmapInfo bitmapInfo = n2 >= 16 ? new BitmapInfo() : new BitmapInfo(n2);
        BitmapInfoHeader bitmapInfoHeader = bitmapInfo.getBitmapInfoHeader();
        int n3 = (int)bitmapStructure.getBitmapWidth();
        int n4 = (int)bitmapStructure.getBitmapHeight();
        bitmapInfoHeader.setWidth(n3);
        bitmapInfoHeader.setHeight(n4);
        bitmapInfoHeader.setPlanes(1L);
        bitmapInfoHeader.setBitCount(n2);
        bitmapInfoHeader.setCompression(Bitmap.Compression.RGB);
        if (n2 == 4 || n2 == 8) {
            int n5 = 1 << n2;
            bitmapInfoHeader.setClrUsed(n5);
            bitmapInfoHeader.setClrImportant(n5);
        }
        Pointer pointer = new Pointer(null, true);
        bitmap2.getDIBits(windowDC, 0, n4, pointer, bitmapInfo, 0);
        int n6 = (int)bitmapInfoHeader.getSizeImage();
        PrimitiveArray primitiveArray = new PrimitiveArray(c == null ? (c = Icon.a("com.jniwrapper.UInt8")) : c, n6);
        bitmap2.getDIBits(windowDC, 0, n4, new Pointer(primitiveArray), bitmapInfo, 0);
        PrimitiveArray primitiveArray2 = new PrimitiveArray(c == null ? (c = Icon.a("com.jniwrapper.UInt8")) : c, n6);
        bitmap.getDIBits(windowDC, 0, n4, new Pointer(primitiveArray2), bitmapInfo, 0);
        windowDC.release();
        PrimitiveArray primitiveArray3 = bitmapInfo.getColors();
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
        int n7 = 0;
        int n8 = 0;
        int n9 = n4 - 1;
        while (n9 >= 0) {
            int n10 = 0;
            while (n10 < n3) {
                int n11 = 0;
                int n12 = 0;
                switch (n2) {
                    case 8: {
                        RGBQuad rGBQuad = (RGBQuad)primitiveArray3.getElement(n7++);
                        int n13 = (int)rGBQuad.getRed();
                        int n14 = (int)rGBQuad.getGreen();
                        int n15 = (int)rGBQuad.getBlue();
                        n11 = 0xFF000000 | n15 | n14 | n13;
                        RGBQuad rGBQuad2 = (RGBQuad)primitiveArray3.getElement(n8++);
                        int n16 = (int)rGBQuad2.getRed();
                        int n17 = (int)rGBQuad2.getGreen();
                        int n18 = (int)rGBQuad2.getBlue();
                        n12 = n18 | n17 | n16;
                        break;
                    }
                    case 16: {
                        int n19 = this.a(primitiveArray, n7++);
                        int n13 = this.a(primitiveArray, n7++);
                        int n14 = n13 << 8 | n19;
                        int n15 = (n14 & 0x1F) << 3;
                        int n20 = (n14 & 0x3E0) << 6;
                        int n16 = (n14 & 0x7C00) << 9;
                        n11 = 0xFF000000 | n15 | n20 | n16;
                        n19 = this.a(primitiveArray2, n8++);
                        n13 = this.a(primitiveArray2, n8++);
                        n14 = n13 << 8 | n19;
                        int n17 = (n14 & 0x1F) << 3;
                        int n18 = (n14 & 0x3E0) << 6;
                        int n21 = (n14 & 0x7C00) << 9;
                        n12 = n17 | n18 | n21;
                        break;
                    }
                    case 24: 
                    case 32: {
                        int n15;
                        int n22 = this.a(primitiveArray, n7++);
                        int n13 = this.a(primitiveArray, n7++);
                        int n14 = this.a(primitiveArray, n7++);
                        n11 = n22 | n13 << 8 | n14 << 16;
                        if (n2 == 32) {
                            if ((n15 = this.a(primitiveArray, n7++)) == 0) {
                                n15 = 255;
                            }
                            n11 |= n15 << 24;
                        } else {
                            n11 |= 0xFF000000;
                        }
                        n15 = this.a(primitiveArray2, n8++);
                        int n23 = this.a(primitiveArray2, n8++);
                        int n16 = this.a(primitiveArray2, n8++);
                        n12 = n15 | n23 << 8 | n16 << 16;
                        if (n2 != 32) break;
                        ++n8;
                    }
                }
                if (n12 != 0) {
                    bufferedImage.setRGB(n10, n9, n12);
                } else {
                    bufferedImage.setRGB(n10, n9, n11);
                }
                ++n10;
            }
            --n9;
        }
        return bufferedImage;
    }

    private int a(PrimitiveArray primitiveArray, int n2) {
        UInt8 uInt8 = (UInt8)primitiveArray.getElement(n2);
        return (int)uInt8.getValue();
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        k = k;
        ICON_SMALL = 0;
        ICON_BIG = 1;
        ICON_SMALL_WIDTH = 16;
        ICON_SMALL_HEIGHT = 16;
        ICON_BIG_WIDTH = 32;
        ICON_BIG_HEIGHT = 32;
    }

    public static class SystemIcon
    extends EnumItem {
        public static final SystemIcon SAMPLE = new SystemIcon(32512);
        public static final SystemIcon HAND = new SystemIcon(32513);
        public static final SystemIcon QUES = new SystemIcon(32514);
        public static final SystemIcon BANG = new SystemIcon(32515);
        public static final SystemIcon NOTE = new SystemIcon(32516);
        public static final SystemIcon WINLOGO = new SystemIcon(32517);
        private Icon b;

        public SystemIcon(int n2) {
            super(n2);
        }

        public Icon getIcon() {
            if (this.b == null) {
                this.b = Icon.loadStandardIconByID(this.getValue());
            }
            return this.b;
        }
    }
}

