/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.Point;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.gdi.Gdi32;
import com.jniwrapper.win32.gdi.GdiObject;
import com.jniwrapper.win32.gdi.PolyFillMode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class Region
extends GdiObject {
    static final String b = "CreateEllipticRgn";
    static final String d = "CreateEllipticRgnIndirect";
    static final String f = "CombineRgn";
    static final String r = "CreatePolygonRgn";
    static final String o = "CreatePolyPolygonRgn";
    static final String p = "CreateRectRgn";
    static final String t = "CreateRectRgnIndirect";
    static final String u = "CreateRoundRectRgn";
    static final String k = "EqualRgn";
    static final String m = "GetRegionData";
    static final String c = "GetRgnBox";
    static final String s = "OffsetRgn";
    static final String q = "PtInRegion";
    static final String a = "RectInRegion";
    static final String v = "SetRectRgn";
    public static final int RGN_ERROR = 0;
    public static final int NULLREGION = 1;
    public static final int SIMPLEREGION = 2;
    public static final int COMPLEXREGION = 3;
    static Class n;
    static Class h;

    public Region() {
    }

    public Region(long l2) {
        super(l2);
    }

    public static Region createElliptic(int n2, int n3, int n4, int n5) {
        Function function = Gdi32.getInstance().getFunction(b);
        Region region = new Region();
        function.invoke(region, new Int(n2), new Int(n3), new Int(n4), new Int(n5));
        return region;
    }

    public static Region createElliptic(Rect rect) {
        Region region = new Region();
        Function function = Gdi32.getInstance().getFunction(d);
        function.invoke((Parameter)region, new Pointer(rect));
        return null;
    }

    public static Region createRoundRectRegion(int n2, int n3, int n4, int n5, int n6, int n7) {
        Region region = new Region();
        Function function = Gdi32.getInstance().getFunction(u);
        function.invoke((Parameter)region, new Parameter[]{new Int(n2), new Int(n3), new Int(n4), new Int(n5), new Int(n6), new Int(n7)});
        return region;
    }

    public static Region combineRgn(Region region, Region region2, CombineMode combineMode) {
        Region region3 = Region.createRectRegion(0, 0, 0, 0);
        Int intVal = new Int();
        Function function = Gdi32.getInstance().getFunction(f);
        function.invoke(intVal, region3, region, region2, new Int(combineMode.getValue()));
        long l2 = intVal.getValue();
        if (0L == l2) {
            throw new LastErrorException("Failed to combine regions.");
        }
        return region3;
    }

    public static Region createPolygonRgn(Point[] pointArray, int n2, PolyFillMode polyFillMode) {
        PrimitiveArray primitiveArray = new PrimitiveArray(n == null ? (n = Region.a("com.jniwrapper.win32.Point")) : n, n2);
        int n3 = 0;
        while (n3 < n2) {
            primitiveArray.setElement(n3, pointArray[n3]);
            ++n3;
        }
        Region region = new Region();
        Function function = Gdi32.getInstance().getFunction(r);
        function.invoke(region, new Pointer(primitiveArray), new Int(n2), new Int(polyFillMode.getValue()));
        return region;
    }

    public static Region createPolyPolygonRgn(Point[] pointArray, int[] nArray, int n2, PolyFillMode polyFillMode) {
        Region region = new Region();
        int n3 = pointArray.length;
        PrimitiveArray primitiveArray = new PrimitiveArray(n == null ? (n = Region.a("com.jniwrapper.win32.Point")) : n, n3);
        int n4 = 0;
        while (n4 < n3) {
            primitiveArray.setElement(n4, pointArray[n4]);
            ++n4;
        }
        PrimitiveArray primitiveArray2 = new PrimitiveArray(h == null ? (h = Region.a("com.jniwrapper.Int")) : h, n2);
        int n5 = 0;
        while (n5 < n3) {
            primitiveArray2.setElement(n5, new Int(nArray[n5]));
            ++n5;
        }
        Function function = Gdi32.getInstance().getFunction(o);
        function.invoke(region, new Pointer(primitiveArray), new Pointer(primitiveArray2), new Int(n2), new Int(polyFillMode.getValue()));
        return region;
    }

    public static Region createRectRegion(int n2, int n3, int n4, int n5) {
        Region region = new Region();
        Function function = Gdi32.getInstance().getFunction(p);
        function.invoke((Parameter)region, new Parameter[]{new Int(n2), new Int(n3), new Int(n4), new Int(n5)});
        return region;
    }

    public static Region createRectRegion(Rect rect) {
        Region region = new Region();
        Function function = Gdi32.getInstance().getFunction(t);
        function.invoke((Parameter)region, new Pointer(rect));
        return region;
    }

    public boolean equalRegion(Region region) {
        Bool bool = new Bool();
        Function function = Gdi32.getInstance().getFunction(p);
        function.invoke(bool, this, region);
        return bool.getValue();
    }

    public int getRagionData(PrimitiveArray primitiveArray, int n2) {
        Function function = Gdi32.getInstance().getFunction(m);
        UInt32 uInt32 = new UInt32();
        function.invoke(uInt32, this, new UInt32(n2), new Pointer(primitiveArray));
        return (int)uInt32.getValue();
    }

    public Rect getRegionBox() {
        Rect rect = new Rect();
        Function function = Gdi32.getInstance().getFunction(c);
        Int intVal = new Int();
        function.invoke(intVal, this, new Pointer(rect));
        return rect;
    }

    public void offsetRegion(int n2, int n3) {
        Function function = Gdi32.getInstance().getFunction(s);
        function.invoke(null, this, new Int(n2), new Int(n3));
    }

    public boolean isPointInRegion(int n2, int n3) {
        Bool bool = new Bool();
        Function function = Gdi32.getInstance().getFunction(q);
        function.invoke(bool, this, new Int(n2), new Int(n3));
        return bool.getValue();
    }

    public boolean isPointInRegion(Point point) {
        return this.isPointInRegion((int)point.getY(), (int)point.getY());
    }

    public boolean isRectInRegion(Rect rect) {
        Bool bool = new Bool();
        Function function = Gdi32.getInstance().getFunction(a);
        function.invoke(bool, this, new Pointer(rect));
        return bool.getValue();
    }

    public void setRectRegion(int n2, int n3, int n4, int n5) {
        Function function = Gdi32.getInstance().getFunction(v);
        function.invoke(null, new Parameter[]{this, new Int(n2), new Int(n3), new Int(n4), new Int(n5)});
    }

    public static Region createFromImage(Image image, Color color) {
        return Region.createFromImage(image, color, null);
    }

    public static Region createFromImage(Image image, Color color, Color color2) {
        if (image == null || color == null) {
            throw new IllegalArgumentException();
        }
        if (color2 == null) {
            color2 = new Color(0x101010);
        }
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, color, null);
        graphics2D.dispose();
        Region region = Region.createRectRegion(new Rect());
        int n4 = color.getRed();
        int n5 = color.getGreen();
        int n6 = color.getBlue();
        int n7 = Math.min(n4 + color2.getRed(), 255);
        int n8 = Math.min(n5 + color2.getGreen(), 255);
        int n9 = Math.min(n6 + color2.getBlue(), 255);
        int n10 = 0;
        while (n10 < n2) {
            boolean bl = false;
            int n11 = 0;
            int n12 = 0;
            while (n12 < n3) {
                int n13;
                int n14 = bufferedImage.getRGB(n10, n12);
                int n15 = (n14 & 0xFF0000) >> 16;
                boolean bl2 = false;
                if (n15 >= n4 && n15 <= n7 && (n13 = (n14 & 0xFF00) >> 8) >= n5 && n13 <= n8) {
                    int n16 = n14 & 0xFF;
                    boolean bl3 = bl2 = n16 >= n6 && n16 <= n9;
                }
                if (bl2) {
                    if (bl) {
                        bl = false;
                        Region region2 = Region.createRectRegion(n10, n11, n10 + 1, n12 - 1);
                        region = Region.combineRgn(region, region2, CombineMode.OR);
                        region2.deleteObject();
                    }
                } else if (!bl) {
                    bl = true;
                    n11 = n12;
                }
                ++n12;
            }
            if (bl) {
                Region region3 = Region.createRectRegion(n10, n11, n10 + 1, n3);
                region = Region.combineRgn(region, region3, CombineMode.OR);
                region3.deleteObject();
            }
            ++n10;
        }
        return region;
    }

    public static Region createFromImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        Region region = Region.createRectRegion(new Rect());
        int n4 = 0;
        while (n4 < n2) {
            boolean bl = false;
            boolean bl2 = false;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                int n7 = bufferedImage.getRGB(n4, n6);
                boolean bl3 = bl2 = (n7 & 0xFF000000) >> 24 == 0;
                if (bl2) {
                    if (bl) {
                        bl = false;
                        Region region2 = Region.createRectRegion(n4, n5, n4 + 1, n6 - 1);
                        region = Region.combineRgn(region, region2, CombineMode.OR);
                        region2.deleteObject();
                    }
                } else if (!bl) {
                    bl = true;
                    n5 = n6;
                }
                ++n6;
            }
            if (bl) {
                Region region3 = Region.createRectRegion(n4, n5, n4 + 1, n3);
                region = Region.combineRgn(region, region3, CombineMode.OR);
                region3.deleteObject();
            }
            ++n4;
        }
        return region;
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        b = b;
        d = d;
        f = f;
        r = r;
        o = o;
        p = p;
        t = t;
        u = u;
        k = k;
        m = m;
        c = c;
        s = s;
        q = q;
        a = a;
        v = v;
        RGN_ERROR = 0;
        NULLREGION = 1;
        SIMPLEREGION = 2;
        COMPLEXREGION = 3;
    }

    public static class CombineMode
    extends EnumItem {
        public static final CombineMode AND = new CombineMode(1);
        public static final CombineMode OR = new CombineMode(2);
        public static final CombineMode XOR = new CombineMode(3);
        public static final CombineMode DIFF = new CombineMode(4);
        public static final CombineMode COPY = new CombineMode(5);
        public static final CombineMode MIN = AND;
        public static final CombineMode MAX = COPY;

        private CombineMode(int n2) {
            super(n2);
        }
    }
}

