/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi.bitmap;

import com.jniwrapper.ArrayParameter;
import com.jniwrapper.Int8;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.win32.gdi.BitmapInfo;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;

public abstract class BitmapBuilder {
    private static final int f = 32;
    private static final int d = 4;
    private int g;
    private BufferedImage b;
    private int a;
    private PrimitiveArray c;

    protected BitmapBuilder(int n2, BufferedImage bufferedImage) {
        this.g = n2;
        this.b = bufferedImage;
        this.a = this.b();
        this.c = new PrimitiveArray(this.a(this.getScansizeBytes() * this.getHeight()));
    }

    public final BitmapInfo getBitmapInfo() {
        BitmapInfo bitmapInfo = this.getColorTableSize() > 0 ? new BitmapInfo(this.getColorTableSize()) : new BitmapInfo();
        this.buildColorTable(bitmapInfo.getColors());
        bitmapInfo.getBitmapInfoHeader().setWidth(this.getWidth());
        bitmapInfo.getBitmapInfoHeader().setHeight(this.getHeight());
        bitmapInfo.getBitmapInfoHeader().setPlanes(1L);
        bitmapInfo.getBitmapInfoHeader().setBitCount(this.getBitCount());
        bitmapInfo.getBitmapInfoHeader().setClrUsed(this.getColorTableSize());
        return bitmapInfo;
    }

    public abstract void setBitmapColors();

    protected int getBitCount() {
        return this.g;
    }

    protected final int getScansizeBytes() {
        return this.a;
    }

    private int b() {
        int n2 = this.getWidth() * this.getBitCount();
        return (n2 + 32 - 1) / 32 * 4;
    }

    protected void setBitmapByte(int n2, byte by) {
        this.c.setElement(n2, new Int8(by));
    }

    public int getWidth() {
        return this.b.getWidth();
    }

    public int getHeight() {
        return this.b.getHeight();
    }

    private byte[] a(int n2) {
        return new byte[n2];
    }

    protected abstract int getColorTableSize();

    protected abstract void buildColorTable(ArrayParameter var1);

    protected int getImageOffset(int n2, int n3) {
        return n2 + n3 * this.getWidth();
    }

    protected int getOffsetInBitmapBytes(int n2, int n3) {
        return this.getBitCount() * n2 / 8 + (this.getHeight() - n3 - 1) * this.getScansizeBytes();
    }

    public abstract Image getTransparentMask();

    protected BufferedImage getBufferedImage() {
        return this.b;
    }

    protected ColorModel getColorModel() {
        return this.b.getColorModel();
    }

    public PrimitiveArray getBitmapData() {
        return this.c;
    }

    static {
        f = 32;
        d = 4;
    }
}

