/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.registry;

import com.jniwrapper.Str;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.registry.RegistryEventListener;
import com.jniwrapper.win32.registry.RegistryException;
import com.jniwrapper.win32.registry.RegistryKeyValues;
import com.jniwrapper.win32.registry.WinRegistry;
import com.jniwrapper.win32.registry.f;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RegistryKey
extends EnumItem {
    public static final RegistryKey CLASSES_ROOT = new RegistryKey(Integer.MIN_VALUE, "HKEY_CLASSES_ROOT");
    public static final RegistryKey CURRENT_USER = new RegistryKey(-2147483647, "HKEY_CURRENT_USER");
    public static final RegistryKey LOCAL_MACHINE = new RegistryKey(-2147483646, "HKEY_LOCAL_MACHINE");
    public static final RegistryKey USERS = new RegistryKey(-2147483645, "HKEY_USERS");
    public static final RegistryKey PERFORMANCE_DATA = new RegistryKey(-2147483644, "HKEY_PERFORMANCE_DATA");
    public static final RegistryKey CURRENT_CONFIG = new RegistryKey(-2147483643, "HKEY_CURRENT_CONFIG");
    public static final RegistryKey DYN_DATA = new RegistryKey(-2147483642, "HKEY_DYN_DATA");
    static final int H = 65536;
    static final int M = 131072;
    static final int k = 262144;
    static final int O = 524288;
    static final int E = 0x100000;
    static final int Q = 983040;
    static final int b = 131072;
    static final int J = 131072;
    static final int F = 131072;
    static final int p = 0x1F0000;
    static final int x = 65535;
    static final int e = 0x1000000;
    static final int u = 0x2000000;
    static final int I = Integer.MIN_VALUE;
    static final int D = 0x40000000;
    static final int t = 0x20000000;
    static final int d = 0x10000000;
    static final int c = 1;
    static final int N = 2;
    static final int n = 4;
    static final int s = 8;
    static final int v = 16;
    static final int o = 32;
    static final int K = 131097;
    static final int A = 131078;
    static final int r = 131097;
    static final int l = 983103;
    static final int j = 0;
    static final int G = 0;
    static final int q = 1;
    static final int B = 2;
    static final int f = 4;
    static final int g = 8;
    static final int y = 15;
    static final int h = 0;
    static final int P = 2;
    static final int z = 260;
    private String R = "";
    private String i = "";
    private Handle w = new Handle();
    private int L = 0;
    private RegistryKeyValues m;
    private List S = new LinkedList();
    private boolean C = false;
    public static final int REG_NOTIFY_CHANGE_NAME = 1;
    public static final int REG_NOTIFY_CHANGE_ATTRIBUTES = 2;
    public static final int REG_NOTIFY_CHANGE_LAST_SET = 4;
    public static final int REG_NOTIFY_CHANGE_SECURITY = 8;

    private RegistryKey() {
        super(0);
    }

    private RegistryKey(int n2, String string) {
        super(n2);
        this.i = string;
    }

    public String getName() {
        return this.i;
    }

    public String getPath() {
        return this.R;
    }

    public String getAbsolutePath() {
        String string = this.getPath();
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.length() > 0 && !string.endsWith("\\")) {
            stringBuffer.append('\\');
        }
        stringBuffer.append(this.getName());
        return stringBuffer.toString();
    }

    protected void checkError() {
        if (this.L != 0) {
            throw new RegistryException(this.L);
        }
    }

    protected void checkError(long l2) {
        this.L = (int)l2;
        this.checkError();
    }

    public int getSubKeyCount() {
        UInt32 uInt32 = new UInt32();
        this.checkError(WinRegistry.queryInfoKey(this.getHandle(), (Str)null, null, uInt32, null, null, null, null, null));
        int n2 = (int)uInt32.getValue();
        return n2;
    }

    public void close() {
        this.checkError(WinRegistry.closeKey(this.getHandle()));
    }

    public RegistryKey createSubKey(String string, boolean bl) {
        RegistryKey registryKey = new RegistryKey();
        this.checkError(WinRegistry.createKey(this.getHandle(), string, 0L, bl ? 131103L : 131097L, registryKey.w));
        registryKey.R = this.getAbsolutePath();
        registryKey.i = string;
        return registryKey;
    }

    public RegistryKey createSubKey(String string) {
        return this.createSubKey(string, false);
    }

    public void deleteSubKey(String string) {
        this.checkError(WinRegistry.deleteKey(this.getHandle(), string));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RegistryKey)) {
            return false;
        }
        RegistryKey registryKey = (RegistryKey)object;
        return this.getHandle().getValue() == registryKey.getHandle().getValue();
    }

    public void flush() {
        this.checkError(WinRegistry.flushKey(this.getHandle()));
    }

    public List getSubKeyNames() {
        int n2 = this.getSubKeyCount();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        if (n2 > 0) {
            Handle handle = this.getHandle();
            int n3 = 0;
            int n4 = 0;
            while (n4 == 0) {
                Str str = new Str("", 260);
                n4 = (int)WinRegistry.enumKeyEx(handle, n3, str, new UInt32(260L), null, null);
                if (n4 == 0) {
                    arrayList.add(str.getValue());
                }
                ++n3;
            }
        }
        return arrayList;
    }

    public String toString() {
        return this.getName();
    }

    public RegistryKey openSubKey(String string) {
        return this.openSubKey(string, false, true);
    }

    public RegistryKey openSubKey(String string, boolean bl) {
        return this.openSubKey(string, bl, true);
    }

    public RegistryKey openSubKey(String string, boolean bl, boolean bl2) {
        RegistryKey registryKey = new RegistryKey();
        registryKey.L = (int)WinRegistry.openKey(this.getHandle(), string, bl ? 131103 : 131097, registryKey.w);
        registryKey.R = this.getAbsolutePath();
        registryKey.i = string;
        if (!bl2) {
            registryKey.checkError();
        }
        return registryKey;
    }

    public boolean exists(String string) {
        this.L = (int)WinRegistry.openKey(this.getHandle(), string, 131097, new Handle());
        return this.L != 2;
    }

    public List getSubkeys() {
        List list = this.getSubKeyNames();
        ArrayList<RegistryKey> arrayList = new ArrayList<RegistryKey>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            RegistryKey registryKey = this.openSubKey(string);
            arrayList.add(registryKey);
        }
        return arrayList;
    }

    public RegistryKeyValues values() {
        if (this.m == null) {
            this.m = new RegistryKeyValues(this);
        }
        return this.m;
    }

    public Handle getHandle() {
        if (this.w.isNull()) {
            this.checkError(WinRegistry.openKey(new Handle(this.getValue()), "", 131097, this.w));
        }
        return this.w;
    }

    public void addRegistryEventListener(RegistryEventListener registryEventListener) {
        if (!this.S.contains(registryEventListener)) {
            this.S.add(registryEventListener);
        }
    }

    public void removeRegistryEventListener(RegistryEventListener registryEventListener) {
        this.S.remove(registryEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRegistryEvent(EventObject eventObject) {
        LinkedList linkedList;
        RegistryKey registryKey = this;
        synchronized (registryKey) {
            linkedList = new LinkedList(this.S);
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            RegistryEventListener registryEventListener = (RegistryEventListener)iterator.next();
            registryEventListener.handle(eventObject);
        }
    }

    public void startChangeListening(boolean bl, int n2) {
        Thread thread = new Thread(new f(this, bl, n2));
        thread.start();
    }

    public void startChangeListening() {
        int n2 = 15;
        this.startChangeListening(true, n2);
    }

    public void stopChangeListening() {
        this.C = false;
        this.close();
    }

    static boolean a(RegistryKey registryKey, boolean bl) {
        registryKey.C = bl;
        return registryKey.C;
    }

    static boolean a(RegistryKey registryKey) {
        return registryKey.C;
    }

    static {
        H = 65536;
        M = 131072;
        k = 262144;
        O = 524288;
        E = 0x100000;
        Q = 983040;
        b = 131072;
        J = 131072;
        F = 131072;
        p = 0x1F0000;
        x = 65535;
        e = 0x1000000;
        u = 0x2000000;
        I = Integer.MIN_VALUE;
        D = 0x40000000;
        t = 0x20000000;
        d = 0x10000000;
        c = 1;
        N = 2;
        n = 4;
        s = 8;
        v = 16;
        o = 32;
        K = 131097;
        A = 131078;
        r = 131097;
        l = 983103;
        j = 0;
        G = 0;
        q = 1;
        B = 2;
        f = 4;
        g = 8;
        y = 15;
        h = 0;
        P = 2;
        z = 260;
        REG_NOTIFY_CHANGE_NAME = 1;
        REG_NOTIFY_CHANGE_ATTRIBUTES = 2;
        REG_NOTIFY_CHANGE_LAST_SET = 4;
        REG_NOTIFY_CHANGE_SECURITY = 8;
    }
}

