/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.WinFunctionCache;
import com.jniwrapper.win32.system.Kernel32;
import com.jniwrapper.win32.ui.Wnd;

public class User32
extends WinFunctionCache {
    public static final FunctionName FUNCTION_GET_MESSAGE = new FunctionName("GetMessage");
    public static final String FUNCTION_TRANSLATE_MESSAGE = "TranslateMessage";
    public static final FunctionName FUNCTION_DISPATCH_MESSAGE;
    public static final String FUNCTION_POST_QUIT_MESSAGE = "PostQuitMessage";
    public static final String FUNCTION_CREATE_ELLIPRIC_RGN = "CreateEllipticRgn";
    public static final FunctionName FUNCTION_LOAD_IMAGE;
    public static final String FUNCTION_CREATE_MENU = "CreateMenu";
    public static final String FUNCTION_CREATE_POPUP_MENU = "CreatePopupMenu";
    public static final String FUNCTION_SET_MENU = "SetMenu";
    public static final String FUNCTION_GET_MENU = "GetMenu";
    private static User32 a;

    private User32() {
        super("user32");
        this.setUnicode(Kernel32.getInstance().isUnicode());
    }

    public static User32 getInstance() {
        if (a == null) {
            a = new User32();
        }
        return a;
    }

    public static void postQuitMessage(int n2) {
        Function function = User32.getInstance().getFunction(FUNCTION_POST_QUIT_MESSAGE);
        function.invoke(null, new Int(n2));
    }

    public static Handle loadResourceFromFile(String string, int n2) {
        return User32.loadResourceFromFile(string, n2, 0, 0);
    }

    public static Handle loadResourceFromFile(String string, int n2, int n3, int n4) {
        Function function = User32.getInstance().getFunction(FUNCTION_LOAD_IMAGE.toString());
        Handle handle = new Handle();
        function.invoke((Parameter)handle, new Parameter[]{new Pointer(null, true), new Str(string), new UInt(n2), new Int(n3), new Int(n4), new UInt(32784L)});
        if (handle.isNull()) {
            throw new LastErrorException("Failed to load resource.", true);
        }
        return handle;
    }

    public static void setMenu(Wnd wnd, Handle handle) {
        Function function = User32.getInstance().getFunction(FUNCTION_SET_MENU);
        function.invoke(null, wnd, handle);
    }

    public static Handle getMenu(Wnd wnd) {
        Handle handle = new Handle();
        Function function = User32.getInstance().getFunction(FUNCTION_GET_MENU);
        function.invoke((Parameter)handle, wnd);
        return handle;
    }

    public static Handle createMenu() {
        Handle handle = new Handle();
        Function function = User32.getInstance().getFunction(FUNCTION_CREATE_MENU);
        function.invoke(handle);
        return handle;
    }

    public static Handle createPopupMenu() {
        Handle handle = new Handle();
        Function function = User32.getInstance().getFunction(FUNCTION_CREATE_POPUP_MENU);
        function.invoke((Parameter)handle, new Parameter[0]);
        return handle;
    }

    static {
        FUNCTION_TRANSLATE_MESSAGE = FUNCTION_TRANSLATE_MESSAGE;
        FUNCTION_DISPATCH_MESSAGE = new FunctionName("DispatchMessage");
        FUNCTION_POST_QUIT_MESSAGE = FUNCTION_POST_QUIT_MESSAGE;
        FUNCTION_CREATE_ELLIPRIC_RGN = FUNCTION_CREATE_ELLIPRIC_RGN;
        FUNCTION_LOAD_IMAGE = new FunctionName("LoadImage");
        FUNCTION_CREATE_MENU = FUNCTION_CREATE_MENU;
        FUNCTION_CREATE_POPUP_MENU = FUNCTION_CREATE_POPUP_MENU;
        FUNCTION_SET_MENU = FUNCTION_SET_MENU;
        FUNCTION_GET_MENU = FUNCTION_GET_MENU;
    }
}

