/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Int32;
import com.jniwrapper.Int8;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.ShortInt;
import com.jniwrapper.Str;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.WideString;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.Msg;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.Size;
import com.jniwrapper.win32.gdi.ColorRef;
import com.jniwrapper.win32.gdi.DC;
import com.jniwrapper.win32.gdi.Region;
import com.jniwrapper.win32.ui.FlashInfo;
import com.jniwrapper.win32.ui.PaintStruct;
import com.jniwrapper.win32.ui.User32;
import com.jniwrapper.win32.ui.WindowTools;
import java.awt.Component;

public class Wnd
extends Handle {
    public static final int GW_HWNDFIRST = 0;
    public static final int GW_HWNDLAST = 1;
    public static final int GW_HWNDNEXT = 2;
    public static final int GW_HWNDPREV = 3;
    public static final int GW_OWNER = 4;
    public static final int GW_CHILD = 5;
    private static final FunctionName h;
    private static final FunctionName z;
    private static final FunctionName t;
    private static final String F = "GetClassNameW";
    private static final String d = "GetWindow";
    private static final String E = "GetDesktopWindow";
    private static final String s = "UpdateWindow";
    private static final String y = "DestroyWindow";
    private static final String u = "GetWindowRect";
    private static final String c = "GetClientRect";
    private static final String v = "SetWindowRgn";
    private static final String f = "GetWindowRgn";
    private static final String w = "SetWindowPos";
    private static final String k = "MoveWindow";
    private static final String o = "BeginPaint";
    private static final String q = "EndPaint";
    private static final String B = "ShowWindow";
    private static final FunctionName D;
    private static final FunctionName a;
    private static final String l = "SetLayeredWindowAttributes";
    private static final String r = "RedrawWindow";
    private static final FunctionName C;
    private static final FunctionName j;
    private static final FunctionName g;
    private static final String A = "SetParent";
    private static final String p = "GetParent";
    private static final String m = "BringWindowToTop";
    private static final FunctionName b;
    private static final String n = "GetUpdateRect";
    private static final String x = "FlashWindowEx";
    public static final int WS_OVERLAPPED = 0;
    public static final int WS_POPUP = Integer.MIN_VALUE;
    public static final int WS_CHILD = 0x40000000;
    public static final int WS_MINIMIZE = 0x20000000;
    public static final int WS_VISIBLE = 0x10000000;
    public static final int WS_DISABLED = 0x8000000;
    public static final int WS_CLIPSIBLINGS = 0x4000000;
    public static final int WS_CLIPCHILDREN = 0x2000000;
    public static final int WS_MAXIMIZE = 0x1000000;
    public static final int WS_CAPTION = 0xC00000;
    public static final int WS_BORDER = 0x800000;
    public static final int WS_DLGFRAME = 0x400000;
    public static final int WS_VSCROLL = 0x200000;
    public static final int WS_HSCROLL = 0x100000;
    public static final int WS_SYSMENU = 524288;
    public static final int WS_THICKFRAME = 262144;
    public static final int WS_GROUP = 131072;
    public static final int WS_TABSTOP = 65536;
    public static final int WS_MINIMIZEBOX = 131072;
    public static final int WS_MAXIMIZEBOX = 65536;
    public static final int WS_OVERLAPPEDWINDOW = 0xCF0000;
    public static final int WS_POPUPWINDOW = -2138570752;
    public static final int WS_CHILDWINDOW = 0x40000000;
    public static final int WS_TILED = 0;
    public static final int WS_ICONIC = 0x20000000;
    public static final int WS_SIZEBOX = 262144;
    public static final int WS_TILEDWINDOW = 0xCF0000;
    public static final int WS_EX_DLGMODALFRAME = 1;
    public static final int WS_EX_NOPARENTNOTIFY = 4;
    public static final int WS_EX_TOPMOST = 8;
    public static final int WS_EX_ACCEPTFILES = 16;
    public static final int WS_EX_TRANSPARENT = 32;
    public static final int WS_EX_MDICHILD = 64;
    public static final int WS_EX_TOOLWINDOW = 128;
    public static final int WS_EX_WINDOWEDGE = 256;
    public static final int WS_EX_CLIENTEDGE = 512;
    public static final int WS_EX_CONTEXTHELP = 1024;
    public static final int WS_EX_RIGHT = 4096;
    public static final int WS_EX_LEFT = 0;
    public static final int WS_EX_RTLREADING = 8192;
    public static final int WS_EX_LTRREADING = 0;
    public static final int WS_EX_LEFTSCROLLBAR = 16384;
    public static final int WS_EX_RIGHTSCROLLBAR = 0;
    public static final int WS_EX_CONTROLPARENT = 65536;
    public static final int WS_EX_STATICEDGE = 131072;
    public static final int WS_EX_APPWINDOW = 262144;
    public static final int WS_EX_OVERLAPPEDWINDOW = 768;
    public static final int WS_EX_PALETTEWINDOW = 392;
    public static final int WS_EX_LAYERED = 524288;
    public static final int LWA_COLORKEY = 1;
    public static final int LWA_ALPHA = 2;
    public static final int SWP_NOSIZE = 1;
    public static final int SWP_NOMOVE = 2;
    public static final int SWP_NOZORDER = 4;
    public static final int SWP_NOREDRAW = 8;
    public static final int SWP_NOACTIVATE = 16;
    public static final int SWP_FRAMECHANGED = 32;
    public static final int SWP_SHOWWINDOW = 64;
    public static final int SWP_HIDEWINDOW = 128;
    public static final int SWP_NOCOPYBITS = 256;
    public static final int SWP_NOOWNERZORDER = 512;
    public static final int SWP_NOSENDCHANGING = 1024;
    public static final int SWP_DRAWFRAME = 32;
    public static final int SWP_NOREPOSITION = 512;
    public static final int SWP_DEFERERASE = 8192;
    public static final int SWP_ASYNCWINDOWPOS = 16384;
    public static final int HWND_TOP = 0;
    public static final int HWND_BOTTOM = 1;
    public static final int HWND_TOPMOST = -1;
    public static final int HWND_NOTOPMOST = -2;
    public static final int GWL_WNDPROC = -4;
    public static final int GWL_HINSTANCE = -6;
    public static final int GWL_HWNDPARENT = -8;
    public static final int GWL_STYLE = -16;
    public static final int GWL_EXSTYLE = -20;
    public static final int GWL_USERDATA = -21;
    public static final int GWL_ID = -12;
    public static final int RDW_INVALIDATE = 1;
    public static final int RDW_INTERNALPAINT = 2;
    public static final int RDW_ERASE = 4;
    public static final int RDW_VALIDATE = 8;
    public static final int RDW_NOINTERNALPAINT = 16;
    public static final int RDW_NOERASE = 32;
    public static final int RDW_NOCHILDREN = 64;
    public static final int RDW_ALLCHILDREN = 128;
    public static final int RDW_UPDATENOW = 256;
    public static final int RDW_ERASENOW = 512;
    public static final int RDW_FRAME = 1024;
    public static final int RDW_NOFRAME = 2048;

    public Wnd() {
    }

    public Wnd(long l2) {
        super(l2);
    }

    public Wnd(Component component) {
        this(WindowTools.getWindowHandle(component));
    }

    static Function a(Object object) {
        return User32.getInstance().getFunction(object.toString());
    }

    public void eventLoop() {
        Wnd.eventLoop(this.getValue());
    }

    public static void eventLoop(long l2) {
        if (l2 == 0L) {
            throw new IllegalArgumentException("Event processing window is not available");
        }
        Function function = Wnd.a(User32.FUNCTION_GET_MESSAGE);
        Function function2 = Wnd.a("TranslateMessage");
        Function function3 = Wnd.a(User32.FUNCTION_DISPATCH_MESSAGE);
        Wnd wnd = new Wnd(l2);
        ShortInt shortInt = new ShortInt(1L);
        Msg msg = new Msg();
        UInt32 uInt32 = new UInt32(0L);
        while (shortInt.getValue() != 0L) {
            Pointer pointer = new Pointer(msg);
            function.invoke(shortInt, pointer, wnd, uInt32, uInt32);
            if (shortInt.getValue() == -1L) break;
            function2.invoke(null, pointer);
            function3.invoke(null, pointer);
        }
    }

    public static Wnd findWindow(String string, String string2) {
        Function function = Wnd.a(h);
        Wnd wnd = new Wnd();
        Parameter parameter = string2 == null ? new Handle() : new Str(string2);
        Str str = new Str(string);
        function.invoke(wnd, new Pointer(str), new Pointer(parameter));
        return wnd;
    }

    public static Wnd findWindowEx(Wnd wnd, String string, String string2) {
        Function function = Wnd.a(z);
        Wnd wnd2 = new Wnd();
        Parameter parameter = string2 == null ? new Handle() : new Str(string2);
        Str str = new Str(string);
        function.invoke(wnd2, wnd != null ? wnd : new Handle(), new Handle(), new Pointer(str), new Pointer(parameter));
        return wnd2;
    }

    public static Wnd findWindow(String string) {
        return Wnd.findWindow(string, null);
    }

    public static Wnd findWindowByName(String string) {
        Function function = Wnd.a(h);
        Wnd wnd = new Wnd();
        function.invoke(wnd, new Pointer(null, true), new Str(string));
        return wnd;
    }

    public static Wnd getDesktopWindow() {
        Function function = Wnd.a(E);
        Wnd wnd = new Wnd();
        function.invoke(wnd);
        return wnd;
    }

    private static Wnd a(Object object, Parameter[] parameterArray) {
        Wnd wnd = new Wnd();
        Function function = Wnd.a(object);
        function.invoke((Parameter)wnd, parameterArray);
        if (wnd.getValue() == 0L) {
            throw new LastErrorException("Cannot create window.");
        }
        return wnd;
    }

    public static Wnd createWindow(String string, String string2, int n2, long l2, long l3, long l4, long l5, Wnd wnd, Handle handle, Handle handle2, Handle handle3) {
        return Wnd.a(t, new Parameter[]{new UInt(0L), new Str(string), new Str(string2), new Int(n2), new Int(l2), new Int(l3), new Int(l4), new Int(l5), wnd, handle, handle2, handle3});
    }

    public static Wnd createWindow(int n2, String string, String string2, int n3, long l2, long l3, long l4, long l5, Wnd wnd, Handle handle, Handle handle2, Handle handle3) {
        return Wnd.a(t, new Parameter[]{new Int32(n2), new Str(string), new Str(string2), new Int(n3), new Int(l2), new Int(l3), new Int(l4), new Int(l5), wnd, handle, handle2, handle3});
    }

    public static Wnd createWindow(String string) {
        Handle handle = new Handle();
        Wnd wnd = new Wnd();
        return Wnd.createWindow(0, string, string, 0, 0L, 0L, 0L, 0L, wnd, handle, handle, handle);
    }

    public void update() {
        Function function = Wnd.a(s);
        Int intVal = new Int();
        function.invoke((Parameter)intVal, this);
        if (intVal.getValue() == 0L) {
            throw new LastErrorException("Error updating window.");
        }
    }

    public void destroy() {
        Function function = Wnd.a(y);
        Int intVal = new Int();
        function.invoke((Parameter)intVal, this);
        if (intVal.getValue() == 0L) {
            throw new LastErrorException("Error destroying window.");
        }
    }

    public static void getWindowRect(Wnd wnd, Int intVal, Int intVal2) {
        Wnd.getWindowRect(wnd, new Int(), new Int(), intVal, intVal2);
    }

    public Size getSize() {
        Size size = new Size();
        Rect rect = this.getWindowRect();
        size.setCx(rect.getRightAsInt() - rect.getLeftAsInt());
        size.setCy(rect.getBottomAsInt() - rect.getTopAsInt());
        return size;
    }

    public Size getClientSize() {
        Size size = new Size();
        Rect rect = this.getClientRect();
        size.setCx(rect.getRightAsInt() - rect.getLeftAsInt());
        size.setCy(rect.getBottomAsInt() - rect.getTopAsInt());
        return size;
    }

    public static void getWindowRect(Wnd wnd, Int intVal, Int intVal2, Int intVal3, Int intVal4) {
        Function function = Wnd.a(u);
        function.invoke(null, wnd, new Pointer.OutOnly(new Structure(new Parameter[]{intVal, intVal2, intVal3, intVal4})));
    }

    public Rect getBounds() {
        Rect rect = new Rect();
        Function function = Wnd.a(u);
        function.invoke(null, this, new Pointer.OutOnly(rect));
        return rect;
    }

    public static void getWindowRect(Wnd wnd, Rect rect) {
        Function function = Wnd.a(u);
        function.invoke(null, wnd, new Pointer.OutOnly(rect));
    }

    public Rect getWindowRect() {
        Function function = Wnd.a(u);
        Rect rect = new Rect();
        function.invoke(null, this, new Pointer.OutOnly(rect));
        return rect;
    }

    public static void centerWindow(Wnd wnd) {
        wnd.centerInDesktop();
    }

    public void centerInDesktop() {
        Rect rect = Wnd.getDesktopWindow().getWindowRect();
        Rect rect2 = this.getWindowRect();
        long l2 = (rect.getRight() - rect2.getRight() - rect2.getLeft()) / 2L;
        long l3 = (rect.getBottom() - rect2.getBottom() - rect2.getTop()) / 2L;
        rect2.moveBy((int)l2, (int)l3);
        this.setPosition(new Wnd(), rect2.getLeft(), rect2.getTop(), rect2.getRight(), rect2.getBottom(), 21L);
    }

    public static boolean getClientRect(Wnd wnd, Rect rect) {
        Int intVal = new Int();
        Function function = Wnd.a(c);
        function.invoke(intVal, wnd, new Pointer.OutOnly(rect));
        return intVal.getValue() > 0L;
    }

    public Rect getClientRect() {
        Rect rect = new Rect();
        Function function = Wnd.a(c);
        function.invoke(null, this, new Pointer.OutOnly(rect));
        return rect;
    }

    public static void setWindowRgn(Wnd wnd, Region region, boolean bl) {
        wnd.setRegion(region, bl);
    }

    public void setRegion(Region region, boolean bl) {
        Function function = Wnd.a(v);
        function.invoke(null, this, region == null ? new Handle() : region, new Bool(bl));
    }

    public static Region getWindowRgn(Wnd wnd) {
        return wnd.getRegion();
    }

    public Region getRegion() {
        Region region = new Region();
        Function function = Wnd.a(f);
        function.invoke(null, this, region);
        return region;
    }

    public static boolean setWindowPos(Wnd wnd, Wnd wnd2, long l2, long l3, long l4, long l5, long l6) {
        Function function = Wnd.a(w);
        Bool bool = new Bool();
        function.invoke((Parameter)bool, new Parameter[]{wnd, wnd2, new Int(l2), new Int(l3), new Int(l4), new Int(l5), new UInt(l6)});
        return bool.getValue();
    }

    public boolean setPosition(Wnd wnd, long l2, long l3, long l4, long l5, long l6) {
        Function function = Wnd.a(w);
        Bool bool = new Bool();
        function.invoke((Parameter)bool, new Parameter[]{this, wnd, new Int(l2), new Int(l3), new Int(l4), new Int(l5), new UInt(l6)});
        return bool.getValue();
    }

    public DC beginPaint(PaintStruct paintStruct) {
        Function function = Wnd.a(o);
        DC dC = new DC();
        function.invoke(dC, this, new Pointer.OutOnly(paintStruct));
        if (dC.isNull()) {
            throw new LastErrorException("Failed to get DC.", true);
        }
        return dC;
    }

    public void endPaint(PaintStruct paintStruct) {
        Function function = User32.getInstance().getFunction(q);
        function.invoke(null, this, new Pointer.Const(paintStruct));
    }

    public boolean sendMessage(int n2, long l2, long l3) {
        Function function = Wnd.a(j);
        Bool bool = new Bool();
        function.invoke(bool, this, new UInt(n2), new UInt32(l2), new UInt32(l3));
        return bool.getValue();
    }

    public boolean peekMessage(long l2, boolean bl) {
        return this.peekMessage(new Msg(), l2, l2, bl);
    }

    public boolean peekMessage(Msg msg, long l2, long l3, boolean bl) {
        Function function = Wnd.a(C);
        Bool bool = new Bool();
        function.invoke((Parameter)bool, new Parameter[]{new Pointer(msg), this, new UInt(l2), new UInt(l3), new UInt(bl ? 1L : 0L)});
        return bool.getValue();
    }

    public boolean postMessage(int n2, long l2, long l3) {
        Function function = Wnd.a(g);
        Bool bool = new Bool();
        function.invoke(bool, this, new UInt(n2), new UInt32(l2), new UInt32(l3));
        return bool.getValue();
    }

    public void show(ShowWindowCommand showWindowCommand) {
        Function function = Wnd.a(B);
        function.invoke(null, this, new Int(showWindowCommand.getValue()));
    }

    public void setWindowLong(int n2, long l2) {
        this.setWindowLong(n2, new UInt(l2));
    }

    public long setWindowLong(int n2, Parameter parameter) {
        UInt uInt = new UInt();
        Function function = Wnd.a(D);
        function.invoke(uInt, this, new Int(n2), parameter);
        return uInt.getValue();
    }

    public long getWindowLong(int n2) {
        Function function = Wnd.a(a);
        UInt uInt = new UInt();
        function.invoke(uInt, this, new Int(n2));
        return uInt.getValue();
    }

    public void setLayeredWindowAttributes(int n2, byte by, int n3) {
        Function function = Wnd.a(l);
        function.invoke(null, this, new UInt32(n2), new Int8(by), new UInt(n3));
    }

    public void setLayeredWindowAttributes(ColorRef colorRef, byte by, int n2) {
        Function function = Wnd.a(l);
        function.invoke(null, this, colorRef == null ? new ColorRef(0L) : colorRef, new Int8(by), new UInt(n2));
    }

    public void redraw(Rect rect, Region region, int n2) {
        Function function = Wnd.a(r);
        function.invoke(null, this, new Pointer(rect, rect == null), region == null ? new Region() : region, new UInt(n2));
    }

    public void setParent(Wnd wnd) {
        Function function = Wnd.a(A);
        function.invoke(null, this, wnd);
    }

    public Wnd getParent() {
        Function function = Wnd.a(p);
        Wnd wnd = new Wnd();
        function.invoke((Parameter)wnd, this);
        return wnd;
    }

    public void bringToTop() {
        Function function = Wnd.a(m);
        function.invoke(null, this);
    }

    public static long callWindowProc(Handle handle, Wnd wnd, UInt uInt, UInt32 uInt32, UInt32 uInt322) {
        Function function = Wnd.a(b);
        UInt32 uInt323 = new UInt32();
        function.invoke((Parameter)uInt323, new Parameter[]{handle, wnd, uInt, uInt32, uInt322});
        return uInt323.getValue();
    }

    public static boolean moveWindow(Wnd wnd, int n2, int n3, int n4, int n5, boolean bl) {
        Function function = Wnd.a(k);
        Bool bool = new Bool();
        function.invoke((Parameter)bool, new Parameter[]{wnd, new Int(n2), new Int(n3), new Int(n4), new Int(n5), new Bool(bl)});
        return bool.getValue();
    }

    public void moveWindow(int n2, int n3, int n4, int n5, boolean bl) {
        Function function = Wnd.a(k);
        Bool bool = new Bool();
        function.invoke((Parameter)bool, new Parameter[]{this, new Int(n2), new Int(n3), new Int(n4), new Int(n5), new Bool(bl)});
    }

    public void moveWindow(int n2, int n3, int n4, int n5) {
        this.moveWindow(n2, n3, n4, n5, false);
    }

    public static boolean getUpdateRect(Wnd wnd, Rect rect, boolean bl) {
        return wnd.getUpdateRect(rect, bl);
    }

    public boolean getUpdateRect(Rect rect, boolean bl) {
        Function function = Wnd.a(n);
        Bool bool = new Bool();
        function.invoke(bool, this, new Pointer.OutOnly(rect), new Bool(bl));
        return bool.getValue();
    }

    public boolean getUpdateRect(Rect rect) {
        return this.getUpdateRect(rect, false);
    }

    public boolean flashWindow(FlashInfo flashInfo) {
        Function function = Wnd.a(x);
        Bool bool = new Bool();
        function.invoke((Parameter)bool, new Pointer(flashInfo));
        return bool.getValue();
    }

    public String getClassName() {
        WideString wideString = new WideString();
        User32.getInstance().getFunction(F).invoke(null, this, wideString, new Int(wideString.getMaxLength()));
        return wideString.getValue();
    }

    public Wnd getWindow(int n2) {
        Wnd wnd = new Wnd();
        User32.getInstance().getFunction(d).invoke(wnd, this, new UInt(n2));
        return wnd;
    }

    public Object clone() {
        return new Wnd(this.getValue());
    }

    static {
        GW_HWNDFIRST = 0;
        GW_HWNDLAST = 1;
        GW_HWNDNEXT = 2;
        GW_HWNDPREV = 3;
        GW_OWNER = 4;
        GW_CHILD = 5;
        h = new FunctionName("FindWindow");
        z = new FunctionName("FindWindowEx");
        t = new FunctionName("CreateWindowEx");
        F = F;
        d = d;
        E = E;
        s = s;
        y = y;
        u = u;
        c = c;
        v = v;
        f = f;
        w = w;
        k = k;
        o = o;
        q = q;
        B = B;
        D = new FunctionName("SetWindowLong");
        a = new FunctionName("GetWindowLong");
        l = l;
        r = r;
        C = new FunctionName("PeekMessage");
        j = new FunctionName("SendMessage");
        g = new FunctionName("PostMessage");
        A = A;
        p = p;
        m = m;
        b = new FunctionName("CallWindowProc");
        n = n;
        x = x;
        WS_OVERLAPPED = 0;
        WS_POPUP = Integer.MIN_VALUE;
        WS_CHILD = 0x40000000;
        WS_MINIMIZE = 0x20000000;
        WS_VISIBLE = 0x10000000;
        WS_DISABLED = 0x8000000;
        WS_CLIPSIBLINGS = 0x4000000;
        WS_CLIPCHILDREN = 0x2000000;
        WS_MAXIMIZE = 0x1000000;
        WS_CAPTION = 0xC00000;
        WS_BORDER = 0x800000;
        WS_DLGFRAME = 0x400000;
        WS_VSCROLL = 0x200000;
        WS_HSCROLL = 0x100000;
        WS_SYSMENU = 524288;
        WS_THICKFRAME = 262144;
        WS_GROUP = 131072;
        WS_TABSTOP = 65536;
        WS_MINIMIZEBOX = 131072;
        WS_MAXIMIZEBOX = 65536;
        WS_OVERLAPPEDWINDOW = 0xCF0000;
        WS_POPUPWINDOW = -2138570752;
        WS_CHILDWINDOW = 0x40000000;
        WS_TILED = 0;
        WS_ICONIC = 0x20000000;
        WS_SIZEBOX = 262144;
        WS_TILEDWINDOW = 0xCF0000;
        WS_EX_DLGMODALFRAME = 1;
        WS_EX_NOPARENTNOTIFY = 4;
        WS_EX_TOPMOST = 8;
        WS_EX_ACCEPTFILES = 16;
        WS_EX_TRANSPARENT = 32;
        WS_EX_MDICHILD = 64;
        WS_EX_TOOLWINDOW = 128;
        WS_EX_WINDOWEDGE = 256;
        WS_EX_CLIENTEDGE = 512;
        WS_EX_CONTEXTHELP = 1024;
        WS_EX_RIGHT = 4096;
        WS_EX_LEFT = 0;
        WS_EX_RTLREADING = 8192;
        WS_EX_LTRREADING = 0;
        WS_EX_LEFTSCROLLBAR = 16384;
        WS_EX_RIGHTSCROLLBAR = 0;
        WS_EX_CONTROLPARENT = 65536;
        WS_EX_STATICEDGE = 131072;
        WS_EX_APPWINDOW = 262144;
        WS_EX_OVERLAPPEDWINDOW = 768;
        WS_EX_PALETTEWINDOW = 392;
        WS_EX_LAYERED = 524288;
        LWA_COLORKEY = 1;
        LWA_ALPHA = 2;
        SWP_NOSIZE = 1;
        SWP_NOMOVE = 2;
        SWP_NOZORDER = 4;
        SWP_NOREDRAW = 8;
        SWP_NOACTIVATE = 16;
        SWP_FRAMECHANGED = 32;
        SWP_SHOWWINDOW = 64;
        SWP_HIDEWINDOW = 128;
        SWP_NOCOPYBITS = 256;
        SWP_NOOWNERZORDER = 512;
        SWP_NOSENDCHANGING = 1024;
        SWP_DRAWFRAME = 32;
        SWP_NOREPOSITION = 512;
        SWP_DEFERERASE = 8192;
        SWP_ASYNCWINDOWPOS = 16384;
        HWND_TOP = 0;
        HWND_BOTTOM = 1;
        HWND_TOPMOST = -1;
        HWND_NOTOPMOST = -2;
        GWL_WNDPROC = -4;
        GWL_HINSTANCE = -6;
        GWL_HWNDPARENT = -8;
        GWL_STYLE = -16;
        GWL_EXSTYLE = -20;
        GWL_USERDATA = -21;
        GWL_ID = -12;
        RDW_INVALIDATE = 1;
        RDW_INTERNALPAINT = 2;
        RDW_ERASE = 4;
        RDW_VALIDATE = 8;
        RDW_NOINTERNALPAINT = 16;
        RDW_NOERASE = 32;
        RDW_NOCHILDREN = 64;
        RDW_ALLCHILDREN = 128;
        RDW_UPDATENOW = 256;
        RDW_ERASENOW = 512;
        RDW_FRAME = 1024;
        RDW_NOFRAME = 2048;
    }

    public static class ShowWindowCommand
    extends EnumItem {
        public static final ShowWindowCommand HIDE = new ShowWindowCommand(0);
        public static final ShowWindowCommand SHOWNORMAL = new ShowWindowCommand(1);
        public static final ShowWindowCommand NORMAL = new ShowWindowCommand(1);
        public static final ShowWindowCommand SHOWMINIMIZED = new ShowWindowCommand(2);
        public static final ShowWindowCommand SHOWMAXIMIZED = new ShowWindowCommand(3);
        public static final ShowWindowCommand MAXIMIZE = new ShowWindowCommand(3);
        public static final ShowWindowCommand SHOWNOACTIVATE = new ShowWindowCommand(4);
        public static final ShowWindowCommand SHOW = new ShowWindowCommand(5);
        public static final ShowWindowCommand MINIMIZE = new ShowWindowCommand(6);
        public static final ShowWindowCommand SHOWMINNOACTIVE = new ShowWindowCommand(7);
        public static final ShowWindowCommand SHOWNA = new ShowWindowCommand(8);
        public static final ShowWindowCommand RESTORE = new ShowWindowCommand(9);
        public static final ShowWindowCommand SHOWDEFAULT = new ShowWindowCommand(10);
        public static final ShowWindowCommand FORCEMINIMIZE = new ShowWindowCommand(11);
        public static final ShowWindowCommand MAX = new ShowWindowCommand(11);

        protected ShowWindowCommand(int n2) {
            super(n2);
        }
    }
}

