/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.bean.multiplayer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class JMFUtil {
    private static Locale locale;
    private static ListResourceBundle res;
    private static ListResourceBundle beanInfoRes;
    private static String lang;
    private static String ctry;

    public static String getString(String string) {
        if (res == null) {
            JMFUtil.setResourceBundle(null);
        }
        return res.getString(string);
    }

    public static String getLang() {
        return lang;
    }

    public static void setResourceBundle(Locale locale) {
        JMFUtil.locale = Locale.getDefault();
        try {
            res = (ListResourceBundle)ResourceBundle.getBundle("com.ibm.media.bean.multiplayer.nls.JMFConst", JMFUtil.locale);
        }
        catch (MissingResourceException missingResourceException) {
            JMFUtil.locale = new Locale("en", "US");
            res = (ListResourceBundle)ResourceBundle.getBundle("com.ibm.media.bean.multiplayer.nls.JMFConst", JMFUtil.locale);
            System.out.println("Locale not supported, defaulting to english-US.");
        }
        lang = JMFUtil.locale.getLanguage();
        ctry = JMFUtil.locale.getCountry();
    }

    public static String getBIString(String string) {
        if (beanInfoRes == null) {
            JMFUtil.setBIResourceBundle(null);
        }
        return beanInfoRes.getString(string);
    }

    public static void setBIResourceBundle(Locale locale) {
        JMFUtil.locale = Locale.getDefault();
        try {
            beanInfoRes = (ListResourceBundle)ResourceBundle.getBundle("com.ibm.media.bean.multiplayer.nls.MultiPlayerBeanInfoResources", JMFUtil.locale);
        }
        catch (MissingResourceException missingResourceException) {
            JMFUtil.locale = new Locale("en", "US");
            beanInfoRes = (ListResourceBundle)ResourceBundle.getBundle("com.ibm.media.bean.multiplayer.nls.MultiPlayerBeanInfoResources", JMFUtil.locale);
            System.out.println("Locale not supported, defaulting to english-US.");
        }
        lang = JMFUtil.locale.getLanguage();
        ctry = JMFUtil.locale.getCountry();
    }

    public static Locale getLocale(String string) {
        if (string == null) {
            return Locale.getDefault();
        }
        String string2 = string.trim().toUpperCase();
        if (string2.compareTo("FRANCE") == 0) {
            return Locale.FRANCE;
        }
        if (string2.compareTo("GERMANY") == 0) {
            return Locale.GERMANY;
        }
        if (string2.compareTo("ITALY") == 0) {
            return Locale.ITALY;
        }
        if (string2.compareTo("JAPAN") == 0) {
            return Locale.JAPAN;
        }
        if (string2.compareTo("KOREA") == 0) {
            return Locale.KOREA;
        }
        if (string2.compareTo("CHINA") == 0) {
            return Locale.CHINA;
        }
        if (string2.compareTo("PRC") == 0) {
            return Locale.PRC;
        }
        if (string2.compareTo("TAIWAN") == 0) {
            return Locale.TAIWAN;
        }
        if (string2.compareTo("UK") == 0) {
            return Locale.UK;
        }
        if (string2.compareTo("US") == 0) {
            return Locale.US;
        }
        if (string2.compareTo("CANADA") == 0) {
            return Locale.CANADA;
        }
        if (string2.compareTo("CANADA_FRENCH") == 0) {
            return Locale.CANADA_FRENCH;
        }
        return null;
    }

    public static Panel doGridbagLayout2(Component[] componentArray, int n, int n2) {
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        panel.setBackground(Color.lightGray);
        panel.setForeground(Color.black);
        gridBagConstraints.insets = new Insets(1, 0, 0, 1);
        gridBagConstraints.anchor = 17;
        int n3 = 0;
        while (n3 < componentArray.length) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            if (n3 % n - n + 1 == 0) {
                gridBagConstraints.gridwidth = 0;
            }
            if (n3 % n - n2 + 1 == 0) {
                gridBagConstraints.fill = 2;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.weightx = 1.0;
            }
            gridBagLayout.setConstraints(componentArray[n3], gridBagConstraints);
            panel.add(componentArray[n3], gridBagConstraints);
            ++n3;
        }
        return panel;
    }

    public static void centerComponent(Panel panel, Component component) {
        JMFUtil.doDebug("centerComponent");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        panel.add(component, gridBagConstraints);
    }

    public static float aspectRatio(float f, float f2, int n) {
        return f / (f2 - (float)n);
    }

    public static void center(Panel panel, Component component, boolean bl, int n) {
        int n2 = panel.getSize().width;
        int n3 = panel.getSize().height;
        component.setBounds(panel.getInsets().left, panel.getInsets().top, n2 - panel.getInsets().left - panel.getInsets().right, n3 - panel.getInsets().top - panel.getInsets().bottom);
    }

    public static void setCenterLocation(Frame frame, Frame frame2, int n, int n2) {
        Rectangle rectangle;
        JMFUtil.doDebug("setCenterLocation");
        if (frame2 != null) {
            rectangle = frame2.getBounds();
        } else {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            rectangle = new Rectangle(new Point(0, 0), dimension);
        }
        ((Component)frame).setSize(n, n2);
        ((Component)frame).setLocation(rectangle.x + (rectangle.width - n) / 2, rectangle.y + (rectangle.height - n2) / 2);
    }

    public static void copyStringArray(String[] stringArray, String[] stringArray2) {
        if (stringArray == null | stringArray2 == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = stringArray[n];
            ++n;
        }
    }

    public static void copyShortenStringArray(String[] stringArray, String[] stringArray2, int n, int n2) {
        if (stringArray == null | stringArray2 == null) {
            return;
        }
        int n3 = 0;
        while (n3 < stringArray2.length) {
            stringArray2[n3] = n3 >= n ? stringArray[n3 + n2] : stringArray[n3];
            ++n3;
        }
    }

    public static String parseArrayIntoString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                if (n != stringArray.length - 1) {
                    stringBuffer.append(",");
                }
                JMFUtil.doDebug(stringBuffer.toString());
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public static String[] parseStringIntoArray(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        String string2 = string;
        String string3 = "";
        String[] stringArray = null;
        int n = 0;
        Vector<String> vector = new Vector<String>();
        int n2 = -1;
        JMFUtil.doDebug("Value = " + string);
        n2 = string2.indexOf(",");
        n = string2.length();
        while (n2 != -1) {
            string3 = string2.substring(0, n2);
            vector.addElement(string3);
            if (n2 + 1 < n) {
                string2 = string2.substring(n2 + 1, n);
            } else if (n2 + 1 == n) {
                string2 = "";
                vector.addElement("");
            }
            n2 = string2.indexOf(",");
            n = string2.length();
        }
        if (string2 != null & n != 0) {
            vector.addElement(string2.substring(0, n));
        }
        stringArray = new String[vector.size()];
        int n3 = 0;
        while (n3 < vector.size()) {
            stringArray[n3] = (String)vector.elementAt(n3);
            ++n3;
        }
        return stringArray;
    }

    public static String convertString(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() == 0) {
            return string;
        }
        boolean bl = false;
        int n = -1;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            if (stringBuffer.charAt(n2) == '\\' || stringBuffer.charAt(n2) == '\"') {
                stringBuffer.insert(n2, "\\");
                ++n2;
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static boolean msVersion() {
        boolean bl;
        try {
            Class<?> clazz = Class.forName("com.ms.util.SystemVersionManager");
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private static void doDebug(String string) {
    }

    static {
        lang = null;
        ctry = null;
    }
}

