/*
 * Decompiled with CFR 0.152.
 */
package quicktime.internal.jdirect;

import quicktime.internal.jdirect.ArrayCopy;
import quicktime.internal.jdirect.Struct;

public class DoubleArrayStruct
extends Struct {
    protected double[] doubles;
    private int logicalSize;

    protected DoubleArrayStruct(int sizeInBytes) {
        this.logicalSize = sizeInBytes;
        this.doubles = new double[(sizeInBytes + 7) / 8];
    }

    protected final byte getByteAt(int byteOffset) {
        long bits = Double.doubleToRawLongBits(this.doubles[byteOffset / 8]);
        int inset = byteOffset % 8;
        if (inset == Struct.LONG_HIGH_BYTE_OFFSET) {
            return (byte)bits;
        }
        if (inset == Struct.LONG_SEVEN_BYTE_OFFSET) {
            return (byte)(bits >>> 8);
        }
        if (inset == Struct.LONG_SIX_BYTE_OFFSET) {
            return (byte)(bits >>> 16);
        }
        if (inset == Struct.LONG_FIVE_BYTE_OFFSET) {
            return (byte)(bits >>> 24);
        }
        if (inset == Struct.LONG_FOUR_BYTE_OFFSET) {
            return (byte)(bits >>> 32);
        }
        if (inset == Struct.LONG_THREE_BYTE_OFFSET) {
            return (byte)(bits >>> 40);
        }
        if (inset == Struct.LONG_TWO_BYTE_OFFSET) {
            return (byte)(bits >>> 48);
        }
        return (byte)(bits >>> 56);
    }

    protected double getDoubleAt(int byteOffset) {
        if (byteOffset % 8 == 0) {
            return this.doubles[byteOffset / 8];
        }
        return super.getDoubleAt(byteOffset);
    }

    protected final void setByteAt(int byteOffset, byte value) {
        long bits = Double.doubleToRawLongBits(this.doubles[byteOffset / 8]);
        long longValue = value & 0xFF;
        int inset = byteOffset % 8;
        bits = inset == Struct.LONG_HIGH_BYTE_OFFSET ? (bits |= longValue) : (inset == Struct.LONG_SEVEN_BYTE_OFFSET ? (bits |= longValue << 8) : (inset == Struct.LONG_SIX_BYTE_OFFSET ? (bits |= longValue << 16) : (inset == Struct.LONG_FIVE_BYTE_OFFSET ? (bits |= longValue << 24) : (inset == Struct.LONG_FOUR_BYTE_OFFSET ? (bits |= longValue << 32) : (inset == Struct.LONG_THREE_BYTE_OFFSET ? (bits |= longValue << 40) : (inset == Struct.LONG_TWO_BYTE_OFFSET ? (bits |= longValue << 48) : (bits |= longValue << 56)))))));
        this.doubles[byteOffset / 8] = Double.longBitsToDouble(bits);
    }

    protected void setDoubleAt(int byteOffset, double value) {
        if (byteOffset % 8 == 0) {
            this.doubles[byteOffset / 8] = value;
        } else {
            super.setDoubleAt(byteOffset, value);
        }
    }

    protected void setBytesAt(int byteOffset, byte[] source) {
        ArrayCopy.copyArrayToArray(source, 0, this.doubles, byteOffset, source.length);
    }

    protected void setStructAt(int byteOffset, Struct src) {
        int srcByteCount = src.getSize();
        ArrayCopy.copyArrayToArray(src.getBytesAt(0, srcByteCount), 0, this.doubles, byteOffset, srcByteCount);
    }

    public byte[] getBytesAt(int byteOffset, int byteCount) {
        byte[] result = new byte[byteCount];
        ArrayCopy.copyArrayToArray(this.doubles, byteOffset, result, 0, byteCount);
        return result;
    }

    public byte[] getBytes() {
        return this.getBytesAt(0, this.getSize());
    }

    public final double[] getArray() {
        return this.doubles;
    }

    public final int getSize() {
        return this.logicalSize;
    }
}

