/*
 * Decompiled with CFR 0.152.
 */
package quicktime.internal.jdirect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import quicktime.internal.jdirect.FieldScanner;
import quicktime.internal.jdirect.JDAccessController;
import quicktime.internal.jdirect.JDPrivilegedAction;
import quicktime.internal.jdirect.Linkage;
import quicktime.internal.jdirect.LinkageFactory;
import quicktime.internal.jdirect.Logger;
import quicktime.internal.jdirect.ThunkFactory;

abstract class LinkerAbstract {
    public static final LinkerAbstract kPlatformLinker = LinkerAbstract.getPlaformLinker();
    static final String kLibraryStringName = kPlatformLinker.doGetLibraryFieldName();
    static final String kLockObjectStringName = kPlatformLinker.doGetLockObjectFieldName();
    private static final Class kJavaNioBuffer = LinkerAbstract.findClass("java.nio.Buffer");
    static /* synthetic */ Class class$quicktime$internal$jdirect$LinkerAbstract;

    LinkerAbstract() {
    }

    abstract Object processLibraryStringsInfo(Vector var1);

    abstract long findFunction(Linkage var1, String var2);

    abstract String functionNotFoundMessage(Linkage var1, String var2);

    abstract String doGetLibraryFieldName();

    abstract String doGetLockObjectFieldName();

    abstract String doGetJNILibraryName();

    public static Linkage link(Class targetClass, int linkageIndex, long threadID) {
        return kPlatformLinker.doLink(targetClass, linkageIndex, threadID);
    }

    public static long createMethodClosure(long targetObjectGlobalRef, String methodName, String methodSignature, long unlockDuringCallback) {
        return kPlatformLinker.doCreateMethodClosure(targetObjectGlobalRef, methodName, methodSignature, unlockDuringCallback);
    }

    public static void disposeMethodClosure(long closure) {
        kPlatformLinker.doDisposeMethodClosure(closure);
    }

    public static String getShellVariable(String variableName) {
        return kPlatformLinker.doGetShellVariable(variableName);
    }

    public static long createLockFromObject(Object objlock) {
        return kPlatformLinker.doCreateLockFromObject(objlock);
    }

    public static void releaseLockFromObject(long objlock) {
        kPlatformLinker.doReleaseLockFromObject(objlock);
    }

    static String getJNILibraryName() {
        return kPlatformLinker.doGetJNILibraryName();
    }

    protected Linkage doLink(Class targetClass, int linkageIndex, long threadID) {
        if (targetClass != null) {
            Method[] declaredMethods = LinkerAbstract.getMethods(targetClass);
            int nativeMethodCount = 0;
            int i = 0;
            while (i < declaredMethods.length) {
                Method method = declaredMethods[i];
                if (Modifier.isNative(method.getModifiers())) {
                    ++nativeMethodCount;
                }
                ++i;
            }
            boolean logLoads = Logger.shouldLogLoadingForClass(targetClass.getName());
            if (nativeMethodCount == 0) {
                if (logLoads) {
                    System.err.println("JDirect: No native methods found in class " + targetClass.getName());
                }
            } else {
                if (logLoads) {
                    System.err.println("JDirect: Linking class " + targetClass.getName());
                    System.err.println("         Scanning inheritance:");
                }
                FieldScanner fieldValues = new FieldScanner(targetClass, kLibraryStringName, kLockObjectStringName, logLoads);
                Object libInfo = kPlatformLinker.processLibraryStringsInfo(fieldValues.getLibraries());
                long table = this.createJumpTable(nativeMethodCount, linkageIndex);
                String[] methodNames = new String[nativeMethodCount];
                String[] methodSignatures = new String[nativeMethodCount];
                int nativeMethodIndex = 0;
                int i2 = 0;
                while (i2 < declaredMethods.length) {
                    Method method = declaredMethods[i2];
                    if (Modifier.isNative(method.getModifiers())) {
                        String methodName = method.getName();
                        String methodSignature = LinkerAbstract.getSignature(method);
                        this.installJNINativeMethod(targetClass, methodName, methodSignature, this.getJumpTableEntry(table, nativeMethodCount, nativeMethodIndex));
                        String enhancedSig = methodSignature;
                        if (threadID != 0L) {
                            enhancedSig = "&" + enhancedSig;
                        }
                        if (fieldValues.getLock() != null) {
                            enhancedSig = "+" + enhancedSig;
                        }
                        if (Logger.shouldLogInvocationForClass(targetClass.getName())) {
                            enhancedSig = "~" + enhancedSig;
                        }
                        methodSignatures[nativeMethodIndex] = enhancedSig;
                        methodNames[nativeMethodIndex] = methodName;
                        ++nativeMethodIndex;
                    }
                    ++i2;
                }
                if (logLoads) {
                    System.err.println("         Created jumptable at: 0x" + Long.toHexString(table));
                    System.err.println("         With native method count: " + nativeMethodCount);
                    System.err.println("         Functions will be searched for in:");
                    int i3 = 0;
                    while (i3 < fieldValues.getLibraries().size()) {
                        System.err.println("              " + fieldValues.getLibraries().elementAt(i3));
                        ++i3;
                    }
                }
                return new Linkage(targetClass, methodNames, methodSignatures, fieldValues.getLock(), libInfo, table, threadID);
            }
        }
        return null;
    }

    protected static Method[] getMethods(final Class targetClass) {
        return (Method[])JDAccessController.doPrivileged(new JDPrivilegedAction(){

            public Object run() {
                return targetClass.getDeclaredMethods();
            }
        });
    }

    static long lazyPatchJumpTableEntry(Object targetClass, int linkageIndex, int methodIndex) {
        if (targetClass instanceof Class) {
            return kPlatformLinker.patch(LinkageFactory.getLinkage(linkageIndex), linkageIndex, methodIndex);
        }
        throw new LinkageError("JDirect native methods must be static");
    }

    static String getMethodName(int linkageIndex, int methodIndex) {
        Linkage linkage = LinkageFactory.getLinkage(linkageIndex);
        return linkage.target.getName() + "." + linkage.methodNames[methodIndex];
    }

    private static LinkerAbstract getPlaformLinker() {
        String linkerName;
        String thisClassName = (class$quicktime$internal$jdirect$LinkerAbstract == null ? (class$quicktime$internal$jdirect$LinkerAbstract = LinkerAbstract.class$("quicktime.internal.jdirect.LinkerAbstract")) : class$quicktime$internal$jdirect$LinkerAbstract).getName();
        String packagePrefix = thisClassName.substring(0, thisClassName.lastIndexOf(46) + 1);
        String os_name = System.getProperty("os.name");
        String os_arch = System.getProperty("os.arch");
        if (os_name.equals("Mac OS") && os_arch.equals("PowerPC")) {
            linkerName = packagePrefix + "LinkerMacOS";
        } else if (os_name.equals("Mac OS X") || os_name.equals("Darwin")) {
            linkerName = packagePrefix + "LinkerMacOSX";
        } else {
            System.err.println("JDirect disabled:  unknown os.arch and os.name");
            linkerName = packagePrefix + "LinkerAbstract";
        }
        try {
            return (LinkerAbstract)Class.forName(linkerName).newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.println("JDirect disabled:  class " + linkerName + " not found");
        }
        catch (Throwable t) {
            System.err.println("JDirect disabled");
            t.printStackTrace();
        }
        return null;
    }

    static void loadJNILibrary(final String name) {
        JDAccessController.doPrivileged(new JDPrivilegedAction(){

            public Object run() {
                System.load(name);
                return null;
            }
        });
    }

    static void loadJNILibrary() {
        LinkerAbstract.loadJNILibrary(LinkerAbstract.getJNILibraryName());
    }

    protected static void checkSignatureErrors(Class target, String methodName, String methodSignature) {
        String message = null;
        int closeParen = methodSignature.indexOf(41);
        if (closeParen != -1 && methodSignature.charAt(closeParen + 1) == '[') {
            message = "JDirect native methods cannot have array return types";
        } else if (closeParen != -1 && methodSignature.charAt(closeParen + 1) == 'L') {
            message = "JDirect native methods cannot have Object return types";
        } else if (methodSignature.indexOf("[Z") != -1) {
            message = "JDirect native methods cannot have boolean array parameters";
        } else if (methodSignature.indexOf(59) != -1) {
            if (kJavaNioBuffer == null) {
                message = "JDirect native methods cannot have Objects as parameters unless running on JDK 1.4 or later";
            } else {
                int offset = 0;
                boolean done = false;
                while (!done) {
                    int start = methodSignature.indexOf(76, offset);
                    if (start != -1) {
                        Class<?> compileTimeParamType;
                        int end = methodSignature.indexOf(59, start);
                        String objParamClassName = methodSignature.substring(start + 1, end - 1);
                        try {
                            compileTimeParamType = Class.forName(objParamClassName);
                        }
                        catch (ClassNotFoundException x) {
                            compileTimeParamType = null;
                        }
                        if (compileTimeParamType != null && kJavaNioBuffer.isAssignableFrom(compileTimeParamType)) continue;
                        message = "JDirect native methods cannot have a parameter of type " + objParamClassName + " because it is not a subclass of java.nio.Buffer";
                        done = true;
                        continue;
                    }
                    done = true;
                }
            }
        }
        if (message != null) {
            if (Logger.shouldLogInvocationForClass(target.getName())) {
                System.err.println("\tmethod \"" + methodName + "\" has an illegal JDirect signature \"" + methodSignature + "\"");
            }
            throw new LinkageError(message);
        }
    }

    protected static String getSignature(Method method) {
        StringBuffer sig = new StringBuffer();
        sig.append('(');
        Class<?>[] paramTypes = method.getParameterTypes();
        int paramCount = paramTypes.length;
        int i = 0;
        while (i < paramCount) {
            sig.append(LinkerAbstract.getSignaturePart(paramTypes[i]));
            ++i;
        }
        sig.append(')');
        sig.append(LinkerAbstract.getSignaturePart(method.getReturnType()));
        return sig.toString();
    }

    protected static String getSignaturePart(Class type) {
        String name = type.getName();
        if (type.isPrimitive()) {
            char ch = Character.toUpperCase(name.charAt(0));
            switch (ch) {
                case 'B': {
                    if (type == Byte.TYPE) {
                        return "B";
                    }
                    return "Z";
                }
                case 'L': {
                    return "J";
                }
            }
            char[] buf = new char[]{ch};
            return new String(buf);
        }
        if (type.isArray()) {
            return "[" + LinkerAbstract.getSignaturePart(type.getComponentType());
        }
        return "L" + name.replace('.', '/') + ";";
    }

    protected long patch(Linkage linkage, int linkageIndex, int methodIndex) {
        String methodName = linkage.methodNames[methodIndex];
        LinkerAbstract.checkSignatureErrors(linkage.target, methodName, linkage.methodSignatures[methodIndex]);
        long func = this.findFunction(linkage, methodName);
        if (func != 0L) {
            return this.patch(linkage, linkageIndex, methodIndex, func);
        }
        throw new LinkageError(this.functionNotFoundMessage(linkage, methodName));
    }

    protected long patch(Linkage linkage, int linkageIndex, int methodIndex, long func) {
        return this.patch(linkage, linkageIndex, methodIndex, func, linkage.methodSignatures[methodIndex]);
    }

    protected long patch(Linkage linkage, int linkageIndex, int methodIndex, long func, String methodSignature) {
        return this.patchJumpTableEntry(linkage.jumpTableBase, linkage.methodNames.length, methodIndex, linkageIndex, ThunkFactory.get(methodSignature), func, linkage.lockGlobalRefOrThreadID);
    }

    protected long doCreateLockFromObject(Object lockObj) {
        return LinkerAbstract.createGlobalRef(lockObj);
    }

    protected void doReleaseLockFromObject(long lockObj) {
        LinkerAbstract.releaseGlobalRef(lockObj);
    }

    private static Class findClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException x) {
            return null;
        }
    }

    private static native void init();

    native long createJumpTable(int var1, int var2);

    native long getJumpTableEntry(long var1, int var3, int var4);

    native long patchJumpTableEntry(long var1, int var3, int var4, int var5, long var6, long var8, long var10);

    native void releaseJumpTable(Class var1, long var2);

    native void installJNINativeMethod(Class var1, String var2, String var3, long var4);

    native String doGetShellVariable(String var1);

    native long doCreateMethodClosure(long var1, String var3, String var4, long var5);

    native void doDisposeMethodClosure(long var1);

    public static native long createGlobalRef(Object var0);

    public static native void releaseGlobalRef(long var0);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LinkerAbstract.loadJNILibrary();
        LinkerAbstract.init();
    }
}

