/*
 * Decompiled with CFR 0.152.
 */
package quicktime.internal.jdirect;

import quicktime.internal.jdirect.ArrayCopy;
import quicktime.internal.jdirect.Struct;

public class LongArrayStruct
extends Struct {
    protected long[] longs;
    private int logicalSize;

    protected LongArrayStruct(int sizeInBytes) {
        this.logicalSize = sizeInBytes;
        this.longs = new long[(sizeInBytes + 7) / 8];
    }

    protected byte getByteAt(int byteOffset) {
        long temp = this.longs[byteOffset / 8];
        int inset = byteOffset % 8;
        if (inset == Struct.LONG_HIGH_BYTE_OFFSET) {
            return (byte)temp;
        }
        if (inset == Struct.LONG_SEVEN_BYTE_OFFSET) {
            return (byte)(temp >>> 8);
        }
        if (inset == Struct.LONG_SIX_BYTE_OFFSET) {
            return (byte)(temp >>> 16);
        }
        if (inset == Struct.LONG_FIVE_BYTE_OFFSET) {
            return (byte)(temp >>> 24);
        }
        if (inset == Struct.LONG_FOUR_BYTE_OFFSET) {
            return (byte)(temp >>> 32);
        }
        if (inset == Struct.LONG_THREE_BYTE_OFFSET) {
            return (byte)(temp >>> 40);
        }
        if (inset == Struct.LONG_TWO_BYTE_OFFSET) {
            return (byte)(temp >>> 48);
        }
        return (byte)(temp >>> 56);
    }

    protected long getLongAt(int byteOffset) {
        if (byteOffset % 8 == 0) {
            return this.longs[byteOffset / 8];
        }
        return super.getLongAt(byteOffset);
    }

    protected void setByteAt(int byteOffset, byte value) {
        long temp = this.longs[byteOffset / 8];
        long longValue = (long)value & 0xFFL;
        int inset = byteOffset % 8;
        temp = inset == Struct.LONG_HIGH_BYTE_OFFSET ? (temp |= longValue) : (inset == Struct.LONG_SEVEN_BYTE_OFFSET ? (temp |= longValue << 8) : (inset == Struct.LONG_SIX_BYTE_OFFSET ? (temp |= longValue << 16) : (inset == Struct.LONG_FIVE_BYTE_OFFSET ? (temp |= longValue << 24) : (inset == Struct.LONG_FOUR_BYTE_OFFSET ? (temp |= longValue << 32) : (inset == Struct.LONG_THREE_BYTE_OFFSET ? (temp |= longValue << 40) : (inset == Struct.LONG_TWO_BYTE_OFFSET ? (temp |= longValue << 48) : (temp |= longValue << 56)))))));
        this.longs[byteOffset / 8] = temp;
    }

    protected void setLongAt(int byteOffset, long value) {
        if (byteOffset % 8 == 0) {
            this.longs[byteOffset / 8] = value;
        } else {
            super.setLongAt(byteOffset, value);
        }
    }

    protected void setBytesAt(int byteOffset, byte[] source) {
        ArrayCopy.copyArrayToArray(source, 0, this.longs, byteOffset, source.length);
    }

    protected void setStructAt(int byteOffset, Struct src) {
        int srcByteCount = src.getSize();
        ArrayCopy.copyArrayToArray(src.getBytesAt(0, srcByteCount), 0, this.longs, byteOffset, srcByteCount);
    }

    public byte[] getBytesAt(int byteOffset, int byteCount) {
        byte[] result = new byte[byteCount];
        ArrayCopy.copyArrayToArray(this.longs, byteOffset, result, 0, byteCount);
        return result;
    }

    public byte[] getBytes() {
        return this.getBytesAt(0, this.getSize());
    }

    public final long[] getArray() {
        return this.longs;
    }

    public final long[] getLongArray() {
        return this.getArray();
    }

    public final int getSize() {
        return this.logicalSize;
    }
}

