/*
 * Decompiled with CFR 0.152.
 */
package quicktime.internal.jdirect;

import java.lang.reflect.Method;
import quicktime.internal.jdirect.FieldScanner;
import quicktime.internal.jdirect.LinkerAbstract;
import quicktime.internal.jdirect.Logger;

public class MethodClosure {
    private long closure = 0L;
    private long targetObjectGlobalRef = 0L;
    private long lockGlobalRef = 0L;

    protected MethodClosure(Object targetObject, String methodName, String methodSignature) {
        if (targetObject == null) {
            throw new NullPointerException("MethodClosure target");
        }
        if (methodSignature.length() < 3 || methodSignature.charAt(0) != '(' || methodSignature.charAt(methodSignature.length() - 2) != ')') {
            throw new IllegalArgumentException("Malformed method signature");
        }
        int i = 0;
        while (i < methodSignature.length()) {
            switch (methodSignature.charAt(i)) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    break;
                }
                case 'L': {
                    throw new IllegalArgumentException("JDirect MethodClosures cannot have Object parameters or return types");
                }
                case '[': {
                    throw new IllegalArgumentException("JDirect MethodClosures cannot have array parameters or return types");
                }
                case '(': {
                    if (i == 0) break;
                    throw new IllegalArgumentException("Malformed method signature: '(' can only be first char");
                }
                case ')': {
                    if (i == methodSignature.length() - 2) break;
                    throw new IllegalArgumentException("Malformed method signature: ')' can only be second to last char");
                }
                case 'V': {
                    if (i == methodSignature.length() - 1) break;
                    throw new IllegalArgumentException("Malformed method signature: 'V' can only be last char");
                }
                default: {
                    throw new IllegalArgumentException("Malformed method signature: '" + methodSignature.charAt(i) + "' is not valid");
                }
            }
            ++i;
        }
        this.targetObjectGlobalRef = LinkerAbstract.createGlobalRef(targetObject);
        String thisClassName = this.getClass().getName();
        String targetClassName = targetObject.getClass().getName();
        boolean logLoading = Logger.shouldLogLoadingForClass(thisClassName);
        boolean logInvocation = Logger.shouldLogInvocationForClass(targetClassName);
        if (logLoading) {
            System.err.println("JDirect: Creating closure for " + targetClassName + "." + methodName);
            System.err.println("         Scanning inheritance:");
        }
        FieldScanner fieldValues = new FieldScanner(this.getClass(), null, LinkerAbstract.kLockObjectStringName, logLoading);
        String enhancedSig = methodSignature;
        if (fieldValues.getLock() != null) {
            enhancedSig = "-" + methodSignature;
            this.lockGlobalRef = LinkerAbstract.createLockFromObject(fieldValues.getLock());
        }
        if (logInvocation) {
            enhancedSig = "~" + methodSignature;
        }
        this.closure = LinkerAbstract.createMethodClosure(this.targetObjectGlobalRef, methodName, enhancedSig, this.lockGlobalRef);
        if (logLoading) {
            System.err.println("         Created closure at: 0x" + Long.toHexString(this.closure));
        }
    }

    protected MethodClosure(Object targetObject, String methodName, String methodSignature, boolean ignore) {
        this(targetObject, methodName, methodSignature);
    }

    public void dispose() {
        if (this.closure != 0L) {
            if (Logger.shouldLogLoadingForClass(this.getClass().getName())) {
                System.err.println("JDirect: disposing closure at " + Long.toHexString(this.closure));
            }
            LinkerAbstract.disposeMethodClosure(this.closure);
            this.closure = 0L;
            LinkerAbstract.releaseGlobalRef(this.targetObjectGlobalRef);
            this.targetObjectGlobalRef = 0L;
            if (this.lockGlobalRef != 0L) {
                LinkerAbstract.releaseLockFromObject(this.lockGlobalRef);
                this.lockGlobalRef = 0L;
            }
        }
    }

    public long getClosure() {
        return this.closure;
    }

    public int getProc() {
        return (int)this.closure;
    }

    private static String getClosureMethodNameAndSignature(Method method) {
        Class<?>[] params = method.getParameterTypes();
        StringBuffer buf = new StringBuffer();
        buf.append(method.getName());
        buf.append('(');
        boolean needsComma = false;
        int i = 0;
        while (i < params.length) {
            if (needsComma) {
                buf.append(", ");
            }
            buf.append(params[i].getName());
            needsComma = true;
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }
}

